<?php $__currentLoopData = $content; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="item-card">
        <?php
            if ($type === 'continue' && isset($item->serie_id)) {
                $detailRoute = route('serie.detail', ['id' => $item->serie_id]);
            } elseif ($item->type === 'movie') {
                $detailRoute = route('filme.detail', ['id' => $item->id]);
            } elseif ($item->type === 'serie') {
                $detailRoute = route('serie.detail', ['id' => $item->id]);
            } elseif ($item->type === 'anime') {
                $detailRoute = route('anime.detail', ['id' => $item->id]);
            } else {
                $detailRoute = '#';
            }
        ?>

        <a href="<?php echo e($detailRoute); ?>" class="block">
            <div class="image-wrapper relative overflow-hidden rounded-lg aspect-[2/3] bg-zinc-800">
                <!-- Shimmer placeholder -->
                <div class="absolute inset-0 shimmer"></div>

                <!-- Poster image -->
                <img
                    src="<?php echo e($item->poster_path); ?>"
                    alt="<?php echo e($item->name); ?>"
                    class="absolute inset-0 object-cover w-full h-full lazy-image"
                    loading="lazy"
                    onload="this.classList.add('loaded'); this.previousElementSibling.style.display='none';"
                >

                <!-- Overlay gradiente -->
                <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>

                <?php if($type === 'continue' && isset($item->progress)): ?>
                    <!-- Barra de progresso para Continue Assistindo -->
                    <div class="absolute bottom-0 left-0 w-full h-1 bg-zinc-700">
                        <div class="h-full bg-primary" style="width: <?php echo e($item->progress); ?>%;"></div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="mt-2 space-y-1">
                <h3 class="font-medium truncate"><?php echo e($item->name); ?></h3>

                <div class="flex items-center gap-2">
                    <?php if($item->type === 'movie'): ?>
                        <span class="px-2 py-0.5 text-xs rounded-full bg-zinc-800">Filme</span>
                    <?php elseif($item->type === 'serie'): ?>
                        <span class="px-2 py-0.5 text-xs rounded-full bg-zinc-800">Série</span>
                    <?php elseif($item->type === 'anime'): ?>
                        <span class="px-2 py-0.5 text-xs rounded-full bg-zinc-800">Anime</span>
                    <?php endif; ?>

                    <?php if(isset($item->vote_average) && $item->vote_average > 0): ?>
                        <div class="flex items-center gap-1 px-2 py-0.5 text-xs bg-black/50 rounded-full">
                            <i class="text-yellow-400 fas fa-star"></i>
                            <span><?php echo e(number_format($item->vote_average, 1)); ?></span>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if($type === 'continue' && isset($item->episode_name)): ?>
                    <p class="text-xs truncate text-zinc-400">
                        <?php echo e($item->episode_name); ?>

                    </p>
                <?php endif; ?>
            </div>
        </a>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php /**PATH /home/u446595196/domains/capixabaplay.com.br/public_html/play/resources/views/layouts/partials/_content_items.blade.php ENDPATH**/ ?>