<section class="py-8">
    <!-- Estilos para o efeito shimmer -->
    <style>
        .shimmer {
            background: linear-gradient(90deg,
                        rgba(40, 40, 40, 0.2) 0%,
                        rgba(60, 60, 60, 0.5) 40%,
                        rgba(40, 40, 40, 0.2) 80%);
            background-size: 200% 100%;
            animation: shimmer 1.5s infinite linear;
        }

        @keyframes shimmer {
            0% { background-position: -200% 0; }
            100% { background-position: 200% 0; }
        }

        .image-wrapper {
            position: relative;
            overflow: hidden;
            border-radius: 0.5rem;
            border: 2px solid transparent;
            transition: border-color 0.3s ease, transform 0.3s ease;
        }

        .image-wrapper:hover {
            border-color: white;
            transform: scale(1.05);
        }

        .image-placeholder {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
        }

        .lazy-image {
            opacity: 0;
            transition: opacity 0.3s ease;
            z-index: 2;
            position: relative;
        }

        .lazy-image.loaded {
            opacity: 1;
        }

        /* Estilos para o loading de seções */
        .section-loading {
            min-height: 300px;
            position: relative;
            margin-bottom: 3rem;
        }

        .section-title-placeholder {
            height: 2rem;
            width: 200px;
            margin-bottom: 1.5rem;
            border-radius: 0.25rem;
        }

        .section-items {
            display: flex;
            gap: 0.5rem;
            overflow-x: hidden;
        }

        .section-item-placeholder {
            flex: 0 0 auto;
            border-radius: 0.5rem;
        }

        /* Tamanhos diferentes para os placeholders de item */
        .poster-placeholder {
            width: 160px;
            height: 240px;
        }

        .wide-placeholder {
            width: 280px;
            height: 160px;
        }

        .section-container {
            opacity: 0;
            transition: opacity 0.5s ease-in;
        }

        .section-container.loaded {
            opacity: 1;
        }

        /* Estilos responsivos para telas grandes */
        @media (min-width: 1920px) {
            .poster-placeholder {
                width: 200px;
                height: 300px;
            }

            .wide-placeholder {
                width: 350px;
                height: 200px;
            }

            .section-title {
                font-size: 1.75rem;
            }

            /* Aumenta os números do Top 10 em telas grandes */
            .top10-number {
                font-size: 190px;
            }

            .top10-number-last {
                font-size: 170px;
            }
        }

        /* Estilo para o botão Ver Mais */
        .see-more-btn {
            display: inline-flex;
            align-items: center;
            font-weight: 500;
            color: #a1a1aa;
            transition: color 0.2s ease;
            margin-left: 12px;
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            background-color: rgba(63, 63, 70, 0.5);
        }

        .see-more-btn:hover {
            color: white;
            background-color: rgba(82, 82, 91, 0.7);
        }

        .see-more-btn i {
            margin-left: 0.5rem;
            font-size: 0.8rem;
        }

        /* Estilos para setas de navegação - MODIFICADO */
        .splide__arrow {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 46px;
            height: 183px;
            border-radius: 7%;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 30;
            opacity: 0; /* Inicialmente invisível */
            transition: opacity 0.3s ease;
            cursor: pointer;
            background-color: transparent; /* Removido o fundo */
        }

        .splide__arrow:hover {
            background-color: transparent; /* Sem fundo no hover */
        }

        .splide__arrow i {
            color: #fff;
            font-size: 1.5rem;
            filter: drop-shadow(0px 0px 2px rgba(0,0,0,0.8)); /* Sombra para melhor visibilidade */
            opacity: 0.7;
            transition: opacity 0.3s ease;
        }

        .splide__arrow:hover i {
            opacity: 1;
        }

        .splide__arrow.is-disabled {
            opacity: 0 !important; /* Botão completamente invisível quando desabilitado */
            cursor: default;
        }

        .splide__arrow--prev {
            left: 10px;
        }

        .splide__arrow--next {
            right: 10px;
        }

        /* Mostrar setas apenas quando hover na área do carrossel */
        .splide__track:hover .splide__arrow:not(.is-disabled) {
            opacity: 1;
        }

        /* Área maior para detectar hover nas extremidades */
        .splide__track {
            position: relative;
        }

        /* Ocultar setas em dispositivos móveis - MODIFICADO */
        @media (max-width: 768px) {
            .splide__arrow {
                display: none; /* Ocultar completamente as setas em vez de apenas ajustar opacidade */
            }
        }

        /* Adicionando estilos para carregamento em cascata */
        .cascade-section {
            opacity: 0;
            transform: translateY(20px);
            transition: opacity 0.5s ease, transform 0.5s ease;
        }

        .cascade-section.visible {
            opacity: 1;
            transform: translateY(0);
        }

        .section-placeholder {
            min-height: 200px;
        }

        /* Classe para adiar carregamento de seções remotas */
        .deferred-section {
            min-height: 300px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>

    <!-- Continue Watching com shimmer loading -->
    <?php if(session('selected_profile') && $continueWatching->isNotEmpty()): ?>
        <div class="container px-4 mx-auto mb-12 cascade-section" data-cascade-priority="1">
            <div id="continue-watching-loading" class="section-loading">
                <div class="section-title-placeholder shimmer"></div>
                <div class="section-items">
                    <?php for($i = 0; $i < 5; $i++): ?>
                        <div class="section-item-placeholder wide-placeholder shimmer"></div>
                    <?php endfor; ?>
                </div>
            </div>

            <div id="continue-watching-container" class="section-container">
                <div class="flex items-center ">
                    <h2 class="font-bold text-1xl lg:text-3xl">Continue Assistindo</h2>
                </div>
                <div class="splide" id="continue-watching-carousel">
                    <div class="p-6 splide__track">
                        <ul class="splide__list">
                            <?php $__currentLoopData = $continueWatching; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $path = match ($item->type) {
                                        'movie' => route('filme.detail', ['id' => $item->item_id]),
                                        'serie' => route('serie.detail', ['id' => $item->serie_id]),
                                        'anime' => route('anime.detail', ['id' => $item->anime_id ?? $item->item_id]),
                                        default => null
                                    };

                                    // Obter dados especiais com base no tipo de mídia
                                    $movieInfo = null;
                                    $serieInfo = null;
                                    $animeInfo = null;

                                    if ($item->type === 'movie') {
                                        // Buscar informações do filme: ano e gêneros
                                        $movieInfo = DB::table('movies')
                                            ->leftJoin('movie_genres', 'movies.id', '=', 'movie_genres.movie_id')
                                            ->leftJoin('genres', 'movie_genres.genre_id', '=', 'genres.id')
                                            ->where('movies.id', $item->item_id)
                                            ->select('movies.*', DB::raw('GROUP_CONCAT(genres.name SEPARATOR ", ") as genres'))
                                            ->groupBy('movies.id')
                                            ->first();
                                    } elseif ($item->type === 'serie') {
                                        // Buscar informações do episódio: nome do episódio
                                        $serieInfo = DB::table('episodes')
                                            ->join('seasons', 'episodes.season_id', '=', 'seasons.id')
                                            ->join('series', 'seasons.serie_id', '=', 'series.id')
                                            ->where('episodes.id', $item->episode_id)
                                            ->select('episodes.*', 'series.name as serie_name')
                                            ->first();
                                    } elseif ($item->type === 'anime') {
                                        // Buscar informações do episódio de anime
                                        $animeInfo = DB::table('anime_episodes')
                                            ->join('anime_seasons', 'anime_episodes.anime_season_id', '=', 'anime_seasons.id')
                                            ->join('animes', 'anime_seasons.anime_id', '=', 'animes.id')
                                            ->where('anime_episodes.id', $item->episode_id)
                                            ->select('anime_episodes.*', 'animes.name as anime_name')
                                            ->first();
                                    }

                                    // Calcular o tempo restante em minutos
                                    $remainingTime = 0;
                                    $remainingHours = 0;
                                    $remainingMinutes = 0;
                                    if ($item->duration > 0 && $item->position > 0) {
                                        $remainingTimeSeconds = $item->duration - $item->position;
                                        $remainingTime = ceil($remainingTimeSeconds / 60); // Arredondar para cima para minutos
                                        
                                        // Calcular horas e minutos para melhor formatação
                                        $remainingHours = floor($remainingTime / 60);
                                        $remainingMinutes = $remainingTime % 60;
                                    }

                                    // Calcular progresso para a barra
                                    $progress = 0;
                                    if ($item->duration > 0 && $item->position > 0) {
                                        $progress = min(100, round(($item->position / $item->duration) * 100));
                                    }

                                    // Determinar o poster/backdrop apropriado
                                    $poster = null;
                                    $title = null;
                                    $releaseYear = null;
                                    $genres = null;
                                    $episodeInfo = null;

                                    if ($item->type === 'movie' && $movieInfo) {
                                        $poster = $movieInfo->backdrop_path;
                                        $title = $movieInfo->title;
                                        $releaseYear = $movieInfo->release_date ? date('Y', strtotime($movieInfo->release_date)) : '';
                                        $genres = $movieInfo->genres;
                                    } elseif ($item->type === 'serie' && $serieInfo) {
                                        $poster = $item->still_path ?? $serieInfo->still_path;
                                        $title = $serieInfo->serie_name;
                                        $episodeInfo = "T" . str_pad($item->season_number, 2, '0', STR_PAD_LEFT) .
                                                      "E" . str_pad($item->episode_number, 2, '0', STR_PAD_LEFT) .
                                                      " " . $serieInfo->name;
                                    } elseif ($item->type === 'anime' && $animeInfo) {
                                        $poster = $animeInfo->still_path;
                                        $title = $animeInfo->anime_name;
                                        $episodeInfo = "T" . str_pad($item->season_number, 2, '0', STR_PAD_LEFT) .
                                                      "E" . str_pad($item->episode_number, 2, '0', STR_PAD_LEFT) .
                                                      " " . $animeInfo->name;
                                    }
                                ?>

                                <?php if($path && $poster): ?>
                                    <li class="px-2 splide__slide">
                                        <a href="<?php echo e($path); ?>" class="block group">
                                            <div class="flex flex-col">
                                                <!-- Poster/Image Card com Progress Bar -->
                                                <div class="relative overflow-hidden rounded-lg image-wrapper">
                                                    <div class="image-placeholder shimmer aspect-video"></div>
                                                    <img src="<?php echo e($poster); ?>"
                                                         alt="<?php echo e($title); ?>"
                                                         class="object-cover w-full aspect-video lazy-image"
                                                         loading="lazy"
                                                         onload="this.classList.add('loaded'); this.previousElementSibling.style.display='none';">

                                                    <!-- Play button - MODIFICADO: visível apenas no hover e posicionado mais acima -->
                                                    <div class="absolute z-20 transition-opacity duration-300 transform -translate-x-1/2 -translate-y-1/2 opacity-0 left-1/2 top-1/2 group-hover:opacity-100">
                                                        <div class="flex items-center justify-center w-12 h-12 transition-transform duration-300 border-2 rounded-full border-white/40 backdrop-blur-sm bg-black/40 group-hover:scale-110">
                                                            <i class="text-base text-white fas fa-play"></i>
                                                        </div>
                                                    </div>

                                                    <!-- Gradient overlay -->
                                                    <div class="absolute inset-0 z-10 bg-gradient-to-t from-black/95 via-transparent to-transparent"></div>

                                                    <!-- Progress Bar com porcentagem real - MODIFICADO -->
                                                    <div class="absolute bottom-0 left-0 right-0 z-20 px-2 pb-1.5">
                                                        <div class="w-full h-1 overflow-hidden rounded-full bg-zinc-700/35">
                                                            <div class="h-full rounded-full bg-primary" style="width: <?php echo e($progress); ?>%;"></div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Informações do conteúdo abaixo do poster -->
                                                <div class="mt-2 space-y-1">
                                                    <!-- Tempo restante -->
                                                    <p class="text-xs text-zinc-400">
                                                        <?php if($remainingTime > 0): ?>
                                                            Restam 
                                                            <?php if($remainingHours > 0): ?>
                                                                <?php echo e($remainingHours); ?>h 
                                                            <?php endif; ?>
                                                            <?php if($remainingMinutes > 0 || $remainingHours == 0): ?>
                                                                <?php echo e($remainingMinutes); ?> min
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            Recomeçar
                                                        <?php endif; ?>
                                                    </p>

                                                    <!-- Título principal em negrito -->
                                                    <h3 class="text-sm font-bold text-white line-clamp-1"><?php echo e($title); ?></h3>

                                                    <!-- Informações específicas por tipo -->
                                                    <?php if($item->type === 'movie'): ?>
                                                        <p class="flex items-center text-xs text-zinc-400">
                                                            <?php if($releaseYear): ?>
                                                                <?php echo e($releaseYear); ?>

                                                            <?php endif; ?>
                                                            <?php if($releaseYear && $genres): ?>
                                                                <span class="mx-1 text-zinc-600">•</span>
                                                            <?php endif; ?>
                                                            <?php if($genres): ?>
                                                                <span class="line-clamp-1"><?php echo e($genres); ?></span>
                                                            <?php endif; ?>
                                                        </p>
                                                    <?php elseif($item->type === 'serie' || $item->type === 'anime'): ?>
                                                        <p class="text-xs text-zinc-400 line-clamp-1"><?php echo e($episodeInfo); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Top 10 Movies sem botão Ver Mais -->
    <div class="container px-4 mx-auto mb-12 cascade-section" data-cascade-priority="2">
        <div id="top10-movies-loading" class="section-loading">
            <div class="section-title-placeholder shimmer"></div>
            <div class="section-items">
                <?php for($i = 0; $i < 5; $i++): ?>
                    <div class="flex items-center">
                        <div class="w-20 h-20 mr-4 text-center shimmer" style="border-radius: 50%;"></div>
                        <div class="section-item-placeholder poster-placeholder shimmer"></div>
                    </div>
                <?php endfor; ?>
            </div>
        </div>

        <div id="top10-movies-container" class="section-container">
            <div class="flex items-center ">
                <h2 class="font-bold text-1xl lg:text-3xl section-title">Top 10 Filmes</h2>
                <!-- Removido botão Ver Mais -->
            </div>
            <div class="splide" id="top10-carousel">
                <div class="p-6 splide__track">
                    <ul class="splide__list">
                        <?php $__currentLoopData = $top10; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $filme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="px-2 splide__slide">
                                <a href="<?php echo e(route('filme.detail', ['id' => $filme->id])); ?>" class="block group">
                                    <div class="relative flex items-center ml-2">
                                        <!-- Large number on the left side -->
                                        <div class="absolute bottom-0 left-0 flex items-end h-full transform -translate-x-1/3">
                                            <span class="text-zinc-800 font-black text-[140px] leading-none tracking-tighter top10-number <?php echo e($index == 9 ? 'top10-number-last' : ''); ?>"
                                                  style="text-shadow: -1px -1px 0 #444, 1px -1px 0 #444, -1px 1px 0 #444, 1px 1px 0 #444;
                                                         font-family: 'Roboto', sans-serif; font-weight: 900;
                                                         <?php echo e($index == 9 ? 'font-size: 120px; letter-spacing: -10px;' : ''); ?>">
                                                <?php echo e($index + 1); ?>

                                            </span>
                                        </div>
                                        <!-- Poster image with shimmer effect -->
                                        <div class="relative z-10 w-3/4 overflow-hidden rounded-lg image-wrapper <?php echo e($index == 9 ? 'ml-10' : 'ml-8'); ?>"
                                             style="box-shadow: -8px 0 15px rgba(0,0,0,0.8);">
                                            <div class="image-placeholder shimmer aspect-[2/3]"></div>
                                            <img src="<?php echo e($filme->poster_path); ?>"
                                                 alt="<?php echo e($filme->name); ?>"
                                                 class="w-full aspect-[2/3] object-cover lazy-image hover:border-2 hover:border-white"
                                                 loading="lazy"
                                                 onload="this.classList.add('loaded'); this.previousElementSibling.style.display='none';">
                                            <div class="absolute inset-0 z-10 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Selecionados sem botão Ver Mais -->
    <div class="container px-4 mx-auto mb-12 cascade-section" data-cascade-priority="3">
        <div id="choosed-loading" class="section-loading">
            <div class="section-title-placeholder shimmer"></div>
            <div class="section-items">
                <?php for($i = 0; $i < 5; $i++): ?>
                    <div class="section-item-placeholder wide-placeholder shimmer"></div>
                <?php endfor; ?>
            </div>
        </div>

        <div id="choosed-container" class="section-container">
            <div class="flex items-center ">
                <h2 class="font-bold text-1xl lg:text-3xl">Destaques</h2>
                <!-- Removido botão Ver Mais -->
            </div>
            <div class="splide" id="choosed-carousel">
                <div class="p-6 splide__track">
                    <ul class="splide__list">
                        <?php $__currentLoopData = $pinned; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pinned): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="px-2 splide__slide " >
                                <a href="<?php echo e($pinned->type === 'movie' ? route('filme.detail', ['id' => $pinned->id]) : 
                                    ($pinned->type === 'anime' ? route('anime.detail', ['id' => $pinned->id]) : 
                                    route('serie.detail', ['id' => $pinned->id]))); ?>" class="block group">
                                    <div class="relative overflow-hidden rounded-lg image-wrapper ">
                                        <div class="image-placeholder shimmer aspect-video"></div>
                                        <img src="<?php echo e($pinned->backdrop_path); ?>"
                                             alt="<?php echo e($pinned->name); ?>"
                                             class="object-cover w-full aspect-video lazy-image"
                                             loading="lazy"
                                             onload="this.classList.add('loaded'); this.previousElementSibling.style.display='none';">
                                        <div class="absolute inset-0 z-10 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                                    </div>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Top 10 Séries sem botão Ver Mais -->
    <div class="container px-4 mx-auto mb-12 cascade-section" data-cascade-priority="4">
        <div id="top10series-loading" class="section-loading">
            <div class="section-title-placeholder shimmer"></div>
            <div class="section-items">
                <?php for($i = 0; $i < 5; $i++): ?>
                    <div class="flex items-center">
                        <div class="w-20 h-20 mr-4 text-center shimmer" style="border-radius: 50%;"></div>
                        <div class="section-item-placeholder poster-placeholder shimmer"></div>
                    </div>
                <?php endfor; ?>
            </div>
        </div>

        <div id="top10series-container" class="section-container">
            <div class="flex items-center ">
                <h2 class="font-bold text-1xl lg:text-3xl section-title">Top 10 Séries</h2>
                <!-- Removido botão Ver Mais -->
            </div>
            <div class="splide" id="top10series-carousel">
                <div class="p-6 splide__track">
                    <ul class="splide__list">
                        <?php $__currentLoopData = $top10series; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $serie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="px-2 splide__slide">
                                <a href="<?php echo e(route('serie.detail', ['id' => $serie->id])); ?>" class="block group">
                                    <div class="relative flex items-center ml-2">
                                        <!-- Large number on the left side -->
                                        <div class="absolute bottom-0 left-0 flex items-end h-full transform -translate-x-1/3">
                                            <span class="text-zinc-800 font-black text-[140px] leading-none tracking-tighter top10-number <?php echo e($index == 9 ? 'top10-number-last' : ''); ?>"
                                                  style="text-shadow: -1px -1px 0 #444, 1px -1px 0 #444, -1px 1px 0 #444, 1px 1px 0 #444;
                                                         font-family: 'Roboto', sans-serif; font-weight: 900;
                                                         <?php echo e($index == 9 ? 'font-size: 120px; letter-spacing: -10px;' : ''); ?>">
                                                <?php echo e($index + 1); ?>

                                            </span>
                                        </div>
                                        <!-- Poster image with shimmer effect -->
                                        <div class="relative z-10 w-3/4 overflow-hidden transition-transform duration-300 rounded-lg image-wrapper <?php echo e($index == 9 ? 'ml-10' : 'ml-8'); ?>"
                                             style="box-shadow: -8px 0 15px rgba(0,0,0,0.8);">
                                            <div class="image-placeholder shimmer aspect-[2/3]"></div>
                                            <img src="<?php echo e($serie->poster_path); ?>"
                                                 alt="<?php echo e($serie->name); ?>"
                                                 class="w-full aspect-[2/3] object-cover lazy-image"
                                                 loading="lazy"
                                                 onload="this.classList.add('loaded'); this.previousElementSibling.style.display='none';">
                                            <div class="absolute inset-0 z-10 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Últimos Episódios Adicionados -->
    <?php if(isset($latest_episodes) && $latest_episodes->isNotEmpty()): ?>
        <div class="container px-4 mx-auto mb-12 cascade-section" data-cascade-priority="5">
            <div id="latest-episodes-loading" class="section-loading">
                <div class="section-title-placeholder shimmer"></div>
                <div class="section-items">
                    <?php for($i = 0; $i < 5; $i++): ?>
                        <div class="section-item-placeholder wide-placeholder shimmer"></div>
                    <?php endfor; ?>
                </div>
            </div>

            <div id="latest-episodes-container" class="section-container">
                <div class="flex items-center">
                    <h2 class="font-bold text-1xl lg:text-3xl">Últimos Episódios</h2>
                </div>
                <div class="splide" id="latest-episodes-carousel">
                    <div class="p-6 splide__track">
                        <ul class="splide__list">
                            <?php $__currentLoopData = $latest_episodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $episode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="px-2 splide__slide">
                                    <div class="block cursor-pointer group episode-item"
                                         data-serie-id="<?php echo e($episode->serie_id); ?>"
                                         data-episode-id="<?php echo e($episode->episode_id); ?>"
                                         data-episode-name="<?php echo e($episode->episode_name); ?>"
                                         data-season-number="<?php echo e($episode->season_number); ?>"
                                         data-episode-number="<?php echo e($episode->episode_number); ?>"
                                         data-backdrop="<?php echo e($episode->still_path ?? $episode->serie_backdrop ?? ''); ?>"
                                         data-serie-name="<?php echo e($episode->serie_name); ?>"
                                         data-premium="<?php echo e(isset($episode->premium) ? $episode->premium : 'true'); ?>">
                                        <div class="flex flex-col">
                                            <!-- Card do episódio com imagem -->
                                            <div class="relative overflow-hidden rounded-lg image-wrapper">
                                                <!-- Placeholder de carregamento -->
                                                <div class="image-placeholder shimmer aspect-video"></div>

                                                <!-- Imagem do episódio -->
                                                <img src="<?php echo e($episode->still_path ?? $episode->serie_backdrop ?? ''); ?>"
                                                    alt="<?php echo e($episode->serie_name); ?> - <?php echo e($episode->episode_name); ?>"
                                                    class="object-cover w-full aspect-video lazy-image"
                                                    loading="lazy"
                                                    onload="this.classList.add('loaded'); this.previousElementSibling.style.display='none';">

                                                <!-- Play button centralizado - visível apenas no hover -->
                                                <div class="absolute z-20 transition-opacity duration-300 transform -translate-x-1/2 -translate-y-1/2 opacity-0 left-1/2 top-1/2 group-hover:opacity-100">
                                                    <div class="flex items-center justify-center w-12 h-12 transition-transform duration-300 border-2 rounded-full border-white/40 backdrop-blur-sm bg-black/40 group-hover:scale-110">
                                                        <i class="text-base text-white fas fa-play"></i>
                                                    </div>
                                                </div>

                                                <!-- Gradient overlay -->
                                                <div class="absolute inset-0 z-10 bg-gradient-to-t from-black/95 via-transparent to-transparent"></div>
                                            </div>

                                            <!-- Informações do episódio abaixo do card -->
                                            <div class="mt-2 space-y-1">
                                                <!-- Nome da série em negrito -->
                                                <h3 class="text-sm font-bold text-white line-clamp-1"><?php echo e($episode->serie_name); ?></h3>

                                                <!-- Temporada, episódio e nome do episódio -->
                                                <p class="text-xs text-zinc-400 line-clamp-1">
                                                    T<?php echo e(str_pad($episode->season_number, 2, '0', STR_PAD_LEFT)); ?>E<?php echo e(str_pad($episode->episode_number, 2, '0', STR_PAD_LEFT)); ?> <?php echo e($episode->episode_name); ?>

                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Additional Carousels com loading shimmer aprimorado e botão Ver Mais -->
    <?php $__currentLoopData = [
        ['title' => 'Adicionados Recentemente', 'items' => $latest, 'id' => 'ultimos', 'type' => 'latest', 'priority' => 6],
        ['title' => 'Em Alta', 'items' => $trending, 'id' => 'trending', 'type' => 'trending', 'priority' => 7],
        ['title' => 'Últimas Séries', 'items' => $recents, 'id' => 'srecentes', 'type' => 'series', 'priority' => 8],
        ['title' => 'Novelas', 'items' => $novelas, 'id' => 'novelas', 'type' => 'novelas', 'priority' => 9],
        ['title' => 'Recomendados', 'items' => $recommended, 'id' => 'recomendados', 'type' => 'recommended', 'priority' => 10]
    ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carousel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($carousel['items']->isNotEmpty()): ?>
            <div class="container px-4 mx-auto mb-12 cascade-section" data-cascade-priority="<?php echo e($carousel['priority']); ?>">
                <div id="<?php echo e($carousel['id']); ?>-loading" class="section-loading">
                    <div class="section-title-placeholder shimmer"></div>
                    <div class="section-items">
                        <?php for($i = 0; $i < 5; $i++): ?>
                            <div class="section-item-placeholder poster-placeholder shimmer"></div>
                        <?php endfor; ?>
                    </div>
                </div>

                <div id="<?php echo e($carousel['id']); ?>-container" class="section-container">
                    <div class="flex items-center ">
                        <h2 class="font-bold text-1xl lg:text-3xl section-title"><?php echo e($carousel['title']); ?></h2>
                        <a href="<?php echo e(route('content.more', ['type' => $carousel['type']])); ?>" class="text-xs see-more-btn">
                            Ver mais <i class="ml-1 fas fa-chevron-right"></i>
                        </a>
                    </div>
                    <div class="splide" id="<?php echo e($carousel['id']); ?>-carousel">
                        <div class="p-6 splide__track">
                            <ul class="splide__list">
                                <?php $__currentLoopData = $carousel['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="px-2 splide__slide">
                                        <a href="<?php echo e($item->type === 'movie' ? route('filme.detail', ['id' => $item->id]) : 
                                            ($item->type === 'anime' ? route('anime.detail', ['id' => $item->id]) : 
                                            route('serie.detail', ['id' => $item->id]))); ?>" class="block group">
                                            <div class="relative overflow-hidden rounded-lg image-wrapper">
                                                <div class="image-placeholder shimmer aspect-[2/3]"></div>
                                                <img src="<?php echo e($item->poster_path); ?>"
                                                     alt="<?php echo e($item->name); ?>"
                                                     class="w-full aspect-[2/3] object-cover transition-transform duration-300 lazy-image group-hover:scale-105"
                                                     loading="lazy"
                                                     onload="this.classList.add('loaded'); this.previousElementSibling.style.display='none';">
                                                <div class="absolute inset-0 z-10 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                                            </div>
                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</section>

<!-- Script otimizado para carregamento de carrosséis -->
<script>
    // Configuração para carregamento em cascata
    document.addEventListener('DOMContentLoaded', () => {
        // Array para armazenar observadores
        const observers = [];
        let initializedSplides = {};

        // Função para criar um observador de interseção
        function createObserver(elements, threshold = 0.1, rootMargin = '100px') {
            // Verificar se há elementos para observar
            if (!elements || elements.length === 0) return null;

            const options = {
                root: null,
                rootMargin: rootMargin,
                threshold: threshold
            };

            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        // Processar o elemento quando ele estiver visível
                        processVisibleElement(entry.target);
                        // Parar de observar após processamento
                        observer.unobserve(entry.target);
                    }
                });
            }, options);

            // Começar a observar os elementos
            elements.forEach(element => observer.observe(element));

            // Adicionar à lista de observadores
            observers.push(observer);

            return observer;
        }

        // Função para processar elementos quando se tornarem visíveis
        function processVisibleElement(element) {
            // Marcar como visível para animação
            element.classList.add('visible');

            // Inicializar carrosséis quando visíveis
            initCarouselIfNeeded(element);

            // Remover placeholders de carregamento
            const loadingId = element.querySelector('[id$="-loading"]')?.id;
            const containerId = loadingId?.replace('-loading', '-container');

            if (loadingId && containerId) {
                const loadingEl = document.getElementById(loadingId);
                const containerEl = document.getElementById(containerId);

                if (loadingEl && containerEl) {
                    setTimeout(() => {
                        loadingEl.style.display = 'none';
                        containerEl.classList.add('loaded');

                        // Reinicializar o carrossel após mostrar o contêiner
                        const carouselId = containerEl.querySelector('.splide')?.id;
                        if (carouselId) {
                            setTimeout(() => {
                                dispatchResizeEvent();
                            }, 100);
                        }
                    }, 100);
                }
            }
        }

        // Função para disparar um evento de resize para corrigir layout
        function dispatchResizeEvent() {
            try {
                window.dispatchEvent(new Event('resize'));
            } catch (e) {
                // Fallback para IE
                const evt = window.document.createEvent('UIEvents');
                evt.initUIEvent('resize', true, false, window, 0);
                window.dispatchEvent(evt);
            }
        }

        // Função para inicializar um carrossel se necessário
        function initCarouselIfNeeded(container) {
            const splideElements = container.querySelectorAll('.splide:not(.is-initialized)');

            splideElements.forEach(element => {
                const carouselId = element.id;
                if (!carouselId || initializedSplides[carouselId]) return;

                let config = null;

                if (carouselId.includes('continue-watching') || carouselId.includes('choosed') ||
                    carouselId.includes('latest-episodes') || carouselId.includes('episodio')) {
                    config = { ...window.wideCarouselConfig };
                } else if (carouselId.includes('top10')) {
                    config = { ...window.top10CarouselConfig };
                } else {
                    config = { ...window.carouselConfig };
                }

                try {
                    const splide = new Splide(`#${carouselId}`, config);
                    splide.mount();
                    element.classList.add('is-initialized');
                    initializedSplides[carouselId] = true;

                    // Personalizar setas de navegação
                    customizeCarouselArrows(carouselId, splide);
                } catch (error) {
                    console.error(`Erro ao inicializar carrossel ${carouselId}:`, error);
                }
            });
        }

        // Função para personalizar as setas do carrossel
        function customizeCarouselArrows(carouselId, splide) {
            const element = document.getElementById(carouselId);
            if (!element) return;

            // Personalizar os ícones das setas
            const prevArrows = element.querySelectorAll('.splide__arrow--prev');
            const nextArrows = element.querySelectorAll('.splide__arrow--next');

            prevArrows.forEach(arrow => {
                arrow.innerHTML = '';
                const icon = document.createElement('i');
                icon.className = 'fas fa-chevron-left';
                arrow.appendChild(icon);
            });

            nextArrows.forEach(arrow => {
                arrow.innerHTML = '';
                const icon = document.createElement('i');
                icon.className = 'fas fa-chevron-right';
                arrow.appendChild(icon);
            });

            // Função para verificar e atualizar estado das setas
            function updateArrows() {
                const prevButton = element.querySelector('.splide__arrow--prev');
                const nextButton = element.querySelector('.splide__arrow--next');

                if (prevButton && nextButton) {
                    prevButton.classList.toggle('is-disabled', splide.index === 0);
                    nextButton.classList.toggle('is-disabled', splide.index >= splide.length - splide.options.perPage);
                }
            }

            // Atualizar estado das setas
            updateArrows();

            // Adicionar eventos para atualizar setas
            splide.on('moved', updateArrows);
            splide.on('resized', updateArrows);

            // Adicionar listeners de clique
            setTimeout(() => {
                const arrowElements = element.querySelectorAll('.splide__arrow');
                arrowElements.forEach(arrow => {
                    arrow.addEventListener('click', function(e) {
                        if (arrow.classList.contains('is-disabled')) {
                            e.preventDefault();
                            e.stopPropagation();
                            return false;
                        }

                        e.stopPropagation();

                        if (splide) {
                            if (arrow.classList.contains('splide__arrow--next')) {
                                splide.go('>');
                            } else {
                                splide.go('<');
                            }

                            setTimeout(updateArrows, 50);
                        }
                    });
                });

                updateArrows();
            }, 500);
        }

        // Definir configurações de carrossel globalmente para reutilização
        window.carouselConfig = {
            type: 'slide',
            rewind: true,
            arrows: true,
            pagination: false,
            autoplay: false,
            gap: '0rem',
            padding: { right: '0rem' },
            breakpoints: {
                520: { perPage: 3, padding: { right: '0rem' } },
                640: { perPage: 3, padding: { right: '0rem' } },
                768: { perPage: 4, padding: { right: '0rem' } },
                1024: { perPage: 5, padding: { right: '0rem' } },
                1280: { perPage: 6, padding: { right: '0rem' } },
                1536: { perPage: 7, padding: { right: '0rem' } },
                1920: { perPage: 7, padding: { right: '0rem' } }
            },
            classes: {
                arrows: 'splide__arrows',
                arrow: 'splide__arrow',
                prev: 'splide__arrow--prev',
                next: 'splide__arrow--next'
            },
            i18n: {
                prev: 'Anterior',
                next: 'Próximo'
            },
        };

        // Configurações específicas para carrosséis de itens grandes
        window.wideCarouselConfig = {
            ...window.carouselConfig,
            breakpoints: {
                520: { perPage: 2, padding: { right: '0rem' } },
                640: { perPage: 2, padding: { right: '0rem' } },
                768: { perPage: 2, padding: { right: '0rem' } },
                1024: { perPage: 3, padding: { right: '0rem' } },
                1280: { perPage: 4, padding: { right: '0rem' } },
                1536: { perPage: 5, padding: { right: '0rem' } },
                1920: { perPage: 6, padding: { right: '0rem' } }
            }
        };

        // Configurações para o Top 10
        window.top10CarouselConfig = {
            ...window.carouselConfig,
            breakpoints: {
                520: { perPage: 2, padding: { right: '0rem' } },
                640: { perPage: 2, padding: { right: '0rem' } },
                768: { perPage: 3, padding: { right: '0rem' } },
                1024: { perPage: 4, padding: { right: '0rem' } },
                1280: { perPage: 6, padding: { right: '0rem' } },
                1536: { perPage: 7, padding: { right: '0rem' } },
                1920: { perPage: 7, padding: { right: '0rem' } }
            }
        };

        // Prioritização de carregamento baseado em visibilidade
        const visibleSections = document.querySelectorAll('.cascade-section[data-cascade-priority="1"], .cascade-section[data-cascade-priority="2"]');
        const nearSections = document.querySelectorAll('.cascade-section[data-cascade-priority="3"], .cascade-section[data-cascade-priority="4"]');
        const farSections = document.querySelectorAll('.cascade-section[data-cascade-priority="5"], .cascade-section[data-cascade-priority="6"]');
        const lazySections = document.querySelectorAll('.cascade-section[data-cascade-priority="7"], .cascade-section[data-cascade-priority="8"], .cascade-section[data-cascade-priority="9"], .cascade-section[data-cascade-priority="10"]');

        // Processar primeiro as seções já visíveis
        setTimeout(() => {
            createObserver(visibleSections, 0.1, '0px');
        }, 0);

        // Depois processar as seções que estão próximas
        setTimeout(() => {
            createObserver(nearSections, 0.1, '200px');
        }, 100);

        // Processar as seções mais distantes com um pequeno atraso
        setTimeout(() => {
            createObserver(farSections, 0.1, '300px');
        }, 300);

        // Processar as seções menos importantes por último
        setTimeout(() => {
            createObserver(lazySections, 0.1, '400px');
        }, 600);

        // Limpar observadores quando não forem mais necessários
        window.addEventListener('beforeunload', () => {
            observers.forEach(observer => observer.disconnect());
        });
    });

    // Evitar inicialização duplicada de carrosséis
    window.disableOldCarouselInit = true;
</script>

<!-- Script para reprodução de episódios -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Selecionar todos os elementos de episódios
        const episodeItems = document.querySelectorAll('.episode-item');

        episodeItems.forEach(item => {
            item.addEventListener('click', function() {
                const serieId = this.getAttribute('data-serie-id');
                const episodeId = this.getAttribute('data-episode-id');
                const backdrop = this.getAttribute('data-backdrop');
                const serieName = this.getAttribute('data-serie-name');
                const episodeName = this.getAttribute('data-episode-name');
                const seasonNumber = this.getAttribute('data-season-number');
                const episodeNumber = this.getAttribute('data-episode-number');
                const isPremium = this.getAttribute('data-premium') === 'true';

                // Verificar se o usuário está autenticado
                const isAuthenticated = <?php echo e(auth()->check() ? 'true' : 'false'); ?>;

                // Se o usuário não estiver autenticado, mostrar o modal de login
                if (!isAuthenticated) {
                    // Mostrar o diálogo de autenticação que já está incluído na página
                    // Usamos a função global definida no auth_dialog.blade.php
                    if (typeof window.showLoginRequiredModal === 'function') {
                        window.showLoginRequiredModal();
                    } else {
                        // Fallback: tentar mostrar o modal diretamente
                        const loginModal = document.getElementById('loginRequiredModal');
                        if (loginModal) {
                            loginModal.classList.remove('hidden');
                            loginModal.classList.add('flex');
                            document.body.style.overflow = 'hidden';
                        } else {
                            console.error('Modal de autenticação não encontrado');
                        }
                    }
                    return; // Interromper a execução
                }

                // Verificar se o usuário é premium
                const userIsPremium = <?php echo e(auth()->check() && auth()->user()->premuim == 1 && auth()->user()->expired_in > $hoje ? 'true' : 'true'); ?>;

                // Se o conteúdo é premium e o usuário não é premium, mostrar tela de assinatura
                if (isPremium && !userIsPremium) {
                    // Mostrar o modal de assinatura necessária
                    const subscriptionModal = document.getElementById('random-modal');
                    if (subscriptionModal) {
                        document.getElementById('random-content-loading').classList.add('hidden');
                        document.getElementById('random-content-container').classList.add('hidden');
                        document.getElementById('random-content-error').classList.add('hidden');
                        document.getElementById('subscription-required').classList.remove('hidden');

                        subscriptionModal.classList.remove('hidden');
                        document.body.style.overflow = 'hidden';

                        // Configurar botão de fechar do modal
                        const closeModalBtn = document.getElementById('close-random-modal');
                        if (closeModalBtn) {
                            closeModalBtn.onclick = function() {
                                subscriptionModal.classList.add('hidden');
                                document.body.style.overflow = '';
                            };
                        }
                    } else {
                        // Fallback se o modal não existir
                        alert('Este conteúdo é exclusivo para assinantes premium. Faça upgrade da sua conta para assistir.');
                    }
                    return;
                }

                // Certificar que todos os dados necessários foram obtidos
                if (!serieId || !episodeId) {
                    console.error('Dados do episódio incompletos:', { serieId, episodeId, serieName, episodeName });
                    alert('Erro ao carregar informações do episódio. Tente novamente.');
                    return;
                }

                // Formatar os números da temporada e episódio com zeros à esquerda
                const formattedSeason = String(seasonNumber).padStart(2, '0');
                const formattedEpisode = String(episodeNumber).padStart(2, '0');

                // Criar o título completo formatado
                const fullTitle = `${serieName}`;
                const episodeInfo = `T${formattedSeason}E${formattedEpisode} ${episodeName}`;

                // Mostrar indicador de carregamento
                const loadingModal = document.createElement('div');
                loadingModal.classList.add('fixed', 'inset-0', 'z-50', 'flex', 'items-center', 'justify-center', 'bg-black/80', 'backdrop-blur-sm');
                loadingModal.innerHTML = `
                    <div class="text-center">
                        <div class="inline-block w-16 h-16 mb-4 border-4 rounded-full border-t-primary border-zinc-600 animate-spin"></div>
                        <p class="text-zinc-200">Carregando episódio...</p>
                    </div>
                `;
                document.body.appendChild(loadingModal);

                // Construir URL da API
                const apiUrl = "<?php echo e(route('api.episode.video', ['serieId' => ':serieId', 'episodeId' => ':episodeId'])); ?>";
                const url = apiUrl
                    .replace(':serieId', serieId)
                    .replace(':episodeId', episodeId);

                console.log('Carregando vídeo:', { url, serieId, episodeId, serieName, episodeName });

                // Fazer a requisição para obter o link do vídeo
                fetch(url)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Não foi possível obter o vídeo');
                        }
                        return response.json();
                    })
                    .then(data => {
                        // Remover o indicador de carregamento
                        document.body.removeChild(loadingModal);
                        console.log('Dados do vídeo:', data);

                        // Se tivermos o link do vídeo, reproduzir
                        if (data && data.videoUrl) {
                            // Usar a função de reprodução em tela cheia existente no site
                            if (typeof openFullscreenPlayer === 'function') {
                                openFullscreenPlayer(data.videoUrl, backdrop, 'series', fullTitle, episodeInfo);
                            } else {
                                // Fallback se a função não existir
                                const playerModal = document.getElementById('fullscreen-player-modal');
                                const playerContainer = document.getElementById('modal-player-container');

                                if (playerModal && playerContainer) {
                                    playerModal.classList.remove('hidden');
                                    document.body.style.overflow = 'hidden';

                                    // Criar player usando UltraPlayer se disponível
                                    if (typeof window.UltraPlayer !== 'undefined') {
                                        // Implementação do player
                                    }
                                }
                            }
                        } else {
                            // Se não tiver vídeo disponível, mostrar mensagem de erro
                            alert('Não foi possível reproduzir este episódio. Tente novamente mais tarde.');
                        }
                    })
                    .catch(error => {
                        // Remover o indicador de carregamento
                        if (document.body.contains(loadingModal)) {
                            document.body.removeChild(loadingModal);
                        }

                        console.error('Erro ao obter vídeo:', error);
                        alert('Ocorreu um erro ao carregar o vídeo. Por favor, tente novamente.');
                    });
            });
        });
    });

    // Se houver alguma chamada AJAX para continue-watching, atualizaremos para usar rotas nomeadas
    function updateContinueWatchingProgress(itemId, type, position, duration, episodeId = null) {
        fetch("<?php echo e(route('continueWatching')); ?>", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                item_id: itemId,
                type: type,
                position: position,
                duration: duration,
                episode_id: episodeId
            })
        }).catch(error => {
            console.error('Erro ao salvar progresso:', error);
        });
    }
</script>
<?php /**PATH /home/u446595196/domains/conectaplus.tv.br/public_html/resources/views/layouts/_partials/slides.blade.php ENDPATH**/ ?>