<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Login</title>
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
    <link rel="stylesheet" href="/public/css/web.css">
    <script src="https://accounts.google.com/gsi/client" async defer></script>
</head>
<body class="body-fav">
    
<section class="conteiner-login">
    <div class="login-container">
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

            <!-- Mostrar mensagem de sucesso se estiver definida -->
        <?php if(session('status')): ?>
            <div class="alert alert-success">
                <?php echo e(session('status')); ?>

            </div>
        <?php endif; ?>
        <div class="logo-login" >
            <img src="/public/api/image/minilogo" alt="logo" >
        </div>
        <h2>Entrar</h2>
        <form action="<?php echo e(route('login')); ?>" method="post">
            <?php echo csrf_field(); ?>

            <div>
                <input placeholder="Endereço de Email" class="input-profile" type="email" name="email" id="email" required>
            </div>
            <br>
            <div>
                <input placeholder="Senha" class="password-input" type="password" name="password" id="password" required>
            </div>
            <br>
            <div>
                <button type="submit" class="btn-login">Entrar</button>
            </div>

            <div>
                <div class="g_id_signin" data-type="standard"></div>
            </div>

            <div class="forgot-password">
                <a href="<?php echo e(route('password.request')); ?>">Esqueceu a senha?</a>
            </div>
        </form>
        <div>
            <a class="register-link" href="<?php echo e(route('register')); ?>">Criar uma Conta</a>
        </div>
    </div>

    <div id="g_id_onload"
         data-client_id="727078300048-3p7na3ofetni0o9b31v8m3um8qbumdot.apps.googleusercontent.com"
         data-callback="handleCredentialResponse">
    </div>
</section>

<script src="https://accounts.google.com/gsi/client" async defer></script>

<script>
function handleCredentialResponse(response) {
    const id_token = response.credential;

    fetch('/login-google', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({ token: id_token })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            
            window.location.href = data.redirect;
        } else {
            
            console.error('Erro de login:', data);
        }
    })
    .catch((error) => {
        console.error('Erro:', error);
    });
}
</script>

</body>
</html>
<?php /**PATH /home/ultraflix/public_html/site.ultraflix.net/resources/views/auth/login.blade.php ENDPATH**/ ?>