<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Favoritos - <?php echo e($settings->app_name ?? 'UltraFlix'); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/lottie-web/5.7.4/lottie.min.js"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>

    <style>
        .image-wrapper {
            position: relative;
            overflow: hidden;
            border-radius: 0.5rem;
            border: 2px solid transparent;
            transition: border-color 0.3s ease, transform 0.3s ease;
        }

        .image-wrapper:hover {
            border-color: white;
            transform: scale(1.05);
        }

        .remove-button {
            position: absolute;
            top: 5px;
            right: 5px;
            background-color: rgba(0, 0, 0, 0.7);
            color: white;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: opacity 0.2s ease;
            z-index: 10;
        }

        .remove-button:hover {
            background-color: rgba(220, 38, 38, 0.9);
        }

        .image-wrapper:hover .remove-button {
            opacity: 1;
        }

        .toast {
            position: fixed;
            bottom: 20px;
            right: 20px;
            padding: 12px 20px;
            background-color: rgba(0, 0, 0, 0.8);
            color: white;
            border-radius: 6px;
            z-index: 9999;
            transform: translateY(100px);
            opacity: 0;
            transition: all 0.3s ease;
        }

        .toast.show {
            transform: translateY(0);
            opacity: 1;
        }
    </style>
</head>
<body class="min-h-screen mb-10 text-white bg-black font-poppins">
    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container px-4 py-20 mx-auto">
        <h1 class="mb-8 text-3xl font-bold text-center">Meus Favoritos</h1>

        <?php if(session('error')): ?>
            <div class="px-4 py-3 mb-6 text-red-700 bg-red-100 border border-red-400 rounded" role="alert">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('warning')): ?>
            <div class="px-4 py-3 mb-6 text-yellow-700 bg-yellow-100 border border-yellow-400 rounded" role="alert">
                <?php echo e(session('warning')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('success')): ?>
            <div class="px-4 py-3 mb-6 text-green-700 bg-green-100 border border-green-400 rounded" role="alert">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <!-- Tabs -->
        <div class="flex justify-center gap-4 mb-8">
            <button onclick="openCategory(event, 'Filmes')"
                    class="px-6 py-2 transition-colors rounded-full tablinks bg-zinc-800 hover:bg-zinc-700">
                Filmes
            </button>
            <button onclick="openCategory(event, 'Series')"
                    class="px-6 py-2 transition-colors rounded-full tablinks bg-zinc-800 hover:bg-zinc-700">
                Séries
            </button>
            <button onclick="openCategory(event, 'Animes')"
                    class="px-6 py-2 transition-colors rounded-full tablinks bg-zinc-800 hover:bg-zinc-700">
                Animes
            </button>
        </div>

        <!-- Conteúdo das Tabs -->
        <div id="Filmes" class="hidden tabcontent">
            <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
                <?php $__empty_1 = true; $__currentLoopData = $favoriteMovies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="relative group" id="movie-item-<?php echo e($movie->id); ?>">
                        <a href="<?php echo e(route('filme.detail', ['id' => $movie->id])); ?>" class="block">
                            <div class="relative overflow-hidden rounded-lg image-wrapper">
                                <img src="<?php echo e($movie->poster_path); ?>"
                                    alt="<?php echo e($movie->title); ?>"
                                    class="w-full aspect-[2/3] object-cover">
                                <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                                <button type="button" 
                                        onclick="event.preventDefault(); event.stopPropagation(); removeFavorite('movie', <?php echo e($movie->id); ?>)" 
                                        class="remove-button" 
                                        title="Remover dos favoritos">
                                    <i class="fa-regular fa-circle-minus"></i>
                                </button>
                                <div class="absolute bottom-0 w-full p-2">
                                    <h3 class="text-sm font-semibold truncate"><?php echo e($movie->title); ?></h3>
                                    <div class="flex items-center mt-1">
                                        <span class="text-xs text-yellow-500">
                                            <i class="mr-1 fas fa-star"></i><?php echo e(number_format($movie->vote_average, 1)); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="flex flex-col items-center justify-center h-64 col-span-full">
                        <div id="lottie-animation-filmes" class="w-40 h-40"></div>
                        <p class="mt-4 text-gray-400">Nenhum filme adicionado aos favoritos</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div id="Series" class="hidden tabcontent">
            <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
                <?php $__empty_1 = true; $__currentLoopData = $favoriteSeries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $series): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="relative group" id="serie-item-<?php echo e($series->id); ?>">
                        <a href="<?php echo e(route('serie.detail', ['id' => $series->id])); ?>" class="block">
                            <div class="relative overflow-hidden rounded-lg image-wrapper">
                                <img src="<?php echo e($series->poster_path); ?>"
                                    alt="<?php echo e($series->name); ?>"
                                    class="w-full aspect-[2/3] object-cover">
                                <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                                <button type="button" 
                                        onclick="event.preventDefault(); event.stopPropagation(); removeFavorite('serie', <?php echo e($series->id); ?>)" 
                                        class="remove-button" 
                                        title="Remover dos favoritos">
                                    <i class="fa-regular fa-circle-minus"></i>
                                </button>
                                <div class="absolute bottom-0 w-full p-2">
                                    <h3 class="text-sm font-semibold truncate"><?php echo e($series->name); ?></h3>
                                    <div class="flex items-center mt-1">
                                        <span class="text-xs text-yellow-500">
                                            <i class="mr-1 fas fa-star"></i><?php echo e(number_format($series->vote_average, 1)); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="flex flex-col items-center justify-center h-64 col-span-full">
                        <div id="lottie-animation-series" class="w-40 h-40"></div>
                        <p class="mt-4 text-gray-400">Nenhuma série adicionada aos favoritos</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div id="Animes" class="hidden tabcontent">
            <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
                <?php $__empty_1 = true; $__currentLoopData = $favoriteAnimes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $anime): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="relative group" id="anime-item-<?php echo e($anime->id); ?>">
                        <a href="<?php echo e(route('anime.detail', ['id' => $anime->id])); ?>" class="block">
                            <div class="relative overflow-hidden rounded-lg image-wrapper">
                                <img src="<?php echo e($anime->poster_path); ?>"
                                    alt="<?php echo e($anime->name); ?>"
                                    class="w-full aspect-[2/3] object-cover">
                                <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                                <button type="button" 
                                        onclick="event.preventDefault(); event.stopPropagation(); removeFavorite('anime', <?php echo e($anime->id); ?>)" 
                                        class="remove-button" 
                                        title="Remover dos favoritos">
                                    <i class="fa-regular fa-circle-minus"></i>
                                </button>
                                <div class="absolute bottom-0 w-full p-2">
                                    <h3 class="text-sm font-semibold truncate"><?php echo e($anime->name); ?></h3>
                                    <div class="flex items-center mt-1">
                                        <span class="text-xs text-yellow-500">
                                            <i class="mr-1 fas fa-star"></i><?php echo e(number_format($anime->vote_average, 1)); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="flex flex-col items-center justify-center h-64 col-span-full">
                        <div id="lottie-animation-animes" class="w-40 h-40"></div>
                        <p class="mt-4 text-gray-400">Nenhum anime adicionado aos favoritos</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Toast de notificação -->
    <div id="toast" class="toast">
        <span id="toast-message"></span>
    </div>

    <!-- Fundo com gradiente -->
    <div class="fixed inset-0 -z-10 bg-gradient-to-br from-zinc-900 to-black"></div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Lottie Animations
            ['filmes', 'series', 'animes'].forEach(type => {
                lottie.loadAnimation({
                    container: document.getElementById(`lottie-animation-${type}`),
                    renderer: 'svg',
                    loop: true,
                    autoplay: true,
                    path: 'https://assets-v2.lottiefiles.com/a/a4c7388c-1150-11ee-a0fa-4b9598be54ec/6NRy3xpNKa.json'
                });
            });

            // Abre a primeira aba por padrão
            document.querySelector(".tablinks").click();
        });

        function openCategory(evt, categoryName) {
            // Esconde todos os conteúdos
            document.querySelectorAll(".tabcontent").forEach(tab => {
                tab.classList.add("hidden");
            });

            // Remove active de todas as tabs
            document.querySelectorAll(".tablinks").forEach(button => {
                button.classList.remove("bg-primary", "text-black");
                button.classList.add("bg-zinc-800", "text-white");
            });

            // Mostra o conteúdo selecionado
            document.getElementById(categoryName).classList.remove("hidden");

            // Marca a tab como ativa
            evt.currentTarget.classList.remove("bg-zinc-800", "text-white");
            evt.currentTarget.classList.add("bg-primary", "text-black");
        }

        // Função para remover item dos favoritos
        function removeFavorite(type, id) {
            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
            
            // Determinando a rota com base no tipo
            let endpoint;
            switch(type) {
                case 'movie':
                    endpoint = "<?php echo e(route('movie.removefromfav', '')); ?>/" + id;
                    break;
                case 'serie':
                    endpoint = "<?php echo e(route('serie.removefromfav', '')); ?>/" + id;
                    break;
                case 'anime':
                    endpoint = "<?php echo e(route('anime.removefromfav', '')); ?>/" + id;
                    break;
                default:
                    showToast('Tipo não reconhecido');
                    return;
            }
            
            // Realizando a requisição para remover dos favoritos
            fetch(endpoint, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken
                },
                credentials: 'same-origin'
            })
            .then(response => response.json())
            .then(data => {
                if (data.message) {
                    // Remove o elemento da interface
                    const element = document.getElementById(`${type}-item-${id}`);
                    if (element) {
                        element.classList.add('opacity-0', 'scale-95');
                        element.style.transition = 'all 0.3s ease';
                        
                        setTimeout(() => {
                            element.remove();
                            
                            // Verifica se a lista está vazia
                            const container = document.querySelector(`#${type === 'movie' ? 'Filmes' : type === 'serie' ? 'Series' : 'Animes'}`);
                            const items = container.querySelectorAll(`.relative.group`);
                            
                            if (items.length === 0) {
                                // Se não houver mais itens, mostra a mensagem de vazio
                                const emptyMessage = `
                                    <div class="flex flex-col items-center justify-center h-64 col-span-full">
                                        <div id="lottie-animation-${type === 'movie' ? 'filmes' : type === 'serie' ? 'series' : 'animes'}" class="w-40 h-40"></div>
                                        <p class="mt-4 text-gray-400">Nenhum ${type === 'movie' ? 'filme' : type === 'serie' ? 'série' : 'anime'} adicionado aos favoritos</p>
                                    </div>
                                `;
                                container.querySelector('.grid').innerHTML = emptyMessage;
                                
                                // Inicializa a animação Lottie
                                lottie.loadAnimation({
                                    container: document.getElementById(`lottie-animation-${type === 'movie' ? 'filmes' : type === 'serie' ? 'series' : 'animes'}`),
                                    renderer: 'svg',
                                    loop: true,
                                    autoplay: true,
                                    path: 'https://assets-v2.lottiefiles.com/a/a4c7388c-1150-11ee-a0fa-4b9598be54ec/6NRy3xpNKa.json'
                                });
                            }
                        }, 300);
                    }
                    
                    showToast(`Item removido dos favoritos`);
                } else {
                    showToast('Erro ao remover dos favoritos');
                }
            })
            .catch(error => {
                console.error('Erro:', error);
                showToast('Erro ao processar a solicitação');
            });
        }
        
        // Função para exibir toast de notificação
        function showToast(message) {
            const toast = document.getElementById('toast');
            const toastMessage = document.getElementById('toast-message');
            
            toastMessage.textContent = message;
            toast.classList.add('show');
            
            setTimeout(() => {
                toast.classList.remove('show');
            }, 3000);
        }
    </script>
</body>
</html>
<?php /**PATH /home/u446595196/domains/capixabaplay.com.br/public_html/play/resources/views/favoritos.blade.php ENDPATH**/ ?>