<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Meus Tickets de Suporte - <?php echo e($settings->app_name); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
</head>
<body class="min-h-screen mb-10 text-white bg-black font-poppins">
    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container relative z-10 px-3 pt-20 pb-8 mx-auto lg:px-4 lg:pt-24 lg:pb-12">
        <div class="flex flex-wrap items-center justify-between mb-6 lg:mb-8">
            <h1 class="font-bold text-white text-1xl lg:text-3xl">Tickets de Suporte</h1>
            <a href="<?php echo e(route('support.create')); ?>" class="px-4 py-2 mt-4 text-xs text-black transition duration-300 rounded-full lg:px-6 lg:text-base sm:mt-0 bg-primary hover:bg-primary-dark">
                <i class="mr-1 lg:mr-2 fas fa-plus"></i> Novo Ticket
            </a>
        </div>

        <?php if(session('success')): ?>
            <div class="px-3 py-2 mb-4 text-green-300 border border-green-500 rounded lg:px-4 lg:py-3 lg:mb-6 bg-green-500/20">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="px-3 py-2 mb-4 text-red-300 border border-red-500 rounded lg:px-4 lg:py-3 lg:mb-6 bg-red-500/20">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <div class="overflow-hidden shadow-lg rounded-xl bg-zinc-900/50">
            <?php if($tickets->count() > 0): ?>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="text-xs text-left bg-zinc-800/70">
                                <th class="px-3 py-3 lg:px-6 lg:py-4">#</th>
                                <th class="px-3 py-3 lg:px-6 lg:py-4">Assunto</th>
                                <th class="hidden px-3 py-3 lg:px-6 lg:py-4 md:table-cell">Categoria</th>
                                <th class="px-3 py-3 lg:px-6 lg:py-4">Status</th>
                                <th class="hidden px-3 py-3 lg:px-6 lg:py-4 md:table-cell">Data</th>
                                <th class="px-3 py-3 lg:px-6 lg:py-4">Ações</th>
                            </tr>
                        </thead>
                        <tbody class="text-xs divide-y divide-zinc-800">
                            <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="transition duration-150 hover:bg-zinc-800/30">
                                    <td class="px-3 py-3 text-xs lg:px-6 lg:py-4 lg:text-base"><?php echo e($ticket->id); ?></td>
                                    <td class="px-3 py-3 text-xs lg:px-6 lg:py-4 lg:text-base">
                                        <?php echo e(Str::limit($ticket->subject, 20, '...')); ?>

                                        <span class="hidden lg:inline"><?php echo e(substr($ticket->subject, 20, 30)); ?></span>
                                    </td>
                                    <td class="hidden px-3 py-3 text-xs lg:px-6 lg:py-4 lg:text-base md:table-cell">
                                        <?php
                                            $categories = App\Models\SupportTicket::getCategories();
                                        ?>
                                        <?php echo e($categories[$ticket->category] ?? $ticket->category); ?>

                                    </td>
                                    <td class="px-3 py-3 text-[7px] lg:px-6 lg:py-4 lg:text-base">
                                        <?php if($ticket->status == 'aberto'): ?>
                                            <span class="px-1.5 lg:px-2 py-0.5 lg:py-1  text-blue-300 rounded-full bg-blue-500/20">Aberto</span>
                                        <?php elseif($ticket->status == 'em_andamento'): ?>
                                            <span class="px-1.5 lg:px-2 py-0.5 lg:py-1  text-yellow-300 rounded-full bg-yellow-500/20">Em andamento</span>
                                        <?php elseif($ticket->status == 'resolvido'): ?>
                                            <span class="px-1.5 lg:px-2 py-0.5 lg:py-1  text-green-300 rounded-full bg-green-500/20">Resolvido</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="hidden px-3 py-3 text-xs lg:px-6 lg:py-4 lg:text-base md:table-cell"><?php echo e($ticket->created_at->format('d/m/Y H:i')); ?></td>
                                    <td class="px-3 py-3 text-xs lg:px-6 lg:py-4 lg:text-base">
                                        <a href="<?php echo e(route('support.show', $ticket->id)); ?>" class="text-primary hover:text-primary-dark">
                                            <span class="hidden sm:inline">Ver</span>
                                            <span class="hidden lg:inline"> detalhes</span>
                                            <i class="inline-block sm:hidden fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <div class="px-3 py-3 lg:px-6 lg:py-4">
                    <?php echo e($tickets->links()); ?>

                </div>
            <?php else: ?>
                <div class="px-4 py-8 text-center lg:px-6 lg:py-12">
                    <div class="flex flex-col items-center justify-center mb-6">
                        <div class="p-3 mb-4 text-3xl rounded-full lg:p-4 lg:text-4xl bg-zinc-800/50">
                            <i class="text-primary fas fa-ticket-alt"></i>
                        </div>
                        <p class="mb-4 text-base text-gray-400 lg:text-lg">Você ainda não possui tickets de suporte.</p>
                        <a href="<?php echo e(route('support.create')); ?>" class="inline-flex items-center text-primary hover:text-primary-dark">
                            <i class="mr-1 lg:mr-2 fas fa-plus"></i> Criar meu primeiro ticket
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/support/index.blade.php ENDPATH**/ ?>