<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Desenhos - <?php echo e($settings->app_name); ?>Conecta Plus</title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
    <style>
        .image-wrapper {
            position: relative;
            overflow: hidden;
            border-radius: 0.5rem;
            border: 2px solid transparent;
            transition: border-color 0.3s ease, transform 0.3s ease;
        }

        .image-wrapper:hover {
            border-color: white;
            transform: scale(1.05);
        }
    </style>
</head>
<body class="min-h-screen text-white bg-black font-poppins">
    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container px-4 py-20 mx-auto">
        <!-- Filtro -->
        <div class="mb-8">
            <form action="<?php echo e(route('animes.index')); ?>" method="GET" class="max-w-xs">
                <?php echo csrf_field(); ?>
                <h3 class="mb-4 text-xl font-bold">Desenhos</h3>
                <div class="relative">
                    <div class="relative cursor-pointer">
                        <div class="flex items-center justify-between px-4 py-2 text-white rounded-full dropdown-selected bg-zinc-800">
                            <span class="selected-text"><?php echo e(request('genre') ? optional($genres->where('id', request('genre'))->first())->name ?? 'Todos' : 'Todos'); ?></span>
                            <i class="ml-2 fas fa-chevron-down"></i>
                        </div>
                        <div class="absolute z-50 hidden w-full mt-2 overflow-hidden rounded-lg shadow-xl dropdown-options bg-zinc-800">
                            <div class="px-4 py-2 transition-colors cursor-pointer dropdown-option hover:bg-zinc-700"
                                 data-value="">
                                Todos
                            </div>
                            <?php $__currentLoopData = $genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="px-4 py-2 transition-colors cursor-pointer dropdown-option hover:bg-zinc-700"
                                     data-value="<?php echo e($genre->id); ?>">
                                    <?php echo e($genre->name); ?>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <select name="genre" id="genre" class="hidden">
                        <option value="" <?php echo e(!request('genre') ? 'selected' : ''); ?>>Todos</option>
                        <?php $__currentLoopData = $genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($genre->id); ?>" <?php echo e(request('genre') == $genre->id ? 'selected' : ''); ?>>
                                <?php echo e($genre->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </form>
        </div>

        <!-- Grid de Animes -->
        <div id="animes-grid" class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
            <?php $__currentLoopData = $animes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $anime): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('anime.detail', $anime->id)); ?>" class="block group">
                    <div class="relative overflow-hidden rounded-lg image-wrapper">
                        <img src="<?php echo e($anime->poster_path); ?>"
                             alt="<?php echo e($anime->name); ?>"
                             class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105"
                             loading="lazy">
                        <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Loading Indicator -->
        <div id="loading-indicator" class="hidden py-8 text-center">
            <div class="inline-block w-8 h-8 border-4 rounded-full animate-spin border-primary border-r-transparent"></div>
        </div>
    </div>

    <!-- Fundo com gradiente -->
    <div class="fixed inset-0 -z-10 bg-gradient-to-br from-zinc-900 to-black"></div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Dropdown functionality
            const dropdown = document.querySelector('.dropdown-selected');
            const options = document.querySelector('.dropdown-options');
            const select = document.querySelector('select');
            const selectedText = document.querySelector('.selected-text');

            const updateSelectedText = () => {
                const selected = select.options[select.selectedIndex];
                if (selected) selectedText.textContent = selected.text;
            };
            updateSelectedText();

            dropdown.addEventListener('click', () => {
                options.classList.toggle('hidden');
            });

            options.addEventListener('click', (e) => {
                if (e.target.classList.contains('dropdown-option')) {
                    selectedText.textContent = e.target.textContent;
                    select.value = e.target.dataset.value;
                    options.classList.add('hidden');
                    select.closest('form').submit();
                }
            });

            document.addEventListener('click', (e) => {
                if (!dropdown.contains(e.target)) {
                    options.classList.add('hidden');
                }
            });

            // Infinite Scroll - Versão atualizada
            let currentPage = <?php echo e(request()->get('page', 1)); ?>;
            let isLoading = false;
            let hasMorePages = <?php echo e(isset($animes) && method_exists($animes, 'hasMorePages') && $animes->hasMorePages() ? 'true' : 'false'); ?>;
            const animesGrid = document.getElementById('animes-grid');
            const loadingIndicator = document.getElementById('loading-indicator');
            // Use o valor do select, que agora pode ser uma string vazia para "Todos"
            const genre = document.getElementById('genre').value;

            function loadMoreAnimes() {
                if (isLoading || !hasMorePages) return;

                isLoading = true;
                loadingIndicator.classList.remove('hidden');

                const nextPage = currentPage + 1;
                const url = new URL(window.location.href);
                url.searchParams.set('page', nextPage);

                // Só adiciona o gênero se houver um selecionado
                if (genre) {
                    url.searchParams.set('genre', genre);
                } else {
                    // Remove o parâmetro genre se existir
                    url.searchParams.delete('genre');
                }

                fetch(url, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                })
                .then(response => response.text())
                .then(html => {
                    try {
                        const parser = new DOMParser();
                        const doc = parser.parseFromString(html, 'text/html');
                        const newAnimesElement = doc.getElementById('animes-grid');

                        if (newAnimesElement && newAnimesElement.innerHTML.trim()) {
                            animesGrid.insertAdjacentHTML('beforeend', newAnimesElement.innerHTML);
                            currentPage = nextPage;
                        } else {
                            console.log('Não há mais animes para carregar');
                            hasMorePages = false;
                        }
                    } catch (e) {
                        console.error('Erro ao processar HTML:', e);
                        hasMorePages = false;
                    }
                })
                .catch(error => {
                    console.error('Erro ao buscar mais animes:', error);
                    hasMorePages = false;
                })
                .finally(() => {
                    isLoading = false;
                    loadingIndicator.classList.add('hidden');
                });
            }

            // Detect scroll
            window.addEventListener('scroll', () => {
                const { scrollTop, scrollHeight, clientHeight } = document.documentElement;

                if (scrollTop + clientHeight >= scrollHeight - 800) { // 800px before bottom
                    loadMoreAnimes();
                }
            });
        });
    </script>
</body>
</html>
<?php /**PATH /home/u446595196/domains/conectaplus.tv.br/public_html/resources/views/layouts/pages/animes.blade.php ENDPATH**/ ?>