<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <title><?php echo e($settings->app_name); ?> - Assista Filmes Séries e Animes</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Bungee+Spice&family=Poppins:wght@300;400;500;600;700&family=Roboto:wght@400;500;900&family=Work+Sans:wght@900&display=swap" rel="stylesheet">
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #D4AF37;
            --primary-hover: #D4AF37;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: #0f0f0f;
        }

        .bg-primary {
            background-color: var(--primary-color);
        }

        .hover\:bg-primary-dark:hover {
            background-color: var(--primary-hover);
        }

        .text-primary {
            color: var(--primary-color);
        }

        .movie-card {
            transition: transform 0.3s, box-shadow 0.3s;
            overflow: hidden;
            border-radius: 8px;
            position: relative;
        }

        .movie-card:hover {
            transform: translateY(-5px) scale(1.02);
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.3);
        }

        .movie-card img {
            transition: all 0.5s;
        }

        .movie-card:hover img {
            transform: scale(1.05);
        }

        .gradient-overlay {
            background: linear-gradient(to top, rgba(0,0,0,0.9), transparent);
        }

        .faq-question {
            position: relative;
            padding-right: 40px;
        }

        .faq-question:after {
            content: '+';
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 1.5rem;
            transition: transform 0.3s;
        }

        .faq-question.active:after {
            transform: translateY(-50%) rotate(45deg);
        }

        .faq-answer {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.5s cubic-bezier(0, 1, 0, 1);
        }

        .faq-answer.active {
            max-height: 1000px;
            transition: max-height 1s ease-in-out;
        }

        .header-blur {
            backdrop-filter: blur(10px);
        }

        .custom-animation {
            animation: slideUp 0.8s ease-out;
        }

        @keyframes slideUp {
            0% {
                opacity: 0;
                transform: translateY(20px);
            }
            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .btn-primary {
            background-color: var(--primary-color);
            color: white;
            transition: all 0.3s;
        }

        .btn-primary:hover {
            background-color: var(--primary-hover);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgb(254 255 3 / 30%);
        }

        .stat-card {
            border-left: 4px solid var(--primary-color);
            transition: transform 0.3s;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        @media (max-width: 640px) {
            .faq-answer {
                font-size: 0.9rem;
                line-height: 1.4;
            }
        }
    </style>
</head>
<body class="min-h-screen text-white font-poppins">
    <?php if(auth()->check()): ?>
        <script>window.location.href = '<?php echo e(route('inicio')); ?>';</script>
    <?php endif; ?>

    <!-- Header Moderno -->
    <header class="fixed top-0 z-50 w-full px-4 py-3 transition-all duration-300 bg-black bg-opacity-50 header-blur sm:px-6 sm:py-4">
        <div class="container flex items-center justify-between mx-auto max-w-7xl">
            <div class="w-16 transition-all duration-300 sm:w-28">
                <img src="<?php echo e(route('minilogo')); ?>" alt="Logo" class="w-full">
            </div>
            <div class="flex gap-3 sm:gap-5">
                <button class="px-4 sm:px-6 py-1.5 sm:py-2 text-sm sm:text-base bg-transparent border-2 border-white text-white rounded-full hover:bg-white hover:text-black transition-all duration-300" onclick="location.href='<?php echo e(route('login')); ?>'">
                    <i class="mr-1 fa-solid fa-right-to-bracket"></i> Entrar
                </button>
                <button class="px-4 sm:px-6 py-1.5 sm:py-2 text-sm sm:text-base btn-primary font-semibold rounded-full" onclick="location.href='<?php echo e(route('register')); ?>'">
                    <i class="mr-1 fa-solid fa-user-plus"></i> Criar Conta
                </button>
            </div>
        </div>
    </header>

    <!-- Hero section ajustada (sem vídeo e com imagem de fundo visível) -->
    <div class="relative min-h-screen">
        <div class="absolute inset-0 z-0">
            <img src="<?php echo e(asset('images/background-landing.jpg')); ?>"
                alt=""
                class="object-cover w-full h-full opacity-50">
            <div class="absolute inset-0 bg-gradient-to-t from-black via-black/70 to-black/30"></div>
        </div>
        <div class="relative z-10 flex flex-col items-center justify-center min-h-screen px-4 pt-16 text-center sm:pt-20" data-aos="fade-up" data-aos-duration="1000">
            <h1 class="mb-3 text-4xl font-bold sm:text-5xl md:text-6xl text-primary custom-animation"><?php echo e($settings->app_name); ?></h1>
            <h3 class="max-w-3xl mx-auto mb-6 text-2xl font-bold leading-tight sm:text-3xl md:text-4xl sm:mb-8 custom-animation">Milhares de Filmes e Séries para você curtir com a família, sem travamentos, sem preços altos.</h3>
            <div class="mt-6 sm:mt-10 custom-animation">
                <h4 class="flex items-center justify-center mb-6 space-x-3 text-lg sm:text-xl">
                    <span><i class="text-green-500 fa-solid fa-circle-check"></i> Sem anúncios</span>
                    <span><i class="text-green-500 fa-solid fa-circle-check"></i> HD e Full HD</span>
                    <span><i class="text-green-500 fa-solid fa-circle-check"></i> Catálogo extenso</span>
                </h4>
                <button class="px-8 py-4 text-lg font-semibold text-white transition-all duration-300 rounded-full btn-primary sm:text-xl" onclick="location.href='<?php echo e(route('register')); ?>'">
                    Comece Agora <i class="ml-2 fa-solid fa-arrow-right"></i>
                </button>
                <p class="mt-4 text-gray-300">Cancele quando quiser. Sem compromisso.</p>
            </div>
        </div>
    </div>

    <!-- Seção de planos redesenhada -->
    <div class="container px-4 py-16 mx-auto max-w-7xl sm:px-6 lg:px-8 sm:py-24">
        <div class="flex flex-col items-center justify-between gap-10 md:flex-row">
            <div class="w-full md:w-1/2" data-aos="fade-right" data-aos-duration="1000">
                <div class="w-full h-48 lottie-container sm:h-64"></div>
            </div>
            <div class="w-full text-center md:w-1/2 md:text-left" data-aos="fade-left" data-aos-duration="1000" data-aos-delay="200">
                <span class="inline-block px-3 py-1 mb-4 text-sm font-semibold rounded-full bg-primary/20 text-primary">Plano Acessível</span>
                <h2 class="mb-4 text-3xl font-bold sm:text-4xl">Comece com o Básico</h2>
                <p class="mb-6 text-lg text-gray-300 sm:text-xl">Experimente nosso plano de 15 dias por apenas <span class="font-bold text-primary">R$6,90</span>.</p>
                <ul class="mb-8 space-y-2">
                    <li class="flex items-center text-gray-300"><i class="mr-3 text-green-500 fa-solid fa-check"></i> Acesso a todo conteúdo</li>
                    <li class="flex items-center text-gray-300"><i class="mr-3 text-green-500 fa-solid fa-check"></i> Até 2 dispositivos simultâneos</li>
                    <li class="flex items-center text-gray-300"><i class="mr-3 text-green-500 fa-solid fa-check"></i> Disponível em todos dispositivos</li>
                </ul>
                <button class="px-6 py-3 text-base font-semibold text-white transition-all duration-300 rounded-full bg-primary sm:text-lg hover:bg-primary" onclick="location.href='/register'">
                    Assine Agora <i class="ml-2 fa-solid fa-arrow-right"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- Grid de filmes e séries redesenhado -->
    <div class="container px-4 py-16 mx-auto max-w-7xl sm:px-6 lg:px-8">
        <div class="mb-12 text-center" data-aos="fade-up" data-aos-duration="1000">
            <span class="inline-block px-3 py-1 mb-2 text-sm font-semibold rounded-full bg-primary/20 text-primary">Nosso Catálogo</span>
            <h2 class="text-3xl font-bold sm:text-4xl">Conteúdo Premium</h2>
            <p class="mt-3 text-gray-400">Descubra os títulos mais populares disponíveis em nossa plataforma</p>
        </div>

        <h3 class="mb-6 text-2xl font-bold sm:text-3xl" data-aos="fade-right" data-aos-duration="800">Filmes Populares</h3>
        <div class="grid grid-cols-2 gap-4 mb-16 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 sm:gap-6">
            <?php $__currentLoopData = $topMovies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="movie-card" data-aos="fade-up" data-aos-duration="800" data-aos-delay="<?php echo e($loop->index * 50); ?>">
                    <div class="relative overflow-hidden rounded-lg aspect-[2/3] group">
                        <img src="<?php echo e($movie->poster_path); ?>" alt="<?php echo e($movie->title); ?>" class="object-cover w-full h-full">
                        <div class="absolute inset-0 flex flex-col items-center justify-end p-4 transition-opacity duration-300 opacity-0 gradient-overlay group-hover:opacity-100">
                            <h4 class="text-sm font-semibold text-center sm:text-base"><?php echo e($movie->title); ?></h4>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <h3 class="mb-6 text-2xl font-bold sm:text-3xl" data-aos="fade-right" data-aos-duration="800">Séries Populares</h3>
        <div class="grid grid-cols-2 gap-4 mb-16 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 sm:gap-6">
            <?php $__currentLoopData = $topSeries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="movie-card" data-aos="fade-up" data-aos-duration="800" data-aos-delay="<?php echo e($loop->index * 50); ?>">
                    <div class="relative overflow-hidden rounded-lg aspect-[2/3] group">
                        <img src="<?php echo e($serie->poster_path); ?>" alt="<?php echo e($serie->name); ?>" class="object-cover w-full h-full">
                        <div class="absolute inset-0 flex flex-col items-center justify-end p-4 transition-opacity duration-300 opacity-0 gradient-overlay group-hover:opacity-100">
                            <h4 class="text-sm font-semibold text-center sm:text-base"><?php echo e($serie->name); ?></h4>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Estatísticas redesenhadas -->
        <div class="py-16">
            <div class="mb-12 text-center" data-aos="fade-up" data-aos-duration="1000">
                <span class="inline-block px-3 py-1 mb-2 text-sm font-semibold rounded-full bg-primary/20 text-primary">Números Impressionantes</span>
                <h2 class="text-3xl font-bold sm:text-4xl">Nosso Catálogo em Números</h2>
                <p class="mt-3 text-gray-400">Uma biblioteca extensa e sempre atualizada de conteúdo premium</p>
            </div>

            <div class="flex flex-col items-center justify-between mb-16 md:flex-row">
                <div class="w-full mb-10 md:w-1/2 md:mb-0" data-aos="fade-right" data-aos-duration="1000">
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <div class="p-6 rounded-lg bg-gray-900/60 stat-card">
                            <div class="flex items-center mb-2">
                                <i class="text-3xl text-primary fa fa-film"></i>
                                <h4 class="ml-3 text-2xl font-bold"><?php echo e($totalMovies); ?></h4>
                            </div>
                            <p class="text-gray-400">Filmes</p>
                        </div>
                        <div class="p-6 rounded-lg bg-gray-900/60 stat-card">
                            <div class="flex items-center mb-2">
                                <i class="text-3xl text-primary fa fa-tv"></i>
                                <h4 class="ml-3 text-2xl font-bold"><?php echo e($totalSeries); ?></h4>
                            </div>
                            <p class="text-gray-400">Séries</p>
                        </div>
                        <div class="p-6 rounded-lg bg-gray-900/60 stat-card">
                            <div class="flex items-center mb-2">
                                <i class="text-3xl text-primary fa fa-play-circle"></i>
                                <h4 class="ml-3 text-2xl font-bold"><?php echo e($totalEpisodes); ?></h4>
                            </div>
                            <p class="text-gray-400">Episódios</p>
                        </div>
                        <div class="p-6 rounded-lg bg-gray-900/60 stat-card">
                            <div class="flex items-center mb-2">
                                <i class="text-3xl text-primary fa fa-ghost"></i>
                                <h4 class="ml-3 text-2xl font-bold"><?php echo e($totalAnimes); ?></h4>
                            </div>
                            <p class="text-gray-400">Animes</p>
                        </div>
                    </div>
                </div>
                <div class="flex justify-center w-full md:w-1/2" data-aos="fade-left" data-aos-duration="1000" data-aos-delay="200">
                    <img src="https://i.imgur.com/vz3en64.png" alt="" class="w-full max-w-md transition-transform hover:scale-105">
                </div>
            </div>

            <div class="flex flex-col items-center py-12 my-16 bg-gray-900/30 rounded-xl" data-aos="fade-up" data-aos-duration="1000">
                <h3 class="mb-6 text-2xl font-bold text-center">Disponível no Google Play</h3>
                <a href="<?php echo e($settings->app_url_android); ?>" class="transition-transform hover:scale-105">
                    <img src="https://play.google.com/intl/pt-BR/badges/static/images/badges/pt-br_badge_web_generic.png" alt="Google Play" class="h-16">
                </a>
            </div>

            <!-- FAQ redesenhado -->
            <div class="max-w-3xl px-4 mx-auto sm:px-0" data-aos="fade-up" data-aos-duration="1000">
                <div class="mb-10 text-center">
                    <span class="inline-block px-3 py-1 mb-2 text-sm font-semibold rounded-full bg-primary/20 text-primary">FAQ</span>
                    <h3 class="text-3xl font-bold">Perguntas Frequentes</h3>
                    <p class="mt-3 text-gray-400">Respostas para as dúvidas mais comuns sobre nosso serviço</p>
                </div>
                <div class="space-y-4">
                    <div class="overflow-hidden rounded-lg">
                        <div class="p-4 transition-colors duration-200 bg-gray-800 cursor-pointer sm:p-5 faq-question hover:bg-gray-700">
                            O que é o <?php echo e($settings->app_name); ?>?
                        </div>
                        <div class="p-0 faq-answer">
                            <div class="p-4 bg-gray-700 sm:p-5">
                                O <?php echo e($settings->app_name); ?> é um serviço de streaming que oferece uma ampla variedade de séries, filmes e documentários premiados em milhares de aparelhos conectados à internet. Você pode assistir a quantos filmes e séries quiser, quando e onde quiser – tudo por um preço mensal acessível. Aqui você sempre encontra novidades. A cada semana, adicionamos novas séries e filmes.
                            </div>
                        </div>
                    </div>
                    <div class="overflow-hidden rounded-lg">
                        <div class="p-4 transition-colors duration-200 bg-gray-800 cursor-pointer sm:p-5 faq-question hover:bg-gray-700">
                            Quanto Custa?
                        </div>
                        <div class="p-0 faq-answer">
                            <div class="p-4 bg-gray-700 sm:p-5">
                                Assista ao <?php echo e($settings->app_name); ?> no seu celular, tablet, Smart TV, notebook ou aparelho de streaming por uma taxa mensal única. Os planos variam de R$6 a R$10 por mês. Sem contrato nem taxas extras.
                            </div>
                        </div>
                    </div>
                    <div class="overflow-hidden rounded-lg">
                        <div class="p-4 transition-colors duration-200 bg-gray-800 cursor-pointer sm:p-5 faq-question hover:bg-gray-700">
                            Quais as formas de pagamento?
                        </div>
                        <div class="p-0 faq-answer">
                            <div class="p-4 bg-gray-700 sm:p-5">
                                Você pode ativar sua assinatura usando cartão do Pix QRCode.
                            </div>
                        </div>
                    </div>
                    <div class="overflow-hidden rounded-lg">
                        <div class="p-4 transition-colors duration-200 bg-gray-800 cursor-pointer sm:p-5 faq-question hover:bg-gray-700">
                            Tem algum limite?
                        </div>
                        <div class="p-0 faq-answer">
                            <div class="p-4 bg-gray-700 sm:p-5">
                                Você pode logar em até 2 dispositivos diferentes e criar até 5 perfis diferentes.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer mais elegante com logo em preto e branco -->
    <footer class="relative py-12 bg-black">
        <div class="container px-4 mx-auto max-w-7xl">
            <div class="flex flex-col items-center justify-between space-y-6 md:flex-row md:space-y-0">
                <div class="w-24 sm:w-32">
                    <img src="<?php echo e(route('minilogo')); ?>" alt="Logo" class="w-full" style="filter: grayscale(100%)">
                </div>
                <div class="text-center md:text-right">
                    <p class="mb-2 text-gray-400"><?php echo e($settings->app_name); ?> 2023 &copy; - Todos os direitos reservados</p>

                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/lottie-web/5.7.4/lottie.min.js"></script>

    <script>
        // Inicializa AOS
        AOS.init({
            once: true,
            disable: 'mobile'
        });

        // Controle de scroll para efeito de header
        window.addEventListener('scroll', function() {
            const header = document.querySelector('header');
            if (window.scrollY > 50) {
                header.classList.add('bg-black');
                header.classList.remove('bg-opacity-50');
                header.classList.add('bg-opacity-90');
                header.classList.add('py-2');
                header.classList.remove('py-3', 'sm:py-4');
            } else {
                header.classList.remove('bg-opacity-90');
                header.classList.add('bg-opacity-50');
                header.classList.remove('py-2');
                header.classList.add('py-3', 'sm:py-4');
            }
        });

        // Animação Lottie
        var animation = bodymovin.loadAnimation({
            container: document.querySelector('.lottie-container'),
            path: 'https://lottie.host/566221ba-1f82-490f-bf9c-442f8e739c82/gyKr3Dv4C7.json',
            renderer: 'svg',
            loop: true,
            autoplay: true
        });

        // Controlador de FAQ
        document.querySelectorAll('.faq-question').forEach(item => {
            item.addEventListener('click', () => {
                const answer = item.nextElementSibling;
                const isActive = item.classList.contains('active');

                // Fecha todos os outros
                document.querySelectorAll('.faq-question').forEach(q => {
                    q.classList.remove('active');
                    q.nextElementSibling.classList.remove('active');
                });

                if (!isActive) {
                    item.classList.add('active');
                    answer.classList.add('active');
                }
            });
        });
    </script>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/landing.blade.php ENDPATH**/ ?>