<section class="container-slides">
    <div >
        <?php if($continueWatching->isNotEmpty()): ?>
        <section class="continue-watching">
            <div class="titulo-container">
                <h2 class="titulo">Continue Assistindo</h2>
            </div>
            <div class="splide" id="continue-watching-carousel">
                <div class="splide__track">
                    <ul class="splide__list">
                        <?php $__currentLoopData = $continueWatching; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $path = null;
        $backdrop = null;
        $title = null;

        switch ($item->type) {
            case 'movie':
                $path = route('filme.detail', ['id' => $item->id]);
                $backdrop = $item->backdrop_path;
                $title = $item->title;
                break;
            case 'serie':
                $path = route('serie.detail', ['id' => $item->serie_id]);
                $backdrop = $item->still_path;
                $title = $item->episode_name;
                break;
            case 'anime':
                $path = route('anime.detail', ['id' => $item->id]);
                $backdrop = $item->still_path;
                $title = $item->name;
                break;
        }
    ?>
    <?php if($path): ?>  <!-- Assegure-se de que o caminho foi definido -->
        <li class="splide__slide">
            <a href="<?php echo e($path); ?>" class="movie-card">
                <div class="movie-backdrop-container">
                    <img src="<?php echo e($backdrop); ?>" alt="<?php echo e($title); ?>" class="movie-backdrop">
                </div>
                <div class="progress">
                    <div class="progress-bar" style="width: 14%;"></div>
                </div>
                <div class="movie-details">
                    <h3><?php echo e($title); ?></h3>
                    <button class="continue-watching-btn">
                        <i class="fa fa-play" aria-hidden="true" style="margin-right: 5px"></i> Continuar Assistindo
                    </button>
                </div>
            </a>
        </li>
    <?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
                </div>
            </div>
        </section>
    <?php endif; ?>
    



    <section class="top10series">
        <div class="titulo-container">
            <h2 class="titulo">Top 10 Filmes</h2>
        </div>
        <div class="splide" id="top10-carousel">
            <div class="splide__track">
                <ul class="splide__list">
                    <?php $__currentLoopData = $top10; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $filme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="splide__slide <?php echo e($index === 9 ? 'serie-menor' : ''); ?>">
                            <div class="top10-posicao">
                                <!-- <span class="top10-numero"><?php echo e($index + 1); ?></span> -->
                            </div>
                            <a href="<?php echo e(route('filme.detail', ['id' => $filme->id])); ?>">
                                <div class="top10-info">
                                    <img loading="lazy" class="img-top10" src="<?php echo e($filme->poster_path); ?>" alt="<?php echo e($filme->name); ?>">
                                </div>
                            </a>
                            <!-- <span class="ano"><?php echo e(date('Y', strtotime($filme->release_date))); ?></span> -->
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    </section>

        <section class="choosed">
            <div class="titulo-container">
                <h2 class="titulo">Selecionados</h2>
            </div>
            <div class="splide" id="choosed-carousel">
                <div class="splide__track">
                    <ul class="splide__list">
                        <?php $__currentLoopData = $pinned; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pinned): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="splide__slide">
                                <?php if($pinned->type === 'movie'): ?>
                                    <a href="<?php echo e(route('filme.detail', ['id' => $pinned->id])); ?>">
                                <?php elseif($pinned->type === 'serie'): ?>
                                    <a href="<?php echo e(route('serie.detail', ['id' => $pinned->id])); ?>">
                                <?php endif; ?>
                                <div class="choosed-info">
                                    <figure class="pinned">
                                        <img loading="lazy" class="img-pinned" src="<?php echo e($pinned->backdrop_path); ?>" alt="<?php echo e($pinned->name); ?>">
                                    </figure>
                                </div>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </section>

        <section class="ultimos">
            <div class="titulo-container">
                <h2 class="titulo">Adicionados Recentemente</h2>
            </div>
            <div class="splide" id="ultimos-carousel">
                <div class="splide__track">
                    <ul class="splide__list">
                        <?php $__currentLoopData = $latest; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ultimos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="splide__slide">
                                <?php if($ultimos->type === 'movie'): ?>
                                    <a href="<?php echo e(route('filme.detail', ['id' => $ultimos->id])); ?>">
                                <?php elseif($ultimos->type === 'serie'): ?>
                                    <a href="<?php echo e(route('serie.detail', ['id' => $ultimos->id])); ?>">
                                <?php endif; ?>
                                <div class="filme-info">
                                    <img loading="lazy" class="img-top10" src="<?php echo e($ultimos->poster_path); ?>" alt="<?php echo e($ultimos->name); ?>">
                                </div>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </section>

        <section class="top10filmes">
            <div class="titulo-container">
                <h2 class="titulo">Top 10 Séries</h2>
            </div>
            <div class="splide" id="top10series-carousel">
                <div class="splide__track">
                    <ul class="splide__list">
                        <?php $__currentLoopData = $top10series; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $serietop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="splide__slide <?php echo e($index === 9 ? 'filme-menor' : ''); ?>">
                                <a href="<?php echo e(route('serie.detail', ['id' => $serietop->id])); ?>">
                                    <div class="top10-info">
                                        <!-- <span class="numero <?php echo e($index === 9 ? 'numero-menor' : ''); ?>"><?php echo e($index + 1); ?></span> -->
                                        <img loading="lazy" class="img-top10" src="<?php echo e($serietop->poster_path); ?>" alt="<?php echo e($serietop->name); ?>">
                                    </div>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </section>

        <section class="trending">
            <div class="titulo-container">
                <h2 class="titulo">Em Alta</h2>
            </div>
            <div class="splide" id="trending-carousel">
                <div class="splide__track">
                    <ul class="splide__list">
                        <?php $__currentLoopData = $trending; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trending): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="splide__slide">
                                <?php if($trending->type === 'movie'): ?>
                                    <a href="<?php echo e(route('filme.detail', ['id' => $trending->id])); ?>">
                                <?php elseif($trending->type === 'serie'): ?>
                                    <a href="<?php echo e(route('serie.detail', ['id' => $trending->id])); ?>">
                                <?php endif; ?>
                                <div class="filme-info">
                                    <img loading="lazy" class="img-top10" src="<?php echo e($trending->poster_path); ?>" alt="<?php echo e($trending->name); ?>">
                                </div>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </section>

        <section class="trending">
            <div class="titulo-container">
                <h2 class="titulo">Últimas Séries</h2>
            </div>
            <div class="splide" id="srecentes-carousel">
                <div class="splide__track">
                    <ul class="splide__list">
                        <?php $__currentLoopData = $recents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seriesRecentes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="splide__slide">
                                    <a href="<?php echo e(route('serie.detail', ['id' => $seriesRecentes->id])); ?>">
                                <div class="filme-info">
                                    <img loading="lazy" class="img-top10" src="<?php echo e($seriesRecentes->poster_path); ?>" alt="<?php echo e($seriesRecentes->name); ?>">
                                </div>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </section>

        <section class="choosed">
            <div class="titulo-container">
                <h2 class="titulo">Últimos Episódios de Séries</h2>
            </div>
            <div class="splide" id="episodio-carousel">
                <div class="splide__track">
                    <ul class="splide__list">
                    <?php $__currentLoopData = $latest_episodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $episode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="splide__slide">
                            <a href="<?php echo e(route('serie.detail', ['id' => $episode->serie_id])); ?>">
                                <div class="choosed-info">
                                <figure class="pinned">
                                    <img loading="lazy" class="img-pinned" src="<?php echo e(empty($episode->still_path) ? $episode->serie_backdrop : $episode->still_path); ?>" alt="<?php echo e($episode->episode_name); ?>">
                                </figure>
                                    <!-- Adicionando título do episódio, nome da série, número da temporada e número do episódio -->
                                    <p class="episode-title">
                                        <?php echo e($episode->serie_name); ?>: T<?php echo e(str_pad($episode->season_number, 2, '0', STR_PAD_LEFT)); ?>E<?php echo e(str_pad($episode->episode_number, 2, '0', STR_PAD_LEFT)); ?> <?php echo e($episode->episode_name); ?>

                                    </p>
                                </div>
                            </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </section>

        <section class="trending">
            <div class="titulo-container">
                <h2 class="titulo">Novelas</h2>
            </div>
            <div class="splide" id="novelas-carousel">
                <div class="splide__track">
                    <ul class="splide__list">
                        <?php $__currentLoopData = $novelas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $novelas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="splide__slide">
                                    <a href="<?php echo e(route('serie.detail', ['id' => $novelas->id])); ?>">
                                <div class="filme-info">
                                    <img loading="lazy" class="img-top10" src="<?php echo e($novelas->poster_path); ?>" alt="<?php echo e($novelas->name); ?>">
                                </div>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </section>

        <section class="trending">
            <div class="titulo-container">
                <h2 class="titulo">Recomendados</h2>
            </div>
            <div class="splide" id="recomendados-carousel">
                <div class="splide__track">
                    <ul class="splide__list">
                        <?php $__currentLoopData = $recommended; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recomendados): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="splide__slide">
                                <?php if($recomendados->type === 'movie'): ?>
                                    <a href="<?php echo e(route('filme.detail', ['id' => $recomendados->id])); ?>">
                                <?php elseif($recomendados->type === 'serie'): ?>
                                    <a href="<?php echo e(route('serie.detail', ['id' => $recomendados->id])); ?>">
                                <?php elseif($recomendados->type === 'anime'): ?>
                                    <a href="<?php echo e(route('anime.detail', ['id' => $recomendados->id])); ?>">
                                <?php endif; ?>

                                <div class="filme-info">
                                    <img loading="lazy" class="img-top10" src="<?php echo e($recomendados->poster_path); ?>" alt="<?php echo e($recomendados->name); ?>">
                                </div>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </section>

    </div>
</section>

<!-- Include Splide JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/js/splide.min.js"></script>
<!-- Initialize Splide for each carousel -->
<script>
    new Splide('#top10-carousel', {
        perPage: 3,
        rewind: true,
        arrows:false,
        gap:7,
        pagination: false,
        breakpoints: {
            620: {
                perPage: 3,
            },
            820: {
                perPage: 4,
            },
            1020: {
                perPage: 6,
            },
            1920: {
                perPage: 7,
            },
            2590: {
                perPage: 9,
            },
        },
    }).mount();

    new Splide('#top10series-carousel', {
        perPage: 3,
        rewind: true,
        arrows:false,
        gap:7,
        pagination: false,
        breakpoints: {
            620: {
                perPage: 3,
            },
            820: {
                perPage: 4,
            },
            1020: {
                perPage: 6,
            },
            1920: {
                perPage: 7,
            },
            2590: {
                perPage: 9,
            },
        },
    }).mount();

    new Splide('#srecentes-carousel', {
        perPage: 3,
        rewind: true,
        arrows:false,
        gap:7,
        pagination: false,
        breakpoints: {
            620: {
                perPage: 3,
            },
            820: {
                perPage: 4,
            },
            1020: {
                perPage: 6,
            },
            1920: {
                perPage: 7,
            },
            2590: {
                perPage: 9,
            },
        },
    }).mount();

    new Splide('#ultimos-carousel', {
        perPage: 3,
        rewind: true,
        arrows:false,
        cover:true,
        gap:7,
        pagination: false,
        breakpoints: {
            620: {
                perPage: 3,
            },
            820: {
                perPage: 4,
            },
            1020: {
                perPage: 6,
            },
            1920: {
                perPage: 7,
            },
            2590: {
                perPage: 9,
            },
        },
    }).mount();

    new Splide('#trending-carousel', {
        perPage: 3,
        rewind: true,
        arrows:false,
        cover:true,
        gap:7,
        pagination: false,
        breakpoints: {
            620: {
                perPage: 3,
            },
            820: {
                perPage: 4,
            },
            1020: {
                perPage: 6,
            },
            1920: {
                perPage: 7,
            },
            2590: {
                perPage: 9,
            },
        },
    }).mount();

    new Splide('#novelas-carousel', {
        perPage: 3,
        rewind: true,
        arrows:false,
        cover:true,
        gap:7,
        pagination: false,
        breakpoints: {
            620: {
                perPage: 3,
            },
            820: {
                perPage: 4,
            },
            1020: {
                perPage: 6,
            },
            1920: {
                perPage: 7,
            },
            2590: {
                perPage: 9,
            },
        },
    }).mount();

    new Splide('#recomendados-carousel', {
        perPage: 3,
        rewind: true,
        arrows:false,
        cover:true,
        gap:7,
        pagination: false,
        breakpoints: {
            620: {
                perPage: 3,
            },
            820: {
                perPage: 4,
            },
            1020: {
                perPage: 6,
            },
            1920: {
                perPage: 7,
            },
            2590: {
                perPage: 9,
            },
        },
    }).mount();

    new Splide('#choosed-carousel', {
        perPage: 3,
        rewind: true,
        arrows:false,
        gap:7,
        pagination: false,
        breakpoints: {
            620: {
                perPage: 2,
            },
            820: {
                perPage: 4,
            },
            1020: {
                perPage: 4,
            },
            1920: {
                perPage: 4,
            },
            2590: {
                perPage: 7,
            },
        },
    }).mount();

    new Splide('#episodio-carousel', {
        perPage: 3,
        rewind: true,
        arrows:false,
        gap:7,
        pagination: false,
        breakpoints: {
            620: {
                perPage: 2,
            },
            820: {
                perPage: 4,
            },
            1020: {
                perPage: 4,
            },
            1920: {
                perPage: 4,
            },
            2590: {
                perPage: 7,
            },
        },
    }).mount();

    new Splide('#continue-watching-carousel', {
        perPage: 3,
        rewind: true,
        arrows: false,
        gap: 7,
        pagination: false,
        breakpoints: {
            620: {
                perPage: 2,
            },
            820: {
                perPage: 4,
            },
            1020: {
                perPage: 4,
            },
            1920: {
                perPage: 4,
            },
            2590: {
                perPage: 7,
            },
        },
    }).mount();
</script>
</body>
</html>
<?php /**PATH /home/ultraflix/public_html/ultraflix.pro/resources/views/layouts/_partials/slides.blade.php ENDPATH**/ ?>