

<!-- Login Required Modal -->
<div id="loginRequiredModal" class="fixed inset-0 z-50 items-center justify-center hidden bg-black/80 backdrop-blur-sm">
    <div class="relative w-full max-w-md p-6 mx-4 overflow-hidden rounded-lg shadow-xl bg-zinc-900">
        <!-- Ícone de bloqueio ou login -->
        <div class="flex justify-center mb-6">
            <div class="flex items-center justify-center w-16 h-16 bg-primary/10 rounded-full">
                <i class="text-2xl text-primary fas fa-lock"></i>
            </div>
        </div>

        <!-- Cabeçalho do Modal -->
        <div class="mb-6 text-center">
            <h3 class="mb-2 text-xl font-medium">Login Necessário</h3>
            <p class="text-gray-400">Para assistir a este conteúdo, você precisa fazer login.</p>
        </div>

        <!-- Botões de ação -->
        <div class="flex justify-center space-x-4">
            <button id="cancelLoginBtn" class="px-4 py-2 transition-colors rounded-lg bg-zinc-800 hover:bg-zinc-700">
                Cancelar
            </button>
            <a href="<?php echo e(route('login')); ?>" class="px-4 py-2 text-black transition-colors rounded-lg bg-primary hover:bg-primary-dark">
                Fazer Login
            </a>
        </div>
    </div>
</div>

<script>
/**
 * Sistema de verificação de autenticação e exibição de modal de login
 *
 * Este script permite verificar se o usuário está autenticado antes de assistir
 * a vídeos e exibe um modal de login quando necessário.
 */
document.addEventListener('DOMContentLoaded', function() {
    // Verifica se o modal já foi inicializado para evitar duplicação
    if (window.authDialogInitialized) return;
    window.authDialogInitialized = true;

    // Referência ao modal de login
    const loginModal = document.getElementById('loginRequiredModal');
    const cancelLoginBtn = document.getElementById('cancelLoginBtn');

    if (!loginModal || !cancelLoginBtn) return;

    // Adicionar evento para o botão cancelar
    cancelLoginBtn.addEventListener('click', function() {
        hideLoginRequiredModal();
    });

    // Adicionar evento para fechar o modal ao clicar fora dele
    loginModal.addEventListener('click', function(event) {
        if (event.target === loginModal) {
            hideLoginRequiredModal();
        }
    });

    // Adicionar ao objeto window para acesso global
    window.showLoginRequiredModal = showLoginRequiredModal;
    window.hideLoginRequiredModal = hideLoginRequiredModal;
    window.checkAuthBeforeWatching = checkAuthBeforeWatching;

    /**
     * Mostra o modal que solicita login
     */
    function showLoginRequiredModal() {
        loginModal.classList.remove('hidden');
        loginModal.classList.add('flex');
        document.body.style.overflow = 'hidden'; // Impedir rolagem
    }

    /**
     * Esconde o modal de login
     */
    function hideLoginRequiredModal() {
        loginModal.classList.remove('flex');
        loginModal.classList.add('hidden');
        document.body.style.overflow = ''; // Restaurar rolagem
    }

    /**
     * Verifica se o usuário está autenticado antes de assistir ao conteúdo
     * @param {Function} callback - Função a ser executada se autenticado
     * @returns {Boolean} - True se autenticado, false caso contrário
     */
    function checkAuthBeforeWatching(callback) {
        // Verificamos se o usuário está autenticado
        const isAuthenticated = <?php echo e(auth()->check() ? 'true' : 'false'); ?>;

        if (isAuthenticated) {
            // Se estiver autenticado, executa a callback
            if (typeof callback === 'function') {
                callback();
            }
            return true;
        } else {
            // Se não estiver autenticado, mostra o modal de login
            showLoginRequiredModal();
            return false;
        }
    }
});
</script>
<?php /**PATH /home/u446595196/domains/conectaplus.tv.br/public_html/resources/views/layouts/_partials/auth_dialog.blade.php ENDPATH**/ ?>