<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inicio</title>
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500;600;700&family=Work+Sans:wght@900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/css/splide.min.css">
</head>
<body>

<?php

use Carbon\Carbon

?>

<?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<section class="featured">
    <div class="splide" id="featured-slider">
        <div class="splide__track">
            <ul class="splide__list">
                <?php $__currentLoopData = $featured; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="splide__slide">
                        <?php if($item->type === 'Movie'): ?>
                            <a href="<?php echo e(route('filme.detail', ['id' => $item->featured_id])); ?>" class="filme-link">
                        <?php elseif($item->type === 'Serie'): ?>
                            <a href="<?php echo e(route('serie.detail', ['id' => $item->featured_id])); ?>" class="filme-link">
                        <?php endif; ?>
                        <div class="destaque destaque-gradient">
                            <img src="<?php echo e($item->backdrop_path_tv ?: 'https://upload.wikimedia.org/wikipedia/commons/b/b9/Youtube_loading_symbol_1_(wobbly).gif'); ?>" alt="<?php echo e($item->title); ?>" loading="lazy" class="desktop-image">
                            <img src="<?php echo e($item->poster_path ?: 'https://upload.wikimedia.org/wikipedia/commons/b/b9/Youtube_loading_symbol_1_(wobbly).gif'); ?>" alt="<?php echo e($item->title); ?>" loading="lazy" class="mobile-image">

                        </div>
                        <div class="itens-destaque">
                            <figure class="miniposter">
                                <img src="<?php echo e($item->miniposter); ?>" alt="<?php echo e($item->title); ?>">
                                <p class="sinopse-m" ><?php echo e($item->overview); ?></p>
                                <div class="info">
                                    <p class="imdb"><?php echo e($item->vote_average); ?><i class="fas fa-star"></i></p>
                                    <p class="genero"><?php echo e($item->genre); ?></p>
                                    <li><?php echo e(Carbon::createFromFormat('Y-m-d', $item->release_date)->format('Y')); ?></li>
                                </div>
                            </figure>
                        </div>
                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>
</section>

<section id="random-movie-player">
        <div class="content-random" style="display: contents;">
            <div class="random-btn">
                <h2>Não sabe o que assistir?</h2>
                <button id="btn-random-movie">
                    <i class="fa-regular fa-shuffle"></i> Procurar um filme
                </button>

                <button id="btn-random-series">
                    <i class="fa-regular fa-shuffle"></i> Procurar uma série
                </button>
            </div>

                <?php if(auth()->check() && auth()->user()->premuim == 1 && auth()->user()->expired_in > $hoje): ?>
                    <div id="titulo-capa">
                        <img id="movie-image" src="" alt="Capa do filme">
                        <div class="title-desc">
                            <p id="movie-title" style="margin-top: 20px; font-weight: 600; font-size: 25px;"></p>
                            <p id="movie-date"></p>
                            <p id="movie-overview"></p>
                        </div>
                    </div>
                    <div id="jwplayer-container"></div>

                    <p id="series-title" style="margin-top: 20px; font-size: 20px;"></p>
                    <div id="jwplayer-series-container"></div>
                    <button id="continue-watching" style="display: none;">
                        <i class="fa-regular fa-up-right-from-square"></i> Gostou da série? Clique aqui e continue assistindo
                    </button>
                <?php else: ?> 

                    <div id="banner">
                        <div class="col-b" >
                            <i class="fa-regular fa-lock-keyhole" style="font-size: 30px;"></i>
                            <div>
                                <p>Para assistir aos conteúdos você precisa ter uma assinatura ativa!</p>
                            </div>
                            <a href="<?php echo e(route('choose.plan')); ?>">
                                <button class="btn-premium">Assine agora</button>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
        </div>
    </section>


<?php echo $__env->make('layouts._partials.slides', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</section>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src='https://ssl.p.jwpcdn.com/player/v/8.6.2/jwplayer.js'></script>
    <script>jwplayer.key = "64HPbvSQorQcd52B8XFuhMtEoitbvY/EXJmMBfKcXZQU2Rnn"</script>

    <script>
$(document).ready(function() {
    $('#btn-random-movie').on('click', function() {
        $.ajax({
            url: '<?php echo e(route("random_movie")); ?>',
            type: 'GET',
            success: function(data) {
                $('#movie-title').text(data.movieTitle); // Título do filme
                $('#movie-overview').text(data.movieOverview).show();

                // Formata a data para exibir apenas o ano
                var anoLancamento = data.movieRelease.split("-")[0];
                $('#movie-date').text(anoLancamento).show(); // Mostra apenas o ano do lançamento

                $('#movie-image').attr('src', data.moviePoster).show();
                $('#titulo-capa').show();
                $('#titulo-capa').css('display', 'flex');

                // Configuração do JWPlayer
                jwplayer("jwplayer-container").setup({
                    file: data.movieUrl,
                    image: data.movieImage,
                    width: "100%",
                    aspectratio: "16:9",
                    autostart: false
                });
            },
            error: function() {
                console.error("Não foi possível carregar o filme.");
            }
        });

        $('#banner').show();
    });
});
</script>

<script>
    $(document).ready(function() {
        $('#btn-random-series').on('click', function() {
            $.ajax({
                url: '<?php echo e(route("random_series")); ?>', 
                type: 'GET',
                success: function(data) {
                    var seriesTitle = data.seriesTitle + ' - Temporada ' + data.seasonNumber + ' Episódio ' + data.episodeNumber;
                    $('#series-title').text(seriesTitle);
                    jwplayer("jwplayer-series-container").setup({
                        file: data.episodeUrl,
                        image: data.episodeImage,
                        width: "100%",
                        aspectratio: "16:9",
                        autostart: false
                    });

                    // Mostrar o botão e atualizar o link
                    $('#continue-watching').show().on('click', function() {
                        window.location.href = '<?php echo e(url("/serie")); ?>/' + data.seriesId; // Atualize conforme a sua URL de detalhes da série
                    });
                },
                error: function() {
                    console.error("Não foi possível carregar a série.");
                }
            });

            $('#banner').show();
        });
    });
</script>

    <script src="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/js/splide.min.js" defer></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        new Splide('#featured-slider', {
            type: 'loop', // Loop do slider
            perPage: 1,   // Quantidade de slides exibidos por vez
            autoplay: false,
            pagination: false,
            arrows:false,
            autoHeight: true,
            interval: 5000, // Tempo de cada slide (5 segundos)
        }).mount();
    });
</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js" defer></script>

    
</body>
</html><?php /**PATH /home/ultraflix/public_html/site.ultraflix.net/resources/views/layouts/pages/inicio.blade.php ENDPATH**/ ?>