<!DOCTYPE html>
<html>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

<head>
    <title><?php echo e($filme->title); ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="/css/web.css">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <script src='https://ssl.p.jwpcdn.com/player/v/8.9.5/jwplayer.js'></script>
    <script>
        jwplayer.key = "64HPbvSQorQcd52B8XFuhMtEoitbvY/EXJmMBfKcXZQU2Rnn"
    </script>
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
</head>

<?php
use Carbon\Carbon
?>

<body>
    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section class="backdrop" style="background-image: linear-gradient(to right, rgb(0 0 0 / 50%), transparent), linear-gradient(to bottom, rgb(0 0 0 / 90%), transparent),linear-gradient(to top, rgb(0 0 0), transparent),
                  url('<?php echo e($filme->backdrop_path); ?>');
    background-size: cover;
    background-position: center center;">
        <div class="main">
            <div class="poster-m">
                <aside>
                    <img src="<?php echo e($filme->poster_path); ?>" alt="<?php echo e($filme->title); ?>">
                    <div class="actions">
                        <button id="fav-btn" onclick="toggleFavorite(<?php echo e($filme->id); ?>, <?php echo e($filme->is_favorite ? 'true' : 'false'); ?>)">
                            <i id="fav-icon" class="<?php echo e($filme->is_favorite ? 'fas fa-heart' : 'far fa-heart'); ?>"></i>
                        </button>
                        <div class="trailer-button">
                            <?php if($filme->preview_path): ?>
                            <button onclick="openTrailerPopup('<?php echo e($filme->preview_path); ?>')" class="btn-trailer">
                                <i class="fab fa-youtube"></i> Trailer
                            </button>
                            <?php endif; ?>
                        </div>
                        <div id="trailerModal" class="trailer-modal">
                            <div class="trailer-modal-content">
                                <span class="close-trailer-modal">&times;</span>
                                <iframe id="trailerIframe" width="560" height="315" src="" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                            </div>
                        </div>
                    </div>
                </aside>

                <div class="info-filme">
                    <div class="titulo">
                        <h1><?php echo e($filme->title); ?></h1>
                    </div>
                    <div class="genres">
                        <div class="imdb-m">
                            <p>
                                <i class="fas fa-star"></i> <?php echo e(number_format($filme->vote_average, 1)); ?>

                            </p>
                        </div>
                        <ul>
                            <?php $__currentLoopData = $filme->genres->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><strong><?php echo e($genre->name); ?></strong></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <div class="sinopse">
                        <p><?php echo e($filme->overview); ?></p>
                    </div>
                    <div class="informacoes">
                        <li>Ano: <strong><?php echo e(Carbon::createFromFormat('Y-m-d', $filme->release_date)->format('Y')); ?></strong></li>
                    </div>
                    <div class="duration">
                        <li>Duração: <strong><?php echo e($horas); ?>h <?php echo e($minutos); ?> min</strong></li>
                    </div>
                    <div id="data-cast">
                        <span>Elenco:</span>
                        <div class="cast-container">
                            <?php $__currentLoopData = $filme->casters->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $caster): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="cast-member">
                            <img src="<?php echo e($caster->profile_path ?: 'https://cdn-icons-png.flaticon.com/512/1177/1177568.png'); ?>" alt="<?php echo e($caster->name); ?>" class="cast-img">
                                <strong class="cast-name"><?php echo e($caster->name); ?></strong>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <?php
                $hoje = \Carbon\Carbon::now();
                ?>

                <?php if(auth()->check() && auth()->user()->premuim == 1 && auth()->user()->expired_in > $hoje): ?>
                <div class="player-left">
                    <video id="my-video" controls style="width:100%;height:100%;">

                    </video>
                    <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button class="webvideocast" onclick="window.open('wvc-x-callback://open?url=' + encodeURIComponent('<?php echo $video->link; ?>'))">
                        <i class="fa-brands fa-chromecast"></i> Espelhar
                    </button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="player-options">
                    <?php
                    $contador = 1;
                    ?>
                    <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="option" data-link="<?php echo e($video->link); ?>" data-host="<?php echo e($video->supported_hosts . ', ' . $video->embed); ?>">
                        Servidor <?php echo e($contador); ?>

                    </div>
                    <?php
                    $contador++;
                    ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php else: ?>
                <div class="banner">
                    <div class="col-b">
                        <div>
                            <p>Para assistir aos conteúdos você precisa ter uma assinatura ativa!</p>
                        </div>
                        <a href="<?php echo e(route('choose.plan')); ?>">
                            <button class="btn-premium">Assine agora</button>
                        </a>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <section class="related-movies-slider">
                <div class="prev-next">
                    <h2>Filmes Relacionados</h2>
                    <div class="swiper-button-prev"></div>
                    <div class="swiper-button-next"></div>
                </div>
                <div class="swiper-container">
                    <div class="swiper-wrapper">
                        <?php $__currentLoopData = $filmesRelacionados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedMovie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('filme.detail', ['id' => $relatedMovie->id])); ?>">
                                <img src="<?php echo e($relatedMovie->poster_path); ?>" alt="<?php echo e($relatedMovie->title); ?>">
                            </a>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </section>
        </div>
    </section>
    <script>
        function openTrailerPopup(id) {
            var trailerIframe = document.getElementById('trailerIframe');
            trailerIframe.src = 'https://www.youtube.com/embed/' + id + '?autoplay=1';
            document.getElementById('trailerModal').style.display = 'block';
        }


        var span = document.getElementsByClassName("close-trailer-modal")[0];
        span.onclick = function() {
            var trailerModal = document.getElementById('trailerModal');
            trailerModal.style.display = "none";
            trailerModal.querySelector('iframe').src = '';
        }


        window.onclick = function(event) {
            var trailerModal = document.getElementById('trailerModal');
            if (event.target == trailerModal) {
                trailerModal.style.display = "none";
                trailerModal.querySelector('iframe').src = '';
            }
        }
    </script>


    <script>
        function toggleFavorite(movieId, isFavorite) {
            const url = isFavorite ? '/movie/removefromfav/' + movieId : '/movie/addtofav/' + movieId;
            const method = 'POST';
            const icon = document.getElementById('fav-icon');

            fetch(url, {
                    method: method,
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    // Atualiza o ícone e o estado do botão com base na resposta do servidor
                    const newFavoriteState = data.isFavorite;
                    updateFavoriteIcon(newFavoriteState);
                    document.getElementById('fav-btn').onclick = () => toggleFavorite(movieId, newFavoriteState);
                })
                .catch(error => console.error('Error:', error));
        }

        function updateFavoriteIcon(isFavorite) {
            const icon = document.getElementById('fav-icon');
            if (isFavorite) {
                icon.classList.remove('far', 'fa-heart');
                icon.classList.add('fas', 'fa-heart');
            } else {
                icon.classList.remove('fas', 'fa-heart');
                icon.classList.add('far', 'fa-heart');
            }
        }

        function initializeFavoriteButton(movieId) {
            fetch('/movie/isMovieFavorite/' + movieId, {
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    updateFavoriteIcon(data.isFavorite);
                    document.getElementById('fav-btn').onclick = () => toggleFavorite(movieId, data.isFavorite);
                })
                .catch(error => console.error('Error:', error));
        }

        // Inicialização
        window.onload = () => {
            const movieId = parseInt('<?php echo e($filme->id); ?>', 10);
            initializeFavoriteButton(movieId);
        };
    </script>

    <script type="text/javascript">
        var subtitles = <?php echo json_encode($filme->substitles, 15, 512) ?>;
    </script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const playerOptions = document.querySelectorAll('.option');
            const videoElementId = 'my-video';
            const movieId = '<?php echo e($filme->id); ?>'; // Substitua pelo identificador único do filme.
            const localStorageKey = 'videoPosition-' + movieId;

            function loadPlayer(link) {
    const tracks = subtitles.map(subtitle => ({
        file: subtitle.link,
        label: subtitle.lang,
        kind: 'captions'
    }));

    jwplayer(videoElementId).setup({
        file: link,
        image: '<?= $filme->backdrop_path ?>',
        width: "100%",
        height: "100%",
        aspectratio: "16:9",
        primary: "html5",
        controls: true,
        pipIcon: true,
        playbackRateControls: true,
        playbackRates: [0.25, 0.50, 0.75, 1, 1.25, 1.5, 2],
        "cast": {},
        renderCaptionsNatively: true,
        tracks: tracks,
        showKnob: true,
        "floating": {
        "dismissible": true,
        stretching: "uniform",
        preload: 'metadata',
        startparam: "start",
    }
    });

                const savedTime = parseFloat(localStorage.getItem(localStorageKey)) || 0;
                if (savedTime > 0) {
                    jwplayer(videoElementId).on('ready', function() {
                        this.seek(savedTime);
                    });
                }
            }

            jwplayer(videoElementId).on('time', function(event) {
                localStorage.setItem(localStorageKey, event.position);
            });

            jwplayer(videoElementId).on('complete', function() {
                localStorage.removeItem(localStorageKey);
            });
            const firstOption = document.querySelector('.option[data-link]');
            if (firstOption) {
                loadPlayer(firstOption.getAttribute('data-link'));
            }
            playerOptions.forEach(option => {
                option.addEventListener('click', function() {
                    const link = this.getAttribute('data-link');
                    loadPlayer(link);
                });
            });
        });
    </script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/js-cookie/3.0.1/js.cookie.min.js"></script>

    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var mySwiper = new Swiper('.swiper-container', {
                freeMode: true,
                breakpoints: {
                    // when window width is >= 320px
                    320: {
                        slidesPerView: 3,
                        spaceBetween: 30
                    },
                    // when window width is >= 480px
                    480: {
                        slidesPerView: 3,
                        spaceBetween: 30
                    },

                    800: {
                        slidesPerView: 4,
                        spaceBetween: 30
                    },

                    980: {
                        slidesPerView: 5,
                        spaceBetween: 30
                    },

                    1200: {
                        slidesPerView: 6,
                        spaceBetween: 30
                    },

                    1300: {
                        slidesPerView: 7,
                        spaceBetween: 30
                    },
                    // when window width is >= 640px
                    1700: {
                        slidesPerView: 10,
                        spaceBetween: 40
                    }
                },
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },

            });
        });
    </script>
</body>

</html><?php /**PATH /home/ultraflix/public_html/site.ultraflix.net/resources/views/show.blade.php ENDPATH**/ ?>