<!DOCTYPE html>
<html>
<meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
<head>
    <title>Pesquisa de Filmes e Séries</title>
    <link rel="stylesheet" href="/public/css/web.css">
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

</head>
<body>
<?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <section class="container-busca">

    <form action="<?php echo e(route('search')); ?>" method="GET">
        <div class="Input">
            <input class="search-input" type="text" name="search" placeholder="O que você está procurando ?" id="searchInput">
        </div>
    </form>

    <div id="realTimeResults"></div>


<div class="suggesteds">
    <div class="suggested-section">
        <h3>Filmes Sugeridos</h3>
        <div class="suggested-items">
            <?php $__currentLoopData = $suggestedMovies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $suggestedMovie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="suggested-item">
                    <a href="<?php echo e(route('filme.detail', ['id' => $suggestedMovie->id])); ?>">
                        <img src="<?php echo e($suggestedMovie->poster_path); ?>" alt="<?php echo e($suggestedMovie->name); ?>">
                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- Sugestões de Séries -->
    <div class="suggested-section">
        <h3>Séries Sugeridas</h3>
        <div class="suggested-items">
            <?php $__currentLoopData = $suggestedSeries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $suggestedSerie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="suggested-item">
                    <a href="<?php echo e(route('serie.detail', ['id' => $suggestedSerie->id])); ?>">
                        <img src="<?php echo e($suggestedSerie->poster_path); ?>" alt="<?php echo e($suggestedSerie->name); ?>">
                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
    
</section>

</body>

<script>
    $(document).ready(function() {
        $('#searchInput').keydown(function(event) {
            if (event.keyCode === 13) {
                event.preventDefault();
                return false;
            }
        });

        $('#searchInput').on('input', function() {
            var searchText = $(this).val();

            if (searchText.length >= 3) {
                $.ajax({
                    url: "<?php echo e(route('realtime.search')); ?>", // Use a rota de busca em tempo real
                    method: 'GET',
                    data: { search: searchText },
                    success: function(response) {
                        // Atualiza o conteúdo dos resultados
                        $('#realTimeResults').html(response);

                        // Adiciona a classe para mostrar os resultados com animação
                        $('.results-section').addClass('show-results');

                        $('.suggesteds').hide();
                    }
                });
            } else {
                // Remove a classe para esconder os resultados com animação
                $('.results-section').removeClass('show-results');

                $('#realTimeResults').empty();
                $('.suggesteds').show();
            }
        });
    });
</script>
</html>
<?php /**PATH /home/ultraflix/public_html/ultraflix.pro/resources/views/pesquisa.blade.php ENDPATH**/ ?>