<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Perfil - <?php echo e($settings->app_name); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
</head>
<body class="min-h-screen mb-10 text-white bg-black font-poppins">
    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container px-4 py-10 mx-auto md:py-20">
        <div class="max-w-4xl p-4 mx-auto shadow-xl md:p-8 bg-zinc-900/80 rounded-2xl">
            <!-- Layout Responsivo - Muda para 2 colunas em telas maiores -->
            <div class="flex flex-col md:flex-row md:gap-8">

                <!-- Coluna da Esquerda (Perfil e Assinatura) -->
                <div class="w-full mb-8 md:w-1/3 md:mb-0">
                    <!-- Cabeçalho do Perfil -->
                    <div class="mb-8 text-center">
                        <h2 class="mb-6 text-xl font-bold md:text-2xl">Olá <?php echo e(session('selected_profile')->name); ?></h2>

                        <!-- Avatar Container -->
                        <div class="relative w-24 h-24 mx-auto mb-6 md:w-32 md:h-32 group">
                            <img class="object-cover w-full h-full rounded-full"
                                src="<?php echo e(session('selected_profile') && session('selected_profile')->avatar ? asset(session('selected_profile')->avatar) : asset('/avatars/avatar_default.png')); ?>"
                                alt="Avatar">
                            <a href="<?php echo e(url('/user/profile/edit/'.session('selected_profile')->id)); ?>"
                                class="absolute inset-0 flex items-center justify-center transition-opacity rounded-full opacity-0 bg-black/60 group-hover:opacity-100">
                                <div class="text-center">
                                    <i class="mb-1 text-xl md:mb-2 md:text-2xl fas fa-edit"></i>
                                    <p class="text-xs md:text-sm">Editar Avatar</p>
                                </div>
                            </a>
                        </div>

                        <!-- Botão Mudar Perfil -->
                        <a href="<?php echo e(route('choose-profile')); ?>"
                            class="inline-block px-4 py-2 text-sm text-white transition duration-300 rounded-full md:px-6 md:py-3 md:text-base bg-zinc-800 hover:bg-zinc-700">
                            Mudar Perfil
                        </a>
                    </div>

                    <!-- Status da Assinatura -->
                    <div class="mb-6 p-4 rounded-xl <?php echo e($user->premuim && $user->expired_in > \Carbon\Carbon::now() ? 'bg-primary/10 border border-primary' : 'bg-red-500/10 border border-red-500'); ?>">
                        <h3 class="flex items-center gap-2 mb-2 text-xs font-medium md:text-base">
                            <i class="fas fa-crown"></i>
                            Status da Assinatura
                        </h3>
                        <?php if($user->premuim && $user->expired_in > \Carbon\Carbon::now()): ?>
                            <p class="mb-3 text-xs md:text-base text-primary">
                                Sua conta é premium, válida até <?php echo e(\Carbon\Carbon::parse($user->expired_in)->format('d/m/Y')); ?>

                            </p>
                        <?php else: ?>
                            <p class="mb-3 text-xs text-red-500 md:text-base">
                                Você não tem uma assinatura ativa
                            </p>
                            <div class="mt-4">
                                <a href="<?php echo e(route('choose.plan')); ?>" class="inline-block px-4 py-2 text-xs font-semibold text-black transition duration-300 rounded-full md:px-6 md:text-sm bg-gradient-to-r from-yellow-300 to-yellow-500 hover:from-yellow-400 hover:to-yellow-600">
                                    <i class="mr-2 fas fa-crown"></i>Assinar agora
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Coluna da Direita (Formulário) -->
                <div class="w-full md:w-2/3">
                    <!-- Formulário de Edição -->
                    <div class="space-y-4 md:space-y-6">
                        <h3 class="pb-2 mb-4 text-lg font-bold border-b md:text-xl border-zinc-700">Editar Informações da Conta</h3>

                        <?php if($errors->any()): ?>
                            <div class="p-3 text-red-500 border border-red-500 rounded-lg md:p-4 bg-red-500/10">
                                <ul class="text-sm list-disc list-inside md:text-base">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <?php if(session('status')): ?>
                            <div class="p-3 text-sm border rounded-lg md:p-4 bg-primary/10 border-primary text-primary md:text-base">
                                <?php echo e(session('status')); ?>

                            </div>
                        <?php endif; ?>

                        <form method="POST" action="<?php echo e(route('user.profile.update')); ?>" class="space-y-4 md:space-y-5">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <!-- Nome -->
                            <div>
                                <label class="block mb-1 text-xs font-medium md:mb-2 md:text-sm text-zinc-400">Nome</label>
                                <input type="text"
                                    name="name"
                                    value="<?php echo e($user->name); ?>"
                                    required
                                    class="w-full px-4 py-2 text-sm text-white transition duration-300 border rounded-full md:px-6 md:py-3 md:text-base bg-zinc-800 border-zinc-700 placeholder-zinc-400 focus:outline-none focus:border-primary">
                            </div>

                            <!-- Email -->
                            <div>
                                <label class="block mb-1 text-xs font-medium md:mb-2 md:text-sm text-zinc-400">Email</label>
                                <input type="email"
                                    name="email"
                                    value="<?php echo e($user->email); ?>"
                                    required
                                    class="w-full px-4 py-2 text-sm text-white transition duration-300 border rounded-full md:px-6 md:py-3 md:text-base bg-zinc-800 border-zinc-700 placeholder-zinc-400 focus:outline-none focus:border-primary">
                            </div>

                            <!-- Nova Senha -->
                            <div>
                                <label class="block mb-1 text-xs font-medium md:mb-2 md:text-sm text-zinc-400">Nova Senha</label>
                                <div class="relative">
                                    <input type="password"
                                        id="password-input"
                                        name="password"
                                        class="w-full px-4 py-2 text-sm text-white transition duration-300 border rounded-full md:px-6 md:py-3 md:text-base bg-zinc-800 border-zinc-700 placeholder-zinc-400 focus:outline-none focus:border-primary">
                                    <button type="button"
                                            onclick="togglePasswordVisibility('password-input', this)"
                                            class="absolute transition-colors -translate-y-1/2 right-4 top-1/2 text-zinc-400 hover:text-white">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                            </div>

                            <!-- Confirmar Nova Senha -->
                            <div>
                                <label class="block mb-1 text-xs font-medium md:mb-2 md:text-sm text-zinc-400">Confirmar Nova Senha</label>
                                <div class="relative">
                                    <input type="password"
                                        id="confirm-password-input"
                                        name="password_confirmation"
                                        class="w-full px-4 py-2 text-sm text-white transition duration-300 border rounded-full md:px-6 md:py-3 md:text-base bg-zinc-800 border-zinc-700 placeholder-zinc-400 focus:outline-none focus:border-primary">
                                    <button type="button"
                                            onclick="togglePasswordVisibility('confirm-password-input', this)"
                                            class="absolute transition-colors -translate-y-1/2 right-4 top-1/2 text-zinc-400 hover:text-white">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                            </div>

                            <!-- Botão Submit -->
                            <div class="pt-2 text-center md:text-right">
                                <button type="submit"
                                        class="px-6 py-2 text-sm font-semibold text-black transition duration-300 rounded-full md:px-8 md:py-3 md:text-base bg-primary hover:scale-105">
                                    Atualizar Perfil
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Fundo com gradiente -->
    <div class="fixed inset-0 -z-10 bg-gradient-to-br from-zinc-900 to-black"></div>

    <script>
        function togglePasswordVisibility(inputId, button) {
            const input = document.getElementById(inputId);
            const icon = button.querySelector('i');

            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }
    </script>
</body>
</html>
<?php /**PATH /home/u446595196/domains/conectaplus.tv.br/public_html/resources/views/auth/profile.blade.php ENDPATH**/ ?>