<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="user-id" content="<?php echo e(auth()->user()->id); ?>">
    <meta name="base-url" content="<?php echo e(url('/')); ?>"> <!-- Adicionando a URL base aqui -->
    <title><?php echo e($filme->title); ?> - <?php echo e($settings->app_name); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <script src='https://ssl.p.jwpcdn.com/player/v/8.6.2/jwplayer.js'></script>
    <script>jwplayer.key = "64HPbvSQorQcd52B8XFuhMtEoitbvY/EXJmMBfKcXZQU2Rnn";</script>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
    <script>
        // Define a URL base para scripts JavaScript
        window.appUrl = "<?php echo e(url('/')); ?>";
    </script>
    <style>
        /* Garante que elementos em fullscreen não serão sobrepostos */
        *:fullscreen, *:-webkit-full-screen, *:-moz-full-screen {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            width: 100% !important;
            height: 100% !important;
            z-index: 9999;
        }

        /* Esconde headers e outros elementos durante fullscreen */
        .header-fullscreen-hide {
            display: none !important;
        }

        /* Melhora a estilização do player JW */
        .jwplayer.jw-flag-fullscreen {
            z-index: 9999;
        }

        /* Para resolver problemas em Safari e iOS */
        video::-webkit-media-controls {
            display: none !important;
        }

        .image-wrapper {
            position: relative;
            overflow: hidden;
            border-radius: 0.5rem;
            border: 2px solid transparent;
            transition: border-color 0.3s ease, transform 0.3s ease;
        }

        .image-wrapper:hover {
            border-color: white;
            transform: scale(1.05);
        }
    </style>
</head>
<body class="min-h-screen mb-10 text-white bg-black font-poppins">
    <script>
        // Helper para detectar alterações de fullscreen e esconder headers
        document.addEventListener('DOMContentLoaded', function() {
            const header = document.querySelector('header');

            // Registra eventos de mudança de fullscreen para todos os browsers
            document.addEventListener('fullscreenchange', handleFullscreenChange);
            document.addEventListener('webkitfullscreenchange', handleFullscreenChange);
            document.addEventListener('mozfullscreenchange', handleFullscreenChange);
            document.addEventListener('MSFullscreenChange', handleFullscreenChange);

            function handleFullscreenChange() {
                if (document.fullscreenElement ||
                    document.webkitFullscreenElement ||
                    document.mozFullScreenElement ||
                    document.msFullscreenElement) {
                    // Entrando em fullscreen - esconde o header
                    if (header) header.classList.add('header-fullscreen-hide');
                } else {
                    // Saindo do fullscreen - mostra o header novamente
                    if (header) header.classList.remove('header-fullscreen-hide');
                }
            }
        });
    </script>

    <?php
        use Carbon\Carbon;
        $hoje = Carbon::now();
    ?>

    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Hero Section com Backdrop - Versão aprimorada com fundo fixo -->
    <div class="relative min-h-screen">
        <!-- Backdrop Image with responsive positioning - improved for mobile -->
        <div class="fixed top-0 right-0 z-0 w-full bg-center bg-cover h-2/4 md:w-2/4 md:h-2/4"
            style="background-image: url('<?php echo e($filme->backdrop_path); ?>');">
            <!-- Gradient from left to right (less intense on mobile) -->
            <div class="absolute inset-0 bg-gradient-to-r from-black via-black/70 md:via-transparent to-transparent"></div>
            <!-- Gradient from bottom to top -->
            <div class="absolute inset-0 bg-gradient-to-b from-transparent to-black"></div>
        </div>

        <!-- Content -->
        <div class="container relative z-10 px-4 pt-24 pb-12 mx-auto">
            <div class="grid grid-cols-1 gap-8 lg:grid-cols-12">
                <!-- Poster Column - Ajustado para mobile -->
                <div class="lg:col-span-4 xl:col-span-3">
                    <div class="flex flex-col items-center">
                        <div class="max-w-sm overflow-hidden rounded-lg shadow-xl w-44 sm:w-72 lg:w-full">
                            <img src="<?php echo e($filme->poster_path); ?>"
                                 alt="<?php echo e($filme->title); ?>"
                                 class="w-full h-auto">
                        </div>

                        <!-- Action Buttons -->
                        <div class="flex items-center justify-center gap-4 mt-6 text-sm lg:text-md">
                            <button id="fav-btn"
                                    onclick="toggleFavorite(<?php echo e($filme->id); ?>, <?php echo e($filme->is_favorite ? 'true' : 'false'); ?>)"
                                    class="flex items-center justify-center w-10 h-10 transition-colors rounded-full bg-zinc-800/50 backdrop-blur-sm/50 backdrop-blur-sm hover:bg-zinc-700">
                                <i id="fav-icon" class="<?php echo e($filme->is_favorite ? 'fas fa-heart text-primary' : 'far fa-heart'); ?>"></i>
                            </button>
                            <?php if($filme->preview_path): ?>
                                <button onclick="openTrailerPopup('<?php echo e($filme->preview_path); ?>')"
                                        class="flex items-center gap-2 px-4 py-3 transition-colors rounded-full bg-zinc-800/50 backdrop-blur-sm/50 backdrop-blur-sm hover:bg-zinc-700">
                                    <i class="fab fa-youtube"></i> Trailer
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Info Column -->

                <div class="lg:col-span-8 xl:col-span-9">
                    <h1 class="mb-4 text-2xl font-bold lg:text-4xl"><?php echo e($filme->title); ?></h1>

                    <!-- Rating and Genres -->
                    <div class="flex flex-wrap items-center gap-4 mb-6 text-sm lg:text-lg">
                        <div class="flex items-center gap-2 px-3 py-1 rounded-full bg-zinc-800/50 backdrop-blur-sm">
                            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/69/IMDB_Logo_2016.svg/320px-IMDB_Logo_2016.svg.png" alt="IMDb" class="h-4">
                            <span><?php echo e(number_format($filme->vote_average, 1)); ?></span>
                        </div>
                        <?php $__currentLoopData = $filme->genres->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="px-3 py-1 rounded-full bg-zinc-800/50 backdrop-blur-sm"><?php echo e($genre->name); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Overview with See More/Less functionality -->
                    <div class="mb-6 text-xs lg:text-lg">
                        <p id="short-overview" class="text-gray-300"><?php echo e(\Illuminate\Support\Str::limit($filme->overview, 150)); ?></p>
                        <p id="full-overview" class="hidden text-gray-300"><?php echo e($filme->overview); ?></p>

                        <?php if(strlen($filme->overview) > 150): ?>
                        <button id="toggle-overview" class="mt-2 text-xs font-medium text-primary hover:text-primary-dark">
                            Ver mais
                        </button>
                        <script>
                            document.getElementById('toggle-overview').addEventListener('click', function() {
                                const shortOverview = document.getElementById('short-overview');
                                const fullOverview = document.getElementById('full-overview');
                                const toggleBtn = document.getElementById('toggle-overview');

                                if (shortOverview.classList.contains('hidden')) {
                                    shortOverview.classList.remove('hidden');
                                    fullOverview.classList.add('hidden');
                                    toggleBtn.textContent = 'Ver mais';
                                } else {
                                    shortOverview.classList.add('hidden');
                                    fullOverview.classList.remove('hidden');
                                    toggleBtn.textContent = 'Ver menos';
                                }
                            });
                        </script>
                        <?php endif; ?>
                    </div>

                    <!-- Additional Info -->
                    <div class="flex flex-wrap items-center gap-4 mb-6 text-xs lg:text-lg">
                        <!-- Year -->
                        <div class="flex items-center gap-1 px-4 py-2 rounded-full bg-zinc-800/50 backdrop-blur-sm">
                            <i class="text-gray-400 fas fa-calendar"></i>
                            <span><?php echo e(Carbon::createFromFormat('Y-m-d', $filme->release_date)->format('Y')); ?></span>
                        </div>

                        <!-- Duration -->
                        <div class="flex items-center gap-1 px-4 py-2 rounded-full bg-zinc-800/50 backdrop-blur-sm">
                            <i class="text-gray-400 fas fa-clock"></i>
                            <span><?php echo e($horas); ?>h <?php echo e($minutos); ?>min</span>
                        </div>
                    </div>

                    <!-- Cast -->
                    <div class="mb-8">
                        <h3 class="mb-4 text-lg font-semibold">Elenco</h3>
                        <div class="flex gap-4 pb-4 overflow-x-auto">
                            <?php $__currentLoopData = $filme->casters->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $caster): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex-shrink-0 w-16 lg:w-24">
                                    <img src="<?php echo e($caster->profile_path ?: 'https://cdn-icons-png.flaticon.com/512/1177/1177568.png'); ?>"
                                         alt="<?php echo e($caster->name); ?>"
                                         class="object-cover w-full mb-2 rounded-full aspect-square image-wrapper">
                                    <p class="text-xs text-center"><?php echo e($caster->name); ?></p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <!-- Watch Button -->
                    <button id="watch-button"
                            onclick="openServerSelection()"
                            class="flex items-center gap-2 px-8 py-3 font-semibold text-black transition duration-300 bg-white rounded-full hover:bg-white-400">
                        <i class="fa fa-play"></i>
                        Assistir
                    </button>
                </div>
            </div>

            <!-- Player Section -->
            <?php
                $hoje = \Carbon\Carbon::now();
            ?>

            <?php if(auth()->check() && auth()->user()->premuim == 1 && auth()->user()->expired_in > $hoje): ?>
                <div class="hidden mt-8 player-movie">
                    <!-- Substituindo o elemento de vídeo pelo container do UltraPlayer -->
                    <div id="movie-player-container" class="w-full overflow-hidden rounded-lg aspect-video bg-zinc-900"></div>

                    <!-- Video Sources (escondido, usado para alimentar o modal de seleção) -->
                    <div id="video-sources" class="hidden">
                        <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button class="video-source-item"
                                    data-link="<?php echo e($video->link); ?>"
                                    data-movie-id="<?php echo e($filme->id); ?>"
                                    data-server="<?php echo e($video->server); ?>"
                                    data-hls="<?php echo e($video->hls ?? '0'); ?>"
                                    data-drm="<?php echo e($video->drm ?? '0'); ?>"
                                    data-embed="<?php echo e($video->embed ?? '0'); ?>"
                                    data-lang="<?php echo e($video->lang ?? ''); ?>"
                                    data-poster="<?php echo e($filme->backdrop_path); ?>">
                            </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php else: ?>
                <div class="p-8 mt-8 text-center bg-zinc-900/50 rounded-2xl">
                    <p class="mb-4 text-lg">Para assistir aos conteúdos você precisa ter uma assinatura ativa!</p>
                    <a href="<?php echo e(route('choose.plan')); ?>"
                       class="inline-block px-8 py-3 font-medium text-black transition duration-300 rounded-full bg-primary hover:scale-105">
                        Assine agora
                    </a>
                </div>
            <?php endif; ?>

            <!-- Related Movies Section - Carrossel Ajustado -->
            <div class="mt-16">
                <h2 class="mb-6 font-bold text-1xl lg:text-3xl">Filmes Relacionados</h2>

                <div class="relative px-4 sm:px-6">
                    <!-- Navigation Buttons -->


                    <!-- Swiper Container -->
                    <div class="swiper-container overflow-hidden mx-[-8px] sm:mx-0">
                        <div class="swiper-wrapper">
                            <?php $__currentLoopData = $filmesRelacionados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedMovie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide !w-[160px] sm:!w-[180px] p-2">
                                    <a href="<?php echo e(route('filme.detail', ['id' => $relatedMovie->id])); ?>"
                                       class="block group">
                                        <div class="relative overflow-hidden rounded-lg image-wrapper">
                                            <img src="<?php echo e($relatedMovie->poster_path); ?>"
                                                 alt="<?php echo e($relatedMovie->title); ?>"
                                                 class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105"
                                                 loading="lazy">
                                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                                        </div>
                                    </a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Trailer Modal -->
    <div id="trailerModal" class="fixed inset-0 z-50 hidden bg-black/90">
        <div class="absolute w-full max-w-4xl -translate-x-1/2 -translate-y-1/2 top-1/2 left-1/2">
            <button class="absolute right-0 text-1xl -top-10 close-trailer-modal">&times;</button>
            <div class="aspect-video">
                <iframe id="trailerIframe"
                        class="w-full h-full"
                        frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen></iframe>
            </div>
        </div>
    </div>

    <!-- Server Selection Modal -->
    <div id="serverModal" class="fixed inset-0 z-50 hidden bg-black/80">
        <div class="absolute w-full max-w-md overflow-hidden -translate-x-1/2 -translate-y-1/2 rounded-lg shadow-xl top-1/2 left-1/2 bg-zinc-900">
            <div class="flex items-center justify-between px-6 py-4 border-b border-zinc-800/50 backdrop-blur-sm">
                <h3 class="text-lg font-medium">Selecione o Servidor</h3>
                <button class="text-gray-400 hover:text-white close-server-modal">&times;</button>
            </div>
            <div class="p-6">
                <div id="serverList" class="space-y-2">
                    <!-- Server buttons will be added here dynamically -->
                </div>
            </div>
        </div>
    </div>

    <!-- Video Player Modal -->
    <div id="videoPlayerModal" class="fixed inset-0 z-50 hidden bg-black/90">
        <div class="absolute w-full max-w-4xl -translate-x-1/2 -translate-y-1/2 top-1/2 left-1/2">
            <button class="absolute right-0 text-1xl -top-10 close-player-modal">&times;</button>
            <div id="jwplayer-container" class="bg-black aspect-video"></div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/js-cookie/3.0.1/js.cookie.min.js"></script>
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>

    <!-- Remova o código JavaScript antigo do JWPlayer e substitua pelo nosso script de integração -->
    <!-- Carregue os scripts do player personalizado -->
    <script src="<?php echo e(asset('js/custom-player.js')); ?>"></script>
    <script src="<?php echo e(asset('js/movie-player-integration.js')); ?>"></script>

    <!-- Inicialização do Swiper e outros scripts simplificados -->
    <script>
        // PlayerManager para gerenciar o JW Player
        const PlayerManager = {
            instance: null,
            currentMovieId: null,
            volumeLevel: localStorage.getItem('playerVolume') || 80,

            // Inicializa o JW Player com configurações aprimoradas
            initialize(elementId, videoLink, options) {
                this.destroy(); // Limpa qualquer instância anterior

                const config = {
                    file: videoLink,
                    image: options.posterImage || '',
                    width: "100%",
                    aspectratio: "16:9",
                    primary: "html5",
                    controls: true,
                    autostart: true,
                    pipIcon: true,
                    playbackRateControls: [0.5, 1, 1.25, 1.5, 2],
                    volume: parseInt(this.volumeLevel),
                    abouttext: "<?php echo e($settings->app_name); ?> Player",
                    cast: {},
                    skin: {
                        name: "netflix"
                    }
                };

                // Inicializa o player com as configurações
                this.instance = jwplayer(elementId).setup(config);
                this.currentMovieId = options.movieId;

                return this.instance;
            },

            // Configura manipuladores de eventos para o player
            setupEvents(callbacks = {}) {
                if (!this.instance) return;

                const player = this.instance;
                const movieId = this.currentMovieId;

                // Eventos padrão
                player.on('ready', () => {
                    if (callbacks.onReady) callbacks.onReady();

                    // Recupera posição anterior se existir
                    const savedPosition = localStorage.getItem(`videoPosition-movie-${movieId}`);
                    if (savedPosition && parseFloat(savedPosition) > 0) {
                        const position = parseFloat(savedPosition);
                        const duration = player.getDuration() || 0;

                        // Só continua se não estiver próximo do fim
                        if (position < (duration * 0.95)) {
                            player.once('play', () => {
                                player.seek(position);
                                this.showNotification(`Continuando de ${this.formatTime(position)}`);
                            });
                        }
                    }
                });

                // Salva volume quando alterado
                player.on('volume', event => {
                    this.volumeLevel = event.volume;
                    localStorage.setItem('playerVolume', event.volume);
                });

                // Salva a posição atual periodicamente
                player.on('time', event => {
                    // Salva a cada 5 segundos
                    if (Math.floor(event.position) % 5 === 0) {
                        localStorage.setItem(`videoPosition-movie-${movieId}`, event.position);

                        // Callback externo se necessário
                        if (callbacks.onTime) callbacks.onTime(event);
                    }
                });

                // Verifica quando o player sai do modo fullscreen
                player.on('fullscreen', event => {
                    if (!event.fullscreen && !window.isClosingPlayer) {
                        // Se saiu do fullscreen e não está no processo de fechar o player
                        this.destroy();
                        document.getElementById('videoPlayerModal').style.display = 'none';

                        // Aguardar um momento antes de mostrar a seleção de servidor
                        setTimeout(() => {
                            document.getElementById('serverModal').style.display = 'block';
                        }, 100);
                    }
                });

                // Manipulação de erro
                player.on('error', error => {
                    console.error('JW Player error:', error);
                    if (callbacks.onError) callbacks.onError(error);
                });

                // Finalização do vídeo
                player.on('complete', () => {
                    localStorage.removeItem(`videoPosition-movie-${movieId}`);
                    this.showNotification('Filme concluído');

                    if (callbacks.onComplete) callbacks.onComplete();

                    // Fecha o player quando o vídeo termina
                    setTimeout(() => {
                        this.destroy();
                        document.getElementById('videoPlayerModal').style.display = 'none';
                    }, 3000);
                });
            },

            // Exibe uma notificação temporária sobre o vídeo
            showNotification(message, duration = 3000) {
                if (!this.instance) return;

                const container = this.instance.getContainer();

                // Verifica se já existe uma notificação e remove
                const existingNotification = container.querySelector('.player-notification');
                if (existingNotification) {
                    existingNotification.remove();
                }

                const notification = document.createElement('div');
                notification.className = 'player-notification';
                notification.style.cssText = `
                    position: absolute;
                    bottom: 70px;
                    left: 20px;
                    background-color: rgba(0, 0, 0, 0.7);
                    color: white;
                    padding: 10px 15px;
                    border-radius: 4px;
                    z-index: 10;
                    opacity: 0;
                    transition: opacity 0.3s ease;
                `;
                notification.textContent = message;

                container.appendChild(notification);

                // Fade in
                setTimeout(() => {
                    notification.style.opacity = '1';
                }, 10);

                // Fade out e remoção após um tempo
                setTimeout(() => {
                    notification.style.opacity = '0';
                    setTimeout(() => notification.remove(), 300);
                }, duration);
            },

            // Formata segundos para formato de tempo legível
            formatTime(seconds) {
                const mins = Math.floor(seconds / 60);
                const secs = Math.floor(seconds % 60);
                return `${mins}:${secs < 10 ? '0' : ''}${secs}`;
            },

            // Limpa a instância atual para liberar recursos
            destroy() {
                try {
                    if (this.instance) {
                        // Prevenção de erros de fullscreen
                        try {
                            const playerContainer = this.instance.getContainer();
                            const isFullscreen = document.fullscreenElement === playerContainer ||
                                                document.webkitFullscreenElement === playerContainer ||
                                                document.mozFullScreenElement === playerContainer ||
                                                document.msFullscreenElement === playerContainer;

                            if (isFullscreen) {
                                document.removeEventListener('fullscreenchange', this.instance._events?.fullscreen);
                                document.removeEventListener('webkitfullscreenchange', this.instance._events?.fullscreen);

                                setTimeout(() => {
                                    try {
                                        if (document.exitFullscreen) {
                                            document.exitFullscreen().catch(() => {});
                                        } else if (document.webkitExitFullscreen) {
                                            document.webkitExitFullscreen();
                                        } else if (document.mozCancelFullScreen) {
                                            document.mozCancelFullScreen();
                                        } else if (document.msExitFullscreen) {
                                            document.msExitFullscreen();
                                        }
                                    } catch (e) {
                                        // Ignoramos erros de fullscreen
                                    }
                                }, 10);
                            }
                        } catch (e) {
                            // Ignoramos erros aqui
                        }

                        setTimeout(() => {
                            try {
                                if (this.instance && typeof this.instance.remove === 'function') {
                                    this.instance.remove();
                                }
                            } catch (e) {
                                // Ignoramos erros de remoção
                            }

                            this.instance = null;
                        }, 50);
                    }
                } catch (error) {
                    console.error('Erro ao destruir player:', error);
                }
            }
        };

        // Função para abrir o modal de seleção de servidor
        function openServerSelection() {
            const serverModal = document.getElementById('serverModal');
            const serverList = document.getElementById('serverList');

            // Limpa a lista anterior
            serverList.innerHTML = '';

            // Preenche a lista com os servidores disponíveis
            <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                const serverButton<?php echo e($index); ?> = document.createElement('button');
                serverButton<?php echo e($index); ?>.className = 'w-full text-left px-4 py-3 bg-zinc-800/50 backdrop-blur-sm hover:bg-zinc-700 transition-colors rounded-lg';

                let quality<?php echo e($index); ?> = 'MP4';
                <?php if(isset($video->hls) && $video->hls == 1): ?>
                    quality<?php echo e($index); ?> = 'HLS';
                <?php endif; ?>
                <?php if(isset($video->drm) && $video->drm == 1): ?>
                    quality<?php echo e($index); ?> = 'DRM';
                <?php endif; ?>
                <?php if(isset($video->embed) && $video->embed == 1): ?>
                    quality<?php echo e($index); ?> = 'Embed';
                <?php endif; ?>

                <?php
                    $langSpan = isset($video->lang) && $video->lang ? "<span class=\"ml-2 text-xs text-gray-400\">{$video->lang}</span>" : "";
                ?>

                serverButton<?php echo e($index); ?>.innerHTML =
                    '<div class="flex items-center justify-between">' +
                        '<span class="font-medium">Servidor <?php echo e($index + 1); ?> <?php echo e($video->server ? "- " . $video->server : ""); ?></span>' +
                        '<div>' +
                            '<span class="px-2 py-1 text-xs rounded-full bg-zinc-900 text-primary">' + quality<?php echo e($index); ?> + '</span>' +
                            '<?php echo $langSpan; ?>' +
                        '</div>' +
                    '</div>';

                serverButton<?php echo e($index); ?>.addEventListener('click', function() {
                    showVideoPlayer('<?php echo e($video->link); ?>', <?php echo e($filme->id); ?>, '<?php echo e($filme->backdrop_path); ?>');
                });

                serverList.appendChild(serverButton<?php echo e($index); ?>);
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            // Exibe o modal
            serverModal.style.display = 'block';
        }

        // Função para mostrar o player de vídeo
        function showVideoPlayer(videoLink, movieId, posterImage) {
            // Fecha o modal de seleção
            document.getElementById('serverModal').style.display = 'none';

            // Exibe o modal do player
            const playerModal = document.getElementById('videoPlayerModal');
            playerModal.style.display = 'block';

            // Inicializa o player
            const player = PlayerManager.initialize('jwplayer-container', videoLink, {
                movieId: movieId,
                posterImage: posterImage
            });

            // Configura eventos do player
            PlayerManager.setupEvents({
                onReady: function() {
                    // Auto fullscreen após um pequeno delay
                    setTimeout(() => {
                        try {
                            player.setFullscreen(true);
                        } catch (e) {
                            console.error('Erro ao tentar abrir em fullscreen:', e);
                        }
                    }, 500);
                },
                onComplete: function() {
                    // Comportamento ao finalizar o vídeo
                    saveContinueWatching(movieId, 'movie');
                }
            });

            // Salva no histórico de continuações
            saveContinueWatching(movieId, 'movie');
        }

        document.addEventListener('DOMContentLoaded', function() {
            // Inicialização do carrossel de filmes relacionados
            new Swiper('.swiper-container', {
                slidesPerView: 'auto',
                spaceBetween: 16,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
                breakpoints: {
                    320: { slidesPerView: 2.2, spaceBetween: 8 },
                    480: { slidesPerView: 3.2, spaceBetween: 12 },
                    640: { slidesPerView: 4.2, spaceBetween: 16 },
                    768: { slidesPerView: 5.2, spaceBetween: 16 },
                    1024: { slidesPerView: 6.2, spaceBetween: 20 }
                }
            });

            // Evento para fechar o modal de servidores
            document.querySelector('.close-server-modal').addEventListener('click', function() {
                document.getElementById('serverModal').style.display = 'none';
            });

            // Evento para fechar o modal do player
            document.querySelector('.close-player-modal').addEventListener('click', function() {
                window.isClosingPlayer = true;
                PlayerManager.destroy();
                document.getElementById('videoPlayerModal').style.display = 'none';
                window.isClosingPlayer = false;
            });

            // Fechar modais ao clicar fora deles
            window.addEventListener('click', function(event) {
                const serverModal = document.getElementById('serverModal');
                const playerModal = document.getElementById('videoPlayerModal');
                const trailerModal = document.getElementById('trailerModal');

                if (event.target === serverModal) {
                    serverModal.style.display = 'none';
                }

                if (event.target === playerModal) {
                    window.isClosingPlayer = true;
                    PlayerManager.destroy();
                    playerModal.style.display = 'none';
                    window.isClosingPlayer = false;
                }

                if (event.target === trailerModal) {
                    closeTrailerModal();
                }
            });

            // Inicializa o botão de favoritos no carregamento da página
            const movieId = parseInt('<?php echo e($filme->id); ?>', 10);
            if (movieId) {
                initializeFavoriteButton(movieId);
            }
        });

        // Função para inicializar o botão de favoritos
        function initializeFavoriteButton(movieId) {
            fetch('<?php echo e(route('movie.isFavorite', '')); ?>/' + movieId, {
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                updateFavoriteIcon(data.isFavorite === 1);
                document.getElementById('fav-btn').onclick = () => toggleFavorite(movieId, data.isFavorite === 1);
            })
            .catch(error => {
                console.error('Erro ao verificar favorito:', error);
            });
        }

        // Função para alternar o estado de favorito - implementação revista
        function toggleFavorite(movieId, isFavorite) {
            console.log('Alternando favorito:', movieId, isFavorite);

            const baseUrl = '<?php echo e(url('/')); ?>';
            const endpoint = isFavorite
                ? '/movie/removefromfav/' + movieId
                : '/movie/addtofav/' + movieId;

            fetch(baseUrl + endpoint, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                console.log('Resposta do servidor:', data);

                // Determinamos o novo estado com base na resposta do servidor
                // Se removemos, o isFavorite será false, se adicionamos será true
                const newStatus = !isFavorite;

                // Atualizamos o ícone e reconfiguramos o handler do evento de clique
                updateFavoriteIcon(newStatus);
                document.getElementById('fav-btn').onclick = () => toggleFavorite(movieId, newStatus);
            })
            .catch(error => {
                console.error('Erro ao alternar favorito:', error);
            });
        }

        // Função para atualizar o ícone de favorito - simplificada para maior consistência
        function updateFavoriteIcon(isFavorite) {
            const icon = document.getElementById('fav-icon');
            if (icon) {
                if (isFavorite) {
                    icon.classList.remove('far');
                    icon.classList.add('fas', 'fa-heart', 'text-primary');
                } else {
                    icon.classList.remove('fas', 'fa-heart', 'text-primary');
                    icon.classList.add('far', 'fa-heart');
                }
            }
        }

        // Salvar no histórico de continuação
        function saveContinueWatching(movieId, type) {
            fetch('<?php echo e(route('continueWatching')); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    movie_id: movieId,
                    type: type
                })
            })
            .catch(error => {
                console.error('Erro ao salvar histórico:', error);
            });
        }

        // Funções de trailer permanecem iguais
        function openTrailerPopup(id) {
            if (!id) return;

            const trailerIframe = document.getElementById('trailerIframe');
            const trailerModal = document.getElementById('trailerModal');

            if (trailerIframe && trailerModal) {
                trailerIframe.src = 'https://www.youtube.com/embed/' + id + '?autoplay=1';
                trailerModal.style.display = 'block';
            }
        }

        function closeTrailerModal() {
            const trailerModal = document.getElementById('trailerModal');
            if (trailerModal) {
                trailerModal.style.display = "none";
                const iframe = trailerModal.querySelector('iframe');
                if (iframe) iframe.src = '';
            }
        }

        // Fechar trailer
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.close-trailer-modal').forEach(element => {
                element.addEventListener('click', function() {
                    closeTrailerModal();
                });
            });
        });
    </script>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/show.blade.php ENDPATH**/ ?>