<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ativar</title>
    <link rel="stylesheet" href="/css/web.css">
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
    <link rel="stylesheet" href="/public/css/font-awesome.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="/public/js/font-awesome.js"></script>
</head>
<body class="body-planos">
    <div class="container-planos">
    <div class="hero">
        <div class="fundo">
            <img src="https://assets.nflxext.com/ffe/siteui/vlv3/77d35039-751f-4c3e-9c8d-1240c1ca6188/9c050122-05ae-4838-89ad-f8acbf3d0d77/BR-pt-20231106-popsignuptwoweeks-perspective_alpha_website_large.jpg" alt="">
        </div>
        <div class="hero-int">
            <h3>Milhares de Filmes e Séries para você curtir com a família, sem travamentos, sem preços altos.</h3>
                <div class="cadastre-landing">
                <h4><i class="fa-solid fa-circle-check"></i> Crie sua conta, ative sua assinatura e aproveite.</h4>
                </div>
        </div>
    </div>

    <div class="landing-planos">
        <div class="lottie-container">
            <!-- Aqui vai a animação Lottie -->
        </div>
        <div class="text-container">
          <h1>
            Cansado de <span style="color: #2BF14A;">pagar caro</span> por pouco conteúdo?<br>
            Tenha filmes, séries e animes tudo em um só lugar.
          </h1>
        </div>
    </div>

    <div class="plataformas">
            <h3>Você terá acesso ao nosso catálogo com filmes e séries das principais plataformas de streaming do mercado.</h3>
            <ul>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/primevideo-logo.png" alt=""></li>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/hulu-logo.png" alt=""></li>
                <!-- <li><img src="https://v.baixarfree.com/file/utxgmpx/netflix-logo.png" alt=""></li> -->
                <li><img src="https://v.baixarfree.com/file/utxgmpx/hbomax-logo.png" alt=""></li>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/appletv-logo.png" alt=""></li>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/discoveryplus-logo.png" alt=""></li>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/disneyplus-logo.png" alt=""></li>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/starplus-logo.png" alt=""></li>
            </ul>
        </div>

        <div class="filmes-series-pop-planos">
          <h2>Filmes populares em nosso catálogo</h2>
          <div class="movies-landing">
              <?php $__currentLoopData = $topMovies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="poster-movie">
                      <img src="<?php echo e($movie->poster_path); ?>" alt="<?php echo e($movie->title); ?>">
                  </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>

          <h2>Séries populares em nosso catálogo</h2>
          <div class="series-landing">
              <?php $__currentLoopData = $topSeries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="poster-serie">
                      <img src="<?php echo e($serie->poster_path); ?>" alt="<?php echo e($serie->name); ?>">
                  </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>

        <div class="planos-list">
            <div class="plano">
                <h2 class="titulo-planos">Plano de 30 Dias</h2>
                <p class="preco-planos">R$10,00</p>
                <ul class="itens-plans">
                    <li><i class="fa-regular fa-film-simple"></i> Milhares de filmes e séries</li>
                    <li><i class="fa-regular fa-bolt"></i> Sem travamentos</li>
                    <li><i class="fa-regular fa-ban"></i> Sem anúncios</li>
                </ul>
                <a class="btn-planos" href="https://ev.braip.com/checkout/plaz9j0l/che48qgd?currency=BRL">Assinar</a>
            </div>

            <div class="plano">
                <h2 class="titulo-planos">Plano de 60 Dias</h2>
                <p class="preco-planos">R$16,00</p>
                <ul class="itens-plans">
                    <li><i class="fa-regular fa-film-simple"></i> Milhares de filmes e séries</li>
                    <li><i class="fa-regular fa-bolt"></i> Sem travamentos</li>
                    <li><i class="fa-regular fa-ban"></i> Sem anúncios</li>
                </ul>
                <a class="btn-planos" href="https://ev.braip.com/checkout/plao161x/che48qgd">Assinar</a>
            </div>

            <div class="plano">
                <h2 class="titulo-planos">Plano de 90 Dias</h2>
                <p class="preco-planos">R$25,00</p>
                <ul class="itens-plans">
                    <li><i class="fa-regular fa-film-simple"></i> Milhares de filmes e séries</li>
                    <li><i class="fa-regular fa-bolt"></i> Sem travamentos</li>
                    <li><i class="fa-regular fa-ban"></i> Sem anúncios</li>
                </ul>
                <a class="btn-planos" href="https://ev.braip.com/checkout/plag1klv/che48qgd">Assinar</a>
            </div>
        </div>

        <a href="https://chat.whatsapp.com/C3arDqZnKmEEnmu3FhllXR" class="whatsapp-btn" target="_blank">
            <i class="fab fa-whatsapp"></i> Fale conosco no WhatsApp
        </a>
        <div class="faq">
            
            <label class="accordion-wrapper">
                <h2>Perguntas Frequentes</h2>
              <input type="checkbox" class="accordion" hidden />
              <div class="title">
                <strong>Como Ativar ?</strong>
                <svg viewBox="0 0 256 512" width="12" title="angle-right" class="side-icon" fill="white">
                  <path d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z" />
                </svg>
                <svg viewBox="0 0 320 512" height="24" title="angle-down" class="down-icon" fill="white">
                  <path d="M143 352.3L7 216.3c-9.4-9.4-9.4-24.6 0-33.9l22.6-22.6c9.4-9.4 24.6-9.4 33.9 0l96.4 96.4 96.4-96.4c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9l-136 136c-9.2 9.4-24.4 9.4-33.8 0z" />
                </svg>
              </div>
              <div class="content">
                <p>Apenas crie uma conta no aplicativo usando seu email, então quando escolher o plano e for fazer o pagamento use o mesmo email do app.</p>
              </div>
            </label>
                <label class="accordion-wrapper">
              <input type="checkbox" class="accordion" hidden />
              <div class="title">
                <strong>Demora para ativar ?</strong>
                <svg viewBox="0 0 256 512" width="12" title="angle-right" class="side-icon" fill="white">
                  <path d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z" />
                </svg>
                <svg viewBox="0 0 320 512" height="24" title="angle-down" class="down-icon" fill="white">
                  <path d="M143 352.3L7 216.3c-9.4-9.4-9.4-24.6 0-33.9l22.6-22.6c9.4-9.4 24.6-9.4 33.9 0l96.4 96.4 96.4-96.4c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9l-136 136c-9.2 9.4-24.4 9.4-33.8 0z" />
                </svg>
              </div>
              <div class="content">
                <p>Não. Assim que o pagamento for realizado com sucesso sua assinatura será ativada instantaneamente.</p>
              </div>
            </label>
            <label class="accordion-wrapper">
              <input type="checkbox" class="accordion" hidden />
              <div class="title">
                <strong>Possui Fidelidade ?</strong>
                <svg viewBox="0 0 256 512" width="12" title="angle-right" class="side-icon" fill="white">
                  <path d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z" />
                </svg>
                <svg viewBox="0 0 320 512" height="24" title="angle-down" class="down-icon" fill="white">
                  <path d="M143 352.3L7 216.3c-9.4-9.4-9.4-24.6 0-33.9l22.6-22.6c9.4-9.4 24.6-9.4 33.9 0l96.4 96.4 96.4-96.4c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9l-136 136c-9.2 9.4-24.4 9.4-33.8 0z" />
                </svg>
              </div>
              <div class="content">
                <p>Não, o sistema não cobra automaticamente todos os meses, quando sua assinatura terminar você precisa vir aqui e ativar novamente.</p>
              </div>
            </label>
        </div>
    </div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/lottie-web/5.7.4/lottie.min.js"></script>

<script>
    var animation = bodymovin.loadAnimation({
        container: document.querySelector('.lottie-container'), // Seleciona o container Lottie
        path: 'https://lottie.host/566221ba-1f82-490f-bf9c-442f8e739c82/gyKr3Dv4C7.json', // Caminho para o arquivo JSON da animação
        renderer: 'svg',
        loop: true,
        autoplay: true
    });
</script>
</body>
</html><?php /**PATH /home/ultraflix/public_html/ultraflix.pro/resources/views/planos.blade.php ENDPATH**/ ?>