<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TV Ao Vivo - <?php echo e($settings->app_name ?? 'Conecta Plus'); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
    <script src='https://ssl.p.jwpcdn.com/player/v/8.6.2/jwplayer.js'></script>
    <script>jwplayer.key = "64HPbvSQorQcd52B8XFuhMtEoitbvY/EXJmMBfKcXZQU2Rnn";</script>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        .image-wrapper {
            position: relative;
            overflow: hidden;
            border-radius: 0.5rem;
            border: 2px solid transparent;
            transition: border-color 0.3s ease, transform 0.3s ease;
        }

        .image-wrapper:hover {
            border-color: white;
            transform: scale(1.05);
        }

        /* Container do player */
        #player-container {
            transition: all 0.3s ease;
            border-radius: 0.75rem;
            overflow: hidden;
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.3);
        }

        /* Estilo da seção do player */
        .player-section {
            position: relative;
        }

        /* Comportamento sticky do player para desktop */
        @media (min-width: 1024px) {
            .player-section {
                position: sticky;
                top: 2rem;
                height: max-content;
                transition: top 0.3s ease;
            }
        }

        /* Comportamento sticky em mobile */
        @media (max-width: 1023px) {
            .player-section.is-sticky {
                position: sticky;
                top: 0;
                z-index: 50;
                background-color: #000;
                padding-top: 0.5rem;
                padding-bottom: 0.5rem;
                margin: 0 -1rem;
                width: calc(100% + 2rem);
                box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            }

            .player-section.is-sticky #player-container,
            .player-section.is-sticky #player-placeholder {
                border-radius: 0;
                margin-bottom: 0.5rem;
            }
        }

        /* Placeholder do player */
        .player-placeholder {
            background-color: rgba(39, 39, 42, 0.6);
            border-radius: 0.75rem;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            min-height: 300px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }

        /* Animação ao carregar o player */
        .player-fade-in {
            animation: fadeIn 0.5s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Canal selecionado */
        .selected-channel {
            border-left: 4px solid theme('colors.primary');
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 0.5rem;
            transform: translateX(0.25rem);
            transition: all 0.3s ease;
        }

        .selected-channel .image-wrapper {
            border-color: theme('colors.primary');
        }

        /* Estilo da barra de busca */
        .search-container {
            background-color: rgba(15, 15, 15, 0.8);
            backdrop-filter: blur(10px);
            border-radius: 0.75rem;
            border: 1px solid rgba(255, 255, 255, 0.1);
            padding: 1rem;
            position: sticky;
            top: 2rem;
            z-index: 10;
            margin-bottom: 1.5rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        }

        /* Estilos para os canais */
        .channel-card {
            transition: all 0.2s ease;
            padding: 0.5rem;
            border-radius: 0.5rem;
        }

        .channel-card:hover {
            background-color: rgba(255, 255, 255, 0.05);
            transform: translateY(-2px);
        }

        /* Indicador de canal ao vivo */
        .live-indicator {
            position: absolute;
            top: 0.5rem;
            right: 0.5rem;
            background-color: #e50914; /* Vermelho para indicar "ao vivo" */
            color: white;
            padding: 0.125rem 0.375rem;
            border-radius: 1rem;
            font-size: 10px;
            font-weight: bold;
            opacity: 0;
            transform: scale(0.8);
            transition: all 0.3s ease;
        }

        .selected-channel .live-indicator {
            opacity: 1;
            transform: scale(1);
        }

        /* Badge para número de visualizações */
        .views-badge {
            position: absolute;
            bottom: 0.5rem;
            left: 0.5rem;
            background-color: rgba(0, 0, 0, 0.7);
            padding: 0.125rem 0.375rem;
            border-radius: 0.25rem;
            font-size: 0.75rem;
            display: flex;
            align-items: center;
            gap: 0.25rem;
        }

        /* Estilos para o modal premium */
        #premium-modal {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(10px);
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .premium-modal-content {
            background-color: #0f0f0f;
            border-radius: 1rem;
            width: 90%;
            max-width: 500px;
            padding: 2rem;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.9);
            text-align: center;
            animation: modal-fade-in 0.4s ease-out;
        }

        @keyframes modal-fade-in {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
    </style>
</head>
<body class="min-h-screen text-white bg-black font-poppins">
    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    

    <div class="container px-4 py-20 mx-auto">
        <!-- Layout Principal - Desktop: grid de 2 colunas, Mobile: coluna única -->
        <div class="lg:grid lg:grid-cols-12 lg:gap-8">
            <!-- Player de Vídeo (Coluna Esquerda em Desktop, Full Width em Mobile) -->
            <div id="player-section" class="mb-6 lg:col-span-8 player-section">
                <!-- Player Container (Visível quando um canal é selecionado) -->
                <div id="player-container" class="w-full mb-4 bg-zinc-900" style="display: none;">
                    <div id="channel-info" class="p-4 border-b border-zinc-800">
                        <div class="flex items-center justify-between">
                            <div>
                                <h2 class="text-lg font-bold channel-title"></h2>
                                <p class="text-zinc-400 channel-genre"></p>
                            </div>
                            <div class="flex items-center space-x-2">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-[9px] font-medium bg-red-600 text-white">
                                    <svg class="w-2 h-2 mr-1 fill-current animate-pulse" viewBox="0 0 8 8">
                                        <circle cx="4" cy="4" r="4"></circle>
                                    </svg>
                                    Ao vivo
                                </span>
                            </div>
                        </div>
                    </div>
                    <div id="video-player" class="aspect-video"></div>
                </div>

                <!-- Placeholder (Visível quando nenhum canal está selecionado) -->
                <div id="player-placeholder" class="w-full mb-4 player-placeholder">
                    <i class="mb-4 text-5xl text-zinc-500 fas fa-tv"></i>
                    <p class="text-xl font-medium text-zinc-300">Selecione um canal para assistir</p>
                    <p class="mt-2 text-sm text-zinc-500">Escolha entre os canais disponíveis abaixo</p>
                    <div class="flex mt-6 space-x-2">
                        <div class="w-12 h-3 rounded animate-pulse bg-zinc-700"></div>
                        <div class="w-20 h-3 rounded animate-pulse bg-zinc-700"></div>
                        <div class="w-16 h-3 rounded animate-pulse bg-zinc-700"></div>
                    </div>
                </div>
            </div>

            <!-- Lista de Canais (Coluna Direita em Desktop) -->
            <div class="lg:col-span-4 channels-container">
                <!-- Barra de Busca -->
                <div class="mb-6 search-container">
                    <h3 class="flex items-center mb-4 text-xl font-bold">
                        <i class="mr-2 text-primary fas fa-satellite-dish"></i>
                        Canais de TV
                    </h3>
                    <div class="relative">
                        <input type="text" placeholder="Buscar canal..." id="search-input"
                            class="w-full px-4 py-3 text-white transition-all rounded-full bg-zinc-800 focus:outline-none focus:ring-2 focus:ring-primary">
                        <i class="absolute transform -translate-y-1/2 fas fa-search right-4 top-1/2 text-zinc-400"></i>
                    </div>
                    <div class="flex justify-between px-2 mt-2 text-xs text-zinc-500">
                        <span><i class="mr-1 fas fa-broadcast-tower"></i> <span id="channels-count"><?php echo e(count($livetv)); ?></span> canais</span>
                        <span id="search-result"></span>
                    </div>
                </div>

                <!-- Grid de Canais -->
                <div id="channels-grid" class="grid grid-cols-2 gap-4 sm:grid-cols-2 lg:grid-cols-1 xl:grid-cols-2">
                    <?php $__currentLoopData = $livetv; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="channel-item" data-views="<?php echo e($movie->views); ?>">
                            <div class="cursor-pointer channel-card" data-id="<?php echo e($movie->id); ?>" onclick="loadChannel(<?php echo e($movie->id); ?>)">
                                <div class="relative overflow-hidden rounded-lg image-wrapper">
                                    <img src="<?php echo e($movie->backdrop_path ?? $movie->poster_path); ?>"
                                        alt="<?php echo e($movie->name); ?>"
                                        class="object-cover w-full transition-transform duration-300 aspect-video"
                                        loading="lazy">
                                    <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/30 to-transparent"></div>
                                    <div class="live-indicator">AO VIVO</div>
                                  
                                    
                                </div>
                                <div class="px-1 mt-2">
                                    <h3 class="text-sm font-medium text-white"><?php echo e($movie->name); ?></h3>
                                    <?php if($movie->genres && count($movie->genres) > 0 && isset($movie->genres[0]->genre)): ?>
                                        <p class="text-xs text-zinc-400"><?php echo e($movie->genres[0]->genre->name); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Mensagem quando nenhum canal é encontrado na busca -->
                <div id="no-results" class="hidden py-8 text-center">
                    <i class="mb-3 text-4xl text-zinc-600 fas fa-search"></i>
                    <p class="text-zinc-400">Nenhum canal encontrado para sua busca.</p>
                    <button onclick="document.getElementById('search-input').value = ''; document.getElementById('search-input').dispatchEvent(new Event('keyup'));"
                        class="px-4 py-2 mt-4 text-sm transition-colors rounded-full bg-zinc-800 hover:bg-zinc-700">
                        Limpar busca
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Fundo com gradiente -->
    <div class="fixed inset-0 -z-10 bg-gradient-to-br from-zinc-900 to-black"></div>

    <!-- Modal de Assinatura Premium -->
    <!--<?php if(!$isPremium): ?>-->
    <!--<div id="premium-modal" class="premium-modal">-->
    <!--    <div class="premium-modal-content">-->
    <!--        <i class="mb-6 text-5xl fas fa-lock text-primary"></i>-->
    <!--        <h3 class="mb-4 text-2xl font-bold">Assinatura Necessária</h3>-->
    <!--        <p class="mb-8 text-zinc-400">Para assistir aos canais de TV ao vivo você precisa ter uma assinatura ativa! Acesse nosso conteúdo exclusivo sem limites.</p>-->
    <!--        <div class="flex flex-col gap-4 mt-6">-->
    <!--            <a href="<?php echo e(route('choose.plan')); ?>"-->
    <!--               class="px-8 py-3 font-medium text-black transition duration-300 rounded-full bg-primary hover:scale-105">-->
    <!--                Assine agora-->
    <!--            </a>-->
    <!--            <button id="close-premium-modal" -->
    <!--                    class="px-8 py-3 font-medium transition-colors rounded-full bg-zinc-800 hover:bg-zinc-700 text-zinc-200">-->
    <!--                Voltar-->
    <!--            </button>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</div>-->
    <!--<?php endif; ?>-->

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Verificar se usuário é premium
        window.isPremium = <?php echo e($isPremium ? 'true' : 'true'); ?>;

        // Busca de canais
        var searchInput = document.getElementById('search-input');
        var noResults = document.getElementById('no-results');
        var searchResult = document.getElementById('search-result');
        var channelsCount = document.getElementById('channels-count');

        searchInput.addEventListener('keyup', function() {
            var searchTerm = this.value.toLowerCase();
            var channels = document.querySelectorAll('.channel-item');
            var visibleCount = 0;

            channels.forEach(function(channel) {
                var name = channel.querySelector('h3').textContent.toLowerCase();
                if (name.includes(searchTerm)) {
                    channel.style.display = ''; // Mostra o canal
                    visibleCount++;
                } else {
                    channel.style.display = 'none'; // Oculta o canal
                }
            });

            // Atualizar contador de resultados
            if (searchTerm) {
                searchResult.textContent = visibleCount + ' encontrados';
                if (visibleCount === 0) {
                    noResults.classList.remove('hidden');
                } else {
                    noResults.classList.add('hidden');
                }
            } else {
                searchResult.textContent = '';
                noResults.classList.add('hidden');
            }
        });

        // Verificar se há canal na URL e carregá-lo
        const urlParams = new URLSearchParams(window.location.search);
        const channelId = urlParams.get('channel');
        if (channelId) {
            loadChannel(channelId);
        }

        // Configurar comportamento de scroll
        setupScrollBehavior();
        window.addEventListener('resize', setupScrollBehavior);
        window.addEventListener('scroll', handleScroll);

        // Ordenar canais por visualizações (opcional)
        sortChannelsByViews();

        // Configurar botão para fechar o modal premium
        const closeModalBtn = document.getElementById('close-premium-modal');
        if (closeModalBtn) {
            closeModalBtn.addEventListener('click', function() {
                window.history.back(); // Voltar à página anterior
            });
        }
    });

    // Função para ordenar canais por visualizações
    function sortChannelsByViews() {
        var grid = document.getElementById('channels-grid');
        var channels = Array.from(grid.querySelectorAll('.channel-item'));

        channels.sort(function(a, b) {
            var viewsA = parseInt(a.dataset.views) || 0;
            var viewsB = parseInt(b.dataset.views) || 0;
            return viewsB - viewsA; // Ordenação decrescente
        });

        channels.forEach(function(channel) {
            grid.appendChild(channel);
        });
    }

    // Configuração do comportamento de rolagem baseado no tamanho da tela
    function setupScrollBehavior() {
        const playerSection = document.getElementById('player-section');
        const headerHeight = document.querySelector('header')?.offsetHeight || 0;

        // Ajustar posição do player com base no tamanho da tela
        if (window.innerWidth < 1024) {
            playerSection.style.top = headerHeight + 'px';
        } else {
            playerSection.style.top = '2rem';
        }
    }

    // Gerenciar comportamento do scroll
    function handleScroll() {
        const playerSection = document.getElementById('player-section');
        const headerHeight = document.querySelector('header')?.offsetHeight || 0;

        if (window.innerWidth < 1024 &&
            document.getElementById('player-container').style.display === 'block') {

            const scrollTop = window.pageYOffset || document.documentElement.scrollTop;

            // Ativar sticky quando rolamos além do topo da página
            if (scrollTop > headerHeight) {
                playerSection.classList.add('is-sticky');
                playerSection.style.top = headerHeight + 'px';
            } else {
                playerSection.classList.remove('is-sticky');
            }
        }
    }

    // Função para carregar e reproduzir o canal
    function loadChannel(id) {
        // Verificar se o usuário é premium
        if (!window.isPremium) {
            // Se não for premium, não faz nada (o modal já está sendo exibido)
            return;
        }

        // Mostrar um indicador de carregamento
        document.getElementById('player-placeholder').style.display = 'none';

        if (!document.getElementById('player-loading')) {
            const loadingElement = document.createElement('div');
            loadingElement.id = 'player-loading';
            loadingElement.className = 'w-full mb-4 player-placeholder';
            loadingElement.innerHTML = `
                <div class="inline-block w-12 h-12 border-t-2 border-r-2 rounded-full border-primary animate-spin"></div>
                <p class="mt-4 text-zinc-300">Carregando canal...</p>
            `;
            document.getElementById('player-section').insertBefore(
                loadingElement,
                document.getElementById('player-container')
            );
        }

        // Rolar para o player em dispositivos móveis
        if (window.innerWidth < 1024) {
            window.scrollTo({ top: 0, behavior: 'smooth' });
        }

        // Atualizar URL sem recarregar a página
        const newUrl = window.location.pathname + '?channel=' + id;
        history.pushState({}, '', newUrl);

        // Remover seleção anterior e selecionar novo canal
        document.querySelectorAll('.channel-card').forEach(function(card) {
            card.closest('.channel-item').classList.remove('selected-channel');
        });

        // Encontrar e selecionar o canal atual
        const selectedChannel = document.querySelector(`.channel-card[data-id="${id}"]`);
        if (selectedChannel) {
            selectedChannel.closest('.channel-item').classList.add('selected-channel');
        }

        // Fazer requisição AJAX para obter a URL do vídeo
        $.ajax({
            url: "<?php echo e(route('api.livetv.video-url', ['id' => ':id'])); ?>".replace(':id', id),
            type: 'GET',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            success: function(response) {
                // Remover indicador de carregamento
                if (document.getElementById('player-loading')) {
                    document.getElementById('player-loading').remove();
                }

                // Mostrar o container do player
                const playerContainer = document.getElementById('player-container');
                playerContainer.style.display = 'block';
                playerContainer.classList.add('player-fade-in');

                // Configurar o JWPlayer
                jwplayer("video-player").setup({
                    file: response.videoUrl,
                    width: "100%",
                    aspectratio: "16:9",
                    stretching: "uniform",
                    autostart: true,
                    primary: "html5",
                    hlshtml: true,
                    preload: "auto",
                    logo: {
                        file: "#",
                        position: 'top-right'
                    },
                    skin: {
                        name: "netflix",
                        active: "#D4AF37"
                    }
                });

                // Atualizar informações do canal
                $.ajax({
                    url: "<?php echo e(route('api.livetv.info', ['id' => ':id'])); ?>".replace(':id', id),
                    type: 'GET',
                    success: function(channelData) {
                        document.querySelector('.channel-title').textContent = channelData.name;

                        // Atualizar a categoria do canal se existir
                        if (channelData.genres && channelData.genres.length > 0 && channelData.genres[0].genre) {
                            document.querySelector('.channel-genre').textContent = channelData.genres[0].genre.name;
                        } else {
                            document.querySelector('.channel-genre').textContent = '';
                        }

                        // Destacar canal selecionado na lista
                        if (selectedChannel) {
                            // Scroll para o canal selecionado em dispositivos móveis
                            setTimeout(() => {
                                if (window.innerWidth >= 1024) {
                                    selectedChannel.scrollIntoView({
                                        behavior: 'smooth',
                                        block: 'nearest'
                                    });
                                }
                            }, 300);
                        }

                        // Atualizar o título da página
                        document.title = channelData.name + ' - TV Ao Vivo - <?php echo e($settings->app_name ?? "UltraFlix"); ?>';
                    }
                });
            },
            error: function(error) {
                console.error('Erro ao carregar o vídeo:', error);

                // Remover indicador de carregamento
                if (document.getElementById('player-loading')) {
                    document.getElementById('player-loading').remove();
                }

                // Mostrar placeholder com mensagem de erro
                const playerPlaceholder = document.getElementById('player-placeholder');
                playerPlaceholder.style.display = 'flex';
                playerPlaceholder.innerHTML = `
                    <i class="mb-4 text-4xl text-red-500 fas fa-exclamation-circle"></i>
                    <p class="text-xl font-medium text-zinc-300">Não foi possível reproduzir este canal</p>
                    <p class="mt-2 text-sm text-zinc-500">Tente novamente mais tarde ou escolha outro canal</p>
                    <button onclick="this.closest('#player-placeholder').innerHTML = originalPlaceholderContent; this.closest('#player-placeholder').classList.remove('bg-red-900/20')" 
                            class="px-4 py-2 mt-4 text-sm text-white transition-colors rounded-full bg-primary hover:bg-primary-dark">
                        Fechar
                    </button>
                `;
                playerPlaceholder.classList.add('bg-red-900/20');
            }
        });
    }

    // Guardar o conteúdo original do placeholder
    const originalPlaceholderContent = `
        <i class="mb-4 text-5xl text-zinc-500 fas fa-tv"></i>
        <p class="text-xl font-medium text-zinc-300">Selecione um canal para assistir</p>
        <p class="mt-2 text-sm text-zinc-500">Escolha entre os canais disponíveis abaixo</p>
        <div class="flex mt-6 space-x-2">
            <div class="w-12 h-3 rounded animate-pulse bg-zinc-700"></div>
            <div class="w-20 h-3 rounded animate-pulse bg-zinc-700"></div>
            <div class="w-16 h-3 rounded animate-pulse bg-zinc-700"></div>
        </div>
    `;
    </script>
</body>
</html>
<?php /**PATH /home/u446595196/domains/conectaplus.tv.br/public_html/resources/views/layouts/pages/canais.blade.php ENDPATH**/ ?>