<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Pagamento Confirmado - <?php echo e($settings->app_name); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Limpar qualquer marcador de pagamento no localStorage
            const keys = Object.keys(localStorage);
            for(let i = 0; i < keys.length; i++) {
                const key = keys[i];
                if (key.startsWith('payment_success_')) {
                    localStorage.removeItem(key);
                }
            }
        });
    </script>
</head>
<body class="min-h-screen font-sans text-white bg-black"
      style="background-image: linear-gradient(to right, rgba(0, 0, 0, 86%), transparent), linear-gradient(to left, rgba(0, 0, 0, 86%), transparent), linear-gradient(to top, rgb(0, 0, 0, 0%), transparent), url('/public/assets/images/background.jpg'); background-attachment: fixed; background-size: cover; background-position: center center;">

    <div class="container max-w-xl px-4 py-10 mx-auto">
        <div class="p-8 border shadow-xl bg-zinc-900/70 backdrop-blur-lg border-zinc-800/50 rounded-xl">
            <!-- Ícone de sucesso -->
            <div class="flex justify-center mb-8">
                <div class="text-7xl text-primary">
                    <i class="fas fa-check-circle"></i>
                </div>
            </div>

            <!-- Título e mensagem -->
            <h1 class="mb-6 text-2xl font-bold text-center md:text-3xl">Pagamento Confirmado com Sucesso!</h1>

            <p class="mb-8 text-center text-zinc-300">
                Seu plano foi ativado e você já pode aproveitar todo o conteúdo disponível na plataforma.
                Obrigado por escolher a <?php echo e($settings->app_name); ?> como sua plataforma de streaming.
            </p>

            <!-- Detalhes da assinatura -->
            <div class="px-6 py-5 mb-8 border-l-4 rounded-r-lg bg-green-900/10 border-primary">
                <h2 class="mb-4 text-lg font-semibold text-primary">Detalhes da assinatura:</h2>

                <div class="space-y-3">
                    <div class="flex items-center justify-between">
                        <span class="text-zinc-400">Status:</span>
                        <span class="font-medium text-white">Ativo</span>
                    </div>

                    <div class="flex items-center justify-between">
                        <span class="text-zinc-400">Plano:</span>
                        <span class="font-medium text-white"><?php echo e(auth()->user()->pack_name ?? 'Assinatura Premium'); ?></span>
                    </div>

                    <div class="flex items-center justify-between">
                        <span class="text-zinc-400">Validade:</span>
                        <span class="font-medium text-white"><?php echo e(auth()->user()->expired_in ? \Carbon\Carbon::parse(auth()->user()->expired_in)->format('d/m/Y') : 'N/A'); ?></span>
                    </div>
                </div>
            </div>

            <!-- Botão para ir para o início -->
            <div class="text-center">
                <a href="<?php echo e(route('inicio')); ?>" class="inline-block w-full px-6 py-4 text-lg font-bold text-black transition-colors rounded-full bg-primary hover:scale-105 sm:w-auto sm:px-10">
                    <i class="mr-2 fas fa-home"></i> Ir para o início
                </a>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/u446595196/domains/capixabaplay.com.br/public_html/play/resources/views/pagamento_sucesso.blade.php ENDPATH**/ ?>