<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inicio - <?php echo e($settings->app_name); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500;600;700&family=Work+Sans:wght@900&display=swap" rel="stylesheet">

    <!-- Preload de recursos críticos -->
    <link rel="preload" href="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/css/splide.min.css" as="style" onload="this.onload=null;this.rel='stylesheet'">
    <noscript><link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/css/splide.min.css"></noscript>

    <script>
        // Configuração de performance
        window.PERFORMANCE_CONFIG = {
            LAZY_LOAD_OFFSET: '200px',
            DEFER_FEATURED_TIMEOUT: 100,
            DEFER_SLIDES_TIMEOUT: 200
        };

        // Definir cache para scripts
        window.scriptCache = {};
    </script>

    <script defer src="https://cdn.tailwindcss.com"></script>
    <script defer src="<?php echo e(asset('js/tema.js')); ?>"></script>

    <!-- Estilos para o efeito shimmer do featured -->
    <style>
        /* Estratégia de carregamento de conteúdo */
        .content-staged {
            opacity: 0;
            transform: translateY(10px);
            transition: opacity 0.4s ease, transform 0.4s ease;
        }

        .content-loaded {
            opacity: 1;
            transform: translateY(0);
        }

        /* Estilo para content skeleton durante carregamento */
        .skeleton-screen {
            background: #27272a;
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
            transition: opacity 0.5s ease;
        }

        .shimmer-featured {
            background: linear-gradient(90deg,
                        rgba(30, 30, 30, 0.2) 0%,
                        rgba(50, 50, 50, 0.5) 40%,
                        rgba(30, 30, 30, 0.2) 80%);
            background-size: 200% 100%;
            animation: shimmer 1.5s infinite linear;
        }

        .featured-placeholder {
            position: relative;
            height: 75vh;
            width: 100%;
        }

        @media (max-width: 768px) {
            .featured-placeholder {
                height: 70vh;
            }
        }

        .featured-skeleton {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 2rem;
        }

        @media (min-width: 1024px) {
            .featured-skeleton {
                left: 8rem;
                max-width: 48rem;
            }
        }

        .featured-container {
            opacity: 0;
            transition: opacity 0.5s ease;
        }

        .featured-container.loaded {
            opacity: 1;
        }

        @keyframes shimmer {
            0% { background-position: -200% 0; }
            100% { background-position: 200% 0; }
        }
    </style>
</head>
<body class="min-h-screen text-white bg-zinc-950 font-poppins">
    <?php
        use Carbon\Carbon;
    ?>

    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Container principal com carregamento progressivo -->
    <div id="main-content-container" class="content-staged">
        <!-- Featured Section - Redesenhada para ser mais moderna e elegante -->
        <section class="relative w-full">
            <!-- Shimmer Loading Placeholder -->
            <div id="featured-loading" class="featured-placeholder shimmer-featured">
                <div class="featured-skeleton">
                    <!-- Logo/Title placeholder -->
                    <div class="w-3/4 h-12 mb-6 rounded-lg shimmer-featured"></div>

                    <!-- Badges placeholder -->
                    <div class="flex gap-2 mb-4">
                        <div class="w-20 h-6 rounded-full shimmer-featured"></div>
                        <div class="w-16 h-6 rounded-full shimmer-featured"></div>
                        <div class="w-24 h-6 rounded-full shimmer-featured"></div>
                    </div>

                    <!-- Overview placeholder -->
                    <div class="mb-5 space-y-2">
                        <div class="w-full h-4 rounded shimmer-featured"></div>
                        <div class="w-5/6 h-4 rounded shimmer-featured"></div>
                        <div class="w-4/6 h-4 rounded shimmer-featured"></div>
                    </div>

                    <!-- Button placeholder -->
                    <div class="w-32 h-12 rounded-full shimmer-featured"></div>
                </div>
            </div>

            <!-- Actual Featured Content -->
            <div id="featured-content" class="featured-container">
                <div class="splide" id="featured-slider">
                    <div class="splide__track">
                        <ul class="splide__list">
                            <?php $__currentLoopData = $featured; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="relative splide__slide">
                                    <?php if($item->type === 'Movie'): ?>
                                        <a href="<?php echo e(route('filme.detail', ['id' => $item->featured_id])); ?>" class="block">
                                    <?php elseif($item->type === 'Serie'): ?>
                                        <a href="<?php echo e(route('serie.detail', ['id' => $item->featured_id])); ?>" class="block">
                                    <?php endif; ?>
                                        <div class="relative featured-item">
                                            <!-- Desktop Image - Melhor contraste e gradiente -->
                                            <img src="<?php echo e($item->backdrop_path_tv ?: 'https://upload.wikimedia.org/wikipedia/commons/b/b9/Youtube_loading_symbol_1_(wobbly).gif'); ?>"
                                                alt="<?php echo e($item->title); ?>"
                                                loading="lazy"
                                                class="hidden md:block w-full h-[75vh] xl:h-[80vh] object-cover">

                                            <!-- Mobile Image - Optimizada para dispositivos móveis -->
                                            <img src="<?php echo e($item->poster_path ?: 'https://upload.wikimedia.org/wikipedia/commons/b/b9/Youtube_loading_symbol_1_(wobbly).gif'); ?>"
                                                alt="<?php echo e($item->title); ?>"
                                                loading="lazy"
                                                class="md:hidden w-full h-[70vh] sm:h-[65vh] object-cover">

                                            <!-- Gradient Overlay - Aprimorado para melhor legibilidade -->
                                            <div class="absolute inset-0 bg-gradient-to-t from-zinc-950 via-zinc-950/80 to-transparent"></div>
                                            <div class="absolute inset-0 bg-gradient-to-r from-zinc-950/90 via-zinc-950/50 to-transparent"></div>

                                            <!-- Content - Layout redesenhado para maior impacto -->
                                            <div class="absolute bottom-0 w-full p-6 pb-8 md:p-10 lg:left-32 lg:p-16 md:max-w-3xl">
                                                <!-- Logotipo do filme/série em vez do título -->
                                                <div class="mb-6">
                                                    <?php if($item->enable_miniposter == 1 && $item->miniposter): ?>
                                                        <!-- Exibe o logotipo/miniposter se estiver habilitado e disponível -->
                                                        <img src="<?php echo e($item->miniposter); ?>"
                                                            alt="<?php echo e($item->title); ?>"
                                                            class="max-w-[250px] sm:max-w-[300px] md:max-w-[350px] lg:max-w-[400px] h-auto object-contain drop-shadow-lg">
                                                    <?php else: ?>
                                                        <!-- Fallback para o título caso não haja logo -->
                                                        <h1 class="mb-4 text-3xl font-bold sm:text-4xl lg:text-5xl drop-shadow-lg">
                                                            <?php echo e($item->title); ?>

                                                        </h1>
                                                    <?php endif; ?>
                                                </div>

                                                <!-- Métricas e Detalhes em Design Badge -->
                                                <div class="flex flex-wrap items-center gap-3 mb-4 text-sm sm:text-base">
                                                    <!-- IMDB Rating Badge com ícone -->
                                                    <div class="flex items-center gap-1 px-3 py-1 font-medium rounded-full backdrop-blur-sm bg-black/50">
                                                        <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/69/IMDB_Logo_2016.svg/320px-IMDB_Logo_2016.svg.png"
                                                            alt="IMDB"
                                                            class="h-4 mr-1">
                                                        <span class="font-bold text-white"><?php echo e(number_format($item->vote_average, 1)); ?></span>
                                                    </div>

                                                    <div class="px-3 py-1 text-white rounded-full bg-zinc-800/50 backdrop-blur-sm">
                                                        <?php echo e($item->genre); ?>

                                                    </div>

                                                    <div class="px-3 py-1 text-white rounded-full bg-zinc-800/50 backdrop-blur-sm">
                                                        <?php echo e(Carbon::createFromFormat('Y-m-d', $item->release_date)->format('Y')); ?>

                                                    </div>

                                                    <?php if($item->type === 'Movie'): ?>
                                                        <div class="px-3 py-1 text-white rounded-full bg-zinc-800/50 backdrop-blur-sm">
                                                            <i class="mr-1 fa-regular fa-film"></i> Filme
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="px-3 py-1 text-white rounded-full bg-zinc-800/50 backdrop-blur-sm">
                                                            <i class="mr-1 fa-regular fa-tv"></i> Série
                                                        </div>
                                                    <?php endif; ?>
                                                </div>

                                                <!-- Descrição com Gradiente -->
                                                <div class="mb-5">
                                                    <p class="max-w-2xl text-sm leading-relaxed text-zinc-100 line-clamp-3 sm:line-clamp-4 sm:text-base">
                                                        <?php echo e($item->overview); ?>

                                                    </p>
                                                </div>

                                                <!-- Botão de Assistir (Agora com fundo branco) -->
                                                <div class="flex flex-wrap gap-3">
                                                    <button class="flex items-center gap-2 px-6 py-3 font-medium text-black transition-all transform bg-white rounded-full hover:bg-gray-100 hover:scale-105">
                                                        <i class="fas fa-play"></i>
                                                        <span>Assistir</span>
                                                    </button>
                                                </div>
                                            </div>

                                            <!-- Indicador de Slide (pontos personalizados) -->
                                            <div class="absolute bottom-4 right-6">
                                                <div class="flex gap-2">
                                                    <?php for($i = 0; $i < count($featured); $i++): ?>
                                                        <div class="h-2 w-2 rounded-full <?php echo e($loop->index === $i ? 'bg-primary' : 'bg-white/30'); ?>"></div>
                                                    <?php endfor; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>


                </div>
            </div>
        </section>

        <!-- Carregamento progressivo da seção de slides -->
        <div id="slides-container" class="content-staged">
            <?php echo $__env->make('layouts._partials.slides', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <!-- Random Movie Section - Redesign mais profissional -->
        <section class="py-16 bg-gradient-to-b from-black to-zinc-950">
            <div class="container px-4 mx-auto">
                <div class="mb-12 text-center">
                    <h2 class="mb-3 text-3xl font-bold">Não sabe o que assistir?</h2>
                    <p class="max-w-2xl mx-auto mb-8 text-zinc-400">Deixe-nos sugerir algo para você. Descubra filmes e séries aleatórios que podem se tornar seus novos favoritos.</p>

                    <div class="flex flex-col justify-center gap-4 sm:flex-row">
                        <button id="btn-random-movie"
                                class="relative flex items-center justify-center px-8 py-4 overflow-hidden font-medium text-white transition duration-300 group bg-zinc-800 hover:bg-zinc-700 rounded-xl">
                            <div class="absolute inset-0 transition-opacity duration-300 opacity-0 bg-gradient-to-r from-primary/20 to-transparent group-hover:opacity-100"></div>
                            <i class="mr-3 fas fa-random text-primary"></i>
                            <span class="flex flex-col items-start">
                                <span class="text-xs text-zinc-400">Escolha aleatória</span>
                                <span>Filmes</span>
                            </span>
                        </button>

                        <button id="btn-random-series"
                                class="relative flex items-center justify-center px-8 py-4 overflow-hidden font-medium text-white transition duration-300 group bg-zinc-800 hover:bg-zinc-700 rounded-xl">
                            <div class="absolute inset-0 transition-opacity duration-300 opacity-0 bg-gradient-to-r from-primary/20 to-transparent group-hover:opacity-100"></div>
                            <i class="mr-3 fas fa-random text-primary"></i>
                            <span class="flex flex-col items-start">
                                <span class="text-xs text-zinc-400">Escolha aleatória</span>
                                <span>Séries</span>
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Modal de Conteúdo Aleatório -->
    <div id="random-modal" class="fixed inset-0 z-50 flex items-center justify-center hidden">
        <div class="absolute inset-0 bg-black/80 backdrop-blur-sm"></div>

        <div class="relative z-10 w-full max-w-5xl mx-4 overflow-hidden shadow-2xl bg-zinc-950 rounded-xl">
            <!-- Botão de fechar -->
            <button id="close-random-modal" class="absolute z-20 flex items-center justify-center w-10 h-10 text-white transition-colors rounded-full bg-black/10 top-4 right-4 hover:bg-red-600/50 backdrop-blur-sm">
                <i class="fas fa-times"></i>
            </button>

            <!-- Conteúdo do modal -->
            <div class="max-h-[90vh] overflow-y-auto">
                <!-- Container para conteúdo aleatório -->
                <div id="random-content-container" class="hidden">
                    <div class="relative">
                        <!-- Backdrop image -->
                        <div id="movie-backdrop-container" class="relative w-full h-64 overflow-hidden sm:h-80 md:h-96 bg-zinc-800">
                            <img id="movie-backdrop" class="object-cover w-full h-full" src="" alt="">
                            <div class="absolute inset-0 bg-gradient-to-t from-zinc-950 via-zinc-950/80 to-transparent"></div>
                            <div class="absolute inset-0 bg-gradient-to-r from-zinc-950/70 via-zinc-950/30 to-transparent"></div>
                        </div>

                        <!-- Movie/Series info -->
                        <div class="p-6 md:p-8">
                            <div class="flex flex-col gap-6 md:flex-row">
                                <!-- Poster -->
                                <div class="relative z-10 flex-shrink-0 -mt-24 w-36 md:w-48">
                                    <img id="movie-image" src="" alt="Poster"
                                         class="border-2 rounded-lg shadow-2xl w-36 md:w-48 border-zinc-800">
                                </div>

                                <!-- Info -->
                                <div class="flex-1">
                                    <h3 id="movie-title" class="mb-2 text-xl font-bold md:text-2xl"></h3>

                                    <!-- Metadata -->
                                    <div class="flex flex-wrap items-center gap-3 mb-4">
                                        <p id="movie-date" class="px-2 py-0.5 text-xs rounded-full bg-zinc-800/80">2023</p>
                                        <p id="movie-duration" class="flex items-center gap-1 px-2 py-0.5 text-xs rounded-full bg-zinc-800/80">
                                            <i class="fas fa-clock"></i>
                                            <span>0h 00min</span>
                                        </p>
                                        <div id="movie-rating-container" class="flex items-center px-2 py-0.5 text-xs rounded-full bg-zinc-800/80">
                                            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/69/IMDB_Logo_2016.svg/320px-IMDB_Logo_2016.svg.png"
                                                alt="IMDB"
                                                class="h-4 mr-1">
                                            <span id="movie-rating" class="text-sm font-medium text-white">0.0</span>
                                        </div>
                                    </div>


                                    <!-- Genres - Limited to 3 items -->
                                    <div class="flex flex-wrap gap-2 mb-4" id="movie-genres"></div>

                                    <!-- Overview -->
                                    <p id="movie-overview" class="mb-6 text-sm text-zinc-300"></p>

                                    <div class="flex flex-col gap-4 sm:flex-row">
                                        <button id="watch-content-button" class="flex items-center justify-center px-6 py-3 font-medium text-black transition duration-300 rounded-lg bg-primary hover:scale-105">
                                            <i class="mr-2 fas fa-play"></i>
                                            Assistir Agora
                                        </button>

                                        <button id="find-another-button" class="flex items-center justify-center px-6 py-3 font-medium transition duration-300 rounded-lg text-zinc-100 bg-zinc-800 hover:bg-zinc-700">
                                            <i class="mr-2 fas fa-random"></i>
                                            Encontrar Outro
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Loading indicator -->
                <div id="random-content-loading" class="hidden py-20 text-center">
                    <div class="inline-block w-16 h-16 mb-4 border-4 rounded-full border-zinc-600 border-t-primary animate-spin"></div>
                    <p class="text-zinc-400">Buscando conteúdo perfeito para você...</p>
                </div>

                <!-- No results message -->
                <div id="random-content-error" class="hidden p-8 text-center">
                    <i class="mb-4 text-4xl text-red-500 fas fa-exclamation-circle"></i>
                    <h3 class="mb-2 text-xl font-bold">Não foi possível encontrar conteúdo</h3>
                    <p class="mb-6 text-zinc-400">Tente novamente ou escolha outra categoria</p>
                    <button id="try-again-button" class="px-6 py-3 font-medium transition duration-300 rounded-lg text-zinc-100 bg-zinc-800 hover:bg-zinc-700">
                        Tentar Novamente
                    </button>
                </div>

                <!-- Subscription required message -->
                <div id="subscription-required" class="hidden py-16 text-center">
                    <i class="mb-6 text-5xl fas fa-lock text-primary"></i>
                    <h3 class="mb-4 text-2xl font-bold">Assinatura Necessária</h3>
                    <p class="max-w-xl mx-auto mb-8 text-zinc-400">Para assistir aos conteúdos você precisa ter uma assinatura ativa! Acesse milhares de filmes e séries sem limites.</p>
                    <a href="<?php echo e(route('choose.plan')); ?>"
                       class="inline-block px-8 py-3 font-medium text-black transition duration-300 rounded-full bg-primary hover:scale-105">
                        Assine agora
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de player em tela cheia - Adaptado para UltraPlayer -->
    <div id="fullscreen-player-modal" class="fixed inset-0 z-[60] hidden bg-black">
        <button id="close-fullscreen-player" class="absolute z-[61] flex items-center justify-center w-10 h-10 text-white transition-colors bg-black rounded-full top-4 right-4 bg-opacity-40 hover:bg-opacity-60">
            <i class="fas fa-times"></i>
        </button>
        <div class="w-full h-full">
            <div id="modal-player-container" class="w-full h-full"></div>
        </div>
    </div>

    <!-- Scripts - Optimized loading -->
    <script>
        // Estratégia de carregamento otimizada
        document.addEventListener('DOMContentLoaded', function() {
            // Carregar primeiro o conteúdo principal
            setTimeout(() => {
                document.getElementById('main-content-container').classList.add('content-loaded');

                // Depois carregar o conteúdo de slides com um pequeno atraso
                setTimeout(() => {
                    document.getElementById('slides-container').classList.add('content-loaded');
                }, window.PERFORMANCE_CONFIG.DEFER_SLIDES_TIMEOUT);

            }, window.PERFORMANCE_CONFIG.DEFER_FEATURED_TIMEOUT);

            // Função para carregar scripts dinamicamente
            function loadScript(src, callback, priority = 'low') {
                // Verificar se o script já foi carregado
                if (window.scriptCache[src]) {
                    if (callback) callback();
                    return;
                }

                const script = document.createElement('script');
                script.src = src;

                if (priority === 'high') {
                    // Alta prioridade: carrega imediatamente
                    script.async = false;
                } else {
                    // Baixa prioridade: carrega assincronamente
                    script.async = true;
                    script.defer = true;
                }

                script.onload = function() {
                    window.scriptCache[src] = true;
                    if (callback) callback();
                };

                document.body.appendChild(script);
            }

            // Carregar jQuery primeiro (recurso crítico)
            loadScript("https://code.jquery.com/jquery-3.6.0.min.js", function() {
                // Após jQuery, carregar Splide (recurso crítico para carrosséis)
                loadScript("https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/js/splide.min.js", function() {
                    // Iniciar featured slider logo após carregar Splide
                    initFeaturedSlider();

                    // Carregar scripts não críticos em paralelo
                    loadScript("<?php echo e(asset('js/custom-player.js')); ?>", function() {
                        loadScript("<?php echo e(asset('js/random-content-player.js')); ?>");
                    });
                }, 'high');
            }, 'high');

            // Função para inicializar o slider de destaque
            function initFeaturedSlider() {
                if (typeof Splide !== 'undefined' && document.getElementById('featured-slider')) {
                    try {
                        new Splide('#featured-slider', {
                            type: 'fade',
                            rewind: true,
                            autoplay: true,
                            interval: 8000,
                            arrows: false,
                            pagination: false,
                            perPage: 1,
                            speed: 1000,
                            pauseOnHover: true,
                            pauseOnFocus: false,
                            lazyLoad: 'nearby'
                        }).mount();

                        // Esconder o shimmer loading após inicialização
                        const featuredLoading = document.getElementById('featured-loading');
                        const featuredContent = document.getElementById('featured-content');

                        if (featuredLoading && featuredContent) {
                            setTimeout(() => {
                                featuredLoading.style.display = 'none';
                                featuredContent.classList.add('loaded');
                            }, 300);
                        }
                    } catch (e) {
                        console.error('Erro ao inicializar featured slider:', e);
                    }
                }
            }
        });
    </script>

    <script>
        // Implementação otimizada do Modal de Conteúdo Aleatório
        document.addEventListener("DOMContentLoaded", function() {
            // Código para gerenciar modais
            const randomModal = document.getElementById('random-modal');
            const closeRandomModal = document.getElementById('close-random-modal');
            const randomContentContainer = document.getElementById('random-content-container');
            const randomContentLoading = document.getElementById('random-content-loading');
            const randomContentError = document.getElementById('random-content-error');
            const subscriptionRequired = document.getElementById('subscription-required');
            const watchContentButton = document.getElementById('watch-content-button');
            const findAnotherButton = document.getElementById('find-another-button');
            const tryAgainButton = document.getElementById('try-again-button');

            let currentType = null;
            let currentContent = null;

            // Verificar se usuário é premium
            window.isPremium = <?php echo e(auth()->check() && auth()->user()->premuim == 1 && auth()->user()->expired_in > $hoje ? 'true' : 'false'); ?>;

            // Fechar modal aleatório
            closeRandomModal.addEventListener('click', function() {
                randomModal.classList.add('hidden');
                document.body.style.overflow = '';
            });

            // Função para mostrar indicador de carregamento
            function showLoading() {
                randomContentContainer.classList.add('hidden');
                randomContentError.classList.add('hidden');
                subscriptionRequired.classList.add('hidden');
                randomContentLoading.classList.remove('hidden');

                // Exibir o modal
                randomModal.classList.remove('hidden');
                document.body.style.overflow = 'hidden';  // Impedir rolagem
            }

            // Função para mostrar erro
            function showError() {
                randomContentContainer.classList.add('hidden');
                randomContentLoading.classList.add('hidden');
                subscriptionRequired.classList.add('hidden');
                randomContentError.classList.remove('hidden');
            }

            // Função para mostrar conteúdo aleatório
            function showContent() {
                randomContentLoading.classList.add('hidden');
                randomContentError.classList.add('hidden');
                subscriptionRequired.classList.add('hidden');
                randomContentContainer.classList.remove('hidden');
            }

            // Função para mostrar mensagem de assinatura necessária
            function showSubscriptionRequired() {
                randomContentLoading.classList.add('hidden');
                randomContentError.classList.add('hidden');
                randomContentContainer.classList.add('hidden');
                subscriptionRequired.classList.remove('hidden');
            }

            // Função para buscar filme aleatório
            function fetchRandomMovie() {
                currentType = 'movie';
                showLoading();

                $.ajax({
                    url: '<?php echo e(route("random_movie")); ?>',
                    type: 'GET',
                    success: function(data) {
                        window.currentContent = data;

                        // Preencher informações do filme
                        $('#movie-title').text(data.movieTitle);

                        // Limitar o tamanho do overview
                        const overview = data.movieOverview || '';
                        const truncatedOverview = overview.length > 200
                            ? overview.substring(0, 200) + '...'
                            : overview;

                        $('#movie-overview').text(truncatedOverview);

                        // Formatação da data de lançamento
                        const releaseYear = data.movieRelease ? data.movieRelease.split("-")[0] : 'N/A';
                        $('#movie-date').text(releaseYear);

                        // Duração formatada
                        $('#movie-duration').html(`<i class="fas fa-clock"></i> ${data.movieDuration || 'N/A'}`);
                        $('#movie-duration').removeClass('hidden');

                        // Imagens
                        $('#movie-image').attr('src', data.moviePoster);
                        $('#movie-backdrop').attr('src', data.movieBackdrop || data.movieImage || data.moviePoster);

                        // Avaliação
                        if (data.movieRating) {
                            $('#movie-rating').text(data.movieRating.toFixed(1));
                            $('#movie-rating-container').removeClass('hidden');
                        } else {
                            $('#movie-rating-container').addClass('hidden');
                        }

                        // Gêneros do filme
                        const genresContainer = $('#movie-genres');
                        genresContainer.empty();
                        if (data.movieGenres && data.movieGenres.length > 0) {
                            data.movieGenres.forEach(genre => {
                                genresContainer.append(`
                                    <span class="px-3 py-1 text-sm font-medium rounded-full bg-zinc-800/80">
                                        ${genre}
                                    </span>
                                `);
                            });
                        }

                        showContent();

                        // Configurar botão de assistir para abrir em fullscreen com UltraPlayer
                        watchContentButton.onclick = function() {
                            openFullscreenPlayer(
                                data.movieUrl,
                                data.movieBackdrop || data.movieImage || data.moviePoster,
                                'movie'
                            );
                        };

                        findAnotherButton.onclick = fetchRandomMovie;
                    },
                    error: function() {
                        showError();
                        console.error("Não foi possível carregar o filme.");
                    }
                });
            }

            // Função para buscar série aleatória
            function fetchRandomSeries() {
                currentType = 'series';
                showLoading();

                $.ajax({
                    url: '<?php echo e(route("random_series")); ?>',
                    type: 'GET',
                    success: function(data) {
                        window.currentContent = data;

                        // Preencher informações da série
                        const seriesTitle = `${data.seriesTitle} - Temporada ${data.seasonNumber} Episódio ${data.episodeNumber}`;
                        $('#movie-title').text(seriesTitle);

                        // Limitar o tamanho do overview
                        const overview = data.episodeOverview || data.seriesOverview || 'Sem descrição disponível';
                        const truncatedOverview = overview.length > 200
                            ? overview.substring(0, 200) + '...'
                            : overview;

                        $('#movie-overview').text(truncatedOverview);

                        // Formatação da data de lançamento
                        const releaseYear = data.seriesFirstAirDate ? data.seriesFirstAirDate.split("-")[0] : 'N/A';
                        $('#movie-date').text(releaseYear);

                        // Não ocultar duração para séries
                        $('#movie-duration').html(`<i class="fas fa-film"></i> Série`);
                        $('#movie-duration').removeClass('hidden');

                        // Imagens
                        $('#movie-image').attr('src', data.seriesPoster || data.episodeImage);
                        $('#movie-backdrop').attr('src', data.seriesBackdrop || data.episodeImage || data.seriesPoster);

                        // Avaliação
                        if (data.seriesRating) {
                            $('#movie-rating').text(data.seriesRating.toFixed(1));
                            $('#movie-rating-container').removeClass('hidden');
                        } else {
                            $('#movie-rating-container').addClass('hidden');
                        }

                        // Gêneros da série
                        const genresContainer = $('#movie-genres');
                        genresContainer.empty();
                        if (data.seriesGenres && data.seriesGenres.length > 0) {
                            data.seriesGenres.forEach(genre => {
                                genresContainer.append(`
                                    <span class="px-3 py-1 text-xs font-medium rounded-full bg-zinc-800/80">
                                        ${genre}
                                    </span>
                                `);
                            });
                        }

                        showContent();

                        // Configurar botão de assistir para abrir em fullscreen com UltraPlayer
                        watchContentButton.onclick = function() {
                            openFullscreenPlayer(
                                data.episodeUrl,
                                data.seriesBackdrop || data.episodeImage || data.seriesPoster,
                                'series'
                            );
                        };

                        // Botão "Encontrar Outro" busca outra série aleatória
                        findAnotherButton.onclick = fetchRandomSeries;
                    },
                    error: function() {
                        showError();
                        console.error("Não foi possível carregar a série.");
                    }
                });
            }

            // Configurar botões iniciais
            document.getElementById('btn-random-movie').addEventListener('click', function() {
                if (!window.isPremium) {
                    showSubscriptionRequired();
                    randomModal.classList.remove('hidden');
                    document.body.style.overflow = 'hidden';
                } else {
                    fetchRandomMovie();
                }
            });

            document.getElementById('btn-random-series').addEventListener('click', function() {
                if (!window.isPremium) {
                    showSubscriptionRequired();
                    randomModal.classList.remove('hidden');
                    document.body.style.overflow = 'hidden';
                } else {
                    fetchRandomSeries();
                }
            });

            tryAgainButton.addEventListener('click', function() {
                if (currentType === 'movie') {
                    fetchRandomMovie();
                } else {
                    fetchRandomSeries();
                }
            });

            // Função para abrir o player em tela cheia
            function openFullscreenPlayer(videoUrl, posterUrl, type) {
                const playerModal = document.getElementById('fullscreen-player-modal');
                const playerContainer = document.getElementById('modal-player-container');

                if (!playerModal || !playerContainer) {
                    console.error('Modal ou container do player não encontrado!');
                    return;
                }

                // Mostrar o modal
                playerModal.classList.remove('hidden');
                document.body.style.overflow = 'hidden';

                // Verificar se função do random-content-player.js está disponível
                if (typeof window.openFullscreenPlayer === 'function' && window.openFullscreenPlayer !== openFullscreenPlayer) {
                    // Se a função foi substituída pelo random-content-player.js, usar essa versão
                    return window.openFullscreenPlayer(videoUrl, posterUrl, type);
                }

                // Limpar o container
                playerContainer.innerHTML = '';

                // Verificar se UltraPlayer está disponível
                if (typeof window.UltraPlayer === 'undefined') {
                    console.error('UltraPlayer não está disponível!');
                    playerContainer.innerHTML = `
                        <div style="display:flex;align-items:center;justify-content:center;height:100%;color:white;text-align:center;">
                            <p>Erro ao carregar o player. Por favor, tente novamente.</p>
                        </div>
                    `;
                    return;
                }

                try {
                    console.log('Criando player para conteúdo aleatório com:', { videoUrl, posterUrl, type });

                    // Criar instância do UltraPlayer diretamente
                    const player = new window.UltraPlayer({
                        container: playerContainer,
                        source: videoUrl,
                        poster: posterUrl,
                        autoplay: true,
                        muted: false,
                        primaryColor: '#2BF14A',
                        title: window.currentContent?.movieTitle || window.currentContent?.seriesTitle || 'Reproduzindo'
                    });

                    // Armazenar referência global
                    window.currentRandomPlayer = player;

                    // Configurar botão de fechar
                    const closeButton = document.getElementById('close-fullscreen-player');
                    if (closeButton) {
                        closeButton.onclick = function() {
                            try {
                                if (player && player.state && player.state.fullscreen) {
                                    player.exitFullscreen();
                                }

                                setTimeout(() => {
                                    try {
                                        if (window.currentRandomPlayer) {
                                            window.currentRandomPlayer.destroy();
                                            window.currentRandomPlayer = null;
                                        }

                                        playerModal.classList.add('hidden');
                                        document.body.style.overflow = '';
                                    } catch (e) {
                                        console.error('Erro ao limpar player:', e);
                                        playerModal.classList.add('hidden');
                                        document.body.style.overflow = '';
                                    }
                                }, 100);
                            } catch (e) {
                                console.error('Erro ao fechar player:', e);
                                playerModal.classList.add('hidden');
                                document.body.style.overflow = '';
                            }
                        };
                    }

                } catch (error) {
                    console.error('Erro ao inicializar UltraPlayer:', error);
                    playerContainer.innerHTML = `
                        <div style="display:flex;align-items:center;justify-content:center;height:100%;color:white;text-align:center;padding:20px;">
                            <p>Não foi possível reproduzir o vídeo. Erro: ${error.message}</p>
                        </div>
                    `;
                }
            }

            // Usar IntersectionObserver para detectar quando elementos ficam visíveis
            if ('IntersectionObserver' in window) {
                const lazyLoadObserver = new IntersectionObserver((entries) => {
                    entries.forEach(entry => {
                        if (entry.isIntersecting) {
                            let element = entry.target;

                            // Se for uma imagem com data-src, carregá-la
                            if (element.tagName === 'IMG' && element.dataset.src) {
                                element.src = element.dataset.src;
                                element.removeAttribute('data-src');
                            }

                            // Marcar como carregado
                            element.classList.add('loaded');

                            // Parar de observar
                            lazyLoadObserver.unobserve(element);
                        }
                    });
                }, {
                    rootMargin: window.PERFORMANCE_CONFIG.LAZY_LOAD_OFFSET
                });

                // Observar todas as imagens lazy e elementos lazy
                document.querySelectorAll('img[data-src], .lazy-element').forEach(element => {
                    lazyLoadObserver.observe(element);
                });
            }
        });
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/layouts/pages/inicio.blade.php ENDPATH**/ ?>