<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Criar Perfil</title>
    <link rel="stylesheet" href="/public/css/web.css">
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
</head>
<body class="body-fav">
<div class="container-profilec">
    <div class="row-profiles">
        <div class="col-">
            <div class="card-profiles">
                <div class="card-header">Criar Novo Perfil</div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(url('/user/profile/create')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <input placeholder="Nome de Perfil" class="input-profile" type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <div class="form-group-avatares">
                            <h4 >Escolha um Avatar</h4>
                            <div class="avatar-list">
                            <?php $__currentLoopData = $avatars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $avatar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="avatar-container-create">
                                <input type="radio" id="avatar<?php echo e($loop->index); ?>" name="avatar" value="<?php echo e($avatar); ?>" required>
                                <label for="avatar<?php echo e($loop->index); ?>"><img loading="lazy" src="<?php echo e($avatar); ?>" alt="Avatar"></label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="criar-perfil-create">
                            <button type="submit" class="btn-profiles-criar">Criar Perfil</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html><?php /**PATH /home/ultraflix/public_html/site.ultraflix.net/resources/views/auth/create-profile.blade.php ENDPATH**/ ?>