<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aviso Importante</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body, html {
            margin: 0;
            padding: 0;
            height: 100%;
            width: 100%;
            font-family: 'Arial', sans-serif;
            background-color: #121212;
            color: #fff;
            overflow: hidden;
        }

        .call-to-action-container {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            padding: 20px;
            background-color: #121212;
        }

        .call-to-action-card {
            background-color: #1a1a1a;
            border: 1px solid #333;
            border-radius: 20px;
            padding: 30px;
            text-align: center;
            max-width: 500px;
            width: 90%;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.5);
        }

        .call-to-action-icon {
            font-size: 64px;
            color: #ff5722;
            margin-bottom: 25px;
        }

        .call-to-action-title {
            color: #fff;
            font-size: 28px;
            margin-bottom: 20px;
            font-weight: 700;
        }

        .call-to-action-message {
            color: #ddd;
            font-size: 18px;
            margin-bottom: 35px;
            line-height: 1.6;
        }

        .call-to-action-button {
            display: inline-block;
            background-color: #FFC107; /* Amarelo */
            color: #000;
            padding: 15px 40px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: bold;
            font-size: 18px;
            letter-spacing: 1px;
            transition: all 0.3s ease;
            text-transform: uppercase;
            box-shadow: 0 4px 8px rgba(255, 193, 7, 0.3);
        }

        .call-to-action-button:hover {
            background-color: #FFD54F;
            transform: translateY(-3px);
            box-shadow: 0 8px 15px rgba(255, 193, 7, 0.4);
        }

        @media (max-width: 480px) {
            .call-to-action-title {
                font-size: 24px;
            }

            .call-to-action-message {
                font-size: 16px;
            }

            .call-to-action-button {
                padding: 12px 30px;
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="call-to-action-container">
        <div class="call-to-action-card">
            <div class="call-to-action-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <h3 class="call-to-action-title">Aviso Importante</h3>
            <p class="call-to-action-message">
                Este aplicativo deixará de funcionar, por favor acesse o nosso novo site para continuar assistindo seus conteúdos.
            </p>
            <a href="https://goldflix.pro/" class="call-to-action-button" onclick="openInBrowser(event)">
                CLIQUE AQUI
            </a>
        </div>
    </div>

    <script>
    function openInBrowser(event) {
        event.preventDefault();
        const url = "https://goldflix.pro/";
        
        // Verifica se está em ambiente móvel com capacidade de intent
        if (typeof AndroidInterface !== 'undefined') {
            // Para Android usando JavascriptInterface
            AndroidInterface.openUrl(url);
        } else if (window.webkit && window.webkit.messageHandlers && window.webkit.messageHandlers.openUrl) {
            // Para iOS usando WKWebView
            window.webkit.messageHandlers.openUrl.postMessage(url);
        } else {
            // Fallback para navegador padrão
            window.open(url, '_blank');
        }
        
        return false;
    }
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/call-to-action.blade.php ENDPATH**/ ?>