<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quem está assistindo?</title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
    <style>
        .toast {
            visibility: hidden;
            min-width: 250px;
            text-align: center;
            border-radius: 9999px;
            padding: 16px;
            position: fixed;
            z-index: 50;
            left: 50%;
            transform: translateX(-50%);
            top: 30px;
            font-weight: 500;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        }

        .toast.success {
            background-color: rgba(43, 241, 74, 0.9);
            color: #000;
        }

        .toast.error {
            background-color: rgba(239, 68, 68, 0.9);
            color: #fff;
        }

        .toast.show {
            visibility: visible;
            animation: fadein 0.5s, fadeout 0.5s 4.5s;
        }

        @keyframes fadein {
            from {top: 0; opacity: 0;}
            to {top: 30px; opacity: 1;}
        }

        @keyframes fadeout {
            from {top: 30px; opacity: 1;}
            to {top: 0; opacity: 0;}
        }

        /* Modal styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.7);
            z-index: 100;
            justify-content: center;
            align-items: center;
        }

        .modal.show {
            display: flex;
        }

        .modal-content {
            animation: modalFadeIn 0.3s;
        }

        @keyframes modalFadeIn {
            from {opacity: 0; transform: scale(0.95);}
            to {opacity: 1; transform: scale(1);}
        }
    </style>
</head>
<body class="min-h-screen text-white bg-black font-poppins">
    <?php if(session('response')): ?>
        <div id="toast" class="toast <?php echo e(session('response')['type'] === 'success' ? 'success' : 'error'); ?>">
            <?php echo e(session('response')['message']); ?>

        </div>
    <?php endif; ?>

    <!-- Delete Confirmation Modal -->
    <div id="deleteModal" class="modal">
        <div class="w-full max-w-sm p-6 mx-4 modal-content bg-zinc-800 rounded-xl">
            <h3 class="mb-4 text-xl font-bold text-center">Confirmar exclusão</h3>
            <p class="mb-6 text-center">Tem certeza que deseja excluir este perfil?</p>
            <div class="flex justify-center space-x-4">
                <button id="cancelDelete" class="px-5 py-2 transition-colors rounded-full bg-zinc-700 hover:bg-zinc-600">
                    Cancelar
                </button>
                <button id="confirmDelete" class="px-5 py-2 transition-colors bg-red-600 rounded-full hover:bg-red-700">
                    Excluir
                </button>
            </div>
        </div>
    </div>

    <div class="container flex flex-col items-center justify-center min-h-screen px-4 py-20 mx-auto">
        <div class="w-full max-w-4xl p-8 shadow-xl bg-zinc-900/80 rounded-2xl">
            <h1 class="mb-12 text-3xl font-bold text-center">Quem está assistindo?</h1>

            <div class="grid grid-cols-2 gap-6 mb-12 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5">
                <?php $__empty_1 = true; $__currentLoopData = $profiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $profile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="relative group">
                        <!-- Profile Avatar -->
                        <div class="relative aspect-square">
                            <a href="<?php echo e(url('/select-profile/'.$profile->id)); ?>" class="relative block w-full h-full transition-transform duration-300 group-hover:scale-105">
                                <img src="<?php echo e($profile->avatar ? asset($profile->avatar) : asset('/avatars/avatar_default.png')); ?>"
                                     alt="Avatar"
                                     class="object-cover w-full h-full transition-all duration-300 border-4 border-transparent rounded-full group-hover:border-primary/50">
                            </a>

                            <!-- Delete Button -->
                            <form class="absolute -top-2 -right-2" action="<?php echo e(url('/user/profile/delete/'.$profile->id)); ?>" method="POST" id="delete-form-<?php echo e($profile->id); ?>">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="button" class="p-2 transition-colors rounded-full delete-icon bg-zinc-800 hover:bg-zinc-700" data-profile-id="<?php echo e($profile->id); ?>">
                                    <i class="text-sm fas fa-trash text-primary"></i>
                                </button>
                            </form>
                        </div>

                        <!-- Profile Name -->
                        <p class="mt-3 font-medium text-center"><?php echo e($profile->name); ?></p>

                        <!-- Edit Button -->
                        <div class="mt-2 text-center">
                            <a href="<?php echo e(url('/user/profile/edit/'.$profile->id)); ?>"
                               class="inline-block px-4 py-2 text-sm text-white transition-colors border rounded-full border-primary hover:bg-primary hover:text-black">
                                Editar
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="py-8 text-lg text-center col-span-full text-zinc-400">
                        <p>Você não criou nenhum perfil</p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Create Profile Button -->
            <div class="text-center">
                <a href="<?php echo e(url('/user/profile/create')); ?>"
                   class="inline-block px-6 py-3 font-semibold text-black transition-colors rounded-full bg-primary hover:scale-105">
                    Criar Perfil
                </a>
            </div>
        </div>
    </div>

    <script>
        function showToast() {
            var toast = document.getElementById("toast");
            if (toast) {
                toast.className = toast.className + " show";
                setTimeout(function(){
                    toast.className = toast.className.replace(" show", "");
                }, 5000);
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            showToast();

            const modal = document.getElementById('deleteModal');
            const cancelButton = document.getElementById('cancelDelete');
            const confirmButton = document.getElementById('confirmDelete');
            let currentProfileId = null;

            // Attach event listeners to all delete buttons
            document.querySelectorAll('.delete-icon').forEach(function(button) {
                button.addEventListener('click', function() {
                    // Store the profile ID to delete
                    currentProfileId = this.getAttribute('data-profile-id');
                    // Show the modal
                    modal.classList.add('show');
                });
            });

            // Cancel button closes the modal
            cancelButton.addEventListener('click', function() {
                modal.classList.remove('show');
                currentProfileId = null;
            });

            // Clicking outside the modal content closes it
            modal.addEventListener('click', function(event) {
                if (event.target === modal) {
                    modal.classList.remove('show');
                    currentProfileId = null;
                }
            });

            // Confirm button submits the form
            confirmButton.addEventListener('click', function() {
                if (currentProfileId) {
                    document.getElementById('delete-form-' + currentProfileId).submit();
                }
            });
        });
    </script>
</body>
</html>
<?php /**PATH /home/u446595196/domains/conectaplus.tv.br/public_html/resources/views/auth/choose-profile.blade.php ENDPATH**/ ?>