<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($title); ?> - <?php echo e($settings->app_name); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500;600;700&family=Work+Sans:wght@900&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>

    <style>
        .item-card {
            transition: transform 0.3s ease;
        }

        .item-card:hover {
            transform: scale(1.05);
        }

        .lazy-image {
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .lazy-image.loaded {
            opacity: 1;
        }

        .shimmer {
            background: linear-gradient(90deg,
                        rgba(40, 40, 40, 0.2) 0%,
                        rgba(60, 60, 60, 0.5) 40%,
                        rgba(40, 40, 40, 0.2) 80%);
            background-size: 200% 100%;
            animation: shimmer 1.5s infinite linear;
        }

        @keyframes shimmer {
            0% { background-position: -200% 0; }
            100% { background-position: 200% 0; }
        }

        .page-header {
            position: relative;
            padding-bottom: 1.5rem;
            margin-bottom: 2rem;
        }


        /* Estilos para o infinite scroll */
        .infinite-scroll-loader {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 2rem 0;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .infinite-scroll-loader.visible {
            opacity: 1;
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 3px solid rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            border-top-color: #2BF14A;
            animation: spinner 1s ease-in-out infinite;
            margin-bottom: 0.5rem;
        }

        @keyframes spinner {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Animação fade-in para novos itens */
        .new-item {
            opacity: 0;
            transform: translateY(10px);
            animation: fadeIn 0.5s ease forwards;
        }

        @keyframes fadeIn {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }


        .image-wrapper {
            position: relative;
            overflow: hidden;
            border-radius: 0.5rem;
            border: 2px solid transparent;
            transition: border-color 0.3s ease, transform 0.3s ease;
        }

        .image-wrapper:hover {
            border-color: white;
            transform: scale(1.05);
        }
    </style>
</head>

<body class="min-h-screen mb-10 text-white bg-zinc-950 font-poppins">
    <!-- Header -->
    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Content -->
    <div class="container px-4 py-20 mx-auto md:py-16">
        <div class="flex items-center justify-between mb-8">
            <div>
                <h1 class="font-bold text-1xl md:text-4xl page-header"><?php echo e($title); ?></h1>
            </div>
            <a href="<?php echo e(route('inicio')); ?>" class="flex items-center px-3 py-2 text-sm transition-colors rounded-full bg-zinc-800 hover:bg-zinc-700">
                <i class="mr-2 fas fa-arrow-left"></i>
                <span>Voltar</span>
            </a>
        </div>

        <!-- Content Grid - 3 colunas no desktop, 2 no mobile -->
        <?php if($content->count() > 0): ?>
            <div id="content-grid" class="grid grid-cols-2 gap-4 md:gap-6 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
                <?php $__currentLoopData = $content; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="item-card">
                        <?php
                            if ($type === 'continue' && isset($item->serie_id)) {
                                $detailRoute = route('serie.detail', ['id' => $item->serie_id]);
                            } elseif ($item->type === 'movie') {
                                $detailRoute = route('filme.detail', ['id' => $item->id]);
                            } elseif ($item->type === 'serie') {
                                $detailRoute = route('serie.detail', ['id' => $item->id]);
                            } elseif ($item->type === 'anime') {
                                $detailRoute = route('anime.detail', ['id' => $item->id]);
                            } else {
                                $detailRoute = '#';
                            }
                        ?>

                        <a href="<?php echo e($detailRoute); ?>" class="block">
                            <div class="image-wrapper transform transition duration-500 hover:scale-103 relative overflow-hidden rounded-lg aspect-[2/3] bg-zinc-800">
                                <!-- Shimmer placeholder -->
                                <div class="absolute inset-0 shimmer"></div>

                                <!-- Poster image -->
                                <img
                                    src="<?php echo e($item->poster_path); ?>"
                                    alt="<?php echo e($item->name); ?>"
                                    class="absolute inset-0 object-cover w-full h-full lazy-image"
                                    loading="lazy"
                                    onload="this.classList.add('loaded'); this.previousElementSibling.style.display='none';"
                                >

                                <!-- Overlay gradiente -->
                                <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>

                                <?php if($type === 'continue' && isset($item->progress)): ?>
                                    <!-- Barra de progresso para Continue Assistindo -->
                                    <div class="absolute bottom-0 left-0 w-full h-1 bg-zinc-700">
                                        <div class="h-full bg-primary" style="width: <?php echo e($item->progress); ?>%;"></div>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="mt-2 space-y-1">
                                <h3 class="font-medium truncate"><?php echo e($item->name); ?></h3>

                                <div class="flex items-center gap-2">
                                    <?php if($item->type === 'movie'): ?>
                                        <span class="px-2 py-0.5 text-xs rounded-full bg-zinc-800">Filme</span>
                                    <?php elseif($item->type === 'serie'): ?>
                                        <span class="px-2 py-0.5 text-xs rounded-full bg-zinc-800">Série</span>
                                    <?php elseif($item->type === 'anime'): ?>
                                        <span class="px-2 py-0.5 text-xs rounded-full bg-zinc-800">Anime</span>
                                    <?php endif; ?>

                                    <?php if(isset($item->vote_average) && $item->vote_average > 0): ?>
                                        <div class="flex items-center gap-1 px-2 py-0.5 text-xs bg-black/50 rounded-full">
                                            <i class="text-yellow-400 fas fa-star"></i>
                                            <span><?php echo e(number_format($item->vote_average, 1)); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <?php if($type === 'continue' && isset($item->episode_name)): ?>
                                    <p class="text-xs truncate text-zinc-400">
                                        <?php echo e($item->episode_name); ?>

                                    </p>
                                <?php endif; ?>
                            </div>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Infinite Scroll Loader -->
            <div id="infinite-scroll-loader" class="infinite-scroll-loader">
                <div class="spinner"></div>
                <p class="text-sm text-zinc-400">Carregando mais conteúdo...</p>
            </div>

            <!-- Hidden inputs para o infinite scroll -->
            <input type="hidden" id="current-page" value="<?php echo e($content->currentPage()); ?>">
            <input type="hidden" id="last-page" value="<?php echo e($content->lastPage()); ?>">
            <input type="hidden" id="content-type" value="<?php echo e($type); ?>">

        <?php else: ?>
            <div class="flex flex-col items-center justify-center py-20">
                <i class="mb-4 text-5xl text-zinc-700 fas fa-search"></i>
                <h3 class="mb-2 text-xl font-medium">Nenhum conteúdo encontrado</h3>
                <p class="text-zinc-400">Não encontramos nenhum resultado para esta categoria.</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Configuração do Intersecção Observer para lazy loading de imagens
            const lazyImageObserver = 'IntersectionObserver' in window ? new IntersectionObserver(function(entries, observer) {
                entries.forEach(function(entry) {
                    if (entry.isIntersecting) {
                        const lazyImage = entry.target;
                        if (!lazyImage.classList.contains('loaded')) {
                            if (lazyImage.getAttribute('src')) {
                                lazyImageObserver.unobserve(lazyImage);
                            }
                        }
                    }
                });
            }, {
                rootMargin: '200px 0px',
                threshold: 0.01
            }) : null;

            // Função para observar novas imagens lazy (necessária para itens carregados via AJAX)
            function observeLazyImages() {
                if (!lazyImageObserver) return;

                const lazyImages = document.querySelectorAll('.lazy-image:not(.observed)');
                console.log(`Observando ${lazyImages.length} novas imagens`);

                lazyImages.forEach(function(lazyImage) {
                    lazyImage.classList.add('observed');
                    lazyImageObserver.observe(lazyImage);
                });
            }

            // Observe imagens iniciais
            observeLazyImages();

            // Configuração do Infinite Scroll
            const contentGrid = document.getElementById('content-grid');
            const loader = document.getElementById('infinite-scroll-loader');
            const currentPageInput = document.getElementById('current-page');
            const lastPageInput = document.getElementById('last-page');
            const contentTypeInput = document.getElementById('content-type');
            const itemsCountElement = document.getElementById('items-count');

            let currentPage = parseInt(currentPageInput.value);
            const lastPage = parseInt(lastPageInput.value);
            const contentType = contentTypeInput.value;
            let isLoading = false;
            let totalItems = <?php echo e($content->total()); ?>;
            let loadingTimerId = null;

            // Verifica imediatamente se estamos na última página e oculta o loader se for o caso
            if (currentPage >= lastPage) {
                console.log('Já estamos na última página, ocultando loader');
                loader.style.display = 'none';
            }

            // Função para verificar se o usuário rolou até perto do final da página
            function checkScrollPosition() {
                if (isLoading || currentPage >= lastPage) return;

                const scrollPosition = window.scrollY;
                const windowHeight = window.innerHeight;
                const documentHeight = document.documentElement.scrollHeight;

                // Carregar mais conteúdo quando o usuário estiver próximo do fim da página
                // Reduzido o valor para 300px para iniciar a carga antes de chegar no final
                if (scrollPosition + windowHeight > documentHeight - 300) {
                    loadMoreContent();
                }
            }

            // Função para carregar mais conteúdo via AJAX
            function loadMoreContent() {
                if (isLoading || currentPage >= lastPage) {
                    // Se já estamos na última página, garantir que o loader esteja oculto
                    if (currentPage >= lastPage) {
                        loader.style.display = 'none';
                    }
                    return;
                }

                // Definir estado de carregamento
                isLoading = true;
                loader.classList.add('visible');

                // Log para depuração
                console.log(`Carregando página ${currentPage + 1} de ${lastPage}`);

                // Configura um timeout de segurança para resetar o estado de carregamento caso a requisição falhe
                if (loadingTimerId) clearTimeout(loadingTimerId);
                loadingTimerId = setTimeout(() => {
                    if (isLoading) {
                        console.error('Timeout ao carregar a próxima página');
                        isLoading = false;
                        loader.classList.remove('visible');
                    }
                }, 10000); // 10 segundos de timeout

                // Calcula a próxima página
                const nextPage = currentPage + 1;

                // Faz a requisição AJAX
                $.ajax({
                    url: `<?php echo e(url()->current()); ?>?page=${nextPage}`,
                    type: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        clearTimeout(loadingTimerId);

                        if (response && response.html) {
                            // Pequeno delay para uma experiência melhor
                            setTimeout(() => {
                                // Cria um elemento temporário para parsear o HTML
                                const tempContainer = document.createElement('div');
                                tempContainer.innerHTML = response.html;

                                // Adiciona cada novo item ao grid com animação
                                const newItems = tempContainer.querySelectorAll('.item-card');
                                console.log(`Adicionando ${newItems.length} novos itens da página ${nextPage}`);

                                if (newItems.length > 0) {
                                    newItems.forEach((item, index) => {
                                        item.classList.add('new-item');
                                        item.style.animationDelay = `${index * 0.05}s`;
                                        contentGrid.appendChild(item);
                                    });

                                    // Atualiza o contador de itens mostrados
                                    if (typeof totalItems !== 'undefined' && document.getElementById('items-count')) {
                                        totalItems += newItems.length;
                                        document.getElementById('items-count').textContent = `${totalItems} itens encontrados`;
                                    }
                                }

                                // Atualiza a página atual
                                currentPage = nextPage;
                                currentPageInput.value = currentPage;

                                // Observa as novas imagens para lazy loading
                                if (typeof observeLazyImages === 'function') {
                                    observeLazyImages();
                                }

                                // Desativa o estado de carregamento
                                isLoading = false;
                                loader.classList.remove('visible');

                                // Se chegou na última página ou se a resposta indica que é a última, oculta o loader
                                if (currentPage >= lastPage || (response.lastPage && currentPage >= response.lastPage)) {
                                    console.log('Última página alcançada, ocultando loader');
                                    loader.style.display = 'none';
                                } else if (document.documentElement.scrollHeight <= window.innerHeight) {
                                    // Se a página não tem barra de rolagem, carrega a próxima
                                    console.log('Página não possui scroll suficiente, carregando mais');
                                    setTimeout(checkScrollPosition, 500);
                                }
                            }, 500);
                        } else {
                            // Se não houver dados HTML na resposta, considera como última página
                            console.error('Dados inválidos recebidos do servidor ou fim das páginas');
                            isLoading = false;
                            loader.classList.remove('visible');
                            loader.style.display = 'none'; // Oculta o loader definitivamente
                        }
                    },
                    error: function(xhr, status, error) {
                        clearTimeout(loadingTimerId);
                        console.error('Erro ao carregar mais conteúdo:', error, xhr.responseText);
                        isLoading = false;
                        loader.classList.remove('visible');

                        // Em caso de erro, considera que alcançamos o limite
                        loader.style.display = 'none';
                    }
                });
            }

            // Observar o scroll do usuário com debounce para melhor performance
            let scrollTimer = null;
            window.addEventListener('scroll', function() {
                if (scrollTimer !== null) clearTimeout(scrollTimer);
                scrollTimer = setTimeout(checkScrollPosition, 100);
            });

            // Verificar scroll na inicialização para casos de tela grande
            setTimeout(() => {
                // Verifica novamente se estamos na última página antes de verificar o scroll
                if (currentPage >= lastPage) {
                    loader.style.display = 'none';
                } else {
                    checkScrollPosition();
                }
            }, 500);
        });
    </script>
</body>
</html>
<?php /**PATH /home/u446595196/domains/conectaplus.tv.br/public_html/resources/views/layouts/pages/content-more.blade.php ENDPATH**/ ?>