<!DOCTYPE html>
<html>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<head>
    <title><?php echo e($anime->name); ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="/public/css/web.css">
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <script src='https://ssl.p.jwpcdn.com/player/v/8.6.2/jwplayer.js'></script>
    <script>jwplayer.key = "64HPbvSQorQcd52B8XFuhMtEoitbvY/EXJmMBfKcXZQU2Rnn"</script>
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css" />

</head>

<?php
use Carbon\Carbon;
?>

<body>

<?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<section class="backdrop" style="background-image: linear-gradient(to right, rgb(0 0 0 / 80%), transparent), linear-gradient(to bottom, rgb(0 0 0 / 90%), transparent),linear-gradient(to top, rgb(0 0 0), transparent),
                url('<?php echo e($anime->backdrop_path_tv); ?>');
background-size: cover;
background-position: center center;">

    <div class="main">

        <div class="poster-m">
            <aside>
                <img src="<?php echo e($anime->poster_path); ?>" alt="<?php echo e($anime->name); ?>">
            </aside>

            <div>
                <div class="titulo">
                    <h1><?php echo e($anime->name); ?></h1>
                </div>

                <div class="genres">
                    <div class="imdb">
                        <p>
                            <i class="fas fa-star"></i> <?php echo e(number_format($anime->vote_average, 1)); ?>

                        </p>
                    </div>
                    <ul>
                        <?php $__currentLoopData = $anime->genres->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><strong><?php echo e($genre->name); ?></strong></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>

                </div>

                <div class="sinopse">
                    <p><?php echo e($anime->overview); ?></p>
                </div>

                <div class="informacoes">
                    <li>Ano: <strong><?php echo e(Carbon::createFromFormat('Y-m-d', $anime->first_air_date)->format('Y')); ?></strong></li>
                </div>

                <div class="episodes">
                    <li>Episódios: <strong><?php echo e($anime->seasons->flatMap->episodes->count()); ?></strong></li>

                </div>

                <div id="data-cast">
                    <span>Elenco:</span>
                    <ul>
                        <?php $__currentLoopData = $anime->casters->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $caster): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><strong><?php echo e($caster->name); ?></strong><?php if($index < 2): ?> , <?php endif; ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>

        <body>
        <div class="containers">
        <?php
            $hoje = \Carbon\Carbon::now();
        ?>

        <?php if(auth()->check() && auth()->user()->premuim == 1 && auth()->user()->expired_in > $hoje): ?>
                
            <div class="custom-select-wrapper">
                <div class="custom-select">
                    <div class="custom-select__trigger"><span>Temporada 1</span>
                        <div class="arrow"></div>
                    </div>
                    <div class="custom-options">
                        <?php $__currentLoopData = $anime->seasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="custom-option <?php echo e($loop->first ? 'selected' : ''); ?>" data-value="<?php echo e($season->season_number); ?>"><?php echo e($season->name); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

                <!-- Display the episodes of each season -->

                <div class="season-episodes">
                    <?php $__currentLoopData = $anime->seasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="ep <?php echo e($season->season_number != 1 ? 'hidden' : ''); ?>" id="season_<?php echo e($season->season_number); ?>">
                            <ul>
                                <?php $__currentLoopData = $season->episodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $episode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li id="season_<?php echo e($season->season_number); ?>" class="episodio">
                                        <?php if($episode->videos[0]->link): ?>
                                        <img src="<?php echo e($episode->still_path ?: asset('/public/episode')); ?>" onclick="openVideoModal('<?php echo e($episode->videos[0]->link); ?>', <?php echo e($episode->videos[0]->supported_hosts); ?>, '<?php echo e($episode->videos[0]->link); ?>')" alt="<?php echo e($episode->name); ?> Still">
                                            <div class="names">
                                                <div class="n-e-number">
                                                    <h4><?php echo e($episode->episode_number); ?> - <?php echo e($episode->name); ?></h4>
                                                </div>
                                                <p><?php echo e($episode->overview); ?></p>
                                            </div>
                                            <?php if(count($episode->videos) > 1): ?>
                                                <div id="videoOptions" style="display: none;">
                                                    <button class="btn btn-primary" onclick="openVideoModal('<?php echo e($episode->videos[1]->link); ?>')">Opção 2</button>
                                                </div>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <div class="unavailable-banner">
                                                O episódio não está disponível no momento.
                                            </div>
                                        <?php endif; ?>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="banner">
                    <div class="col-b" >
                        <div>
                            <p>Para assistir aos conteúdos você precisa ter uma assinatura ativa!</p>
                        </div>
                        <a href="<?php echo e(route('choose.plan')); ?>">
                            <button class="btn-premium">Assine agora</button>
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>

            <section class="related-series-slider">
                <div class="prev-next">
                    <h2>Séries Relacionadas</h2>
                    <div class="swiper-button-prev"></div>
                    <div class="swiper-button-next"></div>
                </div>
            <div class="swiper-container">
                <div class="swiper-wrapper">
                    <?php $__currentLoopData = $animesRelacionadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedSerie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('serie.detail', ['id' => $relatedSerie->id])); ?>">
                                <img src="<?php echo e($relatedSerie->poster_path); ?>" alt="<?php echo e($relatedSerie->name); ?>">
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    </div>
</section>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.9.0/slick/slick.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>

<script>
    function toggleCustomSelect() {
        const optionsContainer = document.querySelector('.custom-select .custom-options');
        
        // Alternar a classe 'show' para mostrar ou esconder o menu
        optionsContainer.classList.toggle('show');
    }

    document.addEventListener('DOMContentLoaded', function() {
    const customSelectWrapper = document.querySelector('.custom-select-wrapper');
    
    // Removido o 'onclick' do HTML, então adicione o event listener aqui
    customSelectWrapper.addEventListener('click', function(e) {
        // Verifique se o clique não é dentro das opções para evitar fechamento quando selecionar uma opção
        if (!e.target.matches('.custom-option')) {
            toggleCustomSelect();
        }
    });
    
    // Inicializa as opções customizadas do select
    document.querySelectorAll('.custom-option').forEach(option => {
    option.addEventListener('click', function(e) {
        if (!this.classList.contains('selected')) {
            // Remova a classe 'selected' da opção atualmente selecionada, se houver
            const currentSelected = this.parentNode.querySelector('.custom-option.selected');
            if (currentSelected) {
                currentSelected.classList.remove('selected');
            }

            // Adicione a classe 'selected' para a opção clicada
            this.classList.add('selected');

            // Atualize o texto do trigger para refletir a opção selecionada
            this.closest('.custom-select').querySelector('.custom-select__trigger span').textContent = this.textContent;

            // Chame a função para atualizar a temporada exibida
            showSeason(this.dataset.value);

            // Recolha o menu de opções após a seleção
            toggleCustomSelect();
        }
    });
});

    function showSeason(selectedSeasonNumber) {
        const seasons = document.querySelectorAll('.ep');
        seasons.forEach((season) => {
            if (season.id === `season_${selectedSeasonNumber}`) {
                season.classList.remove('hidden');
            } else {
                season.classList.add('hidden');
            }
        });
    }

    // Função para esconder o dropdown ao clicar fora
    window.addEventListener('click', function(e) {
        const select = document.querySelector('.custom-select');
        const optionsContainer = select.querySelector('.custom-options');
        const selectWrapper = select.closest('.custom-select-wrapper');
        
        // Se o clique foi fora do select e das opções
        if (!selectWrapper.contains(e.target)) {
            optionsContainer.classList.remove('show');
        }
    });

    // Execute a função para mostrar a temporada quando a página carregar
    showSeason(document.querySelector('.custom-option.selected').dataset.value);
    });

</script>

<script>
    function openVideoModal(videoLink, supportedHosts, episodeVideoLink) {
    const modalContent = document.createElement('div');
    const videoPlayerId = 'jwplayer-container';
    modalContent.innerHTML = `<div id="${videoPlayerId}"></div>`;

    $.fancybox.open({
        src: modalContent,
        type: 'html',
        touch: false,
        afterShow: function(instance, current) {
            if (supportedHosts !== 1) {
                jwplayer(videoPlayerId).setup({
                    file: videoLink,
                    image: '<?= $episode->still_path ?>',
                    width: "100%",
                    aspectratio: "16:9",
                    primary: "html5"
                    // Adicione mais opções de configuração aqui, se necessário
                });
            }

            const castButton = document.createElement('button');
            castButton.className = 'webvideocast';
            castButton.innerHTML = '<i class="fa-brands fa-chromecast"></i> Espelhar';
            castButton.onclick = function() {
                window.open('wvc-x-callback://open?url=' + encodeURIComponent(episodeVideoLink));
            };

            modalContent.appendChild(castButton);
        }
    });
}
</script>

<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>



<script>
document.addEventListener("DOMContentLoaded", function() {
    var mySwiper = new Swiper('.swiper-container', {
        
        freeMode: true,
        breakpoints: {
            // when window width is >= 320px
            320: {
            slidesPerView: 3,
            spaceBetween: 30
            },
            // when window width is >= 480px
            480: {
            slidesPerView: 3,
            spaceBetween: 30
            },

            800: {
            slidesPerView: 4,
            spaceBetween: 30
            },

            980: {
            slidesPerView: 5,
            spaceBetween: 30
            },

            1200: {
            slidesPerView: 6,
            spaceBetween: 30
            },

            1300: {
            slidesPerView: 7,
            spaceBetween: 30
            },
            // when window width is >= 640px
            1700: {
            slidesPerView: 10,
            spaceBetween: 40
            }
        },
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        
    });
});
</script>



    <div class="modal-backdrop" id="overlay"></div>
    <div class="modal fade" id="videoModal" tabindex="-1" role="dialog" aria-labelledby="videoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button aria-hidden="true" type="button" id="close-btn" style="display:none" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="modal-body">
                    <!-- Video player will be added here -->
                </div>
            </div>
        </div>
    </div>
    </div>
</body>

</html><?php /**PATH /home/ultraflix/public_html/ultraflix.pro/resources/views/anime.blade.php ENDPATH**/ ?>