<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Download SQL File</title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @keyframes pulse {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.5;
            }
        }
        .animate-pulse-slow {
            animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
        }
    </style>
</head>
<body class="min-h-screen text-gray-200 bg-gray-900">
    <div class="container max-w-4xl px-4 py-12 mx-auto">
        <div class="overflow-hidden bg-gray-800 shadow-2xl rounded-xl">
            <div class="p-8">
                <h1 class="mb-6 text-3xl font-bold text-emerald-400">Baixar SQL com dados de filmes, séries e animes</h1>

                <?php if(session('success')): ?>
                    <div class="px-4 py-3 mb-6 border rounded-lg text-emerald-100 border-emerald-500 bg-emerald-900/60">
                        <div class="flex items-center mb-2">
                            <svg class="w-5 h-5 mr-2 text-emerald-300" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            <?php echo e(session('success')); ?>

                        </div>
                    </div>

                    <form action="<?php echo e(route('download.sql')); ?>" method="GET" id="downloadForm" class="mb-6">
                        <input type="hidden" name="download_token" value="<?php echo e(session('download_token')); ?>">
                        <button
                            type="submit"
                            class="flex items-center justify-center w-full px-6 py-3 text-white transition-all duration-300 rounded-lg bg-emerald-600 hover:bg-emerald-700 md:w-auto"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
                            </svg>
                            Iniciar Download
                        </button>
                    </form>
                <?php else: ?>
                    <form id="validationForm" action="<?php echo e(route('download.sql')); ?>" method="GET" class="mb-6">
                        <div class="relative">
                            <input
                                type="password"
                                name="password"
                                placeholder="Digite a senha"
                                class="w-full px-4 py-3 text-white transition-all duration-300 bg-gray-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-emerald-500"
                                required
                            >
                        </div>
                        <button
                            type="submit"
                            class="flex items-center justify-center w-full px-6 py-3 mt-4 font-medium text-white transition-all duration-300 rounded-lg bg-emerald-600 hover:bg-emerald-700 md:w-auto"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                            </svg>
                            Validar Senha
                        </button>
                    </form>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="px-4 py-3 mb-6 text-red-100 border border-red-500 rounded-lg bg-red-900/60">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-center mb-2">
                                <svg class="w-5 h-5 mr-2 text-red-300" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                                </svg>
                                <?php echo e($error); ?>

                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>

                <div id="loadingText" class="hidden">
                    <div class="flex items-center px-4 py-3 text-blue-100 border border-blue-500 rounded-lg bg-blue-900/30 animate-pulse-slow">
                        <svg class="w-5 h-5 mr-3 text-blue-300 animate-spin" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        Aguarde um pouco, o arquivo está sendo gerado. Pode demorar alguns minutos. O download irá iniciar automaticamente...
                    </div>
                </div>
            </div>

            <div class="border-t border-gray-700 bg-gray-850">
                <div class="p-8">
                    <h3 class="mb-6 text-2xl font-bold text-emerald-400">Como importar o arquivo no seu banco de dados</h3>

                    <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
                        <div class="overflow-hidden transition-all duration-300 rounded-lg hover:shadow-emerald-500/20 hover:shadow-lg">
                            <img
                                src="https://i.imgur.com/xBI4NIV.png"
                                alt="Passo 1 para importação"
                                class="w-full transition-all duration-500 rounded-lg hover:scale-105"
                            >
                        </div>
                        <div class="overflow-hidden transition-all duration-300 rounded-lg hover:shadow-emerald-500/20 hover:shadow-lg">
                            <img
                                src="https://i.imgur.com/VluPwG6.png"
                                alt="Passo 2 para importação"
                                class="w-full transition-all duration-500 rounded-lg hover:scale-105"
                            >
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const validationForm = document.getElementById('validationForm');
            const downloadForm = document.getElementById('downloadForm');
            const loadingText = document.getElementById('loadingText');

            if (validationForm) {
                validationForm.addEventListener('submit', function() {
                    const submitButton = validationForm.querySelector('button[type="submit"]');
                    submitButton.disabled = true;
                    submitButton.classList.add('opacity-50', 'cursor-not-allowed');
                });
            }

            if (downloadForm) {
                downloadForm.addEventListener('submit', function() {
                    const downloadButton = downloadForm.querySelector('button[type="submit"]');
                    downloadButton.disabled = true;
                    downloadButton.classList.add('opacity-50', 'cursor-not-allowed');
                    loadingText.classList.remove('hidden');
                });
            }
        });
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/download_sql.blade.php ENDPATH**/ ?>