<?php $__env->startSection('styles'); ?>
<style>
    .card {
        background-color: white;
        border: 1px solid #e5e7eb;
        border-radius: 0.5rem;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
    }

    .card-header {
        background-color: #f9fafb;
        border-bottom: 1px solid #e5e7eb;
        padding: 1rem 1.5rem;
    }

    .badge-blue {
        background-color: rgba(59, 130, 246, 0.1);
        color: #3b82f6;
    }

    .badge-yellow {
        background-color: rgba(234, 179, 8, 0.1);
        color: #ca8a04;
    }

    .badge-green {
        background-color: rgba(16, 185, 129, 0.1);
        color: #059669;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container px-4 py-8 mx-auto">
    <div class="mb-8">
        <a href="<?php echo e(route('admin.support.index')); ?>" class="flex items-center text-primary hover:text-primary-dark">
            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 mr-1" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd" />
            </svg>
            Voltar para o painel de suporte
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="px-4 py-3 mb-6 text-green-700 bg-green-100 border border-green-200 rounded">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="px-4 py-3 mb-6 text-red-700 bg-red-100 border border-red-200 rounded">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 gap-6 md:grid-cols-3">
        <!-- Informações do Ticket -->
        <div class="md:col-span-2">
            <div class="overflow-hidden card">
                <div class="flex items-center justify-between card-header">
                    <h1 class="text-xl font-bold text-gray-800">#<?php echo e($ticket->id); ?> - <?php echo e($ticket->subject); ?></h1>
                    <div>
                        <?php if($ticket->status == 'aberto'): ?>
                            <span class="px-3 py-1 text-xs font-medium rounded-full badge-blue">Aberto</span>
                        <?php elseif($ticket->status == 'em_andamento'): ?>
                            <span class="px-3 py-1 text-xs font-medium rounded-full badge-yellow">Em andamento</span>
                        <?php elseif($ticket->status == 'resolvido'): ?>
                            <span class="px-3 py-1 text-xs font-medium rounded-full badge-green">Resolvido</span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="p-6">
                    <!-- Detalhes do ticket -->
                    <div class="mb-6">
                        <div class="flex justify-between mb-2 text-sm text-gray-600">
                            <div>
                                <span>Enviado por: <strong class="text-gray-800"><?php echo e($ticket->user->name); ?></strong></span>
                                <span class="mx-2">•</span>
                                <span><?php echo e($ticket->created_at->format('d/m/Y H:i')); ?></span>
                            </div>
                            <div>
                                <?php
                                    $categories = App\Models\SupportTicket::getCategories();
                                ?>
                                <span>Categoria: <?php echo e($categories[$ticket->category] ?? $ticket->category); ?></span>
                            </div>
                        </div>

                        <div class="p-4 border rounded-lg bg-gray-50 border-gray-200">
                            <p class="text-gray-800 whitespace-pre-line"><?php echo e($ticket->message); ?></p>
                        </div>
                    </div>

                    <!-- Resposta anterior, se existir -->
                    <?php if($ticket->admin_response): ?>
                        <div class="p-4 mt-8 mb-6 border border-primary/10 rounded-lg bg-primary/5">
                            <h3 class="mb-2 text-lg font-semibold text-gray-800">Resposta do Suporte</h3>
                            <div class="flex justify-between mb-2 text-sm text-gray-600">
                                <div>
                                    <span>Respondido por: <?php echo e($ticket->admin->name ?? 'Administrador'); ?></span>
                                    <span class="mx-2">•</span>
                                    <span><?php echo e($ticket->updated_at->format('d/m/Y H:i')); ?></span>
                                </div>
                            </div>

                            <div class="p-4 border rounded-lg bg-white border-gray-200">
                                <p class="text-gray-800 whitespace-pre-line"><?php echo e($ticket->admin_response); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Formulário de resposta -->
                    <div class="p-6 mt-8 border border-gray-200 rounded-lg bg-gray-50">
                        <h3 class="mb-4 text-lg font-semibold text-gray-800">Atualizar Ticket</h3>

                        <form action="<?php echo e(route('admin.support.update', $ticket->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <div class="mb-4">
                                <label for="status" class="block mb-2 text-gray-700">Status</label>
                                <select id="status" name="status"
                                        class="w-full px-4 py-2 border rounded-lg border-gray-300 focus:outline-none focus:ring-2 focus:ring-primary focus:border-primary">
                                    <option value="aberto" <?php echo e($ticket->status == 'aberto' ? 'selected' : ''); ?>>Aberto</option>
                                    <option value="em_andamento" <?php echo e($ticket->status == 'em_andamento' ? 'selected' : ''); ?>>Em Andamento</option>
                                    <option value="resolvido" <?php echo e($ticket->status == 'resolvido' ? 'selected' : ''); ?>>Resolvido</option>
                                </select>
                            </div>

                            <div class="mb-4">
                                <div class="flex items-center justify-between mb-2">
                                    <label for="admin_response" class="text-gray-700">Resposta</label>

                                    <!-- Botão para respostas rápidas adaptado para o tema claro -->
                                    <button type="button" data-open-modal
                                            class="flex items-center px-3 py-1 text-xs text-white transition-colors bg-primary rounded hover:bg-primary-dark">
                                        <i class="mr-1 mdi mdi-lightning-bolt"></i>
                                        Respostas Rápidas
                                    </button>
                                </div>
                                <textarea id="admin_response" name="admin_response" rows="6"
                                          class="w-full px-4 py-2 text-gray-800 border rounded-lg border-gray-300 focus:outline-none focus:ring-2 focus:ring-primary focus:border-primary"><?php echo e($ticket->admin_response); ?></textarea>
                                <p class="mt-1 text-sm text-gray-500">
                                    Uma resposta é obrigatória ao marcar o ticket como resolvido.
                                </p>
                            </div>

                            <div class="flex justify-end">
                                <button type="submit"
                                        class="px-6 py-2 text-white transition duration-300 rounded-md bg-primary hover:bg-primary-dark">
                                    Atualizar Ticket
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar com Informações do Usuário -->
        <div>
            <div class="overflow-hidden card">
                <div class="card-header">
                    <h2 class="text-lg font-semibold text-gray-800">Informações do Usuário</h2>
                </div>

                <div class="p-6">
                    <div class="flex flex-col mb-6 text-center">
                        <div class="w-20 h-20 mx-auto mb-3 overflow-hidden bg-gray-100 rounded-full">
                            <img src="https://ui-avatars.com/api/?name=<?php echo e(urlencode($ticket->user->name)); ?>&color=7F9CF5&background=EBF4FF"
                                 alt="<?php echo e($ticket->user->name); ?>" class="object-cover w-full h-full">
                        </div>
                        <h3 class="mb-1 text-lg font-medium text-gray-800"><?php echo e($ticket->user->name); ?></h3>
                        <p class="text-sm text-gray-600"><?php echo e($ticket->user->email); ?></p>
                    </div>

                    <div class="mb-4">
                        <div class="mb-2 text-sm font-semibold text-gray-600">ID do Usuário</div>
                        <div class="p-2 text-sm bg-gray-50 rounded-md border border-gray-200"><?php echo e($ticket->user->id); ?></div>
                    </div>

                    <div class="mb-4">
                        <div class="mb-2 text-sm font-semibold text-gray-600">Data de Registro</div>
                        <div class="p-2 text-sm bg-gray-50 rounded-md border border-gray-200"><?php echo e($ticket->user->created_at->format('d/m/Y')); ?></div>
                    </div>

                    <div class="mb-4">
                        <div class="mb-2 text-sm font-semibold text-gray-600">Status da Assinatura</div>
                        <div class="p-2 text-sm bg-gray-50 rounded-md border border-gray-200">
                            <?php if($ticket->user->premuim == 1): ?>
                                <span class="text-green-400">Ativo</span>
                            <?php else: ?>
                                <span class="text-red-400">Inativo</span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div>
                        <div class="mb-2 text-sm font-semibold text-gray-600">Outros Tickets</div>
                        <div class="p-2 bg-gray-50 rounded-md border border-gray-200">
                            <?php
                                $otherTickets = App\Models\SupportTicket::where('user_id', $ticket->user_id)
                                                ->where('id', '!=', $ticket->id)
                                                ->latest()
                                                ->take(5)
                                                ->get();
                            ?>

                            <?php if($otherTickets->count() > 0): ?>
                                <ul class="space-y-1 text-sm">
                                    <?php $__currentLoopData = $otherTickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherTicket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('admin.support.show', $otherTicket->id)); ?>" class="text-primary hover:underline">
                                                #<?php echo e($otherTicket->id); ?> - <?php echo e(\Illuminate\Support\Str::limit($otherTicket->subject, 20)); ?>

                                                <span class="text-xs text-gray-500">(<?php echo e($otherTicket->status); ?>)</span>
                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php else: ?>
                                <p class="text-sm text-gray-400">Nenhum outro ticket encontrado.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Ações rápidas -->
            <div class="p-4 mt-4 overflow-hidden shadow-lg bg-zinc-900/50 rounded-xl">
                <div class="flex flex-col gap-2">
                    <a href="<?php echo e(route('admin.support.index')); ?>" class="w-full px-4 py-2 text-center text-white rounded-md bg-zinc-800 hover:bg-zinc-700">
                        Voltar para lista de tickets
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<!-- Incluir o modal de respostas rápidas -->
<?php echo $__env->make('admin.support._quick_responses', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Adicionar scripts personalizados -->
<?php $__env->startSection('scripts'); ?>
<script>
    // Verificar se o usuário está tentando resolver um ticket sem resposta
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.querySelector('form');
        const statusSelect = document.getElementById('status');
        const responseTextarea = document.getElementById('admin_response');

        if (form && statusSelect && responseTextarea) {
            form.addEventListener('submit', function(event) {
                if (statusSelect.value === 'resolvido' && responseTextarea.value.trim() === '') {
                    event.preventDefault();
                    alert('Uma resposta é obrigatória ao marcar o ticket como resolvido.');
                    responseTextarea.focus();
                }
            });
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/admin/support/show.blade.php ENDPATH**/ ?>