<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Download SQL File</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: black;
            color: white;
        }
        .btn-primary {
            background-color: green;
        }
        .form-control {
            margin-top: 20px;
            width: auto;
        }

        .tuto {
            display: flex;
            align-items: flex-start;
            width: 100%;
            flex-direction: column;
            gap: 15px;
            justify-content: center;
            padding: 20px 0 20px 0;
        }

        .tuto img {
            width: 100%;
            border-radius: 10px;
        }

    </style>
</head>
<body>
    <section class="conteiner">
        <div class="container mt-5">
            <h1>Baixar SQL com dados de filmes séries e animes</h1>
            <form id="downloadForm" action="<?php echo e(route('download.sql')); ?>" method="GET">
                <input type="password" name="password" placeholder="Digite a senha" class="form-control" required>
                <button type="submit" class="btn btn-primary mt-3">Baixar</button>
            </form>
            <?php if($errors->any()): ?>
                <div class="alert alert-danger mt-3">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div><?php echo e($error); ?></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
            <div id="loadingText" class="mt-3" style="display:none;">Aguarde um pouco o arquivo está sendo gerado, pode demorar uns minutos. O Download irá iniciar automaticamente...</div>

            <div class="tuto">
                <h3>Como importar o arquivo no seu banco de dados</h3>
                <img src="https://i.imgur.com/xBI4NIV.png" alt="">
                <img src="https://i.imgur.com/VluPwG6.png" alt="">
            </div>
        </div>
    </section>

    <!-- Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.getElementById('downloadForm').addEventListener('submit', function(event) {
            const downloadButton = document.querySelector('button[type="submit"]');
            downloadButton.classList.add('disabled');
            downloadButton.disabled = true;
            document.getElementById('loadingText').style.display = 'block';
        });
    </script>
</body>
</html>
<?php /**PATH /www/wwwroot/ultraflix.pro/resources/views/download_sql.blade.php ENDPATH**/ ?>