<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" href="/api/image/minilogo" type="image/x-icon">
    <title>Cadastrar</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="/css/web.css">
</head>
<body class="body-fav">
    
<section class="conteiner-login">
    <div class="login-container">
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

            <!-- Mostrar mensagem de sucesso se estiver definida -->
        <?php if(session('status')): ?>
            <div class="alert alert-success">
                <?php echo e(session('status')); ?>

            </div>
        <?php endif; ?>
        <div class="logo-login" >
            <img src="/api/image/minilogo" alt="logo" >
        </div>
        <h2>Cadastrar</h2>
        <form action="<?php echo e(route('register')); ?>" method="post">
            <?php echo csrf_field(); ?>

            <div>
                <input placeholder="Nome" class="input-profile" type="text" name="name" id="name" required>
            </div>
            <br>
            <div>
                <input placeholder="Endereço de Email" class="input-profile" type="email" name="email" id="email" required>
            </div>
            <br>
            <div class="password-wrapper">
                <input placeholder="Senha" class="password-input" type="password" name="password" id="password" required>
                <i class="fas fa-eye password-toggle" onclick="togglePassword('password')"></i>
            </div>
            <br>
            <div class="password-wrapper">
                <input placeholder="Confirmar Senha" class="password-input" type="password" name="password_confirmation" id="password_confirmation" required>
                <i class="fas fa-eye password-toggle" onclick="togglePassword('password_confirmation')"></i>
            </div>
            <br>
            <div>
                <button class="btn-login" type="submit">Registrar</button>
            </div>
        </form>

        <p>Já tem uma conta? <a class="entrar" href="<?php echo e(route('login')); ?>">Faça login</a></p>
    </div>
</section>

<script>
    function togglePassword(inputId) {
        const passwordInput = document.getElementById(inputId);
        const passwordIcon = passwordInput.nextElementSibling;

        if (passwordInput.type === "password") {
            passwordInput.type = "text";
            passwordIcon.classList.remove('fa-eye');
            passwordIcon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = "password";
            passwordIcon.classList.remove('fa-eye-slash');
            passwordIcon.classList.add('fa-eye');
        }
    }
</script>

</body>
</html>
<?php /**PATH /www/wwwroot/ultraflix.pro/resources/views/auth/register.blade.php ENDPATH**/ ?>