<?php if($searchResults->isEmpty()): ?>
    <div class="py-8 text-center">
        <h3 class="text-xl text-zinc-400">Nenhum resultado encontrado.</h3>
    </div>
<?php else: ?>
    <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6 animate-fade-in">
        <?php $__currentLoopData = $searchResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(match($result->type) {
                'serie' => route('serie.detail', ['id' => $result->id]),
                'anime' => route('anime.detail', ['id' => $result->id]),
                default => route('filme.detail', ['id' => $result->id])
            }); ?>" class="block group">
                <div class="relative overflow-hidden rounded-lg image-wrapper">
                    <img src="<?php echo e($result->poster_path); ?>"
                         alt="<?php echo e($result->name); ?>"
                         class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105"
                         loading="lazy">
                    <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                </div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/realtime_search_results.blade.php ENDPATH**/ ?>