
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/css/web.css">
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <title><?php echo e($settings->app_name); ?> - Assista Filmes Séries e Animes</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Bungee+Spice&family=Poppins:wght@500;600;700&family=Roboto:wght@400;500;900&family=Work+Sans:wght@900&display=swap" rel="stylesheet">
</head>
<body>
    <?php if(auth()->check()): ?>
        <script>window.location.href = '/inicio';</script>
    <?php endif; ?>
    <header class="landing-header">
        <div class="landing-logo">
            <img src="/public/api/image/minilogo"alt="Logo">
        </div>
        <div class="landing-buttons">
            <button class="l-entrar" onclick="location.href='/login'">Entrar</button>
            <button class="l-cadastrar" onclick="location.href='/register'">Criar Conta</button>
        </div>
    </header>

    <div class="hero">
        <div class="fundo">
            <img src="https://assets.nflxext.com/ffe/siteui/vlv3/77d35039-751f-4c3e-9c8d-1240c1ca6188/9c050122-05ae-4838-89ad-f8acbf3d0d77/BR-pt-20231106-popsignuptwoweeks-perspective_alpha_website_large.jpg" alt="">
        </div>
        <div class="hero-int">
            <h3>Milhares de Filmes e Séries para você curtir com a família, sem travamentos, sem preços altos.</h3>
                <div class="cadastre-landing">
                <h4><i class="fa-solid fa-circle-check"></i> Crie sua conta, ative sua assinatura e aproveite.</h4>
                    <button class="btn-landing" onclick="location.href='/register'">Criar Conta</button>
                </div>
        </div>
    </div>

    <div class="landing-plan">
        <div class="lottie-container">
            <!-- Aqui vai a animação Lottie -->
        </div>
        <div class="text-container">
            <h2>Comece com o Básico</h2>
            <p>Plano de 15 Dias por R$6,00.</p>
            <!-- Adicione mais conteúdo de texto conforme necessário -->
        </div>
    </div>

    <div class="container-landing">
        <h2>Filmes Populares</h2>
        <div class="movies-landing">
            <?php $__currentLoopData = $topMovies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="poster-movie">
                    <img src="<?php echo e($movie->poster_path); ?>" alt="<?php echo e($movie->title); ?>">
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <h2>Séries Populares</h2>
        <div class="series-landing">
            <?php $__currentLoopData = $topSeries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="poster-serie">
                    <img src="<?php echo e($serie->poster_path); ?>" alt="<?php echo e($serie->name); ?>">
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="plataformas">
            <h3>As Principais Plataformas de Streaming Reunidas dentro de uma só.</h3>
            <ul>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/primevideo-logo.png" alt=""></li>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/hulu-logo.png" alt=""></li>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/netflix-logo.png" alt=""></li>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/hbomax-logo.png" alt=""></li>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/appletv-logo.png" alt=""></li>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/discoveryplus-logo.png" alt=""></li>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/disneyplus-logo.png" alt=""></li>
                <li><img src="https://v.baixarfree.com/file/utxgmpx/starplus-logo.png" alt=""></li>
            </ul>
        </div>
        <div class="info-landing">
            <div class="container-conteudo">
                <div class="itens-content">
                    <p><i class="fa fa-film"></i>Total de Filmes: <?php echo e($totalMovies); ?></p>
                    <p><i class="fa fa-tv"></i>Total de Séries: <?php echo e($totalSeries); ?></p>
                    <p><i class="fa fa-play-circle"></i>Total de Episódios: <?php echo e($totalEpisodes); ?></p>
                    <p><i class="fa fa-ghost"></i>Total de Animes: <?php echo e($totalAnimes); ?></p>
                    <p><i class="fa fa-layer-group"></i>Total de Episódios de Animes: <?php echo e($totalAnimeEpisodes); ?></p>
                </div>
                <div class="img-content">
                    <img src="https://i.imgur.com/vz3en64.png" alt="">
                </div>
            </div>

            <div class="playstore">
                <a href="<?php echo e($settings->app_url_android); ?>">
                    <img src="https://play.google.com/intl/pt-BR/badges/static/images/badges/pt-br_badge_web_generic.png" alt="">
                </a>
            </div>

            <div class="faq-container">
                <h3 class="faq-title">Perguntas Frequentes</h3>
                <div class="faq-item">
                    <div class="faq-question">O que é o Ultraflix?</div>
                    <div class="faq-answer">O Ultraflix é um serviço de streaming que oferece uma ampla variedade de séries, filmes e documentários premiados em milhares de aparelhos conectados à internet. Você pode assistir a quantos filmes e séries quiser, quando e onde quiser – tudo por um preço mensal acessível. Aqui você sempre encontra novidades. A cada semana, adicionamos novas séries e filmes.</div>
                </div>
                <div class="faq-item">
                    <div class="faq-question">Quanto Custa?</div>
                    <div class="faq-answer">Assista ao Ultraflix no seu celular, tablet, Smart TV, notebook ou aparelho de streaming por uma taxa mensal única. Os planos variam de R$6 a R$10 por mês. Sem contrato nem taxas extras.</div>
                </div>
                <div class="faq-item">
                    <div class="faq-question">Quais as formas de pagamento?</div>
                    <div class="faq-answer">Você pode ativar sua assinatura usando cartão de Crédito, Débito e Pix através do Mercado Pago.</div>
                </div>
                <div class="faq-item">
                    <div class="faq-question">Tem algum limite?</div>
                    <div class="faq-answer">Você pode logar em até 2 dispositivos diferentes e criar até 5 perfis diferentes.</div>
                </div>
            </div>
        </div>
    </div>
<script>
    document.querySelectorAll('.faq-question').forEach(item => {
        item.addEventListener('click', () => {
            const answer = item.nextElementSibling;
            answer.style.display = answer.style.display === 'block' ? 'none' : 'block';
        });
    });
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/lottie-web/5.7.4/lottie.min.js"></script>

<script>
    var animation = bodymovin.loadAnimation({
        container: document.querySelector('.lottie-container'), // Seleciona o container Lottie
        path: 'https://lottie.host/566221ba-1f82-490f-bf9c-442f8e739c82/gyKr3Dv4C7.json', // Caminho para o arquivo JSON da animação
        renderer: 'svg',
        loop: true,
        autoplay: true
    });
</script>


<footer class="footer-landing">
    <div class="items-footer-landing">
        <p><?php echo e($settings->app_name); ?> 2023 &copy; - Todos os direitos reservados</p>
    </div>
</footer>
</body>
</html>
<?php /**PATH /home/ultraflix/public_html/site.ultraflix.net/resources/views/landing.blade.php ENDPATH**/ ?>