<!DOCTYPE html>
<html>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<head>
    <title>TV Ao Vivo</title>
    <link rel="stylesheet" href="/public/css/web.css">
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
</head>
<body class="body-fav">

    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="search-container">
        <input type="text" placeholder="Buscar canal..." name="search" id="search-input">
    </div>
    <div id="content">
        <!-- Todos os canais são listados aqui inicialmente e serão substituídos pelos resultados da busca -->
    </div>


    <div class="container-series">
        <div class="tv-list">
            <?php $__currentLoopData = $livetv; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="tv">
                    <a href="<?php echo e(route('livetv.show', $movie->id)); ?>">
                        <figure>
                            <img src="<?php echo e($movie->poster_path); ?>" alt="<?php echo e($movie->title); ?>">
                        </figure>
                    </a>
                    <h3><?php echo e($movie->name); ?></h3>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <div style="padding: 50px" class="espaco"></div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    var searchInput = document.getElementById('search-input');
    searchInput.addEventListener('keyup', function() {
        var searchTerm = this.value.toLowerCase();
        var channels = document.querySelectorAll('.tv'); // Assume que todos os canais já estão no DOM

        channels.forEach(function(channel) {
            var name = channel.querySelector('h3').textContent.toLowerCase();
            if (name.includes(searchTerm)) {
                channel.style.display = ''; // Mostra o canal se corresponder
            } else {
                channel.style.display = 'none'; // Oculta o canal se não corresponder
            }
        });
    });
});
</script>


<script>
  document.addEventListener('DOMContentLoaded', function () {
  var dropdown = document.querySelector('.dropdown');
  var selected = dropdown.querySelector('.dropdown-selected');
  var options = dropdown.querySelector('.dropdown-options');
  var select = dropdown.querySelector('select');
  
  // Atualizar o texto selecionado com base na opção selecionada no <select>
  function updateSelectedText() {
    var selectedOption = select.options[select.selectedIndex];
    if (selectedOption) {
      selected.textContent = selectedOption.text;
    }
  }

  // Inicializar o texto selecionado quando a página carregar
  updateSelectedText();
  
  selected.addEventListener('click', function (e) {
    options.style.display = options.style.display === 'block' ? 'none' : 'block';
    e.stopPropagation();
  });

  options.addEventListener('click', function (e) {
    if (e.target.classList.contains('dropdown-option')) {
      selected.textContent = e.target.textContent;
      select.value = e.target.getAttribute('data-value');
      options.style.display = 'none';
      updateSelectedText(); // Atualizar novamente para garantir consistência
      dropdown.closest('form').submit(); // Enviar o formulário ao selecionar um item
    }
  });

  document.addEventListener('click', function (e) {
    if (!dropdown.contains(e.target)) {
      options.style.display = 'none';
    }
  });
});
</script>
</body>
</html>
<?php /**PATH /home/ultraflix/public_html/ultraflix.pro/resources/views/layouts/pages/canais.blade.php ENDPATH**/ ?>