<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="user-id" content="<?php echo e(auth()->user()->id); ?>">
    <meta name="base-url" content="<?php echo e(url('/')); ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Adicione metadados para identificação da série -->
    <meta name="anime-id" content="<?php echo e($anime->id); ?>">
    <meta name="anime-type" content="anime">
    <title><?php echo e($anime->name); ?> - <?php echo e($settings->app_name); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <script src='https://ssl.p.jwpcdn.com/player/v/8.6.2/jwplayer.js'></script>
    <script>jwplayer.key = "64HPbvSQorQcd52B8XFuhMtEoitbvY/EXJmMBfKcXZQU2Rnn";</script>

    <!-- Incluir definições de rotas globais -->
    <?php echo $__env->make('layouts._partials.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <style>
        /* Estilos específicos para o JW Player */
        .jwplayer-container {
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.5);
            border-radius: 8px 8px 0 0;
            overflow: hidden;
        }

        .jw-progress {
            background-color: #2BF14A !important;
        }

        .jw-knob {
            background-color: #2BF14A !important;
        }

        .jw-button-color:hover:not(.jw-toggle) {
            color: #2BF14A !important;
        }

        .player-loading-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.7);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 10;
        }

        .player-controls-bar {
            background-color: #111;
            padding: 12px 15px;
            border-radius: 0 0 8px 8px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .player-notification {
            position: absolute;
            bottom: 80px;
            left: 20px;
            background-color: rgba(0, 0, 0, 0.7);
            color: white;
            padding: 10px 15px;
            border-radius: 4px;
            z-index: 10;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .player-header {
            background-color: #111;
            padding: 10px 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
            border-radius: 8px 8px 0 0;
        }

        .nav-button {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 16px;
            background-color: #292929;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        .nav-button:hover {
            background-color: #3a3a3a;
        }

        .nav-button:disabled {
            opacity: 0.5;
            cursor: not-allowed;
            background-color: #1e1e1e;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        .spinner {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            border: 4px solid rgba(255,255,255,0.1);
            border-top-color: #2BF14A;
            animation: spin 1s linear infinite;
        }

        /* Estilo melhorado para o modal do player */
        .player-modal {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.9);
            z-index: 9999;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .player-modal-content {
            width: 90%;
            max-width: 1200px;
            background-color: #0f0f0f;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.9);
            animation: player-fade-in 0.3s ease-out;
        }

        @keyframes player-fade-in {
            from { opacity: 0; transform: scale(0.98); }
            to { opacity: 1; transform: scale(1); }
        }

        .player-modal-close {
            position: absolute;
            top: 15px;
            right: 15px;
            width: 35px;
            height: 35px;
            background-color: rgba(0, 0, 0, 0.6);
            border-radius: 50%;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            font-size: 18px;
            z-index: 10;
            transition: background-color 0.2s;
        }

        .player-modal-close:hover {
            background-color: rgba(255, 0, 0, 0.7);
        }

        /* Estilos para ocultar a barra de rolagem */
        .scrollbar-hide {
            -ms-overflow-style: none;  /* IE e Edge */
            scrollbar-width: none;     /* Firefox */
            overflow-y: auto;
            overflow-x: auto;
        }

        /* Oculta a barra de rolagem para Chrome, Safari e Opera */
        .scrollbar-hide::-webkit-scrollbar {
            display: none;
        }

        /* Estilo específico para elementos com scroll horizontal */
        .horizontal-scroll {
            overflow-x: auto;
            white-space: nowrap;
            -webkit-overflow-scrolling: touch; /* Rolagem suave em dispositivos iOS */
            scroll-behavior: smooth; /* Rolagem suave em navegadores modernos */
        }

        .image-wrapper {
            position: relative;
            overflow: hidden;
            border-radius: 0.5rem;
            border: 2px solid transparent;
            transition: border-color 0.3s ease, transform 0.3s ease;
        }

        .image-wrapper:hover {
            border-color: white;
            transform: scale(1.05);
        }
    </style>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
    <script>
        // Define a URL base para scripts JavaScript
        window.appUrl = "<?php echo e(url('/')); ?>";

        // Armazenamos dados da série globalmente para acesso fácil pelos scripts
        window.appData = {
            currentAnime: {
                id: <?php echo e($anime->id); ?>,
                type: "anime",
                name: "<?php echo e($anime->name); ?>"
            }
        };
    </script>
</head>
<body class="min-h-screen mb-10 text-white bg-black font-poppins">
    <?php
        use Carbon\Carbon;
        $hoje = Carbon::now();
    ?>

    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Hero Section com Backdrop -->
    <div class="relative min-h-screen">
        <!-- Backdrop Image with Gradient -->
        <div class="fixed top-0 right-0 z-0 w-full bg-center bg-cover h-2/4 md:w-2/4 md:h-2/4"
            style="background-image: url('<?php echo e($anime->backdrop_path); ?>');">
            <!-- Gradient from left to right (less intense on mobile) -->
            <div class="absolute inset-0 bg-gradient-to-r from-black via-black/70 md:via-transparent to-transparent"></div>
            <!-- Gradient from bottom to top -->
            <div class="absolute inset-0 bg-gradient-to-b from-transparent to-black"></div>
        </div>

        <!-- Content -->
        <div class="container relative z-10 px-4 pt-24 pb-12 mx-auto">
            <div class="grid grid-cols-1 gap-8 lg:grid-cols-12">
                <!-- Poster Column -->
                <div class="lg:col-span-4 xl:col-span-3">
                    <div class="flex flex-col items-center">
                        <div class="max-w-sm overflow-hidden rounded-lg shadow-xl w-44 sm:w-72 lg:w-full">
                            <img src="<?php echo e($anime->poster_path); ?>"
                                 alt="<?php echo e($anime->name); ?>"
                                 class="w-full h-auto">
                        </div>

                        <!-- Action Buttons -->
                        <div class="flex items-center justify-center gap-4 mt-6 text-sm lg:text-md">
                            <button id="fav-btn"
                                    class="flex items-center justify-center w-10 h-10 transition-colors rounded-full bg-zinc-800/50 backdrop-blur-sm/50 backdrop-blur-sm hover:bg-zinc-700">
                                <i id="fav-icon" class="far fa-heart"></i>
                            </button>
                            <?php if($anime->preview_path): ?>
                                <button onclick="openTrailerPopup('<?php echo e($anime->preview_path); ?>')"
                                        class="flex items-center gap-2 px-4 py-3 transition-colors rounded-full bg-zinc-800/50 backdrop-blur-sm/50 backdrop-blur-sm hover:bg-zinc-700">
                                    <i class="fab fa-youtube"></i> Trailer
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Info Column -->
                <div class="lg:col-span-8 xl:col-span-9">
                    <h1 class="mb-4 text-2xl font-bold lg:text-4xl"><?php echo e($anime->name); ?></h1>

                    <!-- Rating and Genres -->
                    <div class="flex flex-wrap items-center gap-4 mb-6 text-sm lg:text-lg">
                    <div class="flex items-center gap-2 px-3 py-1 rounded-full bg-zinc-800/50 backdrop-blur-sm">
                            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/69/IMDB_Logo_2016.svg/320px-IMDB_Logo_2016.svg.png" alt="IMDb" class="h-4">
                            <span><?php echo e(number_format($anime->vote_average, 1)); ?></span>
                        </div>
                        <?php $__currentLoopData = $anime->genres->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="px-3 py-1 rounded-full bg-zinc-800/50 backdrop-blur-sm"><?php echo e($genre->name); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Overview with See More/Less functionality -->
                    <div class="mb-6 text-xs lg:text-lg">
                        <p id="short-overview" class="text-gray-300"><?php echo e(\Illuminate\Support\Str::limit($anime->overview, 150)); ?></p>
                        <p id="full-overview" class="hidden text-gray-300"><?php echo e($anime->overview); ?></p>

                        <?php if(strlen($anime->overview) > 150): ?>
                        <button id="toggle-overview" class="mt-2 text-xs font-medium text-primary hover:text-primary-dark">
                            Ver mais
                        </button>
                        <script>
                            document.getElementById('toggle-overview').addEventListener('click', function() {
                                const shortOverview = document.getElementById('short-overview');
                                const fullOverview = document.getElementById('full-overview');
                                const toggleBtn = document.getElementById('toggle-overview');

                                if (shortOverview.classList.contains('hidden')) {
                                    shortOverview.classList.remove('hidden');
                                    fullOverview.classList.add('hidden');
                                    toggleBtn.textContent = 'Ver mais';
                                } else {
                                    shortOverview.classList.add('hidden');
                                    fullOverview.classList.remove('hidden');
                                    toggleBtn.textContent = 'Ver menos';
                                }
                            });
                        </script>
                        <?php endif; ?>
                    </div>

                    <!-- Additional Info -->
                    <div class="flex flex-wrap items-center gap-4 mb-6 text-xs lg:text-lg">
                        <!-- Year -->
                        <div class="flex items-center gap-1 px-4 py-2 rounded-full bg-zinc-800/50 backdrop-blur-sm">
                            <i class="text-gray-400 fas fa-calendar"></i>
                            <span><?php echo e(Carbon::createFromFormat('Y-m-d', $anime->first_air_date)->format('Y')); ?></span>
                        </div>

                        <!-- Episodes -->
                        <div class="flex items-center gap-1 px-4 py-2 rounded-full bg-zinc-800/50 backdrop-blur-sm">
                            <i class="text-gray-400 fas fa-film"></i>
                            <span><?php echo e($anime->seasons->flatMap->episodes->count()); ?> Episódios</span>
                        </div>
                    </div>

                    <!-- Cast -->
                    <div class="mb-8">
                        <h3 class="mb-4 text-lg font-semibold">Elenco</h3>
                        <div class="flex gap-4 pb-4 overflow-x-auto scrollbar-hide">
                            <?php $__currentLoopData = $anime->casters->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $caster): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex-shrink-0 w-16 p-2 lg:w-24">
                                    <img src="<?php echo e($caster->profile_path ?: 'https://cdn-icons-png.flaticon.com/512/1177/1177568.png'); ?>"
                                         alt="<?php echo e($caster->name); ?>"
                                         class="object-cover w-full mb-2 rounded-full image-wrapper aspect-square">
                                    <p class="text-xs text-center"><?php echo e($caster->name); ?></p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>

            
                <div class="mt-4 lg:mt-12">
                    <!-- Season Selector - Versão Horizontal -->
                    <div class="mb-4 lg:mb-6">
                        <div class="flex items-center justify-between mb-3">
                            <h3 class="text-base font-semibold lg:text-2xl">Temporadas</h3>
                            <div class="flex items-center space-x-2">
                                <!-- Botões de scroll movidos para ao lado do texto -->
                                <button id="scroll-left-btn" class="p-2 rounded-full shadow-lg bg-zinc-800/70 hover:bg-zinc-700/90">
                                    <i class="fas fa-chevron-left text-primary"></i>
                                </button>
                                <button id="scroll-right-btn" class="p-2 rounded-full shadow-lg bg-zinc-800/70 hover:bg-zinc-700/90">
                                    <i class="fas fa-chevron-right text-primary"></i>
                                </button>
                            </div>
                        </div>

                        <div class="relative">
                            <div class="flex items-center pb-2 space-x-2 overflow-x-auto scrollbar-hide seasons-scroller" id="seasons-scroller">
                                <?php $__currentLoopData = $anime->seasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <button
                                        class="season-tab whitespace-nowrap px-3 py-1.5 lg:px-4 lg:py-2 rounded-full transition-colors text-sm lg:text-base font-medium
                                               <?php echo e($loop->first ? 'bg-primary text-black' : 'bg-zinc-800/50 backdrop-blur-sm hover:bg-zinc-700 text-white'); ?>"
                                        data-season="<?php echo e($season->season_number); ?>">
                                        <?php echo e($season->name); ?>

                                    </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>

                    <!-- Episodes Grid -->
                    <div class="space-y-6 lg:space-y-8">
                        <?php $__currentLoopData = $anime->seasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="season-content <?php echo e($season->season_number != 1 ? 'hidden' : ''); ?>" id="season_<?php echo e($season->season_number); ?>">
                                <div class="overflow-x-auto episodes-slider scrollbar-hide"
                                     data-season="<?php echo e($season->season_number); ?>">
                                    <div class="flex gap-3 p-4 lg:gap-6 episodes-wrapper" style="user-select: none;">
                                        <?php $__currentLoopData = $season->episodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $episode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div id="episode_<?php echo e($episode->id); ?>"
                                                class="episode-item flex-shrink-0 w-[160px] sm:w-[180px] lg:w-[220px] flex flex-col transition-transform cursor-pointer"
                                                data-season="<?php echo e($season->season_number); ?>"
                                                data-episode="<?php echo e($episode->episode_number); ?>">
                                                <!-- Episode Image with Play Button -->
                                                <div class="relative w-full h-[100px] sm:h-[110px] lg:h-[130px] mb-2 lg:mb-3 image-wrapper">
                                                    <img src="<?php echo e($episode->still_path ?: $anime->backdrop_path); ?>"
                                                        alt="<?php echo e($episode->name); ?>"
                                                        class="object-cover w-full h-full rounded-lg">

                                                    <div class="absolute bottom-2 left-2 play-overlay">
                                                        <div class="flex items-center justify-center transition-transform duration-200 rounded-full w-7 h-7 bg-black/60 backdrop-blur-sm hover:scale-110">
                                                            <i class="text-xs text-white fas fa-play"></i>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Episode Info -->
                                                <h4 class="mb-0.5 lg:mb-1 text-sm lg:text-base font-medium line-clamp-1">
                                                    <?php echo e($episode->episode_number); ?>. <?php echo e($episode->name); ?>

                                                </h4>
                                                <p class="text-xs text-gray-400 lg:text-sm line-clamp-2"><?php echo e($episode->overview); ?></p>

                                                <div class="mt-1.5 lg:mt-2">
                                                    <?php if(count($episode->videos) > 0): ?>
                                                        <span class="px-2 py-0.5 text-xs rounded-full bg-primary text-black">Disponível</span>
                                                    <?php else: ?>
                                                        <span class="px-2 py-0.5 text-xs rounded-full bg-red-500/50 text-white">Indisponível</span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            

            <!-- Related Animes Section -->
            <div class="mt-16">
                <h2 class="mb-6 font-bold text-1xl lg:text-3xl">Animes Relacionados</h2>

                <div class="relative px-4 sm:px-6">
                    <!-- Swiper Container -->
                    <div class="overflow-hidden swiper-container">
                        <div class="p-4 swiper-wrapper">
                            <?php $__currentLoopData = $animesRelacionados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedAnime): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide !w-[160px] sm:!w-[180px] p-1">
                                    <a href="<?php echo e(route('anime.detail', ['id' => $relatedAnime->id])); ?>"
                                       class="block group">
                                        <div class="relative overflow-hidden rounded-lg image-wrapper">
                                            <img src="<?php echo e($relatedAnime->poster_path); ?>"
                                                 alt="<?php echo e($relatedAnime->name); ?>"
                                                 class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105"
                                                 loading="lazy">
                                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                                        </div>
                                    </a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Trailer Modal -->
    <div id="trailerModal" class="fixed inset-0 z-50 hidden bg-black/90">
        <div class="absolute w-full max-w-4xl -translate-x-1/2 -translate-y-1/2 top-1/2 left-1/2">
            <button class="absolute right-0 text-2xl -top-10 close-trailer-modal">&times;</button>
            <div class="aspect-video">
                <iframe id="trailerIframe"
                        class="w-full h-full"
                        frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen></iframe>
            </div>
        </div>
    </div>

    <!-- Server Selection Modal -->
    <div id="serverModal" class="fixed inset-0 z-50 hidden bg-black/80">
        <div class="absolute w-full max-w-md overflow-hidden -translate-x-1/2 -translate-y-1/2 rounded-lg shadow-xl top-1/2 left-1/2 bg-zinc-900">
            <div class="flex items-center justify-between px-6 py-4 border-b border-zinc-800/50 backdrop-blur-sm">
                <h3 class="text-lg font-medium">Selecione o Servidor</h3>
                <button class="text-gray-400 hover:text-white close-server-modal">&times;</button>
            </div>
            <div class="p-6">
                <div id="serverList" class="mb-4 space-y-2">
                    <!-- Server buttons will be added here dynamically -->
                </div>

                <!-- Chromecast Section -->
                <div class="pt-4 mt-4 border-t border-zinc-800/50">
                    <div class="flex items-center justify-between">
                        <p class="text-sm text-gray-400">Transmitir:</p>
                        <div class="flex space-x-2">
                            <?php $__currentLoopData = $episode->videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button class="flex items-center justify-center w-10 h-10 transition-colors rounded-full bg-zinc-800/50 backdrop-blur-sm hover:bg-zinc-700"
                                        title="Enviar para Chromecast"
                                        onclick="window.open('wvc-x-callback://open?url=' + encodeURIComponent('<?php echo $video->link; ?>'))">
                                    <i class="fa-brands fa-chromecast"></i>
                                </button>
                                <?php if($index == 0): ?>
                                    <?php break; ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/js-cookie/3.0.1/js.cookie.min.js"></script>
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize drag scrolling for all episode sliders
            document.querySelectorAll('.episodes-slider').forEach(slider => {
                makeDraggable(slider);
            });

            function makeDraggable(element) {
                const wrapper = element.querySelector('.episodes-wrapper');
                let isDown = false;
                let startX;
                let scrollLeft;

                // Mouse events
                element.addEventListener('mousedown', (e) => {
                    isDown = true;
                    element.style.cursor = 'grabbing';
                    startX = e.pageX - element.offsetLeft;
                    scrollLeft = element.scrollLeft;
                    e.preventDefault();
                });

                element.addEventListener('mouseleave', () => {
                    isDown = false;
                    element.style.cursor = 'grab';
                });

                element.addEventListener('mouseup', () => {
                    isDown = false;
                    element.style.cursor = 'grab';
                });

                element.addEventListener('mousemove', (e) => {
                    if (!isDown) return;
                    e.preventDefault();
                    const x = e.pageX - element.offsetLeft;
                    const walk = (x - startX) * 2; // Speed multiplier
                    element.scrollLeft = scrollLeft - walk;
                });

                // Touch events for mobile
                element.addEventListener('touchstart', (e) => {
                    isDown = true;
                    startX = e.touches[0].pageX - element.offsetLeft;
                    scrollLeft = element.scrollLeft;
                }, { passive: true });

                element.addEventListener('touchend', () => {
                    isDown = false;
                });

                element.addEventListener('touchmove', (e) => {
                    if (!isDown) return;
                    const x = e.touches[0].pageX - element.offsetLeft;
                    const walk = (x - startX) * 2;
                    element.scrollLeft = scrollLeft - walk;
                }, { passive: true });

                // Handle clicks on episode items separately
                element.querySelectorAll('.episode-item').forEach(item => {
                    item.addEventListener('click', (e) => {
                        if (isDown && Math.abs(element.scrollLeft - scrollLeft) > 5) {
                            // If we've scrolled more than 5px, prevent the click
                            e.stopPropagation();
                            return;
                        }

                        const episode = JSON.parse(item.dataset.episodeData || '{}');
                        if (item.querySelector('.play-overlay')) {
                            openServerSelection(episode);
                        }
                    });

                    // Store episode data as an attribute
                    const season = item.dataset.season;
                    const episodeNum = item.dataset.episode;
                    const episodeId = item.id.replace('episode_', '');

                    // Find the episode data
                    <?php $__currentLoopData = $anime->seasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $season->episodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $episode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            if (episodeId == <?php echo e($episode->id); ?>) {
                                item.dataset.episodeData = JSON.stringify(<?php echo json_encode($episode); ?>);
                            }
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                });
            }

            // Add click event to play overlays
            document.querySelectorAll('.play-overlay').forEach(overlay => {
                overlay.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const episodeItem = overlay.closest('.episode-item');
                    const episodeData = JSON.parse(episodeItem.dataset.episodeData || '{}');
                    openServerSelection(episodeData);
                });
            });
        });
    </script>

    <script>
        // Dropdown functionality for seasons
        document.addEventListener('DOMContentLoaded', function() {
            const menuButton = document.getElementById('seasons-menu-button');
            const dropdown = document.getElementById('seasons-dropdown');
            const selectedSeason = document.getElementById('selected-season');

            // Verificar se os elementos existem antes de adicionar event listeners
            if (menuButton && dropdown && selectedSeason) {
                menuButton.addEventListener('click', function() {
                    dropdown.classList.toggle('hidden');
                });

                document.querySelectorAll('.season-option').forEach(option => {
                    option.addEventListener('click', function(e) {
                        e.preventDefault();
                        const season = this.getAttribute('data-season');
                        selectedSeason.textContent = this.textContent;
                        dropdown.classList.add('hidden');
                        showSeason(season);
                    });
                });

                // Close dropdown when clicking outside
                document.addEventListener('click', function(e) {
                    if (!menuButton.contains(e.target) && !dropdown.contains(e.target)) {
                        dropdown.classList.add('hidden');
                    }
                });
            }

            function showSeason(seasonNumber) {
                const seasons = document.querySelectorAll('.season-content');
                seasons.forEach(season => {
                    if (season.id === `season_${seasonNumber}`) {
                        season.classList.remove('hidden');
                    } else {
                        season.classList.add('hidden');
                    }
                });
            }
        });

        // Server selection functionality
        function openServerSelection(episode) {
            const serverModal = document.getElementById('serverModal');
            const serverList = document.getElementById('serverList');
            serverList.innerHTML = ''; // Limpa a lista anterior

            // Armazena o episódio atual no localStorage para referência
            localStorage.setItem('currentEpisode', JSON.stringify(episode));

            // Para cada vídeo do episódio, cria um botão de servidor
            episode.videos.forEach((video, index) => {
                const serverButton = document.createElement('button');
                serverButton.className = 'w-full text-left px-4 py-3 bg-zinc-800/50 backdrop-blur-sm hover:bg-zinc-700 transition-colors rounded-lg';

                let quality = 'MP4';
                if (video.hls) quality = 'HLS';
                if (video.drm) quality = 'DRM';
                if (video.embed) quality = 'Embed';

                serverButton.innerHTML = `
                    <div class="flex items-center justify-between">
                        <span class="font-medium">Servidor ${index + 1} ${video.server ? '- ' + video.server : ''}</span>
                        <div>
                            <span class="px-2 py-1 text-xs rounded-full bg-zinc-900 text-primary">${quality}</span>
                            ${video.lang ? `<span class="ml-2 text-xs text-gray-400">${video.lang}</span>` : ''}
                        </div>
                    </div>
                `;

                serverButton.onclick = () => {
                    // Simplificamos a chamada para depender apenas do player-integration.js
                    window.playEpisode(video.link, episode.id, episode);
                };

                serverList.appendChild(serverButton);
            });

            serverModal.style.display = 'block';
        }

        // Eventos para fechar o modal de servidores
        document.querySelector('.close-server-modal').onclick = function() {
            document.getElementById('serverModal').style.display = 'none';
        }

        window.onclick = function(event) {
            const serverModal = document.getElementById('serverModal');
            if (event.target == serverModal) {
                serverModal.style.display = 'none';
            }
        }
    </script>

    <!-- Carregamento otimizado dos scripts do player -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Carregamos o custom-player.js primeiro
            loadScript('<?php echo e(asset("js/custom-player.js")); ?>', function() {
                console.log('✅ custom-player.js carregado');

                // Depois carregamos o player-integration.js
                loadScript('<?php echo e(asset("js/player-integration.js")); ?>', function() {
                    console.log('✅ player-integration.js carregado');

                    // Após carregamento do script, verificamos se playEpisode foi definido
                    if (typeof window.playEpisode !== 'function') {
                        console.error('❌ A função playEpisode não foi definida pelo player-integration.js');

                        // Definimos uma implementação de fallback
                        window.playEpisode = function(videoLink, episodeId, currentEpisode) {
                            console.log('⚠️ Usando implementação fallback para playEpisode');
                            if (typeof window.showVideoPlayer === 'function') {
                                window.showVideoPlayer(videoLink, null, episodeId, currentEpisode);
                            } else {
                                console.error('❌ Não foi possível iniciar o player - função showVideoPlayer não disponível');
                            }
                        };
                    } else {
                        console.log('✅ Player-integration inicializado com sucesso');
                    }
                });
            });

            function loadScript(src, callback) {
                const script = document.createElement('script');
                script.src = src;
                script.async = true;

                script.onload = function() {
                    if (callback) callback();
                };

                script.onerror = function() {
                    console.error(`❌ Erro ao carregar o script: ${src}`);
                    if (callback) callback();
                };

                document.body.appendChild(script);
            }
        });
    </script>

    <!-- Script que se integra com o sistema de recuperação de posição -->
    <script>
        // Função para obter a posição salva do servidor e armazenar globalmente
        async function fetchEpisodePosition(episodeId) {
            if (!episodeId) return 0;

            try {
                const animeId = <?php echo e($anime->id); ?>;
                const baseUrl = '<?php echo e(url('/')); ?>';

                console.log(`🔍 Buscando posição para episódio ${episodeId}`);

                const response = await fetch(`${baseUrl}/continue-watching/get-position?item_id=${animeId}&type=anime&episode_id=${episodeId}`, {
                    method: 'GET',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                });

                if (!response.ok) {
                    throw new Error(`Erro HTTP: ${response.status}`);
                }

                const data = await response.json();
                console.log('📊 Posição recuperada:', data);

                // Armazenar a posição em uma variável global para acesso fácil
                if (!window.episodePositions) window.episodePositions = {};
                window.episodePositions[episodeId] = data.position;

                // Também armazenar no localStorage como backup
                localStorage.setItem(`videoPosition-${episodeId}`, data.position);

                return data.position;
            } catch (error) {
                console.error('❌ Erro ao buscar posição:', error);
                return 0;
            }
        }

        // Adicionar um evento personalizado para quando um episódio é clicado
        document.addEventListener('DOMContentLoaded', function() {
            // Obter todos os itens de episódio
            const episodeItems = document.querySelectorAll('.episode-item');

            // Adicionar evento para cada episódio
            episodeItems.forEach(item => {
                const episodeId = item.id.replace('episode_', '');

                // Pré-carregar as posições em segundo plano para os episódios visíveis
                setTimeout(() => {
                    fetchEpisodePosition(episodeId).then(position => {
                        // Se tiver uma posição significativa, adicionar um indicador visual
                        if (position > 30) {
                            // Adicionar um indicador de progresso
                            const indicator = document.createElement('div');
                            indicator.className = 'absolute bottom-0 left-0 h-1 bg-primary';
                            indicator.style.width = '100%';
                            indicator.style.opacity = '0.8';

                            // Adicionar ao elemento da imagem do episódio
                            const imageWrapper = item.querySelector('.image-wrapper');
                            if (imageWrapper) {
                                imageWrapper.appendChild(indicator);
                            }
                        }
                    });
                }, 500); // Atraso para não sobrecarregar a página ao carregar
            });
        });
    </script>

    <!-- Substitua o script de recuperação de posição por um otimizado com tratamento de erros -->
    <script>
        // Objeto para armazenar em cache as posições já consultadas
        const episodePositionsCache = {};

        // Variável para rastrear falhas repetidas
        let failureCount = 0;
        const MAX_FAILURES = 3;

        // Tempo em ms para considerar o cache válido (5 minutos)
        const CACHE_TTL = 5 * 60 * 1000;

        // Função para obter a posição salva do servidor (com cache e tratamento de erros)
        async function fetchEpisodePosition(episodeId) {
            if (!episodeId) return 0;

            // Verificar se temos dados em cache válidos
            const now = Date.now();
            if (episodePositionsCache[episodeId] &&
                (now - episodePositionsCache[episodeId].timestamp) < CACHE_TTL) {
                console.log(`📊 Usando posição em cache para episódio ${episodeId}:`,
                    episodePositionsCache[episodeId].position);
                return episodePositionsCache[episodeId].position;
            }

            // Se já tivemos muitas falhas, usar localStorage sem tentar a rede
            if (failureCount >= MAX_FAILURES) {
                console.warn('⚠️ Muitas falhas ao buscar posições, usando localStorage');
                return getPositionFromLocalStorage(episodeId);
            }

            try {
                const animeId = <?php echo e($anime->id); ?>;
                const baseUrl = '<?php echo e(url('/')); ?>';
                const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

                console.log(`🔍 Buscando posição para episódio ${episodeId}`);

                // Criar requisição com Promise e timeout manual em vez de AbortSignal
                const fetchPromise = fetch(`${baseUrl}/continue-watching/get-position?item_id=${animeId}&type=anime&episode_id=${episodeId}`, {
                    method: 'GET',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken
                    }
                });

                // Criar um timeout manual com Promise.race
                const timeoutPromise = new Promise((_, reject) => {
                    setTimeout(() => reject(new Error('Timeout')), 8000); // 8 segundos em vez de 5
                });

                // Competir entre a requisição e o timeout
                const response = await Promise.race([fetchPromise, timeoutPromise]);

                // Redefine contador de falhas
                failureCount = 0;

                const data = await response.json();
                console.log('📊 Posição recuperada:', data);

                // Guardar em cache
                episodePositionsCache[episodeId] = {
                    position: data.position,
                    timestamp: Date.now()
                };

                // Também armazenar no localStorage como backup
                if (data.position > 0) {
                    localStorage.setItem(`videoPosition-${episodeId}`, data.position);
                    localStorage.setItem(`videoPosition-${episodeId}-timestamp`, Date.now());
                }

                return data.position;
            } catch (error) {
                console.error('❌ Erro ao buscar posição:', error);

                // Incrementar contador de falhas
                failureCount++;

                // Usar localStorage como fallback
                return getPositionFromLocalStorage(episodeId);
            }
        }

        // Função auxiliar para obter posição do localStorage com verificação adicional
        function getPositionFromLocalStorage(episodeId) {
            try {
                const savedPosition = localStorage.getItem(`videoPosition-${episodeId}`);
                const timestamp = localStorage.getItem(`videoPosition-${episodeId}-timestamp`);

                if (savedPosition) {
                    const position = parseFloat(savedPosition);
                    console.log(`📊 Usando posição do localStorage: ${position}`);

                    // Armazenar no cache também
                    episodePositionsCache[episodeId] = {
                        position: position,
                        timestamp: timestamp ? parseInt(timestamp) : Date.now()
                    };

                    return position;
                }
            } catch (e) {
                console.error('Erro ao acessar localStorage:', e);
            }

            return 0;
        }

        // Carregar as posições em segundo plano para os episódios visíveis
        document.addEventListener('DOMContentLoaded', function() {
            // Obter todos os itens de episódio da temporada ativa
            const activeSeasonContent = document.querySelector('.season-content:not(.hidden)');
            if (!activeSeasonContent) return;

            const episodeItems = activeSeasonContent.querySelectorAll('.episode-item');

            // Carregar posições para os primeiros 5 episódios para melhorar UX
            for (let i = 0; i < Math.min(5, episodeItems.length); i++) {
                const item = episodeItems[i];
                const episodeId = item.id.replace('episode_', '');

                // Carregamento com atraso escalonado para reduzir carga no servidor
                setTimeout(() => {
                    fetchEpisodePosition(episodeId).then(position => {
                        // Se tiver uma posição significativa, adicionar um indicador visual
                        if (position > 30) {
                            addProgressIndicator(item, position);
                        }
                    }).catch(() => { /* Ignora erros aqui */ });
                }, i * 500); // Atraso progressivo: 0ms, 500ms, 1000ms, etc.
            }

            // Adicionar evento para quando trocamos de temporada
            const seasonTabs = document.querySelectorAll('.season-tab');
            seasonTabs.forEach(tab => {
                tab.addEventListener('click', function() {
                    // Resetar contador de falhas quando muda de temporada
                    failureCount = 0;

                    // Aguardar a troca de temporada ser concluída
                    setTimeout(() => {
                        const newActiveSeason = document.querySelector('.season-content:not(.hidden)');
                        if (!newActiveSeason) return;

                        const newEpisodeItems = newActiveSeason.querySelectorAll('.episode-item');

                        // Carregar posições para os primeiros episódios da nova temporada
                        for (let i = 0; i < Math.min(5, newEpisodeItems.length); i++) {
                            const item = newEpisodeItems[i];
                            const episodeId = item.id.replace('episode_', '');

                            setTimeout(() => {
                                fetchEpisodePosition(episodeId).then(position => {
                                    if (position > 30) {
                                        addProgressIndicator(item, position);
                                    }
                                }).catch(() => { /* Ignora erros aqui */ });
                            }, i * 500);
                        }
                    }, 300);
                });
            });
        });

        // Função auxiliar para adicionar indicador de progresso
        function addProgressIndicator(episodeItem, position) {
            // Verificar se já existe um indicador para evitar duplicatas
            const existingIndicator = episodeItem.querySelector('.progress-indicator');
            if (existingIndicator) return;

            // Adicionar um indicador de progresso
            const indicator = document.createElement('div');
            indicator.className = 'absolute bottom-0 left-0 h-1 bg-primary progress-indicator';
            indicator.style.width = '100%';
            indicator.style.opacity = '0.8';

            // Adicionar ao elemento da imagem do episódio
            const imageWrapper = episodeItem.querySelector('.image-wrapper');
            if (imageWrapper) {
                imageWrapper.appendChild(indicator);
            }
        }
    </script>

    <!-- Substitua o script para testar a recuperação de posição -->
    <script>
        // Função para verificar no console se a recuperação de posição está funcionando
        async function testPositionRecovery(episodeId) {
            if (!episodeId) return;

            const animeId = <?php echo e($anime->id); ?>;
            const baseUrl = '<?php echo e(url('/')); ?>';
            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

            console.log('🔍 Teste: Buscando posição para episódio:', episodeId);

            try {
                // Usar promise com timeout manual
                const controller = new AbortController();
                const timeoutId = setTimeout(() => controller.abort(), 10000); // 10 segundos para teste

                const response = await fetch(`${baseUrl}/continue-watching/get-position?item_id=${animeId}&type=anime&episode_id=${episodeId}`, {
                    method: 'GET',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken
                    },
                    signal: controller.signal
                });

                clearTimeout(timeoutId); // Limpar timeout se a requisição for bem-sucedida

                if (!response.ok) {
                    throw new Error(`HTTP error! Status: ${response.status}`);
                }

                const data = await response.json();
                console.log('🎯 Teste: Posição recuperada:', data);

                // Teste da configuração do jwplayer para depuração
                console.log('📝 Teste: Configuração que seria usada no jwplayer:');
                console.log({
                    file: 'URL_DO_VIDEO',
                    starttime: data.position,
                    image: 'POSTER_IMAGE'
                });

                return data;
            } catch (error) {
                console.error('❌ Teste: Erro ao buscar posição:', error);
                return null;
            }
        }

        // Executar teste para o primeiro episódio visível após 3 segundos (tempo para carregar a página)
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                const firstEpisode = document.querySelector('.episode-item');
                if (firstEpisode) {
                    const episodeId = firstEpisode.id.replace('episode_', '');
                    testPositionRecovery(episodeId);
                }
            }, 3000);
        });
    </script>

    <!-- Substitua o script de carregamento por uma versão corrigida -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log('🚀 Página carregada, iniciando carregamento dos scripts do player');

            // Carregar o player-integration.js primeiro
            loadScript('<?php echo e(asset("js/player-integration.js")); ?>', function() {
                console.log('✅ player-integration.js carregado');

                // Depois carregamos o custom-player.js
                loadScript('<?php echo e(asset("js/custom-player.js")); ?>', function() {
                    console.log('✅ custom-player.js carregado');

                    // Dar tempo suficiente para os scripts se inicializarem
                    setTimeout(function() {
                        // Verificar diretamente se showVideoPlayer existe
                        if (typeof window.showVideoPlayer === 'function') {
                            console.log('✅ showVideoPlayer disponível');

                            // Se playEpisode não existir, vamos implementá-lo usando showVideoPlayer
                            if (typeof window.playEpisode !== 'function') {
                                console.log('ℹ️ Implementando playEpisode usando showVideoPlayer');

                                window.playEpisode = function(videoLink, episodeId, currentEpisode) {
                                    console.log(`▶️ playEpisode: ID=${episodeId}, Link=${videoLink.substring(0, 50)}...`);
                                    window.showVideoPlayer(videoLink, null, episodeId, currentEpisode);
                                };
                            }
                        } else {
                            console.error('❌ ERRO CRÍTICO: showVideoPlayer não está disponível');

                            // Implementação de fallback de emergência
                            window.showVideoPlayer = function(videoLink, supportedHosts, episodeId, currentEpisode) {
                                console.error('⚠️ Usando implementação de emergência do player');

                                // Fechar modal de servidores
                                const serverModal = document.getElementById('serverModal');
                                if (serverModal) {
                                    serverModal.style.display = 'none';
                                }

                                // Abrir nova janela com o vídeo (último recurso)
                                alert('O player interno não está disponível. O vídeo será aberto em uma nova janela.');
                                window.open(videoLink, '_blank');
                            };

                            window.playEpisode = function(videoLink, episodeId, currentEpisode) {
                                window.showVideoPlayer(videoLink, null, episodeId, currentEpisode);
                            };
                        }
                    }, 500);
                });
            });

            // Função auxiliar para carregar scripts
            function loadScript(src, callback) {
                const script = document.createElement('script');
                script.src = src;
                script.async = true;

                script.onload = function() {
                    if (callback) callback();
                };

                script.onerror = function() {
                    console.error(`❌ Erro ao carregar o script: ${src}`);
                    if (callback) callback();
                };

                document.body.appendChild(script);
            }
        });
    </script>

    <!-- Corrigir manipulação de clique nos servidores -->
    <script>
        // Server selection functionality (versão corrigida)
        function openServerSelection(episode) {
            const serverModal = document.getElementById('serverModal');
            const serverList = document.getElementById('serverList');
            serverList.innerHTML = ''; // Limpa a lista anterior

            // Garantir que o episódio tenha o ID da série
            episode.anime_id = episode.anime_id || <?php echo e($anime->id); ?>;

            // Garantir que tenha temporada e número de episódio
            if (!episode.season_number) {
                const activeSeason = document.querySelector('.season-tab.bg-primary');
                if (activeSeason && activeSeason.dataset.season) {
                    episode.season_number = parseInt(activeSeason.dataset.season);
                } else {
                    episode.season_number = 1;
                }
            }

            // Para cada vídeo do episódio, cria um botão de servidor
            episode.videos.forEach((video, index) => {
                const serverButton = document.createElement('button');
                serverButton.className = 'w-full text-left px-4 py-3 mb-2 bg-zinc-800/50 backdrop-blur-sm hover:bg-zinc-700 transition-colors rounded-lg';

                let quality = 'MP4';
                if (video.hls) quality = 'HLS';
                if (video.drm) quality = 'DRM';
                if (video.embed) quality = 'Embed';

                serverButton.innerHTML = `
                    <div class="flex items-center justify-between">
                        <span class="font-medium">Servidor ${index + 1} ${video.server ? '- ' + video.server : ''}</span>
                        <div>
                            <span class="px-2 py-1 text-xs rounded-full bg-zinc-900 text-primary">${quality}</span>
                            ${video.lang ? `<span class="ml-2 text-xs text-gray-400">${video.lang}</span>` : ''}
                        </div>
                    </div>
                `;

                // Modificar para garantir que todos os dados necessários sejam enviados para o player
                serverButton.onclick = function() {
                    // Verificar se temos os dados completos do episódio
                    const completeEpisodeData = {
                        id: episode.id,
                        anime_id: episode.anime_id,
                        name: episode.name,
                        season_number: episode.season_number,
                        episode_number: episode.episode_number,
                        still_path: episode.still_path,
                        overview: episode.overview || ''
                    };

                    console.log('Reproduzindo episódio com dados completos:', completeEpisodeData);

                    // Chamar playEpisode com os dados completos
                    if (typeof window.playEpisode === 'function') {
                        window.playEpisode(video.link, episode.id, completeEpisodeData);
                    } else {
                        console.error('Função playEpisode não disponível');
                        if (typeof window.showVideoPlayer === 'function') {
                            window.showVideoPlayer(video.link, null, episode.id, completeEpisodeData);
                        }
                    }
                };

                serverList.appendChild(serverButton);
            });

            serverModal.style.display = 'block';
        }
    </script>

    <!-- Script para testar e verificar se a recuperação de posição está funcionando -->
    <script>
        // Função para verificar no console se a recuperação de posição está funcionando
        async function testPositionRecovery(episodeId) {
            if (!episodeId) return;

            const animeId = <?php echo e($anime->id); ?>;
            const baseUrl = '<?php echo e(url('/')); ?>';
            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

            console.log('🔍 Teste: Buscando posição para episódio:', episodeId);

            try {
                const response = await fetch(`${baseUrl}/continue-watching/get-position?item_id=${animeId}&type=anime&episode_id=${episodeId}`, {
                    method: 'GET',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken
                    }
                });

                if (!response.ok) {
                    throw new Error(`HTTP error! Status: ${response.status}`);
                }

                const data = await response.json();
                console.log('🎯 Teste: Posição recuperada:', data);

                // Teste da configuração do jwplayer para depuração
                console.log('📝 Teste: Configuração que seria usada no jwplayer:');
                console.log({
                    file: 'URL_DO_VIDEO',
                    starttime: data.position,
                    image: 'POSTER_IMAGE'
                });

                return data;
            } catch (error) {
                console.error('❌ Teste: Erro ao buscar posição:', error);
                return null;
            }
        }

        // Executar teste para o primeiro episódio visível ao carregar a página
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                const firstEpisode = document.querySelector('.episode-item');
                if (firstEpisode) {
                    const episodeId = firstEpisode.id.replace('episode_', '');
                    testPositionRecovery(episodeId);
                }
            }, 2000); // Atraso para garantir que tudo esteja carregado
        });
    </script>

    <!-- Substitua o script de recuperação de posição por uma versão otimizada que busca apenas episódios visíveis -->
    <script>
        // Objeto para armazenar em cache as posições dos episódios
        const episodePositionsCache = {};

        // Variável para controlar quais episódios já tiveram posição consultada
        const fetchedEpisodeIds = new Set();

        // Função para obter a posição de um episódio específico
        async function fetchEpisodePosition(episodeId) {
            // Se já temos esse ID em cache, retornar diretamente
            if (episodePositionsCache[episodeId]) {
                return episodePositionsCache[episodeId].position;
            }

            // Se já tentamos buscar esse episódio antes e ele não foi encontrado, evitar nova consulta
            if (fetchedEpisodeIds.has(episodeId)) {
                return 0;
            }

            try {
                const animeId = <?php echo e($anime->id); ?>;
                const baseUrl = '<?php echo e(url('/')); ?>';
                const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

                console.log(`Buscando posição para episódio ${episodeId}`);

                const response = await fetch(`${baseUrl}/continue-watching/get-position?item_id=${animeId}&type=anime&episode_id=${episodeId}`, {
                    method: 'GET',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken
                    }
                });

                if (!response.ok) {
                    throw new Error(`Erro HTTP: ${response.status}`);
                }

                const data = await response.json();

                // Salvar no cache para futuras consultas
                episodePositionsCache[episodeId] = {
                    position: data.position,
                    duration: data.duration,
                    timestamp: Date.now()
                };

                // Registrar que já tentamos buscar este episódio
                fetchedEpisodeIds.add(episodeId);

                return data.position;
            } catch (error) {
                console.error('Erro ao buscar posição:', error);

                // Registrar que já tentamos buscar este episódio para não repetir
                fetchedEpisodeIds.add(episodeId);

                return 0;
            }
        }

        // Função que carrega apenas os episódios visíveis da temporada atual
        function loadCurrentSeasonPositions() {
            // Encontrar a temporada atualmente visível
            const activeSeasonContent = document.querySelector('.season-content:not(.hidden)');
            if (!activeSeasonContent) return;

            // Obter apenas os episódios visíveis na viewport
            const visibleEpisodes = getVisibleEpisodes(activeSeasonContent);

            // Buscar posições apenas para os episódios visíveis
            visibleEpisodes.forEach((item, index) => {
                // Apenas buscar se ainda não foi buscado antes
                const episodeId = item.id.replace('episode_', '');
                if (!fetchedEpisodeIds.has(episodeId)) {
                    // Atraso progressivo para não sobrecarregar o servidor
                    setTimeout(() => {
                        fetchEpisodePosition(episodeId).then(position => {
                            if (position > 30) {
                                addProgressIndicator(item, position);
                            }
                        }).catch(() => {}); // Ignorar erros
                    }, index * 200);
                }
            });
        }

        // Função auxiliar para obter apenas os episódios visíveis na viewport
        function getVisibleEpisodes(container) {
            const allEpisodes = Array.from(container.querySelectorAll('.episode-item'));

            // Limitar a no máximo 5 episódios para evitar sobrecarga
            return allEpisodes.slice(0, 5);
        }

        // Adicionar indicador visual de progresso a um episódio
        function addProgressIndicator(episodeItem, position) {
            // Verificar se já existe um indicador
            const existingIndicator = episodeItem.querySelector('.progress-indicator');
            if (existingIndicator) return;

            // Criar indicador de progresso
            const indicator = document.createElement('div');
            indicator.className = 'absolute bottom-0 left-0 h-1 bg-primary progress-indicator';
            indicator.style.width = '100%';
            indicator.style.opacity = '0.8';

            // Adicionar ao elemento da imagem
            const imageWrapper = episodeItem.querySelector('.image-wrapper');
            if (imageWrapper) {
                imageWrapper.appendChild(indicator);
            }
        }

        // Inicializar quando o DOM estiver pronto
        document.addEventListener('DOMContentLoaded', function() {
            // Carregar posições para a temporada atual quando a página carrega
            setTimeout(loadCurrentSeasonPositions, 500);

            // Adicionar eventos para mudança de temporada
            const seasonTabs = document.querySelectorAll('.season-tab');
            seasonTabs.forEach(tab => {
                tab.addEventListener('click', function() {
                    // Aguardar a troca de temporada antes de carregar as posições
                    setTimeout(loadCurrentSeasonPositions, 300);
                });
            });
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var mySwiper = new Swiper('.swiper-container', {
                freeMode: true,
                arrow: false,
                slidesPerView: 'auto',
                lazyPreloaderClass:'swiper-lazy-preloader',
                breakpoints: {
                    320: {
                        slidesPerView: 3,
                        spaceBetween: 30
                    },
                    480: {
                        slidesPerView: 3,
                        spaceBetween: 30
                    },
                    800: {
                        slidesPerView: 4,
                        spaceBetween: 30
                    },
                    980: {
                        slidesPerView: 5,
                        spaceBetween: 30
                    },
                    1200: {
                        slidesPerView: 6,
                        spaceBetween: 30
                    },
                    1300: {
                        slidesPerView: 7,
                        spaceBetween: 30
                    },
                    1700: {
                        slidesPerView: 10,
                        spaceBetween: 40
                    }
                },

            });

            // Inicialização dos botões de temporada - CÓDIGO CORRIGIDO
            const seasonTabs = document.querySelectorAll('.season-tab');
            seasonTabs.forEach(tab => {
                tab.addEventListener('click', function() {
                    // Remove a classe ativa de todos os botões
                    seasonTabs.forEach(t => {
                        // Corrigido: adicionar classes separadamente
                        t.classList.remove('bg-primary', 'text-black');
                        t.classList.add('bg-zinc-800/50'); // Adicionando uma classe por vez
                        t.classList.add('backdrop-blur-sm');
                        t.classList.add('text-white');
                    });

                    // Adiciona a classe ativa ao botão clicado
                    this.classList.remove('bg-zinc-800/50', 'backdrop-blur-sm', 'text-white');
                    this.classList.add('bg-primary', 'text-black');

                    // Mostra a temporada selecionada
                    const selectedSeasonNumber = this.dataset.season;
                    const seasons = document.querySelectorAll('.season-content');
                    seasons.forEach((season) => {
                        if (season.id === `season_${selectedSeasonNumber}`) {
                            season.classList.remove('hidden');
                        } else {
                            season.classList.add('hidden');
                        }
                    });
                });
            });

            // Adicione estilos para o scrollbar horizontal
            const style = document.createElement('style');
            style.textContent = `
                .seasons-scroller {
                    -ms-overflow-style: none;  /* IE e Edge */
                    scrollbar-width: none;     /* Firefox */
                    scroll-behavior: smooth;
                    -webkit-overflow-scrolling: touch;
                }
                .seasons-scroller::-webkit-scrollbar {
                    display: none;  /* Chrome, Safari e Opera */
                }
            `;
            document.head.appendChild(style);

            // Aplica a classe scrollbar-hide a todos os elementos com overflow-x-auto
            document.querySelectorAll('.overflow-x-auto').forEach(element => {
                element.classList.add('scrollbar-hide');
            });

            // Adicione o código para o scroll horizontal das temporadas em desktop
            const scrollLeftBtn = document.getElementById('scroll-left-btn');
            const scrollRightBtn = document.getElementById('scroll-right-btn');
            const seasonsScroller = document.getElementById('seasons-scroller');

            // Mostrar/ocultar botões de scroll baseado no overflow
            function updateScrollButtonVisibility() {
                if (seasonsScroller.scrollWidth > seasonsScroller.clientWidth) {
                    // Tem overflow, mostra os botões de acordo com a posição do scroll
                    scrollLeftBtn.classList.remove('hidden');
                    scrollRightBtn.classList.remove('hidden');

                    // Oculta o botão de scroll esquerdo se estiver no início
                    if (seasonsScroller.scrollLeft <= 0) {
                        scrollLeftBtn.classList.add('opacity-50', 'cursor-not-allowed');
                    } else {
                        scrollLeftBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                    }

                    // Oculta o botão de scroll direito se estiver no final
                    const maxScrollLeft = seasonsScroller.scrollWidth - seasonsScroller.clientWidth;
                    if (Math.ceil(seasonsScroller.scrollLeft) >= maxScrollLeft) {
                        scrollRightBtn.classList.add('opacity-50', 'cursor-not-allowed');
                    } else {
                        scrollRightBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                    }
                } else {
                    // Não tem overflow, oculta os botões
                    scrollLeftBtn.classList.add('hidden');
                    scrollRightBtn.classList.add('hidden');
                }
            }

            // Inicializa a visibilidade dos botões
            updateScrollButtonVisibility();

            // Evento de redimensionamento da janela
            window.addEventListener('resize', updateScrollButtonVisibility);

            // Evento de scroll
            seasonsScroller.addEventListener('scroll', updateScrollButtonVisibility);

            // Função para scroll suave
            function scrollSmoothly(element, direction) {
                const scrollAmount = 200; // quantidade de pixels para scrollar
                const currentScroll = element.scrollLeft;
                const targetScroll = direction === 'left'
                    ? Math.max(0, currentScroll - scrollAmount)
                    : Math.min(element.scrollWidth - element.clientWidth, currentScroll + scrollAmount);

                element.scrollTo({
                    left: targetScroll,
                    behavior: 'smooth'
                });
            }

            // Eventos de clique nos botões de scroll
            if (scrollLeftBtn) {
                scrollLeftBtn.addEventListener('click', function() {
                    scrollSmoothly(seasonsScroller, 'left');
                });
            }

            if (scrollRightBtn) {
                scrollRightBtn.addEventListener('click', function() {
                    scrollSmoothly(seasonsScroller, 'right');
                });
            }

            // Habilita também navegação com teclas
            seasonsScroller.addEventListener('keydown', function(e) {
                if (e.key === 'ArrowLeft') {
                    scrollSmoothly(seasonsScroller, 'left');
                } else if (e.key === 'ArrowRight') {
                    scrollSmoothly(seasonsScroller, 'right');
                }
            });
        });

        function openTrailerPopup(id) {
            var trailerIframe = document.getElementById('trailerIframe');
            trailerIframe.src = 'https://www.youtube.com/embed/' + id + '?autoplay=1';
            document.getElementById('trailerModal').style.display = 'block';
        }

        var span = document.getElementsByClassName("close-trailer-modal")[0];
        span.onclick = function() {
            var trailerModal = document.getElementById('trailerModal');
            trailerModal.style.display = "none";
            trailerModal.querySelector('iframe').src = '';
        }

        window.onclick = function(event) {
            var trailerModal = document.getElementById('trailerModal');
            if (event.target == trailerModal) {
                trailerModal.style.display = "none";
                trailerModal.querySelector('iframe').src = '';
            }
        }
    </script>

    <!-- Substitua todos os scripts relacionados à recuperação de posição por um único script otimizado -->
    <script>
        // Namespace global para o sistema de posição de vídeo
        window.VideoPositionSystem = window.VideoPositionSystem || {
            // Cache central para todas as posições de episódios
            cache: {},

            // Flag para rastrear se estamos em modo de recuperação após falha
            failureMode: false,

            // Log centralizado com níveis
            log: function(level, message, data) {
                const prefix = {
                    'info': '📋',
                    'debug': '🔍',
                    'error': '❌',
                    'success': '✅',
                    'warning': '⚠️'
                }[level] || '📌';

                console[level === 'error' ? 'error' : level === 'warning' ? 'warn' : 'log'](`${prefix} ${message}`, data || '');
            },

            // Função que busca a posição de um episódio específico
            fetchPosition: async function(episodeId, animeId) {
                if (!episodeId || !animeId) {
                    this.log('error', 'ID de episódio ou série não fornecidos');
                    return 0;
                }

                // Verificar cache primeiro
                if (this.cache[episodeId] && (Date.now() - this.cache[episodeId].timestamp) < 300000) {
                    this.log('info', `Usando posição em cache para episódio ${episodeId}`, this.cache[episodeId]);
                    return this.cache[episodeId].position;
                }

                // Se estamos em modo de falha, usar localStorage
                if (this.failureMode) {
                    return this.getFromLocalStorage(episodeId);
                }

                try {
                    const baseUrl = document.querySelector('meta[name="base-url"]')?.content || '';
                    const csrfToken = document.querySelector('meta[name="csrf-token"]')?.content || '';

                    this.log('debug', `Buscando posição do servidor para episódio ${episodeId}`);

                    // Usar fetch com timeout explícito
                    const controller = new AbortController();
                    const timeoutId = setTimeout(() => controller.abort(), 8000);

                    const response = await fetch(`${baseUrl}/continue-watching/get-position?item_id=${animeId}&type=anime&episode_id=${episodeId}`, {
                        method: 'GET',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': csrfToken
                        },
                        signal: controller.signal
                    });

                    clearTimeout(timeoutId);

                    if (!response.ok) {
                        throw new Error(`Erro HTTP: ${response.status}`);
                    }

                    const data = await response.json();
                    this.log('success', `Posição recuperada para episódio ${episodeId}`, data);

                    // Salvar no cache
                    this.cache[episodeId] = {
                        position: data.position,
                        duration: data.duration,
                        timestamp: Date.now(),
                        season: data.season_number,
                        episode: data.episode_number
                    };

                    // Backup no localStorage
                    this.saveToLocalStorage(episodeId, data.position);

                    return data.position;
                } catch (error) {
                    this.log('error', `Falha ao buscar posição para episódio ${episodeId}`, error);
                    this.failureMode = true;
                    return this.getFromLocalStorage(episodeId);
                }
            },

            // Salvar posição no localStorage
            saveToLocalStorage: function(episodeId, position) {
                try {
                    localStorage.setItem(`videoPosition-${episodeId}`, position);
                    localStorage.setItem(`videoPosition-${episodeId}-timestamp`, Date.now());
                } catch (e) {
                    this.log('warning', 'Erro ao salvar no localStorage', e);
                }
            },

            // Recuperar posição do localStorage
            getFromLocalStorage: function(episodeId) {
                try {
                    const savedPosition = localStorage.getItem(`videoPosition-${episodeId}`);
                    if (savedPosition) {
                        const position = parseFloat(savedPosition);
                        this.log('info', `Posição recuperada do localStorage: ${position}`);
                        return position;
                    }
                } catch (e) {
                    this.log('warning', 'Erro ao acessar localStorage', e);
                }
                return 0;
            },

            // Adicionar indicador visual de progresso
            addProgressIndicator: function(episodeElement, position) {
                if (!episodeElement) return;

                // Verificar se já existe um indicador
                if (episodeElement.querySelector('.progress-indicator')) return;

                const indicator = document.createElement('div');
                indicator.className = 'absolute bottom-0 left-0 h-1 bg-primary progress-indicator';
                indicator.style.width = '100%';
                indicator.style.opacity = '0.8';

                const imageWrapper = episodeElement.querySelector('.image-wrapper');
                if (imageWrapper) {
                    imageWrapper.appendChild(indicator);
                }
            },

            // Carregar posições para episódios visíveis da temporada atual
            loadVisibleEpisodes: function() {
                const activeSeasonContent = document.querySelector('.season-content:not(.hidden)');
                if (!activeSeasonContent) return;

                const episodeItems = activeSeasonContent.querySelectorAll('.episode-item');
                const animeId = document.querySelector('meta[name="anime-id"]')?.content;

                // Limitar para os primeiros 5 episódios
                const visibleEpisodes = Array.from(episodeItems).slice(0, 5);

                visibleEpisodes.forEach((item, index) => {
                    const episodeId = item.id.replace('episode_', '');

                    // Atraso progressivo para não sobrecarregar o servidor
                    setTimeout(() => {
                        this.fetchPosition(episodeId, animeId).then(position => {
                            if (position > 30) {
                                this.addProgressIndicator(item, position);
                            }
                        }).catch(() => {/* Ignorar erros aqui */});
                    }, index * 200);
                });
            }
        };

        // Inicialização quando o DOM estiver pronto
        document.addEventListener('DOMContentLoaded', function() {
            // Carregar posições para a temporada ativa
            setTimeout(() => {
                VideoPositionSystem.loadVisibleEpisodes();
            }, 500);

            // Adicionar eventos para mudança de temporada
            const seasonTabs = document.querySelectorAll('.season-tab');
            seasonTabs.forEach(tab => {
                tab.addEventListener('click', function() {
                    // Resetar modo de falha ao trocar de temporada
                    VideoPositionSystem.failureMode = false;

                    // Carregar episódios da nova temporada após a transição
                    setTimeout(() => {
                        VideoPositionSystem.loadVisibleEpisodes();
                    }, 300);
                });
            });
        });
    </script>

    <!-- Substitua o script de manipulação de servidores por uma versão aprimorada -->
    <script>
        // Server selection functionality (versão aprimorada e corrigida)
        function openServerSelection(episode) {
            const serverModal = document.getElementById('serverModal');
            const serverList = document.getElementById('serverList');

            if (!serverModal || !serverList) {
                console.error('Elementos de modal não encontrados');
                return;
            }

            serverList.innerHTML = ''; // Limpa a lista anterior

            // Obter o ID do anime da meta tag
            const animeId = <?php echo e($anime->id); ?>;

            // Garantir que todos os dados do episódio estejam preenchidos
            episode.anime_id = episode.anime_id || animeId;

            if (!episode.anime_id) {
                console.error('ID do anime não encontrado, necessário para reprodução');
                return;
            }

            // Para cada vídeo do episódio, cria um botão de servidor
            if (!episode.videos || !episode.videos.length) {
                const errorMessage = document.createElement('div');
                errorMessage.className = 'text-center py-5 text-red-400';
                errorMessage.textContent = 'Nenhuma fonte de vídeo disponível para este episódio.';
                serverList.appendChild(errorMessage);
            } else {
                episode.videos.forEach((video, index) => {
                    const serverButton = document.createElement('button');
                    serverButton.className = 'w-full text-left px-4 py-3 mb-2 bg-zinc-800/50 backdrop-blur-sm hover:bg-zinc-700 transition-colors rounded-lg';

                    // Determinar tipo de vídeo
                    let quality = 'MP4';
                    if (video.hls) quality = 'HLS';
                    if (video.drm) quality = 'DRM';
                    if (video.embed) quality = 'Embed';

                    serverButton.innerHTML = `
                        <div class="flex items-center justify-between">
                            <span class="font-medium">Servidor ${index + 1}</span>
                            <span class="px-2 py-1 text-xs rounded bg-zinc-700/50">${quality}</span>
                        </div>
                    `;

                    // Modificar para usar a função correta baseada no tipo
                    serverButton.onclick = function() {
                        // Fechar modal de servidores
                        serverModal.style.display = 'none';

                        // Garantir que o episódio tenha ID completo do anime
                        const completeEpisodeData = {
                            ...episode,
                            anime_id: animeId
                        };

                        console.log('Reproduzindo episódio com dados completos:', completeEpisodeData);

                        // Usar playAnimeEpisode específico para animes
                        if (typeof window.playAnimeEpisode === 'function') {
                            window.playAnimeEpisode(video.link, episode.id, completeEpisodeData);
                        } else if (typeof window.playEpisode === 'function') {
                            // Fallback para playEpisode padrão
                            window.playEpisode(video.link, episode.id, completeEpisodeData);
                        } else {
                            // Último recurso: abrir em nova janela
                            window.open(video.link, '_blank');
                        }
                    };

                    serverList.appendChild(serverButton);
                });
            }

            serverModal.style.display = 'block';
        }
    </script>
    
    <script>
        
        // Função para inicializar o botão de favoritos
        function initializeFavoriteButton(animeId) {
            fetch("<?php echo e(route('anime.isFavorite', '')); ?>/" + animeId, {
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                updateFavoriteIcon(data.isFavorite === 1);
                document.getElementById('fav-btn').onclick = () => toggleFavorite(animeId, data.isFavorite === 1);
            })
            .catch(error => {
                console.error('Erro ao verificar favorito:', error);
            });
        }

        // Função para alternar o estado de favorito
        function toggleFavorite(animeId, isFavorite) {
            console.log('Alternando favorito:', animeId, isFavorite);

            const endpoint = isFavorite
                ? "<?php echo e(route('anime.removefromfav', '')); ?>/" + animeId
                : "<?php echo e(route('anime.addtofav', '')); ?>/" + animeId;

            fetch(endpoint, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                console.log('Resposta do servidor:', data);

                // Determinamos o novo estado com base na resposta do servidor
                const newStatus = !isFavorite;

                // Atualizamos o ícone e reconfiguramos o handler do evento de clique
                updateFavoriteIcon(newStatus);
                document.getElementById('fav-btn').onclick = () => toggleFavorite(animeId, newStatus);
            })
            .catch(error => {
                console.error('Erro ao alternar favorito:', error);
            });
        }

        // Função para atualizar o ícone de favorito
        function updateFavoriteIcon(isFavorite) {
            const icon = document.getElementById('fav-icon');
            if (icon) {
                if (isFavorite) {
                    icon.classList.remove('far');
                    icon.classList.add('fas', 'fa-heart', 'text-primary');
                } else {
                    icon.classList.remove('fas', 'fa-heart', 'text-primary');
                    icon.classList.add('far', 'fa-heart');
                }
            }
        }

        // Inicializar o botão de favoritos quando a página carregar
        document.addEventListener('DOMContentLoaded', function() {
            const animeId = parseInt('<?php echo e($anime->id); ?>', 10);
            if (animeId) {
                initializeFavoriteButton(animeId);
            }
        });
    </script>
</body>
</html>
<?php /**PATH /home/u446595196/domains/capixabaplay.com.br/public_html/play/resources/views/anime.blade.php ENDPATH**/ ?>