<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Escolha seu Plano - <?php echo e($settings->app_name); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
</head>
<body class="min-h-screen font-sans text-white bg-black"
      style="background-image: linear-gradient(to right, rgba(0, 0, 0, 86%), transparent), linear-gradient(to left, rgba(0, 0, 0, 86%), transparent), linear-gradient(to top, rgb(0, 0, 0, 0%), transparent), url('/public/assets/images/background.jpg'); background-attachment: fixed; background-size: cover; background-position: center center;">

    <div class="container max-w-lg px-4 py-10 mx-auto">
        <div class="p-6 border shadow-xl bg-black/50 backdrop-blur-md rounded-xl border-white/10">
            <div class="text-center">
                <div id="lottie-container" class="w-32 h-32 mx-auto"></div>
                <h2 class="pb-3 mb-6 text-2xl font-bold border-b border-zinc-700">Ative sua assinatura e desfrute de milhares de conteúdos</h2>
            </div>

            <form class="space-y-6" action="<?php echo e(route('realizarPagamento')); ?>" method="post" id="payment-form">
                <?php echo csrf_field(); ?>
                <div class="space-y-4">
                    <label class="block font-medium">Este email será ativado</label>
                    <input type="text" name="name" id="name" class="hidden" value="<?php echo e(Auth::user()->name); ?>">

                    <input type="email" name="email" id="email" class="w-full px-4 py-3 text-white border rounded-full bg-zinc-800 border-zinc-700" value="<?php echo e(Auth::user()->email); ?>" readonly>

                    <input placeholder="+55 Digite seu número de whatsapp" type="tel" id="phone" name="numero"
                           class="w-full px-4 py-3 text-white border rounded-full bg-zinc-800 border-zinc-700"
                           oninput="addCountryCode()"
                           pattern="\+55[0-9]{2}[0-9]{4,5}[0-9]{4}" required>

                    <!-- Campo CPF/CNPJ removido -->
                </div>

                <!-- Exibição de mensagens de erro -->
                <?php if($errors->any()): ?>
                    <div class="p-4 my-4 border-l-4 border-red-500 rounded-md bg-red-900/30">
                        <ul class="pl-5 list-disc">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="text-red-400"><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <div class="mt-8">
                    <h3 class="mb-4 text-xl font-bold text-center">Escolha um plano</h3>

                    <div class="space-y-3">
                        <!-- Planos da base de dados -->
                        <?php
                            // Obter planos da base de dados
                            $plans = App\Plan::all();
                            $tvPlans = $plans->filter(function($plan) {
                                return stripos($plan->name, 'canais') !== false ||
                                       stripos($plan->description, 'canais') !== false ||
                                       (isset($plan->is_tv_plan) && $plan->is_tv_plan);
                            });
                            $standardPlans = $plans->filter(function($plan) {
                                return stripos($plan->name, 'canais') === false &&
                                       (stripos($plan->description, 'canais') === false) &&
                                       (!isset($plan->is_tv_plan) || !$plan->is_tv_plan);
                            })->sortBy('price');
                        ?>

                        <!-- Planos padrão (não TV) -->
                        <?php $__currentLoopData = $standardPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label class="relative block p-4 transition-all border-2 rounded-lg cursor-pointer bg-gradient-to-r from-green-900/30 to-green-800/10 border-green-500/50 hover:bg-green-900/20">
                                <input type="radio" name="plano" id="plano<?php echo e($plan->id); ?>" value="<?php echo e($plan->id); ?>" class="hidden" required>
                                <div class="flex items-center">
                                    <div class="relative w-5 h-5 mr-3 bg-transparent border-2 border-green-500 rounded-full">
                                        <div class="absolute hidden rounded-full radio-dot inset-1 bg-primary"></div>
                                    </div>
                                    <span class="font-bold"><?php echo e($plan->name); ?> - R$<?php echo e(number_format((float)$plan->price, 2, ',', '.')); ?></span>
                                </div>
                            </label>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php if($tvPlans->count() > 0): ?>
                            <div class="my-4 border-t-2 border-zinc-800"></div>

                            <!-- Planos de TV -->
                            <?php $__currentLoopData = $tvPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <label class="relative block p-4 text-black transition-all rounded-lg cursor-pointer bg-gradient-to-b from-amber-500 to-amber-600 hover:from-amber-400 hover:to-amber-500">
                                    <input type="radio" name="plano" id="plano<?php echo e($plan->id); ?>" value="<?php echo e($plan->id); ?>" class="hidden">
                                    <div class="flex items-center">
                                        <div class="relative w-5 h-5 mr-3 bg-transparent border-2 rounded-full border-amber-700">
                                            <div class="absolute hidden rounded-full radio-dot inset-1 bg-amber-800"></div>
                                        </div>
                                        <span class="font-bold"><?php echo e($plan->name); ?> - R$<?php echo e(number_format((float)$plan->price, 2, ',', '.')); ?></span>
                                    </div>
                                </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <div class="p-2 text-xs text-center border border-red-500 rounded-md bg-red-900/30">
                                O plano de canais é separado dos planos de filmes e séries!
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Seção de PIX -->
                <div class="flex flex-col items-center p-4 mt-8 rounded-lg bg-zinc-900/50">
                    <img src="https://logodownload.org/wp-content/uploads/2020/02/pix-bc-logo.png" alt="PIX" class="h-10 mb-2">
                    <p class="text-sm text-gray-400">Pagamento rápido e seguro</p>
                </div>

                <button type="submit" class="flex items-center justify-center w-full gap-2 px-8 py-4 text-lg font-bold text-black transition-all rounded-full bg-gradient-to-r from-yellow-400 to-amber-500 hover:from-yellow-300 hover:to-amber-400">
                    <i class="fas fa-qrcode"></i>
                    <span>Gerar QR Code PIX</span>
                </button>
            </form>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bodymovin/5.7.8/lottie.min.js"></script>
    <script src="/public/js/cpf-validator.js"></script>

    <script>
        // Carregue a animação Lottie
        var animation = bodymovin.loadAnimation({
            container: document.getElementById('lottie-container'),
            renderer: 'svg',
            loop: true,
            autoplay: true,
            path: 'https://assets1.lottiefiles.com/packages/lf20_rZQs81.json'
        });

        // Adiciona código do país no telefone
        function addCountryCode() {
            var input = document.getElementById('phone');
            var code = '+55';
            if (input.value && input.value.indexOf(code) !== 0) {
                input.value = code + input.value;
            }
        }

        // Script para selecionar planos
        document.addEventListener('DOMContentLoaded', function() {
            // Selecionar todos os inputs radio de planos
            const planInputs = document.querySelectorAll('input[name="plano"]');

            // Adicionar evento de clique para cada label de plano
            planInputs.forEach(function(input) {
                input.addEventListener('change', function() {
                    // Remover classe ativa de todos os elementos
                    document.querySelectorAll('input[name="plano"]').forEach(function(radio) {
                        const parentLabel = radio.closest('label');
                        const radioDot = parentLabel.querySelector('.radio-dot');

                        if (radio.checked) {
                            radioDot.classList.remove('hidden');
                            parentLabel.classList.add('ring-2', 'ring-primary', 'ring-opacity-60');
                        } else {
                            radioDot.classList.add('hidden');
                            parentLabel.classList.remove('ring-2', 'ring-primary', 'ring-opacity-60');
                        }
                    });
                });

                // Verificar se o plano já está selecionado ao carregar a página
                if (input.checked) {
                    const parentLabel = input.closest('label');
                    const radioDot = parentLabel.querySelector('.radio-dot');
                    radioDot.classList.remove('hidden');
                    parentLabel.classList.add('ring-2', 'ring-primary', 'ring-opacity-60');
                }
            });

            // Adicionar evento de clique nas labels dos planos
            const planLabels = document.querySelectorAll('label.cursor-pointer');
            planLabels.forEach(function(label) {
                label.addEventListener('click', function() {
                    const input = this.querySelector('input[name="plano"]');
                    input.checked = true;

                    // Disparar o evento change manualmente
                    const event = new Event('change');
                    input.dispatchEvent(event);
                });
            });
        });
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/layouts/choose_plan.blade.php ENDPATH**/ ?>