<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Suporte Premium</title>
    <link rel="stylesheet" href="/public/css/web.css">
    <script src="https://suporte.ultraflix.net/js/min/jquery.min.js"></script>
    <script id="sbinit" src="https://suporte.ultraflix.net/js/main.js"></script>

    <style>
        /* Estilos para a página de Suporte Premium */

.suporte-premium-container {
    background-color: #2a2a2a75;
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    padding: 20px;
    max-width: 800px;
    margin: 20px auto;
    border: 2px solid #80808045;
}

h1 {
    color: var(--main-color);
    font-size: 24px;
    text-align: center;
}

.instructions {
    margin-top: 20px;
}

.instructions h2 {
    color: #fff;
    font-size: 20px;
    margin-bottom: 10px;
}

.instructions ul {
    list-style-type: none;
    padding: 0;
    text-align: left;
}

.instructions ul li {
    background-color: #000000;
    border: 2px solid #dddddd42;
    padding: 15px 15px;
    margin-bottom: 10px;
    border-radius: 4px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
}

.instructions ul li strong {
    color: var(--main-color);
}

/* Dicas úteis com estilo diferenciado */
.instructions ul li:last-child {
    background-color: #e7f7ff00;
    border-color: #2bf14a;
    color: #b1b1b1;
    margin-top: 40px;
}

.exit-support-btn {
    display: inline-block;
    padding: 10px 20px;
    margin-top: 20px;
    background-color: var(--main-color);
    color: #000000;
    text-decoration: none;
    border-radius: 5px;
    font-weight: 600;
    transition: background-color 0.3s ease;
}

.exit-support-btn:hover {
    background-color: #00b306;
}
    </style>
</head>
<body>
    <div class="suporte-premium-container">
        <h1>Bem-vindo ao Suporte Premium</h1>
        <div class="instructions">
            <h2>Como usar nosso suporte</h2>
            <ul>
                <li><strong>Passo 1:</strong> Inicie o chat clicando no ícone de mensagem no canto inferior direito da sua tela.</li>
                <li><strong>Passo 2:</strong> Insira seu nome para que possamos indentificá-lo(a) atendê-lo(a) melhor.</li>
                <li><strong>Passo 3:</strong> Descreva sua dúvida ou problema com o máximo de detalhes possível para facilitar a assistência.</li>
                <li><strong>Passo 4:</strong> Aguarde enquanto um de nossos atendentes entra em contato com você. O tempo médio de resposta é de 2 a 5 minutos, mas pode demorar mais, apenas aguarde.</li>
                <li><strong>Dicas úteis:</strong> Tenha em mãos informações que possam ser necessárias para a resolução de problemas, como detalhes de transações, capturas de tela de erros, entre outros.</li>
            </ul>
        </div>
        <a href="<?php echo e(url('/inicio')); ?>" class="exit-support-btn">Sair da Tela de Suporte</a>
    </div>
</body>
</html>
<?php /**PATH /home/ultraflix/public_html/ultraflix.pro/resources/views/suporte_premium.blade.php ENDPATH**/ ?>