<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/public/css/font-awesome.css">
    <script src="/public/js/font-awesome.js"></script>
    <link rel="icon" href="/api/image/minilogo" type="image/x-icon">
    <style>
        /* public/css/plan_style.css */

        body {
            background-color: black;
            color: white;
            font-family: Arial, sans-serif;
        }

        .container {
            display: flex;
            max-width: 565px;
            margin: 38px auto;
            padding: 20px;
            border-radius: 11px;
            background-color: #22222278;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            flex-direction: column;
            justify-content: center;
            align-items: center;
            backdrop-filter: blur(12px);
            border: 2px solid #ffffff24;
        }

        h2 {
            border-bottom: 1px solid #444;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }

        h3 {
            margin-top: 30px;
            margin-bottom: 20px;
        }

        .form-group label {
            font-weight: bold;
            margin-bottom: 10px;
            display: block;
        }

        .form-control {
            width: 100%;
            padding: 5px;
            border-radius: 30px;
            height: 25px;
            margin-bottom: 10px;
            position: relative;
            left: 5px;
            border: none;
            outline: none;
            color: white;
            background-color: #333;
        }

        .form-check {
            border: 2px solid #00a100;
            border-radius: 10px;
            width: 60%;
            font-weight: 800;
            color: #fff;
            padding: 12px;
            margin: 10px 0;
            background-color: #ffffff0d;
            backdrop-filter: blur(20px);
        }

        .form-check-p6 {
            border-radius: 10px;
            width: 100%;
            font-weight: 800;
            color: #000;
            padding: 12px;
            margin: 10px 0;
            backdrop-filter: blur(20px);
            background: radial-gradient(
                100.39% 460.66% at 50.68% -234.91%,
                #ff9900 2%,
                #ffee53 48.27%,
                #f2ac2a 69.44%,
                #000413 136%
            );
            box-shadow: 0px 6px 16px 0px #0000008a;
        }

        .form-check-input {
            display: none;
        }

        .form-check-label {
            position: relative;
            padding-left: 35px;
            cursor: pointer;
        }

        .form-check-label:before {
            content: "";
            display: block;
            position: absolute;
            top: 50%;
            left: 0;
            transform: translateY(-50%);
            width: 20px;
            height: 20px;
            border: 2px solid #128900;
            border-radius: 50%;
        }

        .form-check-p6 .form-check-label:before {
            content: "";
            display: block;
            position: absolute;
            top: 50%;
            left: 0;
            transform: translateY(-50%);
            width: 20px;
            height: 20px;
            border: 2px solid #ffe602;
            border-radius: 50%;
        }

        .form-check-input:checked + .form-check-label:after {
            content: "";
            display: block;
            position: absolute;
            top: 50%;
            left: 6px;
            transform: translateY(-50%);
            width: 12px;
            height: 12px;
            background-color: #17ff00;
            border-radius: 50%;
            box-shadow: 0px 0px 30px 8px #17ff00;
        }

        .form-check-p6 .form-check-input:checked + .form-check-label:after {
            content: "";
            display: block;
            position: absolute;
            top: 50%;
            left: 6px;
            transform: translateY(-50%);
            width: 12px;
            height: 12px;
            background-color: #ffe602;
            border-radius: 50%;
            box-shadow: 0px 0px 50px 20px #ffe602;
        }

        .btn-premium {
            padding: 10px 20px;
            font-size: 16px;
            background-image: linear-gradient(to right, #ffd700, #ffcc52);
            color: #000000;
            border: none;
            font-weight: 600;
            width: 80%;
            border-radius: 50px;
            cursor: pointer;
            margin: 30px 0 20px 0px;
            transition: all 0.3s ease-in-out;
        }

        .btn-premium:hover {
            background-image: linear-gradient(to right, #ffcc52, #ffd700);
        }

        .login-container {
            display: flex;
            text-align: center;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        #lottie-container {
            width: 150px;
            height: 120px;
            position: relative;
        }

        input[type="tel"] {
            width: 100%;
            padding: 5px;
            border-radius: 30px;
            height: 25px;
            margin-bottom: 10px;
            position: relative;
            left: 5px;
            border: none;
            outline: none;
            color: white;
            background-color: #333;
        }

        .form-group {
            display: flex;
            flex-direction: column;
            width: 100%;
            gap: 11px;
        }

        .form-p {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        .line {
            border: 2px solid #3c3c3c;
            width: 100%;
            border-radius: 50px;
            margin: 15px 0 15px 0;
        }

        .tv-alert {
            padding: 0px 10px 0 10px;
            border: 1px solid red;
            border-radius: 5px;
            color: white;
        }

        .tv-alert p {
            font-size: 12px;
        }

    </style>
    <title>Planos</title>
</head>
<body style="background-image: linear-gradient(to right, rgba(0, 0, 0, 86%), transparent), linear-gradient(to left, rgba(0, 0, 0, 86%), transparent), linear-gradient(to top, rgb(0, 0, 0, 0%), transparent), url('/public/assets/images/background.jpg'); background-attachment: fixed; background-size: cover; background-position: center center; height: 100vh;">
<div class="container">
    <div class="login-container">
        <div id="lottie-container"></div>
        <h2>Ative sua assinatura e desfrute de milhares de conteúdos</h2>

        <form class="form-p" action="<?php echo e(route('realizarPagamento')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label for="email">Este email será ativado</label>
                <input type="text" name="name" id="name" class="form-control" value="<?php echo e(Auth::user()->name); ?>" readonly hidden>
                <div style="position: relative; display: inline-block;">
                    <input type="email" name="email" id="email" class="form-control" value="<?php echo e(Auth::user()->email); ?>" readonly>
                </div>
                <input placeholder="+55 Digite seu número de whatsapp" type="tel" id="phone" name="numero" oninput="addCountryCode()" pattern="\+55[0-9]{2}[0-9]{4,5}[0-9]{4}" required title="Digite um número de telefone válido. Exemplo: +5521987654321">
            </div>

            <h3>Escolha um plano</h3>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="plano" id="plano1" value="plano1">
                <label class="form-check-label" for="plano1">15 Dias - R$6,00</label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="plano" id="plano2" value="plano2">
                <label class="form-check-label" for="plano2">30 Dias - R$10,00</label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="plano" id="plano5" value="plano5">
                <label class="form-check-label" for="plano5">60 Dias - R$16,00</label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="plano" id="plano3" value="plano3">
                <label class="form-check-label" for="plano3">90 Dias - R$25,00</label>
            </div>
            <div class="line"></div>
            <div class="form-check-p6">
                <input class="form-check-input" type="radio" name="plano" id="plano6" value="plano6">
                <label class="form-check-label" for="plano6">Canais Ao Vivo - R$15,00/30 Dias</label>
            </div>
            <div class="tv-alert">
                <p>O plano de canais é separado dos planos de filmes e séries!</p>
            </div>
            <button type="submit" class="btn-premium">Assinar</button>
        </form>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bodymovin/5.7.8/lottie.min.js"></script>
<script>
        // Carregue a animação Lottie
        var animation = bodymovin.loadAnimation({
            container: document.getElementById('lottie-container'),
            renderer: 'svg',
            loop: true,
            autoplay: true,
            path: 'https://assets1.lottiefiles.com/packages/lf20_rZQs81.json' // Substitua pelo caminho correto para o arquivo JSON da animação
        });
    </script>

<script>
      document.getElementById('yourFormId').addEventListener('submit', function(e) {
          var phone = document.getElementById('phone').value;
          var phoneRegex = /^[0-9]{2}[0-9]{4,5}[0-9]{4}$/; // Expressão regular para validar o telefone

          if (!phoneRegex.test(phone)) {
              alert('Por favor, insira um número de telefone válido.');
              e.preventDefault(); // Impede o envio do formulário
          }
      });
  </script>


    <script>
      function addCountryCode() {
          var input = document.getElementById('phone');
          var code = '+55';
          if (input.value && input.value.indexOf(code) !== 0) {
              input.value = code + input.value;
          }
      }
    </script>
</body>
</html><?php /**PATH /www/wwwroot/ultraflix.pro/resources/views/layouts/choose_plan.blade.php ENDPATH**/ ?>