<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Favoritos - <?php echo e($settings->app_name ?? 'UltraFlix'); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/lottie-web/5.7.4/lottie.min.js"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
</head>
<body class="min-h-screen mb-10 text-white bg-black font-poppins">
    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container px-4 py-20 mx-auto">
        <h1 class="mb-8 text-3xl font-bold text-center">Meus Favoritos</h1>

        <?php if(session('error')): ?>
            <div class="px-4 py-3 mb-6 text-red-700 bg-red-100 border border-red-400 rounded" role="alert">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('warning')): ?>
            <div class="px-4 py-3 mb-6 text-yellow-700 bg-yellow-100 border border-yellow-400 rounded" role="alert">
                <?php echo e(session('warning')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('success')): ?>
            <div class="px-4 py-3 mb-6 text-green-700 bg-green-100 border border-green-400 rounded" role="alert">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <!-- Tabs -->
        <div class="flex justify-center gap-4 mb-8">
            <button onclick="openCategory(event, 'Filmes')"
                    class="px-6 py-2 transition-colors rounded-full tablinks bg-zinc-800 hover:bg-zinc-700">
                Filmes
            </button>
            <button onclick="openCategory(event, 'Series')"
                    class="px-6 py-2 transition-colors rounded-full tablinks bg-zinc-800 hover:bg-zinc-700">
                Séries
            </button>
            <button onclick="openCategory(event, 'Animes')"
                    class="px-6 py-2 transition-colors rounded-full tablinks bg-zinc-800 hover:bg-zinc-700">
                Animes
            </button>
        </div>

        <!-- Conteúdo das Tabs -->
        <div id="Filmes" class="hidden tabcontent">
            <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
                <?php $__empty_1 = true; $__currentLoopData = $favoriteMovies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <a href="<?php echo e(route('filme.detail', ['id' => $movie->id])); ?>" class="block group">
                        <div class="relative overflow-hidden rounded-lg">
                            <img src="<?php echo e($movie->poster_path); ?>"
                                alt="<?php echo e($movie->title); ?>"
                                class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                            <div class="absolute bottom-0 w-full p-2">
                                <h3 class="text-sm font-semibold truncate"><?php echo e($movie->title); ?></h3>
                                <div class="flex items-center mt-1">
                                    <span class="text-xs text-yellow-500">
                                        <i class="mr-1 fas fa-star"></i><?php echo e(number_format($movie->vote_average, 1)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="flex flex-col items-center justify-center h-64 col-span-full">
                        <div id="lottie-animation-filmes" class="w-40 h-40"></div>
                        <p class="mt-4 text-gray-400">Nenhum filme adicionado aos favoritos</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div id="Series" class="hidden tabcontent">
            <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
                <?php $__empty_1 = true; $__currentLoopData = $favoriteSeries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $series): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <a href="<?php echo e(route('serie.detail', ['id' => $series->id])); ?>" class="block group">
                        <div class="relative overflow-hidden rounded-lg">
                            <img src="<?php echo e($series->poster_path); ?>"
                                alt="<?php echo e($series->name); ?>"
                                class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                            <div class="absolute bottom-0 w-full p-2">
                                <h3 class="text-sm font-semibold truncate"><?php echo e($series->name); ?></h3>
                                <div class="flex items-center mt-1">
                                    <span class="text-xs text-yellow-500">
                                        <i class="mr-1 fas fa-star"></i><?php echo e(number_format($series->vote_average, 1)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="flex flex-col items-center justify-center h-64 col-span-full">
                        <div id="lottie-animation-series" class="w-40 h-40"></div>
                        <p class="mt-4 text-gray-400">Nenhuma série adicionada aos favoritos</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div id="Animes" class="hidden tabcontent">
            <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
                <?php $__empty_1 = true; $__currentLoopData = $favoriteAnimes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $anime): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <a href="<?php echo e(route('anime.detail', ['id' => $anime->id])); ?>" class="block group">
                        <div class="relative overflow-hidden rounded-lg">
                            <img src="<?php echo e($anime->poster_path); ?>"
                                alt="<?php echo e($anime->name); ?>"
                                class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                            <div class="absolute bottom-0 w-full p-2">
                                <h3 class="text-sm font-semibold truncate"><?php echo e($anime->name); ?></h3>
                                <div class="flex items-center mt-1">
                                    <span class="text-xs text-yellow-500">
                                        <i class="mr-1 fas fa-star"></i><?php echo e(number_format($anime->vote_average, 1)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="flex flex-col items-center justify-center h-64 col-span-full">
                        <div id="lottie-animation-animes" class="w-40 h-40"></div>
                        <p class="mt-4 text-gray-400">Nenhum anime adicionado aos favoritos</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Fundo com gradiente -->
    <div class="fixed inset-0 -z-10 bg-gradient-to-br from-zinc-900 to-black"></div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Lottie Animations
            ['filmes', 'series', 'animes'].forEach(type => {
                lottie.loadAnimation({
                    container: document.getElementById(`lottie-animation-${type}`),
                    renderer: 'svg',
                    loop: true,
                    autoplay: true,
                    path: 'https://assets-v2.lottiefiles.com/a/a4c7388c-1150-11ee-a0fa-4b9598be54ec/6NRy3xpNKa.json'
                });
            });

            // Abre a primeira aba por padrão
            document.querySelector(".tablinks").click();
        });

        function openCategory(evt, categoryName) {
            // Esconde todos os conteúdos
            document.querySelectorAll(".tabcontent").forEach(tab => {
                tab.classList.add("hidden");
            });

            // Remove active de todas as tabs
            document.querySelectorAll(".tablinks").forEach(button => {
                button.classList.remove("bg-primary", "text-black");
                button.classList.add("bg-zinc-800", "text-white");
            });

            // Mostra o conteúdo selecionado
            document.getElementById(categoryName).classList.remove("hidden");

            // Marca a tab como ativa
            evt.currentTarget.classList.remove("bg-zinc-800", "text-white");
            evt.currentTarget.classList.add("bg-primary", "text-black");
        }
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/favoritos.blade.php ENDPATH**/ ?>