<!DOCTYPE html>
<html>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<head>
    <title>Animes</title>
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
    <link rel="stylesheet" href="/public/css/web.css">
</head>
<body class="body-fav">

    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container-series">
        <div class="filter">
            <form action="<?php echo e(route('animes.index')); ?>" method="GET">
                <?php echo csrf_field(); ?>
                <h3 for="genre">Animes</h3>
                <div class="dropdown">
                    <div class="dropdown-selected">Todos</div>
                    <div class="dropdown-options">
                        <?php $__currentLoopData = $genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="dropdown-option" data-value="<?php echo e($genre->id); ?>">
                                <?php echo e($genre->name); ?>

                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <select name="genre" id="genre" style="display:none;">
                        <?php $__currentLoopData = $genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option class="genres-itens" value="<?php echo e($genre->id); ?>" <?php echo e(request('genre') == $genre->id ? 'selected' : ''); ?>>
                                <?php echo e($genre->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </form>
        </div>
        <div class="series-list">
            <?php $__currentLoopData = $animes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $anime): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="serie">
                    <a href="<?php echo e(route('anime.detail', $anime->id)); ?>">
                        <figure>
                            <img src="<?php echo e($anime->poster_path); ?>" alt="<?php echo e($anime->name); ?>">
                        </figure>
                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="pagination">
            <span class="pagination-links">
                <?php
                    $genreQueryParam = request('genre') ? '&genre=' . request('genre') : '';
                ?>

                <?php if($animes->currentPage() > 1): ?>
                    <a href="<?php echo e($animes->previousPageUrl()); ?><?php echo e($genreQueryParam); ?>">Anterior</a>
                <?php endif; ?>

                <?php for($i = max(1, $animes->currentPage() - 1); $i <= min($animes->lastPage(), $animes->currentPage() + 1); $i++): ?>
                    <a href="<?php echo e($animes->url($i)); ?><?php echo e($genreQueryParam); ?>" class="<?php echo e($i === $animes->currentPage() ? 'active' : ''); ?>"><?php echo e($i); ?></a>
                <?php endfor; ?>

                <?php if($animes->hasMorePages()): ?>
                    <a href="<?php echo e($animes->nextPageUrl()); ?><?php echo e($genreQueryParam); ?>">Próxima</a>
                <?php endif; ?>
            </span>
        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
        var dropdown = document.querySelector('.dropdown');
        var selected = dropdown.querySelector('.dropdown-selected');
        var options = dropdown.querySelector('.dropdown-options');
        var select = dropdown.querySelector('select');
        
        // Atualizar o texto selecionado com base na opção selecionada no <select>
        function updateSelectedText() {
          var selectedOption = select.options[select.selectedIndex];
          if (selectedOption) {
            selected.textContent = selectedOption.text;
          }
        }
      
        // Inicializar o texto selecionado quando a página carregar
        updateSelectedText();
        
        selected.addEventListener('click', function (e) {
          options.style.display = options.style.display === 'block' ? 'none' : 'block';
          e.stopPropagation();
        });
      
        options.addEventListener('click', function (e) {
          if (e.target.classList.contains('dropdown-option')) {
            selected.textContent = e.target.textContent;
            select.value = e.target.getAttribute('data-value');
            options.style.display = 'none';
            updateSelectedText(); // Atualizar novamente para garantir consistência
            dropdown.closest('form').submit(); // Enviar o formulário ao selecionar um item
          }
        });
      
        document.addEventListener('click', function (e) {
          if (!dropdown.contains(e.target)) {
            options.style.display = 'none';
          }
        });
      });
      </script>
</body>
</html>
<?php /**PATH /home/ultraflix/public_html/ultraflix.pro/resources/views/layouts/pages/animes.blade.php ENDPATH**/ ?>