<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Canais - <?php echo e($settings->app_name ?? 'Ultraflix'); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        poppins: ['Poppins', 'sans-serif'],
                    },
                    colors: {
                        primary: '#2BF14A',
                        'primary-dark': '#24CC3E'
                    }
                }
            }
        }
    </script>
</head>
<body class="min-h-screen mb-10 text-white bg-black font-poppins">
    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container px-4 py-8 mx-auto">
        <!-- Título e Barra de Busca -->
        <div class="max-w-xl mb-8 space-y-4">
            <h1 class="text-2xl font-bold">Canais ao Vivo</h1>
            <div class="relative">
                <input type="text" 
                       id="search-input" 
                       placeholder="Buscar canal..." 
                       class="w-full px-4 py-2 text-white transition-colors rounded-full bg-zinc-800/50 placeholder:text-zinc-400 focus:outline-none focus:ring-2 focus:ring-primary">
                <i class="absolute transform -translate-y-1/2 fas fa-search right-4 top-1/2 text-zinc-400"></i>
            </div>
        </div>

        <!-- Grid de Canais -->
        <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
            <?php $__currentLoopData = $livetv; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $channel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('livetv.show', $channel->id)); ?>" 
                   class="block transition duration-300 transform channel-item hover:scale-105">
                    <div class="relative overflow-hidden rounded-lg aspect-video bg-zinc-800">
                        <img src="<?php echo e($channel->poster_path); ?>" 
                             alt="<?php echo e($channel->name); ?>"
                             class="object-cover w-full h-full"
                             loading="lazy">
                        <div class="absolute inset-0 transition-opacity bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Loading Indicator -->
        <div id="loading-indicator" class="hidden py-8 text-center">
            <div class="inline-block w-8 h-8 border-4 rounded-full animate-spin border-primary border-r-transparent"></div>
        </div>
    </div>

    <!-- Fundo com gradiente -->
    <div class="fixed inset-0 -z-10 bg-gradient-to-br from-zinc-900 to-black"></div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('search-input');
            const channelItems = document.querySelectorAll('.channel-item');

            searchInput.addEventListener('input', function() {
                const searchTerm = this.value.toLowerCase().trim();

                channelItems.forEach(function(item) {
                    const channelName = item.querySelector('h3').textContent.toLowerCase();
                    const shouldShow = channelName.includes(searchTerm);
                    
                    // Usando classes do Tailwind para animação de fade
                    if (shouldShow) {
                        item.classList.remove('hidden');
                        item.classList.add('opacity-100');
                        item.classList.remove('opacity-0');
                    } else {
                        item.classList.add('opacity-0');
                        item.classList.remove('opacity-100');
                        setTimeout(() => {
                            if (!channelName.includes(searchInput.value.toLowerCase().trim())) {
                                item.classList.add('hidden');
                            }
                        }, 200);
                    }
                });
            });
        });
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/layouts/pages/canais.blade.php ENDPATH**/ ?>