<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pesquisa - <?php echo e($settings->app_name); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
    <style>
        .image-wrapper {
            position: relative;
            overflow: hidden;
            border-radius: 0.5rem;
            border: 2px solid transparent;
            transition: border-color 0.3s ease, transform 0.3s ease;
        }

        .image-wrapper:hover {
            border-color: white;
            transform: scale(1.05);
        }
    </style>
</head>
<body class="min-h-screen mb-10 text-white bg-black font-poppins">
    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container px-4 py-20 mx-auto">
        <!-- Search Section -->
        <div class="max-w-2xl mx-auto mb-12">
            <form action="<?php echo e(route('search')); ?>" method="GET" class="relative">
                <input type="text"
                       name="search"
                       id="searchInput"
                       placeholder="O que você está procurando?"
                       class="w-full px-6 py-4 text-lg text-white transition duration-300 border rounded-full bg-zinc-800/50 border-zinc-700 placeholder-zinc-400 focus:outline-none focus:border-primary">
                <i class="absolute -translate-y-1/2 fas fa-search right-6 top-1/2 text-zinc-400"></i>
            </form>
        </div>

        <!-- Real-time Results -->
        <div id="realTimeResults" class="transition-all duration-300"></div>

        <!-- Suggested Content -->
        <div class="space-y-12 suggesteds">
            <!-- Suggested Movies -->
            <div class="suggested-section">
                <h3 class="mb-6 text-2xl font-bold">Filmes Sugeridos</h3>
                <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
                    <?php $__currentLoopData = $suggestedMovies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('filme.detail', ['id' => $movie->id])); ?>" class="block group">
                            <div class="relative overflow-hidden rounded-lg image-wrapper">
                                <img src="<?php echo e($movie->poster_path); ?>"
                                     alt="<?php echo e($movie->name); ?>"
                                     class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105"
                                     loading="lazy">
                                <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                            </div>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <!-- Suggested Series -->
            <div class="suggested-section">
                <h3 class="mb-6 text-2xl font-bold">Séries Sugeridas</h3>
                <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
                    <?php $__currentLoopData = $suggestedSeries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('serie.detail', ['id' => $serie->id])); ?>" class="block group">
                            <div class="relative overflow-hidden rounded-lg image-wrapper">
                                <img src="<?php echo e($serie->poster_path); ?>"
                                     alt="<?php echo e($serie->name); ?>"
                                     class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105"
                                     loading="lazy">
                                <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                            </div>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Fundo com gradiente -->
    <div class="fixed inset-0 -z-10 bg-gradient-to-br from-zinc-900 to-black"></div>

    <script>
        $(document).ready(function() {
            let searchTimeout;

            $('#searchInput').keydown(function(event) {
                if (event.keyCode === 13) {
                    event.preventDefault();
                    return false;
                }
            });

            $('#searchInput').on('input', function() {
                const searchText = $(this).val();
                clearTimeout(searchTimeout);

                searchTimeout = setTimeout(() => {
                    if (searchText.length >= 3) {
                        $.ajax({
                            url: "<?php echo e(route('realtime.search')); ?>",
                            method: 'GET',
                            data: { search: searchText },
                            success: function(response) {
                                $('#realTimeResults').html(response);
                                $('.suggesteds').slideUp(300);
                            }
                        });
                    } else {
                        $('#realTimeResults').empty();
                        $('.suggesteds').slideDown(300);
                    }
                }, 300); // Debounce de 300ms
            });
        });
    </script>
</body>
</html>
<?php /**PATH /home/u446595196/domains/capixabaplay.com.br/public_html/play/resources/views/pesquisa.blade.php ENDPATH**/ ?>