<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
    <link rel="stylesheet" href="/public/css/web.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <title><?php echo e($livetv->name); ?></title>
    <script src='https://ssl.p.jwpcdn.com/player/v/8.9.5/jwplayer.js'></script>
    <script>
        jwplayer.key = "64HPbvSQorQcd52B8XFuhMtEoitbvY/EXJmMBfKcXZQU2Rnn"
    </script>

    <style>
        .additional-info {
            border-radius: 5px;
            border: 2px solid #ffffff26;
            background-color: #00000024;
            padding: 9px;
        }

        .overview-canal {
            width: 100%;
            background-color: #0e0e0e30;
            border-radius: 10px;
            padding: 20px;
        }

        .overview-canal h3 {
            color: var(--main-color);
        }
    </style>
</head>
<body>
<?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<section class="backdrop-tv" style="background-image: linear-gradient(to right, rgb(0 0 0 / 50%), transparent), linear-gradient(to bottom, rgb(0 0 0 / 90%), transparent),linear-gradient(to top, rgb(0 0 0), transparent),
                  url('<?php echo e($livetv->backdrop_path); ?>');
    background-size: cover;
    background-attachment: fixed;
    background-position: center center;">

<div class="container-tv">
    <div class="content-tv" loading="lazy" >
        <img class="tv-img" src="<?php echo e($livetv->poster_path); ?>" alt="">
        <h1><?php echo e($livetv->name); ?></h1>
        <div class="additional-info">
            <p><strong>Categoria:</strong> <?php echo e($livetv->genresname); ?></p>
        </div>

        <div class="overview-canal">
            <h3>Descrição</h3>
            <p><?php echo e($livetv->overview); ?></p>
        </div>

        <?php
        $hoje = \Carbon\Carbon::now();
        ?>

        <?php if(auth()->check() && auth()->user()->tv_access == 1 && auth()->user()->expired_in_tv > $hoje): ?>
            <?php if($livetv->videos->count() > 0): ?>
                <?php $__currentLoopData = $livetv->videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- Contêiner do JW Player -->
                    <div id="player-<?php echo e($loop->index); ?>"></div>
                    <script>
                        jwplayer("player-<?php echo e($loop->index); ?>").setup({
                            file: "<?php echo e($video->link); ?>?token=<?php echo e($token); ?>", // Inclui o token na URL
                            width: "100%",
                            aspectratio: "16:9",
                            primary: "html5",
                            hlshtml: true,
                            autostart: true,
                            liveSyncDuration: 5,
                            hlsjsdefault:true,
                            preload: "none",
                            horizontalVolumeSlider: true,
                            liveTimeout: 0,
                            controls: true,
                            loadAndParseHlsMetadata: true
                        });
                    </script>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <p>Nenhum vídeo disponível.</p>
            <?php endif; ?>
        <?php else: ?>
        <div class="banner">
            <div class="col-b">
                <div>
                    <p>Para assistir aos canais online você precisa de uma assinatura extra. Apenas R$15 mensal</p>
                </div>
                <a href="<?php echo e(route('choose.plan')); ?>">
                    <button class="btn-premium">Assine Canais Agora</button>
                </a>
            </div>
        </div>
        <?php endif; ?>

        <section class="related-canais-slider">
            <div class="prev-next">
                <h2>Canais Relacionados</h2>
                <div class="swiper-button-prev"></div>
                <div class="swiper-button-next"></div>
            </div>
            <div class="swiper-container-canais">
                <div class="swiper-wrapper">
                    <?php $__currentLoopData = $filmesRelacionados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedMovie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="swiper-slide">
                        <a href="<?php echo e(route('livetv.show', ['id' => $relatedMovie->id])); ?>">
                            <img src="<?php echo e($relatedMovie->poster_path); ?>" alt="<?php echo e($relatedMovie->name); ?>">
                        </a>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
    </section>
    </div>
</div>
    
</section>

<script>
    document.addEventListener("DOMContentLoaded", function() {
    document.getElementById('loading-screen').style.display = 'none';
});

window.onload = function() {
    document.getElementById('loading-screen').style.display = 'none';
};
</script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>

<script>
        document.addEventListener("DOMContentLoaded", function() {
            var mySwiper = new Swiper('.swiper-container-canais', {
                freeMode: true,
                breakpoints: {
                    // when window width is >= 320px
                    320: {
                        slidesPerView: 2,
                        spaceBetween: 30
                    },
                    // when window width is >= 480px
                    480: {
                        slidesPerView: 2,
                        spaceBetween: 30
                    },

                    800: {
                        slidesPerView: 3,
                        spaceBetween: 20
                    },

                    980: {
                        slidesPerView: 4,
                        spaceBetween: 20
                    },

                    1200: {
                        slidesPerView: 5,
                        spaceBetween: 20
                    },

                    1300: {
                        slidesPerView: 6,
                        spaceBetween: 20
                    },
                    // when window width is >= 640px
                    1700: {
                        slidesPerView: 7,
                        spaceBetween: 30
                    }
                },
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },

            });
        });
    </script>
</body>
</html>
<?php /**PATH /home/ultraflix/public_html/site.ultraflix.net/resources/views/canal.blade.php ENDPATH**/ ?>