<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="user-id" content="<?php echo e(auth()->user()->id); ?>">
    <meta name="base-url" content="<?php echo e(url('/')); ?>">
    <!-- Adicione metadados para identificação da série -->
    <meta name="serie-id" content="<?php echo e($serie->id); ?>">
    <meta name="serie-type" content="serie">
    <title><?php echo e($serie->name); ?> - <?php echo e($settings->app_name); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <script src='https://ssl.p.jwpcdn.com/player/v/8.6.2/jwplayer.js'></script>
    <script>jwplayer.key = "64HPbvSQorQcd52B8XFuhMtEoitbvY/EXJmMBfKcXZQU2Rnn";</script>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Estilos específicos para o JW Player */
        .jwplayer-container {
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.5);
            border-radius: 8px 8px 0 0;
            overflow: hidden;
        }

        .jw-progress {
            background-color: #2BF14A !important;
        }

        .jw-knob {
            background-color: #2BF14A !important;
        }

        .jw-button-color:hover:not(.jw-toggle) {
            color: #2BF14A !important;
        }

        .player-loading-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.7);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 10;
        }

        .player-controls-bar {
            background-color: #111;
            padding: 12px 15px;
            border-radius: 0 0 8px 8px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .player-notification {
            position: absolute;
            bottom: 80px;
            left: 20px;
            background-color: rgba(0, 0, 0, 0.7);
            color: white;
            padding: 10px 15px;
            border-radius: 4px;
            z-index: 10;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .player-header {
            background-color: #111;
            padding: 10px 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
            border-radius: 8px 8px 0 0;
        }

        .nav-button {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 16px;
            background-color: #292929;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        .nav-button:hover {
            background-color: #3a3a3a;
        }

        .nav-button:disabled {
            opacity: 0.5;
            cursor: not-allowed;
            background-color: #1e1e1e;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        .spinner {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            border: 4px solid rgba(255,255,255,0.1);
            border-top-color: #2BF14A;
            animation: spin 1s linear infinite;
        }

        /* Estilo melhorado para o modal do player */
        .player-modal {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.9);
            z-index: 9999;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .player-modal-content {
            width: 90%;
            max-width: 1200px;
            background-color: #0f0f0f;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.9);
            animation: player-fade-in 0.3s ease-out;
        }

        @keyframes player-fade-in {
            from { opacity: 0; transform: scale(0.98); }
            to { opacity: 1; transform: scale(1); }
        }

        .player-modal-close {
            position: absolute;
            top: 15px;
            right: 15px;
            width: 35px;
            height: 35px;
            background-color: rgba(0, 0, 0, 0.6);
            border-radius: 50%;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            font-size: 18px;
            z-index: 10;
            transition: background-color 0.2s;
        }

        .player-modal-close:hover {
            background-color: rgba(255, 0, 0, 0.7);
        }

        /* Estilos para ocultar a barra de rolagem */
        .scrollbar-hide {
            -ms-overflow-style: none;  /* IE e Edge */
            scrollbar-width: none;     /* Firefox */
            overflow-y: auto;
            overflow-x: auto;
        }

        /* Oculta a barra de rolagem para Chrome, Safari e Opera */
        .scrollbar-hide::-webkit-scrollbar {
            display: none;
        }

        /* Estilo específico para elementos com scroll horizontal */
        .horizontal-scroll {
            overflow-x: auto;
            white-space: nowrap;
            -webkit-overflow-scrolling: touch; /* Rolagem suave em dispositivos iOS */
            scroll-behavior: smooth; /* Rolagem suave em navegadores modernos */
        }

        .image-wrapper {
            position: relative;
            overflow: hidden;
            border-radius: 0.5rem;
            border: 2px solid transparent;
            transition: border-color 0.3s ease, transform 0.3s ease;
        }

        .image-wrapper:hover {
            border-color: white;
            transform: scale(1.05);
        }
    </style>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
    <script>
        // Define a URL base para scripts JavaScript
        window.appUrl = "<?php echo e(url('/')); ?>";

        // Armazenamos dados da série globalmente para acesso fácil pelos scripts
        window.appData = {
            currentSerie: {
                id: <?php echo e($serie->id); ?>,
                type: "serie",
                name: "<?php echo e($serie->name); ?>"
            }
        };
    </script>
</head>
<body class="min-h-screen mb-10 text-white bg-black font-poppins">
    <?php
        use Carbon\Carbon;
        $hoje = Carbon::now();
    ?>

    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Hero Section com Backdrop -->
    <div class="relative min-h-screen">
        <!-- Backdrop Image with Gradient -->
        <div class="fixed top-0 right-0 z-0 w-full bg-center bg-cover h-2/4 md:w-2/4 md:h-2/4"
            style="background-image: url('<?php echo e($serie->backdrop_path); ?>');">
            <!-- Gradient from left to right (less intense on mobile) -->
            <div class="absolute inset-0 bg-gradient-to-r from-black via-black/70 md:via-transparent to-transparent"></div>
            <!-- Gradient from bottom to top -->
            <div class="absolute inset-0 bg-gradient-to-b from-transparent to-black"></div>
        </div>

        <!-- Content -->
        <div class="container relative z-10 px-4 pt-24 pb-12 mx-auto">
            <div class="grid grid-cols-1 gap-8 lg:grid-cols-12">
                <!-- Poster Column -->
                <div class="lg:col-span-4 xl:col-span-3">
                    <div class="flex flex-col items-center">
                        <div class="max-w-sm overflow-hidden rounded-lg shadow-xl w-44 sm:w-72 lg:w-full">
                            <img src="<?php echo e($serie->poster_path); ?>"
                                 alt="<?php echo e($serie->name); ?>"
                                 class="w-full h-auto">
                        </div>

                        <!-- Action Buttons -->
                        <div class="flex items-center justify-center gap-4 mt-6 text-sm lg:text-md">
                            <button id="fav-btn"
                                    class="flex items-center justify-center w-10 h-10 transition-colors rounded-full bg-zinc-800/50 backdrop-blur-sm/50 backdrop-blur-sm hover:bg-zinc-700">
                                <i id="fav-icon" class="far fa-heart"></i>
                            </button>
                            <?php if($serie->preview_path): ?>
                                <button onclick="openTrailerPopup('<?php echo e($serie->preview_path); ?>')"
                                        class="flex items-center gap-2 px-4 py-3 transition-colors rounded-full bg-zinc-800/50 backdrop-blur-sm/50 backdrop-blur-sm hover:bg-zinc-700">
                                    <i class="fab fa-youtube"></i> Trailer
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Info Column -->
                <div class="lg:col-span-8 xl:col-span-9">
                    <h1 class="mb-4 text-2xl font-bold lg:text-4xl"><?php echo e($serie->name); ?></h1>

                    <!-- Rating and Genres -->
                    <div class="flex flex-wrap items-center gap-4 mb-6 text-sm lg:text-lg">
                    <div class="flex items-center gap-2 px-3 py-1 rounded-full bg-zinc-800/50 backdrop-blur-sm">
                            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/69/IMDB_Logo_2016.svg/320px-IMDB_Logo_2016.svg.png" alt="IMDb" class="h-4">
                            <span><?php echo e(number_format($serie->vote_average, 1)); ?></span>
                        </div>
                        <?php $__currentLoopData = $serie->genres->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="px-3 py-1 rounded-full bg-zinc-800/50 backdrop-blur-sm"><?php echo e($genre->name); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Overview with See More/Less functionality -->
                    <div class="mb-6 text-xs lg:text-lg">
                        <p id="short-overview" class="text-gray-300"><?php echo e(\Illuminate\Support\Str::limit($serie->overview, 150)); ?></p>
                        <p id="full-overview" class="hidden text-gray-300"><?php echo e($serie->overview); ?></p>

                        <?php if(strlen($serie->overview) > 150): ?>
                        <button id="toggle-overview" class="mt-2 text-xs font-medium text-primary hover:text-primary-dark">
                            Ver mais
                        </button>
                        <script>
                            document.getElementById('toggle-overview').addEventListener('click', function() {
                                const shortOverview = document.getElementById('short-overview');
                                const fullOverview = document.getElementById('full-overview');
                                const toggleBtn = document.getElementById('toggle-overview');

                                if (shortOverview.classList.contains('hidden')) {
                                    shortOverview.classList.remove('hidden');
                                    fullOverview.classList.add('hidden');
                                    toggleBtn.textContent = 'Ver mais';
                                } else {
                                    shortOverview.classList.add('hidden');
                                    fullOverview.classList.remove('hidden');
                                    toggleBtn.textContent = 'Ver menos';
                                }
                            });
                        </script>
                        <?php endif; ?>
                    </div>

                    <!-- Additional Info -->
                    <div class="flex flex-wrap items-center gap-4 mb-6 text-xs lg:text-lg">
                        <!-- Year -->
                        <div class="flex items-center gap-1 px-4 py-2 rounded-full bg-zinc-800/50 backdrop-blur-sm">
                            <i class="text-gray-400 fas fa-calendar"></i>
                            <span><?php echo e(Carbon::createFromFormat('Y-m-d', $serie->first_air_date)->format('Y')); ?></span>
                        </div>

                        <!-- Episodes -->
                        <div class="flex items-center gap-1 px-4 py-2 rounded-full bg-zinc-800/50 backdrop-blur-sm">
                            <i class="text-gray-400 fas fa-film"></i>
                            <span><?php echo e($serie->seasons->flatMap->episodes->count()); ?> Episódios</span>
                        </div>
                    </div>

                    <!-- Cast -->
                    <div class="mb-8">
                        <h3 class="mb-4 text-lg font-semibold">Elenco</h3>
                        <div class="flex gap-4 pb-4 overflow-x-auto scrollbar-hide">
                            <?php $__currentLoopData = $serie->casters->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $caster): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex-shrink-0 w-16 p-2 lg:w-24">
                                    <img src="<?php echo e($caster->profile_path ?: 'https://cdn-icons-png.flaticon.com/512/1177/1177568.png'); ?>"
                                         alt="<?php echo e($caster->name); ?>"
                                         class="object-cover w-full mb-2 rounded-full image-wrapper aspect-square">
                                    <p class="text-xs text-center"><?php echo e($caster->name); ?></p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Seasons and Episodes -->
            <?php
                $hoje = \Carbon\Carbon::now();
            ?>

            <?php if(auth()->check() && auth()->user()->premuim == 1 && auth()->user()->expired_in > $hoje): ?>
                <div class="mt-4 lg:mt-12">
                    <!-- Season Selector - Versão Horizontal -->
                    <div class="mb-4 lg:mb-6">
                        <div class="flex items-center justify-between mb-3">
                            <h3 class="text-base font-semibold lg:text-2xl">Temporadas</h3>
                            <div class="flex items-center space-x-2">
                                <!-- Botões de scroll movidos para ao lado do texto -->
                                <button id="scroll-left-btn" class="p-2 rounded-full shadow-lg bg-zinc-800/70 hover:bg-zinc-700/90">
                                    <i class="fas fa-chevron-left text-primary"></i>
                                </button>
                                <button id="scroll-right-btn" class="p-2 rounded-full shadow-lg bg-zinc-800/70 hover:bg-zinc-700/90">
                                    <i class="fas fa-chevron-right text-primary"></i>
                                </button>
                            </div>
                        </div>

                        <div class="relative">
                            <div class="flex items-center pb-2 space-x-2 overflow-x-auto scrollbar-hide seasons-scroller" id="seasons-scroller">
                                <?php $__currentLoopData = $serie->seasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <button
                                        class="season-tab whitespace-nowrap px-3 py-1.5 lg:px-4 lg:py-2 rounded-full transition-colors text-sm lg:text-base font-medium
                                               <?php echo e($loop->first ? 'bg-primary text-black' : 'bg-zinc-800/50 backdrop-blur-sm hover:bg-zinc-700 text-white'); ?>"
                                        data-season="<?php echo e($season->season_number); ?>">
                                        <?php echo e($season->name); ?>

                                    </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>

                    <!-- Episodes Grid -->
                    <div class="space-y-6 lg:space-y-8">
                        <?php $__currentLoopData = $serie->seasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="season-content <?php echo e($season->season_number != 1 ? 'hidden' : ''); ?>" id="season_<?php echo e($season->season_number); ?>">
                                <div class="overflow-x-auto episodes-slider scrollbar-hide"
                                     data-season="<?php echo e($season->season_number); ?>">
                                    <div class="flex gap-3 p-4 lg:gap-6 episodes-wrapper" style="user-select: none;">
                                        <?php $__currentLoopData = $season->episodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $episode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div id="episode_<?php echo e($episode->id); ?>"
                                                class="episode-item flex-shrink-0 w-[160px] sm:w-[180px] lg:w-[220px] flex flex-col transition-transform cursor-pointer"
                                                data-season="<?php echo e($season->season_number); ?>"
                                                data-episode="<?php echo e($episode->episode_number); ?>">
                                                <!-- Episode Image with Play Button -->
                                                <div class="relative w-full h-[100px] sm:h-[110px] lg:h-[130px] mb-2 lg:mb-3 image-wrapper">
                                                    <img src="<?php echo e($episode->still_path ?: $serie->backdrop_path); ?>"
                                                        alt="<?php echo e($episode->name); ?>"
                                                        class="object-cover w-full h-full rounded-lg">

                                                    <div class="absolute bottom-2 left-2 play-overlay">
                                                        <div class="flex items-center justify-center transition-transform duration-200 rounded-full w-7 h-7 bg-black/60 backdrop-blur-sm hover:scale-110">
                                                            <i class="text-xs text-white fas fa-play"></i>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Episode Info -->
                                                <h4 class="mb-0.5 lg:mb-1 text-sm lg:text-base font-medium line-clamp-1">
                                                    <?php echo e($episode->episode_number); ?>. <?php echo e($episode->name); ?>

                                                </h4>
                                                <p class="text-xs text-gray-400 lg:text-sm line-clamp-2"><?php echo e($episode->overview); ?></p>

                                                <div class="mt-1.5 lg:mt-2">
                                                    <?php if(count($episode->videos) > 0): ?>
                                                        <span class="px-2 py-0.5 text-xs rounded-full bg-primary text-black">Disponível</span>
                                                    <?php else: ?>
                                                        <span class="px-2 py-0.5 text-xs rounded-full bg-red-500/50 text-white">Indisponível</span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php else: ?>
                <div class="p-4 mt-6 text-center lg:p-8 lg:mt-8 bg-zinc-900/50 rounded-xl lg:rounded-2xl">
                    <p class="mb-3 text-base lg:mb-4 lg:text-lg">Para assistir aos conteúdos você precisa ter uma assinatura ativa!</p>
                    <a href="<?php echo e(route('choose.plan')); ?>"
                       class="inline-block px-6 py-2 text-sm font-medium text-black transition duration-300 rounded-full lg:px-8 lg:py-3 lg:text-base bg-primary hover:scale-105">
                        Assine agora
                    </a>
                </div>
            <?php endif; ?>

            <!-- Related Series Section -->
            <div class="mt-16">
                <h2 class="mb-6 font-bold text-1xl lg:text-3xl">Séries Relacionadas</h2>

                <div class="relative px-4 sm:px-6">
                    <!-- Swiper Container -->
                    <div class="overflow-hidden swiper-container">
                        <div class="p-4 swiper-wrapper">
                            <?php $__currentLoopData = $seriesRelacionadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedSerie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide !w-[160px] sm:!w-[180px] p-1">
                                    <a href="<?php echo e(route('serie.detail', ['id' => $relatedSerie->id])); ?>"
                                       class="block group">
                                        <div class="relative overflow-hidden rounded-lg image-wrapper">
                                            <img src="<?php echo e($relatedSerie->poster_path); ?>"
                                                 alt="<?php echo e($relatedSerie->name); ?>"
                                                 class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105"
                                                 loading="lazy">
                                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                                        </div>
                                    </a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Trailer Modal -->
    <div id="trailerModal" class="fixed inset-0 z-50 hidden bg-black/90">
        <div class="absolute w-full max-w-4xl -translate-x-1/2 -translate-y-1/2 top-1/2 left-1/2">
            <button class="absolute right-0 text-2xl -top-10 close-trailer-modal">&times;</button>
            <div class="aspect-video">
                <iframe id="trailerIframe"
                        class="w-full h-full"
                        frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen></iframe>
            </div>
        </div>
    </div>

    <!-- Server Selection Modal -->
    <div id="serverModal" class="fixed inset-0 z-50 hidden bg-black/80">
        <div class="absolute w-full max-w-md overflow-hidden -translate-x-1/2 -translate-y-1/2 rounded-lg shadow-xl top-1/2 left-1/2 bg-zinc-900">
            <div class="flex items-center justify-between px-6 py-4 border-b border-zinc-800/50 backdrop-blur-sm">
                <h3 class="text-lg font-medium">Selecione o Servidor</h3>
                <button class="text-gray-400 hover:text-white close-server-modal">&times;</button>
            </div>
            <div class="p-6">
                <div id="serverList" class="space-y-2">
                    <!-- Server buttons will be added here dynamically -->
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/js-cookie/3.0.1/js.cookie.min.js"></script>
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>



    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize drag scrolling for all episode sliders
            document.querySelectorAll('.episodes-slider').forEach(slider => {
                makeDraggable(slider);
            });

            function makeDraggable(element) {
                const wrapper = element.querySelector('.episodes-wrapper');
                let isDown = false;
                let startX;
                let scrollLeft;

                // Mouse events
                element.addEventListener('mousedown', (e) => {
                    isDown = true;
                    element.style.cursor = 'grabbing';
                    startX = e.pageX - element.offsetLeft;
                    scrollLeft = element.scrollLeft;
                    e.preventDefault();
                });

                element.addEventListener('mouseleave', () => {
                    isDown = false;
                    element.style.cursor = 'grab';
                });

                element.addEventListener('mouseup', () => {
                    isDown = false;
                    element.style.cursor = 'grab';
                });

                element.addEventListener('mousemove', (e) => {
                    if (!isDown) return;
                    e.preventDefault();
                    const x = e.pageX - element.offsetLeft;
                    const walk = (x - startX) * 2; // Speed multiplier
                    element.scrollLeft = scrollLeft - walk;
                });

                // Touch events for mobile
                element.addEventListener('touchstart', (e) => {
                    isDown = true;
                    startX = e.touches[0].pageX - element.offsetLeft;
                    scrollLeft = element.scrollLeft;
                }, { passive: true });

                element.addEventListener('touchend', () => {
                    isDown = false;
                });

                element.addEventListener('touchmove', (e) => {
                    if (!isDown) return;
                    const x = e.touches[0].pageX - element.offsetLeft;
                    const walk = (x - startX) * 2;
                    element.scrollLeft = scrollLeft - walk;
                }, { passive: true });

                // Handle clicks on episode items separately
                element.querySelectorAll('.episode-item').forEach(item => {
                    item.addEventListener('click', (e) => {
                        if (isDown && Math.abs(element.scrollLeft - scrollLeft) > 5) {
                            // If we've scrolled more than 5px, prevent the click
                            e.stopPropagation();
                            return;
                        }

                        const episode = JSON.parse(item.dataset.episodeData || '{}');
                        if (item.querySelector('.play-overlay')) {
                            openServerSelection(episode);
                        }
                    });

                    // Store episode data as an attribute
                    const season = item.dataset.season;
                    const episodeNum = item.dataset.episode;
                    const episodeId = item.id.replace('episode_', '');

                    // Find the episode data
                    <?php $__currentLoopData = $serie->seasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $season->episodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $episode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            if (episodeId == <?php echo e($episode->id); ?>) {
                                item.dataset.episodeData = JSON.stringify(<?php echo json_encode($episode); ?>);
                            }
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                });
            }

            // Add click event to play overlays
            document.querySelectorAll('.play-overlay').forEach(overlay => {
                overlay.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const episodeItem = overlay.closest('.episode-item');
                    const episodeData = JSON.parse(episodeItem.dataset.episodeData || '{}');
                    openServerSelection(episodeData);
                });
            });
        });
    </script>

    <script>
        // Dropdown functionality for seasons
        document.addEventListener('DOMContentLoaded', function() {
            const menuButton = document.getElementById('seasons-menu-button');
            const dropdown = document.getElementById('seasons-dropdown');
            const selectedSeason = document.getElementById('selected-season');

            // Verificar se os elementos existem antes de adicionar event listeners
            if (menuButton && dropdown && selectedSeason) {
                menuButton.addEventListener('click', function() {
                    dropdown.classList.toggle('hidden');
                });

                document.querySelectorAll('.season-option').forEach(option => {
                    option.addEventListener('click', function(e) {
                        e.preventDefault();
                        const season = this.getAttribute('data-season');
                        selectedSeason.textContent = this.textContent;
                        dropdown.classList.add('hidden');
                        showSeason(season);
                    });
                });

                // Close dropdown when clicking outside
                document.addEventListener('click', function(e) {
                    if (!menuButton.contains(e.target) && !dropdown.contains(e.target)) {
                        dropdown.classList.add('hidden');
                    }
                });
            }

            function showSeason(seasonNumber) {
                const seasons = document.querySelectorAll('.season-content');
                seasons.forEach(season => {
                    if (season.id === `season_${seasonNumber}`) {
                        season.classList.remove('hidden');
                    } else {
                        season.classList.add('hidden');
                    }
                });
            }
        });

        // Server selection functionality
        function openServerSelection(episode) {
            const serverModal = document.getElementById('serverModal');
            const serverList = document.getElementById('serverList');
            serverList.innerHTML = ''; // Limpa a lista anterior

            // Armazena o episódio atual no localStorage para referência
            localStorage.setItem('currentEpisode', JSON.stringify(episode));

            // Para cada vídeo do episódio, cria um botão de servidor
            episode.videos.forEach((video, index) => {
                const serverButton = document.createElement('button');
                serverButton.className = 'w-full text-left px-4 py-3 bg-zinc-800/50 backdrop-blur-sm hover:bg-zinc-700 transition-colors rounded-lg';

                let quality = 'MP4';
                if (video.hls) quality = 'HLS';
                if (video.drm) quality = 'DRM';
                if (video.embed) quality = 'Embed';

                serverButton.innerHTML = `
                    <div class="flex items-center justify-between">
                        <span class="font-medium">Servidor ${index + 1} ${video.server ? '- ' + video.server : ''}</span>
                        <div>
                            <span class="px-2 py-1 text-xs rounded-full bg-zinc-900 text-primary">${quality}</span>
                            ${video.lang ? `<span class="ml-2 text-xs text-gray-400">${video.lang}</span>` : ''}
                        </div>
                    </div>
                `;

                serverButton.onclick = () => {
                    showVideoPlayer(video.link, video.supported_hosts, episode.id, episode);
                };

                serverList.appendChild(serverButton);
            });

            serverModal.style.display = 'block';
        }

        // Eventos para fechar o modal de servidores
        document.querySelector('.close-server-modal').onclick = function() {
            document.getElementById('serverModal').style.display = 'none';
        }

        window.onclick = function(event) {
            const serverModal = document.getElementById('serverModal');
            if (event.target == serverModal) {
                serverModal.style.display = 'none';
            }
        }

        // Função para lidar com a seleção de servidor e abrir o player - Versão corrigida
        const PlayerManager = {
            instance: null,
            currentEpisodeId: null,
            episodeInfo: null,
            volumeLevel: localStorage.getItem('playerVolume') || 80,

            // Inicializa o JW Player com configurações aprimoradas
            initialize(elementId, videoLink, options) {
                this.destroy(); // Limpa qualquer instância anterior

                const config = {
                    file: videoLink,
                    image: options.posterImage || '',
                    width: "100%",
                    aspectratio: "16:9",
                    primary: "html5",
                    controls: true,
                    autostart: true,
                    pipIcon: true,
                    playbackRateControls: [0.5, 1, 1.25, 1.5, 2],
                    volume: parseInt(this.volumeLevel),
                    abouttext: "<?php echo e($settings->app_name); ?> Player",
                    cast: {},
                    skin: {
                        name: "netflix"
                    }
                };

                // Adiciona legendas se disponíveis
                if (options.subtitles && options.subtitles.length > 0) {
                    config.tracks = options.subtitles.map(sub => ({
                        file: sub.link,
                        label: sub.lang || 'Português',
                        kind: 'captions',
                        default: sub.default === 1
                    }));
                }

                // Inicializa o player com as configurações
                this.instance = jwplayer(elementId).setup(config);
                this.currentEpisodeId = options.episodeId;
                this.episodeInfo = options;

                // Adiciona botões de navegação quando o player estiver pronto
                this.instance.on('ready', () => {
                    this.addNavigationButtons();
                });

                return this.instance;
            },

            // Adiciona botões de navegação à barra de controle do player
            addNavigationButtons() {
                if (!this.instance) return;

                const player = this.instance;

                // Adicionamos CSS personalizado para os botões
                const style = document.createElement('style');
                style.textContent = `
                    .jw-custom-nav-button {
                        display: flex !important;
                        align-items: center !important;
                        background-color: rgba(43, 51, 63, 0.7) !important;
                        border-radius: 3px !important;
                        height: 30px !important;
                        padding: 0 10px !important;
                        margin: 0 5px !important;
                        transition: background-color 0.2s !important;
                    }

                    .jw-custom-nav-button:hover {
                        background-color: rgba(43, 51, 63, 0.9) !important;
                    }

                    .jw-custom-nav-button-disabled {
                        opacity: 0.5 !important;
                        cursor: not-allowed !important;
                    }

                    .jw-button-container .jw-custom-nav-label {
                        display: inline-block !important;
                        color: #fff !important;
                        font-size: 12px !important;
                        line-height: 30px !important;
                        margin: 0 4px !important;
                        font-family: Arial, sans-serif !important;
                        vertical-align: middle !important;
                    }

                    .jw-svg-icon-custom {
                        width: 14px !important;
                        height: 14px !important;
                        fill: #fff !important;
                    }

                    .jw-controlbar .jw-custom-icon {
                        display: flex !important;
                        align-items: center !important;
                    }
                `;
                document.head.appendChild(style);

                // Criamos uma função para criar botões personalizados
                const createCustomButton = (iconSvg, label, clickHandler, position = 'left', disabled = false) => {
                    // Criamos um elemento div para o botão
                    const buttonElement = document.createElement('div');
                    buttonElement.className = `jw-custom-nav-button${disabled ? ' jw-custom-nav-button-disabled' : ''}`;

                    // Container para o ícone
                    const iconContainer = document.createElement('div');
                    iconContainer.className = 'jw-custom-icon';
                    iconContainer.innerHTML = iconSvg;

                    // Texto do botão
                    const labelElement = document.createElement('span');
                    labelElement.className = 'jw-custom-nav-label';
                    labelElement.textContent = label;

                    // Montamos o botão conforme a posição desejada
                    if (position === 'left') {
                        buttonElement.appendChild(iconContainer);
                        buttonElement.appendChild(labelElement);
                    } else {
                        buttonElement.appendChild(labelElement);
                        buttonElement.appendChild(iconContainer);
                    }

                    // Adicionamos o evento de click
                    if (!disabled) {
                        buttonElement.addEventListener('click', clickHandler);
                    }

                    return buttonElement;
                };

                // Quando o player estiver pronto, adicionamos os botões
                this.instance.on('ready', () => {
                    try {
                        // Obtemos o container do player
                        const playerContainer = player.getContainer();
                        const controlbar = playerContainer.querySelector('.jw-controlbar');

                        if (!controlbar) return;

                        // Criamos os SVGs para os ícones
                        const prevIconSvg = '<svg class="jw-svg-icon-custom" viewBox="0 0 24 24"><path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path></svg>';
                        const nextIconSvg = '<svg class="jw-svg-icon-custom" viewBox="0 0 24 24"><path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path></svg>';

                        // Verificamos a disponibilidade de episódios
                        const currentSeason = document.querySelector('.season-content:not(.hidden)');
                        const episodes = currentSeason ? Array.from(currentSeason.querySelectorAll('[id^="episode_"]')) : [];
                        const currentIndex = episodes.findIndex(el => el.id === `episode_${this.currentEpisodeId}`);

                        const isPrevDisabled = currentIndex <= 0;
                        const isNextDisabled = currentIndex >= episodes.length - 1;

                        // Criamos os botões personalizados
                        const prevButton = createCustomButton(
                            prevIconSvg,
                            'Anterior',
                            () => { this.navigateToEpisode(-1); },
                            'left',
                            isPrevDisabled
                        );
                        prevButton.id = 'custom-prev-episode';

                        const nextButton = createCustomButton(
                            nextIconSvg,
                            'Próximo',
                            () => { this.navigateToEpisode(1); },
                            'right',
                            isNextDisabled
                        );
                        nextButton.id = 'custom-next-episode';

                        // Encontramos os grupos de controles para posicionar os botões
                        const leftGroup = controlbar.querySelector('.jw-controlbar-left-group');
                        const rightGroup = controlbar.querySelector('.jw-controlbar-right-group');

                        // Inserimos os botões no player
                        if (leftGroup) leftGroup.appendChild(prevButton);
                        if (rightGroup) rightGroup.insertBefore(nextButton, rightGroup.firstChild);
                    } catch (error) {
                        console.error('Erro ao adicionar botões de navegação:', error);
                    }
                });
            },

            // Atualiza o estado visual dos botões de navegação
            updateNavigationButtonsState() {
                try {
                    // Encontra todos os episódios da temporada atual
                    const currentSeason = document.querySelector('.season-content:not(.hidden)');
                    if (!currentSeason) return;

                    const episodes = Array.from(currentSeason.querySelectorAll('[id^="episode_"]'));
                    const currentIndex = episodes.findIndex(el => el.id === `episode_${this.currentEpisodeId}`);

                    if (currentIndex === -1) return;

                    // Obtém os elementos dos botões no DOM
                    const prevButton = document.getElementById('custom-prev-episode');
                    const nextButton = document.getElementById('custom-next-episode');

                    // Atualiza o estado visual dos botões
                    if (prevButton) {
                        if (currentIndex <= 0) {
                            prevButton.classList.add('jw-custom-nav-button-disabled');
                        } else {
                            prevButton.classList.remove('jw-custom-nav-button-disabled');
                        }
                    }

                    if (nextButton) {
                        if (currentIndex >= episodes.length - 1) {
                            nextButton.classList.add('jw-custom-nav-button-disabled');
                        } else {
                            nextButton.classList.remove('jw-custom-nav-button-disabled');
                        }
                    }
                } catch (error) {
                    console.error('Erro ao atualizar estado dos botões de navegação:', error);
                }
            },

            // Navega para o próximo/anterior episódio com melhor tratamento de erros
            navigateToEpisode(direction) {
                try {
                    // Encontra todos os episódios da temporada atual
                    const currentSeason = document.querySelector('.season-content:not(.hidden)');
                    if (!currentSeason) return;

                    const episodes = Array.from(currentSeason.querySelectorAll('[id^="episode_"]'));
                    const currentIndex = episodes.findIndex(el => el.id === `episode_${this.currentEpisodeId}`);

                    if (currentIndex === -1) return;

                    // Verifica se há um episódio para navegar
                    const targetIndex = currentIndex + direction;
                    if (targetIndex < 0 || targetIndex >= episodes.length) {
                        return; // Não há mais episódios nesta direção
                    }

                    // Pega as informações do próximo episódio
                    const nextEpisode = episodes[targetIndex];
                    const episodeData = JSON.parse(nextEpisode.dataset.episodeData || '{}');

                    // Se tem vídeos, pega o primeiro
                    if (episodeData && episodeData.videos && episodeData.videos.length > 0) {
                        // Bandeira para indicar que está navegando entre episódios
                        window.isNavigatingEpisodes = true;

                        // Limpeza prévia de recursos
                        this.destroy();

                        // Remover o modal atual se existir
                        const existingModal = document.getElementById('videoPlayerModal');
                        if (existingModal) {
                            existingModal.remove();
                        }

                        // Restaurar rolagem
                        document.body.style.overflow = '';

                        // Abre o próximo episódio automaticamente com um pequeno delay
                        setTimeout(() => {
                            // Abre o próximo episódio com o primeiro servidor
                            const videoLink = episodeData.videos[0].link;

                            // Carrega o novo episódio
                            try {
                                showVideoPlayer(videoLink, null, episodeData.id, episodeData);
                            } catch (e) {
                                console.error('Erro ao mostrar próximo episódio:', e);
                            }

                            // Resetamos a bandeira
                            window.isNavigatingEpisodes = false;
                        }, 150);
                    }
                } catch (error) {
                    console.error('Erro ao navegar entre episódios:', error);
                    window.isNavigatingEpisodes = false;
                }
            },

            // Configura manipuladores de eventos para o player
            setupEvents(callbacks = {}) {
                if (!this.instance) return;

                const player = this.instance;
                const episodeId = this.currentEpisodeId;

                // Eventos padrão
                player.on('ready', () => {
                    if (callbacks.onReady) callbacks.onReady();

                    // Atualiza o estado dos botões de navegação
                    this.updateNavigationButtonsState();

                    // Recupera posição anterior se existir
                    const savedPosition = localStorage.getItem(`videoPosition-${episodeId}`);
                    if (savedPosition && parseFloat(savedPosition) > 0) {
                        const position = parseFloat(savedPosition);
                        const duration = player.getDuration() || 0;

                        // Só continua se não estiver próximo do fim
                        if (position < (duration * 0.95)) {
                            player.once('play', () => {
                                player.seek(position);
                                this.showNotification(`Continuando de ${this.formatTime(position)}`);
                            });
                        }
                    }
                });

                // Salva volume quando alterado
                player.on('volume', event => {
                    this.volumeLevel = event.volume;
                    localStorage.setItem('playerVolume', event.volume);
                });

                // Salva a posição atual periodicamente
                player.on('time', event => {
                    // Salva a cada 5 segundos
                    if (Math.floor(event.position) % 5 === 0) {
                        localStorage.setItem(`videoPosition-${episodeId}`, event.position);

                        // Callback externo se necessário
                        if (callbacks.onTime) callbacks.onTime(event);
                    }
                });

                // Evento de fullscreen - adicionado para manejar saída do modo tela cheia
                player.on('fullscreen', event => {
                    // Callback externo quando disponível
                    if (callbacks.onFullscreen) callbacks.onFullscreen(event);
                });

                // Indicador de buffer
                player.on('buffer', event => {
                    if (callbacks.onBuffer) callbacks.onBuffer(event);
                });

                // Manipulação de erro
                player.on('error', error => {
                    console.error('JW Player error:', error);

                    // Mostrar uma mensagem amigável ao usuário
                    const errorMessage = document.createElement('div');
                    errorMessage.className = 'absolute inset-0 bg-black/80 flex items-center justify-center';
                    errorMessage.innerHTML = `
                        <div class="p-6 text-center">
                            <div class="mb-3 text-3xl text-red-500"><i class="fas fa-exclamation-triangle"></i></div>
                            <h3 class="mb-2 text-xl font-semibold">Erro ao reproduzir vídeo</h3>
                            <p class="mb-4 text-gray-400">Tente outro servidor ou verifique sua conexão</p>
                            <button class="px-4 py-2 font-medium text-black rounded bg-primary retry-button">
                                Tentar Novamente
                            </button>
                        </div>
                    `;

                    const container = player.getContainer();
                    container.appendChild(errorMessage);

                    // Botão para tentar novamente
                    errorMessage.querySelector('.retry-button').onclick = () => {
                        errorMessage.remove();
                        player.load();
                    };

                    if (callbacks.onError) callbacks.onError(error);
                });

                // Finalização do vídeo
                player.on('complete', () => {
                    localStorage.removeItem(`videoPosition-${episodeId}`);
                    this.showNotification('Episódio concluído');

                    if (callbacks.onComplete) callbacks.onComplete();

                    // Navega automaticamente para o próximo episódio após alguns segundos
                    setTimeout(() => {
                        this.navigateToEpisode(1);
                    }, 3000);
                });
            },

            // Exibe uma notificação temporária sobre o vídeo
            showNotification(message, duration = 3000) {
                if (!this.instance) return;

                const container = this.instance.getContainer();
                const notification = document.createElement('div');
                notification.className = 'player-notification';
                notification.textContent = message;

                container.appendChild(notification);

                // Fade in
                setTimeout(() => {
                    notification.style.opacity = '1';
                }, 10);

                // Fade out e remoção após um tempo
                setTimeout(() => {
                    notification.style.opacity = '0';
                    setTimeout(() => notification.remove(), 300);
                }, duration);
            },

            // Formata segundos para formato de tempo legível
            formatTime(seconds) {
                const mins = Math.floor(seconds / 60);
                const secs = Math.floor(seconds % 60);
                return `${mins}:${secs < 10 ? '0' : ''}${secs}`;
            },

            // Limpa a instância atual para liberar recursos
            destroy() {
                try {
                    if (this.instance) {
                        // Prevenção de erros de fullscreen - método avançado
                        try {
                            // Verificamos se o player está em fullscreen antes de tentar sair
                            const playerContainer = this.instance.getContainer();
                            const isFullscreen = document.fullscreenElement === playerContainer ||
                                                document.webkitFullscreenElement === playerContainer ||
                                                document.mozFullScreenElement === playerContainer ||
                                                document.msFullscreenElement === playerContainer;

                            // Se estiver em fullscreen, primeiro desabilitamos o evento que causa o erro
                            if (isFullscreen) {
                                // Quando estamos saindo devido a navegação, bloqueamos temporariamente eventos de fullscreen
                                document.removeEventListener('fullscreenchange', this.instance._events?.fullscreen);
                                document.removeEventListener('webkitfullscreenchange', this.instance._events?.fullscreen);

                                // Aplicamos um timeout para saír do fullscreen apenas se necessário
                                setTimeout(() => {
                                    try {
                                        if (document.exitFullscreen) {
                                            document.exitFullscreen().catch(() => {});
                                        } else if (document.webkitExitFullscreen) {
                                            document.webkitExitFullscreen();
                                        } else if (document.mozCancelFullScreen) {
                                            document.mozCancelFullScreen();
                                        } else if (document.msExitFullscreen) {
                                            document.msExitFullscreen();
                                        }
                                    } catch (e) {
                                        // Ignoramos completamente quaisquer erros de fullscreen
                                    }
                                }, 10);
                            }
                        } catch (e) {
                            // Ignoramos erros aqui
                        }

                        // Esperamos um pequeno tempo antes de remover o player
                        setTimeout(() => {
                            try {
                                // Remove o player com tratamento de erros
                                if (this.instance && typeof this.instance.remove === 'function') {
                                    this.instance.remove();
                                }
                            } catch (e) {
                                // Ignoramos erros de remoção
                            }

                            this.instance = null;
                            this.currentEpisodeId = null;
                        }, 50);
                    }
                } catch (error) {
                    console.error('Erro ao destruir player:', error);
                }
            },

            // Verifica se navegação está disponível e retorna o estado (para uso externo)
            checkEpisodeNavigation(episodeId, prevButton, nextButton) {
                try {
                    // Encontra todos os episódios da temporada atual
                    const currentSeason = document.querySelector('.season-content:not(.hidden)');
                    if (!currentSeason) {
                        if (prevButton) prevButton.disabled = true;
                        if (nextButton) nextButton.disabled = true;
                        return;
                    }

                    const episodes = Array.from(currentSeason.querySelectorAll('[id^="episode_"]'));
                    const currentIndex = episodes.findIndex(el => el.id === `episode_${episodeId}`);

                    if (currentIndex === -1) {
                        if (prevButton) prevButton.disabled = true;
                        if (nextButton) nextButton.disabled = true;
                        return;
                    }

                    // Habilita/desabilita botões baseado na disponibilidade de episódios
                    if (prevButton) {
                        if (currentIndex <= 0) {
                            prevButton.disabled = true;
                            prevButton.style.opacity = '0.5';
                            prevButton.style.cursor = 'not-allowed';
                        } else {
                            prevButton.disabled = false;
                            prevButton.style.opacity = '1';
                            prevButton.style.cursor = 'pointer';
                        }
                    }

                    if (nextButton) {
                        if (currentIndex >= episodes.length - 1) {
                            nextButton.disabled = true;
                            nextButton.style.opacity = '0.5';
                            nextButton.style.cursor = 'not-allowed';
                        } else {
                            nextButton.disabled = false;
                            nextButton.style.opacity = '1';
                            nextButton.style.cursor = 'pointer';
                        }
                    }
                } catch (error) {
                    console.error('Erro ao verificar navegação entre episódios:', error);
                }
            }
        };

        // Função melhorada para exibir o player de vídeo
        function showVideoPlayer(videoLink, supportedHosts, episodeId, currentEpisode) {
            // Verificar se já existe um modal e removê-lo
            const existingModal = document.getElementById('videoPlayerModal');
            if (existingModal) {
                existingModal.remove();
            }

            // Fecha o modal de seleção de servidor
            const serverModal = document.getElementById('serverModal');
            if (serverModal) {
                serverModal.style.display = 'none';
            }

            // Obter informações do episódio
            const serieName = document.querySelector('h1').textContent;
            const seasonNumber = currentEpisode.season_number;
            const episodeNumber = currentEpisode.episode_number;
            const episodeTitle = `${serieName} - Temporada ${seasonNumber} Episódio ${episodeNumber}`;

            // Criar o modal personalizado
            const modal = document.createElement('div');
            modal.className = 'player-modal';
            modal.id = 'videoPlayerModal';

            const modalContent = document.createElement('div');
            modalContent.className = 'player-modal-content';

            // Botão de fechar
            const closeButton = document.createElement('div');
            closeButton.className = 'player-modal-close';
            closeButton.innerHTML = '<i class="fas fa-times"></i>';
            closeButton.addEventListener('click', () => {
                closeVideoPlayer();
            });

            // Conteúdo do player
            modalContent.innerHTML = `
                <div class="player-header">
                    <h3 class="truncate max-w-[80%] font-medium text-lg">${episodeTitle}</h3>
                    <button id="cast-button" class="p-2 text-white transition-colors rounded hover:bg-zinc-700">
                        <i class="fa-brands fa-chromecast"></i>
                    </button>
                </div>

                <div style="position: relative;">
                    <div id="jwplayer-container" class="jwplayer-container"></div>
                    <div id="player-loading" class="player-loading-overlay">
                        <div class="spinner"></div>
                    </div>
                </div>

                <div class="player-controls-bar">
                    <button id="prev-episode" class="nav-button">
                        <i class="fas fa-chevron-left"></i>
                        <span>Episódio Anterior</span>
                    </button>

                    <div class="text-sm text-gray-400">
                        <span id="current-time">00:00</span> / <span id="duration">00:00</span>
                    </div>

                    <button id="next-episode" class="nav-button">
                        <span>Próximo Episódio</span>
                        <i class="fas fa-chevron-right"></i>
                    </button>
                </div>
            `;

            // Montar o modal
            modal.appendChild(closeButton);
            modal.appendChild(modalContent);
            document.body.appendChild(modal);

            // Impedir rolagem do corpo
            document.body.style.overflow = 'hidden';

            // Adicionar evento de tecla Escape
            const escHandler = (e) => {
                if (e.key === 'Escape' || e.keyCode === 27) {
                    closeVideoPlayer();
                }
            };
            document.addEventListener('keydown', escHandler);

            // Carregar o player
            const loadingIndicator = document.getElementById('player-loading');
            const prevButton = document.getElementById('prev-episode');
            const nextButton = document.getElementById('next-episode');
            const currentTimeEl = document.getElementById('current-time');
            const durationEl = document.getElementById('duration');

            // Carrega os dados de legendas se disponíveis
            let subtitles = [];
            if (currentEpisode.substitles) {
                subtitles = currentEpisode.substitles;
            }

            // Inicializa o player
            const player = PlayerManager.initialize('jwplayer-container', videoLink, {
                episodeId: episodeId,
                posterImage: '<?= $serie->backdrop_path ?>',
                subtitles: subtitles
            });

            // Configura eventos do player
            PlayerManager.setupEvents({
                onReady: function() {
                    if (loadingIndicator) {
                        loadingIndicator.style.display = 'none';
                    }

                    // Auto fullscreen após um pequeno delay
                    setTimeout(() => {
                        try {
                            // Tenta entrar em modo fullscreen com o player
                            player.setFullscreen(true);
                        } catch (e) {
                            console.error('Erro ao tentar abrir em fullscreen:', e);
                        }
                    }, 500);
                },
                onTime: function(event) {
                    // Atualiza o tempo atual
                    currentTimeEl.textContent = PlayerManager.formatTime(event.position);
                    durationEl.textContent = PlayerManager.formatTime(player.getDuration());
                },
                onComplete: function() {
                    // Navegação automática para o próximo episódio é tratada no PlayerManager agora
                },
                onError: function(error) {
                    console.error('Erro no player:', error);
                    if (loadingIndicator) {
                        loadingIndicator.style.display = 'none';
                    }
                },
                // Novo evento para detectar saída do fullscreen
                onFullscreen: function(event) {
                    if (!event.fullscreen && !window.isClosingPlayer) {
                        // Se saiu do fullscreen e não está no processo de fechar o player
                        // Fechar o player e mostrar o modal de seleção de servidor
                        PlayerManager.destroy();
                        document.getElementById('videoPlayerModal').remove();
                        document.body.style.overflow = '';

                        // Abre novamente o modal de seleção de servidores
                        // Recupera o episódio atual do localStorage
                        const currentEpisode = JSON.parse(localStorage.getItem('currentEpisode') || '{}');
                        if (currentEpisode && currentEpisode.id) {
                            openServerSelection(currentEpisode);
                        }
                    }
                }
            });

            // Configuração do botão Chromecast
            document.getElementById('cast-button').onclick = function() {
                window.open('wvc-x-callback://open?url=' + encodeURIComponent(videoLink));
            };

            // Configuração dos botões de navegação externos
            prevButton.onclick = function() {
                PlayerManager.navigateToEpisode(-1);
            };

            nextButton.onclick = function() {
                PlayerManager.navigateToEpisode(1);
            };

            // Em vez de chamar checkEpisodeNavigation, vamos atualizar os botões diretamente
            // Encontra todos os episódios da temporada atual
            try {
                const currentSeason = document.querySelector('.season-content:not(.hidden)');
                if (currentSeason) {
                    const episodes = Array.from(currentSeason.querySelectorAll('[id^="episode_"]'));
                    const currentIndex = episodes.findIndex(el => el.id === `episode_${episodeId}`);

                    if (currentIndex !== -1) {
                        // Atualiza botões externos
                        if (prevButton) {
                            if (currentIndex <= 0) {
                                prevButton.disabled = true;
                                prevButton.style.opacity = '0.5';
                                prevButton.style.cursor = 'not-allowed';
                            } else {
                                prevButton.disabled = false;
                                prevButton.style.opacity = '1';
                                prevButton.style.cursor = 'pointer';
                            }
                        }

                        if (nextButton) {
                            if (currentIndex >= episodes.length - 1) {
                                nextButton.disabled = true;
                                nextButton.style.opacity = '0.5';
                                nextButton.style.cursor = 'not-allowed';
                            } else {
                                nextButton.disabled = false;
                                nextButton.style.opacity = '1';
                                nextButton.style.cursor = 'pointer';
                            }
                        }
                    }
                }
            } catch (error) {
                console.error('Erro ao atualizar botões de navegação:', error);
            }

            // Tentativa de salvar no histórico de visualização apenas se não gerar erro
            try {
                saveWatchingHistory(episodeId);
            } catch (e) {
                console.error('Erro ao salvar histórico:', e);
            }

            // Função para fechar o player
            function closeVideoPlayer() {
                try {
                    // Remover event listener
                    document.removeEventListener('keydown', escHandler);

                    // Garantir que saímos do fullscreen antes de destruir
                    try {
                        if (document.fullscreenElement ||
                            document.webkitFullscreenElement ||
                            document.mozFullScreenElement ||
                            document.msFullscreenElement) {

                            // Usar o método do navegador para sair do fullscreen
                            if (document.exitFullscreen) {
                                document.exitFullscreen().catch(() => {});
                            } else if (document.webkitExitFullscreen) {
                                document.webkitExitFullscreen();
                            } else if (document.mozCancelFullScreen) {
                                document.mozCancelFullScreen();
                            } else if (document.msExitFullscreen) {
                                document.msExitFullscreen();
                            }

                            // Aguarda um momento para garantir que saiu do fullscreen
                            setTimeout(() => {
                                destroyAndRemovePlayer();
                            }, 100);
                        } else {
                            // Se não estiver em fullscreen, destrua diretamente
                            destroyAndRemovePlayer();
                        }
                    } catch (e) {
                        console.error('Erro ao sair do fullscreen:', e);
                        destroyAndRemovePlayer();
                    }
                } catch (error) {
                    console.error('Erro ao fechar player:', error);

                    // Forçar remoção em caso de erro
                    if (document.getElementById('videoPlayerModal')) {
                        document.getElementById('videoPlayerModal').remove();
                    }
                    document.body.style.overflow = '';
                }

                function destroyAndRemovePlayer() {
                    // Liberar recursos do player com um pequeno delay
                    setTimeout(() => {
                        try {
                            // Se o PlayerManager ainda existir
                            if (PlayerManager && PlayerManager.instance) {
                                PlayerManager.destroy();
                            }

                            // Remover o modal
                            if (document.getElementById('videoPlayerModal')) {
                                document.getElementById('videoPlayerModal').remove();
                            }

                            // Restaurar rolagem
                            document.body.style.overflow = '';
                        } catch (e) {
                            console.error('Erro ao remover player:', e);
                            // Garantir que o modal seja removido mesmo em caso de erro
                            if (document.getElementById('videoPlayerModal')) {
                                document.getElementById('videoPlayerModal').remove();
                            }
                            document.body.style.overflow = '';
                        }
                    }, 50);
                }
            }

            // Expor a função de fechamento para uso global
            window.closeVideoPlayer = closeVideoPlayer;
        }

        // Substitua a função de navegação entre episódios para trabalhar com o novo modal
        function navigateToEpisode(currentEpisodeId, direction) {
            try {
                // Se o player estiver ativo, fechá-lo
                if (document.getElementById('videoPlayerModal')) {
                    window.closeVideoPlayer();
                }

                // Encontra todos os episódios da temporada atual
                const currentSeason = document.querySelector('.season-content:not(.hidden)');
                if (!currentSeason) {
                    console.error('Temporada atual não encontrada');
                    return;
                }

                const episodes = Array.from(currentSeason.querySelectorAll('[id^="episode_"]'));
                const currentIndex = episodes.findIndex(el => el.id === `episode_${currentEpisodeId}`);

                if (currentIndex === -1) {
                    console.error('Episódio atual não encontrado', currentEpisodeId);
                    return;
                }

                // Calcula o índice do próximo/anterior episódio
                const targetIndex = currentIndex + direction;
                if (targetIndex >= 0 && targetIndex < episodes.length) {
                    console.log('Navegando para episódio:', episodes[targetIndex].id);

                    // Adicionar um pequeno atraso para garantir que o modal seja fechado
                    setTimeout(() => {
                        // Simula o clique no episódio correspondente
                        episodes[targetIndex].click();
                    }, 300);
                } else {
                    console.log('Não há mais episódios nesta direção');
                }
            } catch (error) {
                console.error('Erro ao navegar entre episódios:', error);
            }
        }

        // Função simplificada para salvar histórico sem depender de uma tabela específica
        function saveWatchingHistory(episodeId) {
            if (!episodeId) return;

            const baseUrl = '<?php echo e(url('/')); ?>';
            const userId = document.querySelector('meta[name="user-id"]').getAttribute('content');

            // Salvamos apenas no localStorage para evitar erros de banco de dados
            const watchHistory = JSON.parse(localStorage.getItem('watchHistory') || '[]');

            // Adiciona o episódio no início do histórico se não existir
            const existingIndex = watchHistory.findIndex(item => item.id === episodeId);
            if (existingIndex >= 0) {
                // Move para o início se já existir
                watchHistory.splice(existingIndex, 1);
            }

            // Adiciona ao início do array
            watchHistory.unshift({
                id: episodeId,
                type: 'serie',
                timestamp: new Date().toISOString(),
                userId: userId
            });

            // Limita o histórico a 50 itens para não sobrecarregar o localStorage
            if (watchHistory.length > 50) {
                watchHistory.pop();
            }

            localStorage.setItem('watchHistory', JSON.stringify(watchHistory));

            // Tenta enviar ao servidor mas não causa erro se falhar
            try {
                fetch(`${baseUrl}/api/history`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({
                        episode_id: episodeId,
                        type: 'serie'
                    })
                }).catch(e => console.log('Erro ao enviar histórico ao servidor, usando apenas localStorage'));
            } catch (e) {
                // Silenciosamente ignora erros aqui
            }
        }

        window.onload = () => {
            const favBtn = document.getElementById('fav-btn');
            if (favBtn) {
                const movieId = parseInt('<?php echo e($serie->id); ?>', 10);
                initializeFavoriteButton(movieId);
            }
        };

        function initializeFavoriteButton(movieId) {
            const baseUrl = '<?php echo e(url('/')); ?>';
            const endpoint = '/serie/isMovieFavorite/' + movieId;
            const fullUrl = baseUrl + endpoint;

            fetch(fullUrl, {
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP error! Status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                updateFavoriteIcon(data.isFavorite);
                document.getElementById('fav-btn').onclick = () => toggleFavorite(movieId, data.isFavorite);
            })
            .catch(error => {
                console.error('Error:', error);
                document.getElementById('fav-btn').onclick = () => toggleFavorite(movieId, false);
            });
        }

        function updateFavoriteIcon(isFavorite) {
            const icon = document.getElementById('fav-icon');
            if (isFavorite) {
                icon.classList.remove('far', 'fa-heart');
                icon.classList.add('fas', 'fa-heart');
            } else {
                icon.classList.remove('fas', 'fa-heart');
                icon.classList.add('far', 'fa-heart');
            }
        }

        function toggleFavorite(movieId, isFavorite) {
            const baseUrl = '<?php echo e(url('/')); ?>';
            const endpoint = isFavorite ? '/serie/removefromfav/' + movieId : '/serie/addtofav/' + movieId;
            const fullUrl = baseUrl + endpoint;

            fetch(fullUrl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                }
            })
            .then(response => response.json())
            .then(data => {
                const newFavoriteState = data.isFavorite;
                updateFavoriteIcon(newFavoriteState);
                document.getElementById('fav-btn').onclick = () => toggleFavorite(movieId, newFavoriteState);
            })
            .catch(error => console.error('Error:', error));
        }

        document.addEventListener("DOMContentLoaded", function() {
            var mySwiper = new Swiper('.swiper-container', {
                freeMode: true,
                arrow: false,
                slidesPerView: 'auto',
                lazyPreloaderClass:'swiper-lazy-preloader',
                breakpoints: {
                    320: {
                        slidesPerView: 3,
                        spaceBetween: 30
                    },
                    480: {
                        slidesPerView: 3,
                        spaceBetween: 30
                    },
                    800: {
                        slidesPerView: 4,
                        spaceBetween: 30
                    },
                    980: {
                        slidesPerView: 5,
                        spaceBetween: 30
                    },
                    1200: {
                        slidesPerView: 6,
                        spaceBetween: 30
                    },
                    1300: {
                        slidesPerView: 7,
                        spaceBetween: 30
                    },
                    1700: {
                        slidesPerView: 10,
                        spaceBetween: 40
                    }
                },

            });

            // Inicialização dos botões de temporada - CÓDIGO CORRIGIDO
            const seasonTabs = document.querySelectorAll('.season-tab');
            seasonTabs.forEach(tab => {
                tab.addEventListener('click', function() {
                    // Remove a classe ativa de todos os botões
                    seasonTabs.forEach(t => {
                        // Corrigido: adicionar classes separadamente
                        t.classList.remove('bg-primary', 'text-black');
                        t.classList.add('bg-zinc-800/50'); // Adicionando uma classe por vez
                        t.classList.add('backdrop-blur-sm');
                        t.classList.add('text-white');
                    });

                    // Adiciona a classe ativa ao botão clicado
                    this.classList.remove('bg-zinc-800/50', 'backdrop-blur-sm', 'text-white');
                    this.classList.add('bg-primary', 'text-black');

                    // Mostra a temporada selecionada
                    const selectedSeasonNumber = this.dataset.season;
                    const seasons = document.querySelectorAll('.season-content');
                    seasons.forEach((season) => {
                        if (season.id === `season_${selectedSeasonNumber}`) {
                            season.classList.remove('hidden');
                        } else {
                            season.classList.add('hidden');
                        }
                    });
                });
            });

            // Adicione estilos para o scrollbar horizontal
            const style = document.createElement('style');
            style.textContent = `
                .seasons-scroller {
                    -ms-overflow-style: none;  /* IE e Edge */
                    scrollbar-width: none;     /* Firefox */
                    scroll-behavior: smooth;
                    -webkit-overflow-scrolling: touch;
                }
                .seasons-scroller::-webkit-scrollbar {
                    display: none;  /* Chrome, Safari e Opera */
                }
            `;
            document.head.appendChild(style);

            // Aplica a classe scrollbar-hide a todos os elementos com overflow-x-auto
            document.querySelectorAll('.overflow-x-auto').forEach(element => {
                element.classList.add('scrollbar-hide');
            });

            // Adicione o código para o scroll horizontal das temporadas em desktop
            const scrollLeftBtn = document.getElementById('scroll-left-btn');
            const scrollRightBtn = document.getElementById('scroll-right-btn');
            const seasonsScroller = document.getElementById('seasons-scroller');

            // Mostrar/ocultar botões de scroll baseado no overflow
            function updateScrollButtonVisibility() {
                if (seasonsScroller.scrollWidth > seasonsScroller.clientWidth) {
                    // Tem overflow, mostra os botões de acordo com a posição do scroll
                    scrollLeftBtn.classList.remove('hidden');
                    scrollRightBtn.classList.remove('hidden');

                    // Oculta o botão de scroll esquerdo se estiver no início
                    if (seasonsScroller.scrollLeft <= 0) {
                        scrollLeftBtn.classList.add('opacity-50', 'cursor-not-allowed');
                    } else {
                        scrollLeftBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                    }

                    // Oculta o botão de scroll direito se estiver no final
                    const maxScrollLeft = seasonsScroller.scrollWidth - seasonsScroller.clientWidth;
                    if (Math.ceil(seasonsScroller.scrollLeft) >= maxScrollLeft) {
                        scrollRightBtn.classList.add('opacity-50', 'cursor-not-allowed');
                    } else {
                        scrollRightBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                    }
                } else {
                    // Não tem overflow, oculta os botões
                    scrollLeftBtn.classList.add('hidden');
                    scrollRightBtn.classList.add('hidden');
                }
            }

            // Inicializa a visibilidade dos botões
            updateScrollButtonVisibility();

            // Evento de redimensionamento da janela
            window.addEventListener('resize', updateScrollButtonVisibility);

            // Evento de scroll
            seasonsScroller.addEventListener('scroll', updateScrollButtonVisibility);

            // Função para scroll suave
            function scrollSmoothly(element, direction) {
                const scrollAmount = 200; // quantidade de pixels para scrollar
                const currentScroll = element.scrollLeft;
                const targetScroll = direction === 'left'
                    ? Math.max(0, currentScroll - scrollAmount)
                    : Math.min(element.scrollWidth - element.clientWidth, currentScroll + scrollAmount);

                element.scrollTo({
                    left: targetScroll,
                    behavior: 'smooth'
                });
            }

            // Eventos de clique nos botões de scroll
            if (scrollLeftBtn) {
                scrollLeftBtn.addEventListener('click', function() {
                    scrollSmoothly(seasonsScroller, 'left');
                });
            }

            if (scrollRightBtn) {
                scrollRightBtn.addEventListener('click', function() {
                    scrollSmoothly(seasonsScroller, 'right');
                });
            }

            // Habilita também navegação com teclas
            seasonsScroller.addEventListener('keydown', function(e) {
                if (e.key === 'ArrowLeft') {
                    scrollSmoothly(seasonsScroller, 'left');
                } else if (e.key === 'ArrowRight') {
                    scrollSmoothly(seasonsScroller, 'right');
                }
            });
        });

        function openTrailerPopup(id) {
            var trailerIframe = document.getElementById('trailerIframe');
            trailerIframe.src = 'https://www.youtube.com/embed/' + id + '?autoplay=1';
            document.getElementById('trailerModal').style.display = 'block';
        }

        var span = document.getElementsByClassName("close-trailer-modal")[0];
        span.onclick = function() {
            var trailerModal = document.getElementById('trailerModal');
            trailerModal.style.display = "none";
            trailerModal.querySelector('iframe').src = '';
        }

        window.onclick = function(event) {
            var trailerModal = document.getElementById('trailerModal');
            if (event.target == trailerModal) {
                trailerModal.style.display = "none";
                trailerModal.querySelector('iframe').src = '';
            }
        }
    </script>
    <script src="<?php echo e(asset('js/custom-player.js')); ?>"></script>
    <script src="<?php echo e(asset('js/player-integration.js')); ?>"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/serie.blade.php ENDPATH**/ ?>