<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Perfil</title>
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
    <link rel="stylesheet" href="/public/css/web.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="body-fav">

<?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container-profile">
    <h2>Olá <?php echo e(session('selected_profile')->name); ?></h2>
    <div class="avatar-container-conta">
        <img class="avatar-image-conta" src="<?php echo e(session('selected_profile')->avatar ?? 'https://prod-ripcut-delivery.disney-plus.net/v1/variant/disney/FE49954B252C628EC809C68832E9137D5926C2085D58A6510F8BBA12933F7B7E/scale?width=300&aspectRatio=1.00&format=png'); ?>" alt="Avatar">
        <div class="avatar-edit-text">Editar Avatar</div>
        <a href="<?php echo e(url('/user/profile/edit/'.session('selected_profile')->id)); ?>">
            <div class="avatar-overlay">
                <i class="fas fa-edit"></i>
            </div>
        </a>
    </div>

    <a href="<?php echo e(route('choose-profile')); ?>">
        <button class="btn-mudar-perfil">Mudar Perfil</button>
    </a>

    <?php if($user->premuim && $user->expired_in > \Carbon\Carbon::now()): ?>
            <div class="subscription-info">
                <h3>Status da Assinatura</h3>
                <span class="crown-icon">&#x1F451;</span>
                Sua conta é premium, válida até <?php echo e(\Carbon\Carbon::parse($user->expired_in)->format('d/m/Y')); ?>

            </div>
        <?php else: ?>
            <div class="subscription-info">
                Você não tem uma assinatura ativa
            </div>
        <?php endif; ?>
    <h3>Editar Informações da Conta</h3>
    <form class="form-profile" method="POST" action="<?php echo e(route('user.profile.update')); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <?php if($errors->any()): ?>
        <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

            <!-- Mostrar mensagem de sucesso se estiver definida -->
        <?php if(session('status')): ?>
            <div class="alert alert-success">
                <?php echo e(session('status')); ?>

            </div>
        <?php endif; ?>

        <!-- Nome -->
        <div class="form-group">
            <label>Nome</label>
            <input id="input-profile" type="text" class="form-control" name="name" value="<?php echo e($user->name); ?>" required>
        </div>

        <!-- Email -->
        <div class="form-group">
            <label>Email</label>
            <input id="input-profile" type="email" class="form-control" name="email" value="<?php echo e($user->email); ?>" required>
        </div>

        <!-- Password -->
        <div class="form-group">
            <label>Nova Senha</label>
            <div class="input-icon-container">
                <input id="password-input" type="password" class="form-control" name="password">
                <i class="fas fa-eye input-icon" onclick="togglePasswordVisibility('password-input', this)"></i>
            </div>
        </div>

        <!-- Confirmar Nova Senha -->
        <div class="form-group">
            <label>Confirmar Nova Senha</label>
            <div class="input-icon-container">
                <input id="confirm-password-input" type="password" class="form-control" name="password_confirmation">
                <i class="fas fa-eye input-icon" onclick="togglePasswordVisibility('confirm-password-input', this)"></i>
            </div>
        </div>

        

        <button type="submit" class="btn-profile">Atualizar Perfil</button>
    </form>
</div>
<script>
    function togglePasswordVisibility(inputId, iconElement) {
    var passwordInput = document.getElementById(inputId);
    if (passwordInput.type === "password") {
        passwordInput.type = "text";
        iconElement.classList.remove("fa-eye");
        iconElement.classList.add("fa-eye-slash");
    } else {
        passwordInput.type = "password";
        iconElement.classList.remove("fa-eye-slash");
        iconElement.classList.add("fa-eye");
    }
}

</script>

</body>
</html><?php /**PATH /home/ultraflix/public_html/ultraflix.pro/resources/views/auth/profile.blade.php ENDPATH**/ ?>