<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e($livetv->name); ?> - <?php echo e($settings->app_name ?? 'Ultraflix'); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <script src='https://ssl.p.jwpcdn.com/player/v/8.9.5/jwplayer.js'></script>
    <script>jwplayer.key = "64HPbvSQorQcd52B8XFuhMtEoitbvY/EXJmMBfKcXZQU2Rnn";</script>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        poppins: ['Poppins', 'sans-serif'],
                    },
                    colors: {
                        primary: '#2BF14A',
                        'primary-dark': '#24CC3E'
                    }
                }
            }
        }
    </script>
</head>
<body class="min-h-screen mb-10 text-white bg-black font-poppins">
    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Hero Section com Backdrop -->
    <div class="relative min-h-screen">
        <!-- Backdrop Image com Gradientes -->
        <div class="fixed inset-0 z-0 bg-center bg-cover"
             style="background-image: url('<?php echo e($livetv->backdrop_path); ?>');">
            <div class="absolute inset-0 bg-gradient-to-r from-black via-black/70 to-transparent"></div>
            <div class="absolute inset-0 bg-gradient-to-t from-black via-black/30 to-transparent"></div>
        </div>

        <!-- Conteúdo Principal -->
        <div class="container relative z-10 px-4 pt-24 pb-12 mx-auto">
            <div class="grid grid-cols-1 gap-8 lg:grid-cols-12">
                <!-- Coluna do Poster -->
                <div class="lg:col-span-4 xl:col-span-3">
                    <div class="flex flex-col items-center">
                        <div class="w-64 max-w-sm overflow-hidden rounded-lg shadow-xl sm:w-72 lg:w-full">
                            <img src="<?php echo e($livetv->poster_path); ?>"
                                 alt="<?php echo e($livetv->name); ?>"
                                 class="w-full h-auto">
                        </div>
                    </div>
                </div>

                <!-- Coluna de Informações -->
                <div class="lg:col-span-8 xl:col-span-9">
                    <h1 class="mb-4 text-4xl font-bold"><?php echo e($livetv->name); ?></h1>

                    <!-- Categoria -->
                    <div class="flex flex-wrap items-center gap-4 mb-6">
                        <span class="px-3 py-1 rounded-full bg-zinc-800/50 backdrop-blur-sm">
                            <?php echo e($livetv->genresname); ?>

                        </span>
                    </div>

                    <!-- Descrição -->
                    <div class="p-6 mb-8 rounded-lg bg-zinc-800/30 backdrop-blur-sm">
                        <h3 class="mb-2 text-lg font-semibold text-primary">Descrição</h3>
                        <p class="text-gray-300"><?php echo e($livetv->overview); ?></p>
                    </div>

                    <?php
                        $hoje = \Carbon\Carbon::now();
                    ?>

                    <!-- Player ou Banner de Assinatura -->
                    <?php if(auth()->check() && auth()->user()->tv_access == 1 && auth()->user()->expired_in_tv > $hoje): ?>
                        <?php if($livetv->videos->count() > 0): ?>
                            <?php $__currentLoopData = $livetv->videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="w-full overflow-hidden rounded-lg aspect-video">
                                    <div id="player-<?php echo e($loop->index); ?>" class="w-full h-full"></div>
                                </div>
                                <script>
                                    jwplayer("player-<?php echo e($loop->index); ?>").setup({
                                        file: "<?php echo e($video->link); ?>?token=<?php echo e($token); ?>",
                                        width: "100%",
                                        aspectratio: "16:9",
                                        primary: "html5",
                                        hlshtml: true,
                                        autostart: true,
                                        liveSyncDuration: 5,
                                        hlsjsdefault: true,
                                        preload: "none",
                                        horizontalVolumeSlider: true,
                                        controls: true,
                                        loadAndParseHlsMetadata: true
                                    });
                                </script>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="p-6 text-center rounded-lg bg-zinc-800/30">
                                <p class="text-lg">Nenhum vídeo disponível no momento.</p>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="p-8 text-center rounded-lg bg-zinc-800/30 backdrop-blur-sm">
                            <p class="mb-4 text-lg">Para assistir aos canais online você precisa de uma assinatura extra. Apenas R$15 mensal</p>
                            <a href="<?php echo e(route('choose.plan')); ?>"
                               class="inline-block px-8 py-3 font-medium text-black transition duration-300 rounded-full bg-primary hover:bg-primary-dark">
                                Assine Canais Agora
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Canais Relacionados -->
            <div class="mt-16">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-2xl font-bold">Canais Relacionados</h2>
                    <div class="flex gap-2">
                        <button class="swiper-button-prev !hidden sm:!flex w-10 h-10 items-center justify-center rounded-full bg-zinc-800/50 backdrop-blur-sm hover:bg-zinc-700">
                            <i class="fas fa-chevron-left"></i>
                        </button>
                        <button class="swiper-button-next !hidden sm:!flex w-10 h-10 items-center justify-center rounded-full bg-zinc-800/50 backdrop-blur-sm hover:bg-zinc-700">
                            <i class="fas fa-chevron-right"></i>
                        </button>
                    </div>
                </div>

                <div class="overflow-hidden swiper-container-canais">
                    <div class="swiper-wrapper">
                        <?php $__currentLoopData = $filmesRelacionados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedMovie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide !w-[160px] sm:!w-[180px]">
                                <a href="<?php echo e(route('livetv.show', $relatedMovie->id)); ?>"
                                   class="block group">
                                    <div class="relative overflow-hidden rounded-lg">
                                        <img src="<?php echo e($relatedMovie->poster_path); ?>"
                                             alt="<?php echo e($relatedMovie->name); ?>"
                                             class="object-cover w-full transition-transform duration-300 aspect-video group-hover:scale-105"
                                             loading="lazy">
                                        <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            new Swiper('.swiper-container-canais', {
                slidesPerView: 'auto',
                spaceBetween: 16,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
                breakpoints: {
                    320: { slidesPerView: 2.2, spaceBetween: 8 },
                    480: { slidesPerView: 3.2, spaceBetween: 12 },
                    640: { slidesPerView: 4.2, spaceBetween: 16 },
                    768: { slidesPerView: 5.2, spaceBetween: 16 },
                    1024: { slidesPerView: 6.2, spaceBetween: 20 },
                    1280: { slidesPerView: 7.2, spaceBetween: 20 }
                }
            });
        });
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/canal.blade.php ENDPATH**/ ?>