<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/public/css/web.css">
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/lottie-web/5.7.4/lottie.min.js"></script>
    <title>Favoritos</title>
    
</head>
<body class="body-fav">

<?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="container-favoritos">
    <h1>Meus Favoritos</h1>

    <div class="tab-fav">
        <button class="tablinks" onclick="openCategory(event, 'Filmes')">Filmes</button>
        <button class="tablinks" onclick="openCategory(event, 'Series')">Séries</button>
        <button class="tablinks" onclick="openCategory(event, 'Animes')">Animes</button>
    </div>

    <div id="Filmes" class="tabcontent">
    <?php $__empty_1 = true; $__currentLoopData = $favoriteMovies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="favoritos-movies">
                <div class="favorito-item">
                    <a href="<?php echo e(route('filme.detail', ['id' => $movie->id])); ?>">
                        <img src="<?php echo e($movie->poster_path); ?>" alt="<?php echo e($movie->title); ?>">
                    </a>
                </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div id="lottie-animation-filmes"></div>
        <?php endif; ?> 
    </div>

    <div id="Series" class="tabcontent">
    <?php $__empty_1 = true; $__currentLoopData = $favoriteSeries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $series): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="favoritos-series">
                <div class="favorito-item">
                    <a href="<?php echo e(route('serie.detail', ['id' => $series->id])); ?>">
                        <img src="<?php echo e($series->poster_path); ?>" alt="<?php echo e($series->title); ?>">
                    </a>
                </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div id="lottie-animation-series"></div>
        <?php endif; ?>
    </div>

    <div id="Animes" class="tabcontent">
        <?php $__empty_1 = true; $__currentLoopData = $favoriteAnimes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $anime): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="favoritos-animes">
                <div class="favorito-item">
                    <a href="<?php echo e(route('anime.detail', ['id' => $anime->id])); ?>">
                        <img src="<?php echo e($anime->poster_path); ?>" alt="<?php echo e($anime->title); ?>">
                    </a>
                </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div id="lottie-animation-animes"></div>
        <?php endif; ?>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        lottie.loadAnimation({
            container: document.getElementById('lottie-animation-filmes'),
            renderer: 'svg',
            loop: true,
            autoplay: true,
            path: 'https://assets-v2.lottiefiles.com/a/a4c7388c-1150-11ee-a0fa-4b9598be54ec/6NRy3xpNKa.json'
        });

        lottie.loadAnimation({
            container: document.getElementById('lottie-animation-series'),
            renderer: 'svg',
            loop: true,
            autoplay: true,
            path: 'https://assets-v2.lottiefiles.com/a/a4c7388c-1150-11ee-a0fa-4b9598be54ec/6NRy3xpNKa.json'
        });

        lottie.loadAnimation({
            container: document.getElementById('lottie-animation-animes'),
            renderer: 'svg',
            loop: true,
            autoplay: true,
            path: 'https://assets-v2.lottiefiles.com/a/a4c7388c-1150-11ee-a0fa-4b9598be54ec/6NRy3xpNKa.json'
        });

        // Abre a primeira aba por padrão
        document.querySelector(".tablinks").click();
    });

</script>

<script>
    function openCategory(evt, categoryName) {
        var i, tabcontent, tablinks;
        tabcontent = document.getElementsByClassName("tabcontent");
        for (i = 0; i < tabcontent.length; i++) {
            tabcontent[i].style.display = "none";
        }

        tablinks = document.getElementsByClassName("tablinks");
        for (i = 0; i < tablinks.length; i++) {
            tablinks[i].className = tablinks[i].className.replace(" active", "");
        }

        document.getElementById(categoryName).style.display = "block";
        evt.currentTarget.className += " active";
    }

    // Abre a primeira aba por padrão
    document.addEventListener("DOMContentLoaded", function() {
        document.querySelector(".tablinks").click();
    });
</script>
</body>
</html>
<?php /**PATH /home/ultraflix/public_html/site.ultraflix.net/resources/views/favoritos.blade.php ENDPATH**/ ?>