<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quem está assistindo ?</title>
    <link rel="stylesheet" href="/public/css/web.css">
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" >
</head>
<body class="body-fav">
<?php if(session('response')): ?>
    <div id="toast" class="toast" ><?php echo e(session('response')['message']); ?></div>

    <script>
        function showToast() {
            var toast = document.getElementById("toast");
            toast.className = "show";
            setTimeout(function(){ toast.className = toast.className.replace("show", ""); }, 5000);
        }

        window.onload = function() {
            showToast();
        };
    </script>
<?php endif; ?>
<div class="container-profilec">
    <div class="row-profiles">
        <div class="col-">
            <div class="card-profiles-1">
                <div class="card-header">Quem está assistindo?</div>
                <div class="card-body">

                <div class="profile-list">
                        <?php $__empty_1 = true; $__currentLoopData = $profiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $profile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="avatar-container">
                                <div id="confirmation-message" class="confirmation-message">
                                    Clique novamente no botão delete se realmente deseja excluir o perfil
                                </div>
                                <a href="<?php echo e(url('/select-profile/'.$profile->id)); ?>" class="btn btn-primary">
                                    <div class="avatar-image">
                                        <img src="<?php echo e(empty($profile->avatar) ? 'https://i.imgur.com/3ibyBNx.png' : $profile->avatar); ?>" alt="Avatar">
                                        <form class="form-delete-p" action="<?php echo e(url('/user/profile/delete/'.$profile->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="delete-icon">
                                                <i class="fa-solid fa-trash" style="color: #0ffe0b;"></i>
                                            </button>
                                        </form>
                                    </div>
                                </a>
                                <div class="avatar-name"><?php echo e($profile->name); ?></div>
                                <div class="action-buttons">
                                    <a href="<?php echo e(url('/user/profile/edit/'.$profile->id)); ?>" class="btn-profiles-editar">Editar</a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="sem-perfil">
                                <p>Você não criou nenhum perfil</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="criar-perfil">
                        <a href="<?php echo e(url('/user/profile/create')); ?>" class="btn-profiles-criar">Criar Perfil</a>
                    </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    var deleteButtons = document.querySelectorAll('.delete-icon');
    var confirmationMessage = document.getElementById('confirmation-message');

    deleteButtons.forEach(function(button) {
        button.addEventListener('click', function(event) {
            event.preventDefault();

            if (button.getAttribute('data-confirm') === 'true') {
                button.closest('form').submit();
            } else {
                button.setAttribute('data-confirm', 'true');
                showConfirmation();
            }
        });
    });

    function showConfirmation() {
        confirmationMessage.style.display = 'block';
        setTimeout(function() {
            confirmationMessage.style.display = 'none';
        }, 10000);  // Hide the message after 3 seconds
    }
</script>

</body>
</html><?php /**PATH /home/ultraflix/public_html/site.ultraflix.net/resources/views/auth/choose-profile.blade.php ENDPATH**/ ?>