<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Ticket #<?php echo e($ticket->id); ?> - <?php echo e(env('app_name')); ?></title>
    <link rel="icon" href="<?php echo e(route('minilogo')); ?>" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="<?php echo e(asset('js/tema.js')); ?>" defer></script>
</head>
<body class="min-h-screen mb-10 text-white bg-black font-poppins">
    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container relative z-10 px-3 pt-20 pb-8 mx-auto lg:px-4 lg:pt-24 lg:pb-12">
        <div class="mb-6 lg:mb-8">
            <a href="<?php echo e(route('support.index')); ?>" class="flex items-center text-xs text-primary hover:text-primary-dark lg:text-base">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 mr-1 lg:w-5 lg:h-5" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd" />
                </svg>
                Voltar para tickets
            </a>
        </div>

        <?php if(session('success')): ?>
            <div class="px-3 py-2 mb-4 text-green-300 border border-green-500 rounded lg:px-4 lg:py-3 lg:mb-6 bg-green-500/20">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <div class="overflow-hidden shadow-lg rounded-xl bg-zinc-900/50">
            <div class="flex flex-col justify-between px-4 py-3 lg:flex-row lg:items-center lg:px-6 lg:py-4 bg-zinc-800/70">
                <h1 class="mb-2 text-base font-bold text-white lg:text-xl lg:mb-0">#<?php echo e($ticket->id); ?> - <?php echo e($ticket->subject); ?></h1>
                <div>
                    <?php if($ticket->status == 'aberto'): ?>
                        <span class="px-2 lg:px-3 py-0.5 lg:py-1 text-xs text-blue-300 rounded-full bg-blue-500/20">Aberto</span>
                    <?php elseif($ticket->status == 'em_andamento'): ?>
                        <span class="px-2 lg:px-3 py-0.5 lg:py-1 text-xs text-yellow-300 rounded-full bg-yellow-500/20">Em andamento</span>
                    <?php elseif($ticket->status == 'resolvido'): ?>
                        <span class="px-2 lg:px-3 py-0.5 lg:py-1 text-xs text-green-300 rounded-full bg-green-500/20">Resolvido</span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="p-4 lg:p-6">
                <div class="mb-6 lg:mb-8">
                    <div class="flex flex-col justify-between mb-2 space-y-2 text-xs text-gray-400 lg:text-xs md:flex-row md:space-y-0">
                        <div>
                            <span>Enviado por: <?php echo e($ticket->user->name); ?></span>
                            <span class="hidden mx-2 md:inline">•</span>
                            <span class="block md:inline"><?php echo e($ticket->created_at->format('d/m/Y H:i')); ?></span>
                        </div>
                        <div>
                            <?php
                                $categories = App\Models\SupportTicket::getCategories();
                            ?>
                            <span>Categoria: <?php echo e($categories[$ticket->category] ?? $ticket->category); ?></span>
                        </div>
                    </div>

                    <div class="p-3 border rounded-lg lg:p-4 bg-zinc-800/30 border-zinc-700">
                        <p class="text-xs whitespace-pre-line lg:text-base"><?php echo e($ticket->message); ?></p>
                    </div>
                </div>

                <?php if($ticket->admin_response): ?>
                    <div class="p-3 mt-6 border rounded-lg lg:p-4 lg:mt-8 border-primary/30 bg-primary/5">
                        <h3 class="mb-2 text-base font-semibold text-white lg:text-lg">Resposta do Suporte</h3>
                        <div class="flex flex-col justify-between mb-2 space-y-2 text-xs text-gray-400 lg:text-xs md:flex-row md:space-y-0">
                            <div>
                                <span>Respondido por: <?php echo e($ticket->admin->name ?? 'Administrador'); ?></span>
                                <span class="hidden mx-2 md:inline">•</span>
                                <span class="block md:inline"><?php echo e($ticket->updated_at->format('d/m/Y H:i')); ?></span>
                            </div>
                        </div>

                        <div class="p-3 mt-2 border rounded-lg lg:p-4 bg-zinc-800/30 border-zinc-700/50">
                            <p class="text-xs whitespace-pre-line lg:text-base"><?php echo e($ticket->admin_response); ?></p>
                        </div>
                    </div>
                <?php elseif($ticket->status != 'resolvido'): ?>
                    <div class="p-4 mt-4 text-center rounded-lg lg:p-6 lg:mt-6 bg-zinc-800/30">
                        <p class="text-xs text-gray-400 lg:text-base">
                            <i class="mr-1 lg:mr-2 fas fa-info-circle"></i>
                            Aguardando resposta da nossa equipe. Você receberá uma notificação quando houver atualizações.
                        </p>
                    </div>
                <?php endif; ?>

                <?php if($ticket->status == 'resolvido'): ?>
                    <div class="p-3 mt-6 text-center border rounded-lg lg:p-4 lg:mt-8 border-green-500/30 bg-green-500/5">
                        <p class="text-xs text-green-300 lg:text-base">
                            <i class="mr-1 lg:mr-2 fas fa-check-circle"></i>
                            Este ticket foi marcado como resolvido.
                        </p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\ultraflix\resources\views/support/show.blade.php ENDPATH**/ ?>