<!DOCTYPE html>
<html>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<head>
    <title>Séries</title>
    <link rel="stylesheet" href="/public/css/web.css">
    <link rel="icon" href="/public/api/image/minilogo" type="image/x-icon">
</head>
<body class="body-fav">

    <?php echo $__env->make('layouts._partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container-series">
        <div class="filter">
            <form action="<?php echo e(route('series.index')); ?>" method="GET">
                <?php echo csrf_field(); ?>
                <h3 for="genre">Séries</h3>
                <div class="dropdown">
                    <div class="dropdown-selected">Todos</div>
                    <div class="dropdown-options">
                        <?php $__currentLoopData = $genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="dropdown-option" data-value="<?php echo e($genre->id); ?>">
                                <?php echo e($genre->name); ?>

                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <select name="genre" id="genre" style="display:none;">
                        <?php $__currentLoopData = $genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option class="genres-itens" value="<?php echo e($genre->id); ?>" <?php echo e(request('genre') == $genre->id ? 'selected' : ''); ?>>
                                <?php echo e($genre->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </form>
        </div>
        <div class="series-list">
            <?php $__currentLoopData = $series; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="serie">
                    <a href="<?php echo e(route('serie.detail', $serie->id)); ?>">
                        <figure>
                            <img src="<?php echo e($serie->poster_path); ?>" alt="<?php echo e($serie->name); ?>">
                        </figure>
                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="pagination">
            <span class="pagination-links">
                <?php
                    $genreQueryParam = request('genre') ? '&genre=' . request('genre') : '';
                ?>

                <?php if($series->currentPage() > 1): ?>
                    <a href="<?php echo e($series->previousPageUrl()); ?><?php echo e($genreQueryParam); ?>">Anterior</a>
                <?php endif; ?>

                <?php for($i = max(1, $series->currentPage() - 1); $i <= min($series->lastPage(), $series->currentPage() + 1); $i++): ?>
                    <a href="<?php echo e($series->url($i)); ?><?php echo e($genreQueryParam); ?>" class="<?php echo e($i === $series->currentPage() ? 'active' : ''); ?>"><?php echo e($i); ?></a>
                <?php endfor; ?>

                <?php if($series->hasMorePages()): ?>
                    <a href="<?php echo e($series->nextPageUrl()); ?><?php echo e($genreQueryParam); ?>">Próxima</a>
                <?php endif; ?>
            </span>
        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
        var dropdown = document.querySelector('.dropdown');
        var selected = dropdown.querySelector('.dropdown-selected');
        var options = dropdown.querySelector('.dropdown-options');
        var select = dropdown.querySelector('select');
        
        // Atualizar o texto selecionado com base na opção selecionada no <select>
        function updateSelectedText() {
          var selectedOption = select.options[select.selectedIndex];
          if (selectedOption) {
            selected.textContent = selectedOption.text;
          }
        }
      
        // Inicializar o texto selecionado quando a página carregar
        updateSelectedText();
        
        selected.addEventListener('click', function (e) {
          options.style.display = options.style.display === 'block' ? 'none' : 'block';
          e.stopPropagation();
        });
      
        options.addEventListener('click', function (e) {
          if (e.target.classList.contains('dropdown-option')) {
            selected.textContent = e.target.textContent;
            select.value = e.target.getAttribute('data-value');
            options.style.display = 'none';
            updateSelectedText(); // Atualizar novamente para garantir consistência
            dropdown.closest('form').submit(); // Enviar o formulário ao selecionar um item
          }
        });
      
        document.addEventListener('click', function (e) {
          if (!dropdown.contains(e.target)) {
            options.style.display = 'none';
          }
        });
      });
      </script>
</body>
</html>
<?php /**PATH /home/ultraflix/public_html/ultraflix.pro/resources/views/layouts/pages/series.blade.php ENDPATH**/ ?>