
<?php
// Obtém os dados
$dados = [
    'status' => 'success',
    'data' => [
        'count' => [
            'movies' => DB::table('movies')->count(),
            'series' => DB::table('series')->count(),
            'animes' => DB::table('animes')->count(),
            'users' => DB::table('episodes')->count(),
            'users' => DB::table('episodes')->count(),
            'animesep' => DB::table('anime_episodes')->count()
        ]
    ]
];

// Converte os dados em formato JSON
$jsonData = json_encode($dados);
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link rel="icon" href="https://ultraflix.net/wp-content/uploads/2023/02/cropped-favicon-32x32.png" type="image/x-icon">
    <title>Ativar Assinatura</title>
    
    <style>
        /* Estilos CSS */
        html, body {
            height: 100%;
            margin: 0;
            padding: 0;
            overflow: auto;
        }

        body {
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #000;
            font-family: 'Lucida Sans', 'Lucida Sans Regular', 'Lucida Grande', 'Lucida Sans Unicode', Geneva, Verdana, sans-serif;
            color: #f9f9f9;
            background-image: url(https://f005.backblazeb2.com/file/gmutxflix/src/bgggggo-22.jpg);
            background-repeat: no-repeat;
            background-size: cover;
        }

        .container {
            display: flex;
            flex-direction: column;
            align-items: center;
            width: 100%;
            height: auto;
            padding: 20px;
            margin-bottom: 20px;
            margin-left: 2px;
            margin-top: 29px;
            box-sizing: border-box;
            border-radius: 30px;
            
            
        }

        h2 {
            font-size: 35px;
            font-weight: 800;
            margin-bottom: 10px;
        }
        
        span {
            font-size: 18px;
            font-weight: 700;
            margin-top: 25px;
            text-align: center;
        }
        
        .spanpag {
            font-size: 14px;
            font-weight: 700;
            margin-top: 25px;
            margin-bottom: 10px;
            color: #ff0000;
            text-align: center;
        }
        
        form {
            margin-top: 20px;
            margin-left: 8px;
            display: inline-grid;
        }
        
        input[type="email"] {
            width: 310px;
            padding: 5px;
            border-radius: 30px;
            height: 25px;
            margin-bottom: 10px;
            position: relative;
            left: 5px;
            border:none;
        }
        
        input::placeholder {
            font-size: 14px;
        }
        
        input::placeholder {
            opacity: 1;
            transition: opacity 0.3s;
        }
        
        input:focus::placeholder {
            opacity: 0;
        }
        
        input[type="email"]:focus {
            outline: none;
        }

        .pay {
        background: hsl(119.08deg 100% 50%);
        padding: 16px 24px;
        position: relative;
        height: 100%;
        width: 102%;
        top: 10px;
        color: white;
        font-size: 16px;
        font-weight: 700;
        border: none;
        border-radius: 32px;

        &::after {
        position: absolute;
        content: "";
        top: 1px;
        left: -16px;
        right: 0px;
        z-index: -3;
        height: 95%;
        width: 110%;
        transform: scale(0.9) translateZ(0px);
        filter: blur(21px);
        background: linear-gradient(to left, rgb(96, 255, 87), rgb(76, 228, 66), rgb(61, 196, 45), rgb(28, 155, 7), rgb(13, 165, 11), rgb(17, 155, 15), rgb(88, 196, 45), rgb(66, 228, 78), rgb(105, 255, 87)) 0% 0% / 200% 200%;
        animation: 1.75s ease-in-out 0s infinite normal none running animateGlow;
          }
        }
        
        @keyframes animateGlow {
          0% {
            background-position: 0% 50%;
          }
          100% {
            background-position: 200% 50%;
          }
        }
        
        #lottie-container {
            width: 200px;
            height: 200px;
            position: relative;
            margin-top: 482px;
            margin-bottom: -31px;
        }
        
        #lottie-containerd {
            width: 100px;
            height: 100px;
            position: relative;
            margin-top: 10px;
            margin-bottom: -15px;
        }

        /* Estilos para dispositivos móveis */
        
        
        .box {
            position: relative;
            top: 27%;
            left: 58%;
            border-radius: 30px;
            transform: translate(-50%, -50%);
        }
        
        .box select {
            background-color: #0000006b;
            color: #0dfd00;
            padding: 12px;
            width: 250px;
            border-radius: 30px;
            border: 1px solid #0dfd00;
            font-size: 20px;
            box-shadow: 0 5px 25px rgba(0, 0, 0, 0.2);
            -webkit-appearance: button;
            appearance: button;
            outline: none;
        }
        
        .box::before {
          font-family: 'Lucida Sans', 'Lucida Sans Regular', 'Lucida Grande', 'Lucida Sans Unicode', Geneva, Verdana, sans-serif;
          position: absolute;
          top: 0;
          right: 0;
          width: 20%;
          height: 100%;
          text-align: center;
          font-size: 28px;
          line-height: 45px;
          color: rgba(255, 255, 255, 0.5);
          background-color: rgba(255, 255, 255, 0.1);
          pointer-events: none;
        }
        
        .box:hover::before {
          color: rgba(255, 255, 255, 0.6);
          background-color: rgba(255, 255, 255, 0.2);
        }
        
        .box select option {
          padding: 30px;
        }
        
        strong {
            color:#0dfd00;
        }
        
        .pixav {
            border-radius: 30px;
            border: 1px solid #eb2828;
            margin-top: 25px;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        
        .pixaviso {
            padding: 6%;
            text-align: center;
            font-size: 18px;
            margin: -2%;
        }
        
        @import url("https://fonts.googleapis.com/css?family=Roboto:400,400i,700");
        
        .accordion-wrapper {
          display: block;
          box-shadow: 0px 2px 4px 0px rgba(0,0,0,0.2);
          max-width: 500px;
          margin: 0 auto;
          margin-top: 12px;
          margin-bottom: 12px;
        }
        
        .accordion + .title {
          user-select: none;
          cursor: pointer;
          display: flex;
          align-items: center;
          justify-content: space-between;
          padding: 8px;
          background: #161616;
          border-radius: 30px;
          position: relative;
          z-index: 99;
          border: 1px solid #0dfd00;
        }
        
        .accordion ~ .title strong {
          line-height: 24px;
          color: white;
          margin-left: 7px;
        }
        
        .accordion ~ .title .side-icon {
          display: block;
        }
        
        .accordion:checked ~ .title .side-icon {
          display: none;
        }
        
        .accordion ~ .title .down-icon {
          display: none;
        }
        
        .accordion:checked ~ .title .down-icon {
          display: block;
        }
        
        .accordion ~ .content {
            display: none;
            padding: 15px;
            position: relative;
            cursor: pointer;
            margin-top: -27px;
            border-radius: 20px;
            background-color: #1a1a1a;
            border: 1px solid #0dfd00;
        }
        
        .accordion:checked ~ .content {
          display: block;
        }
        
        .faq {
            width:100%;
            margin-top: 40px;
        }
        
        .atenc {
            color:#eb2828;
            font-size: 22px;
        }
        
        .espaco {
            margin-top: 70px;
            font-size: 13px;
            text-align: center;
        }
        
        .conteinerm {
            display: flex;
            flex-direction: column;
            align-items: center;
            width: 100%;
            height: auto;
            padding: 12px;
            margin-bottom: -10px;
            margin-left: 2px;
            margin-top: 50px;
            box-sizing: border-box;
            backdrop-filter: blur(15px);
            border-radius: 30px;
            background-color: #ffffff1c;
        }
        
        .conteinerm h1 {
            font-size:18px;
        }
        
        .conteinerm span {
            color:#0dfd00;
            font-size: 15px;
            font-family: 'Lucida Sans', 'Lucida Sans Regular', 'Lucida Grande', 'Lucida Sans Unicode', Geneva, Verdana, sans-serif;
        }
        .conteinerm p {
            font-family: 'Lucida Sans', 'Lucida Sans Regular', 'Lucida Grande', 'Lucida Sans Unicode', Geneva, Verdana, sans-serif;
        }
        
        
    </style>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bodymovin/5.7.8/lottie.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" integrity="sha384-pzjw8IaBJs2Ig+B6D7HztCx2yL/RD8KvcYP5G+A3Rk0U+8Y+TEVd6/Qm16SEx1vl" crossorigin="anonymous">

    <script>
        // Obtém os dados JSON do PHP
        var jsonData = <?php echo $jsonData; ?>;

        // Função para atualizar os elementos na página com os dados
        function atualizarDados() {
            var moviesCount = document.getElementById('moviesCount');
            var seriesCount = document.getElementById('seriesCount');
            var animesCount = document.getElementById('animesCount');
            var usersCount = document.getElementById('usersCount');
            var animesEpCount = document.getElementById('animesEpCount');

            moviesCount.innerText = jsonData.data.count.movies;
            seriesCount.innerText = jsonData.data.count.series;
            animesCount.innerText = jsonData.data.count.animes;
            usersCount.innerText = jsonData.data.count.users;
            animesEpCount.innerText = jsonData.data.count.animesep;
        }

        // Atualiza os dados assim que a página é carregada
        window.onload = atualizarDados;
    </script>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="bcontainer">
    
    <div class="container">
        <div id="lottie-container"></div>
        <h2>Ativar Assinatura</h2>
        
        
        <span>Escolha um plano</span>

        <form action="<?php echo e(route('realizarPagamento')); ?>" method="POST">
            
            
            <div class="box" required>
              <select name="plano">
                <option value="plano1">R$6 - 15 dias</option>
                <option value="plano2">R$10 - 30 dias</option>
                <option value="plano3">R$25 - 90 dias</option>
            </select>
            </div>
            
            <?php echo csrf_field(); ?>
            <span class="spanpag">Atenção! Digite o seu email cadastrado no app!!</span>
            <input placeholder="Digite o email da sua conta Ultraflix" type="email" name="email" required>
            <button class="pay" type="submit">Realizar Pagamento</button>
        </form>
        
        <div class="conteinerm">
                <h1>Você terá acesso a:</h1>
                <p><i class="fas fa-film"></i> <span id="moviesCount"></span> Filmes</p>
                <p><i class="fas fa-tv"></i> <span id="seriesCount"></span> Séries</p>
                <p><i class="fas fa-tv"></i> <span id="animesCount"></span> Animes</p>
                <p><i class="fas fa-video"></i> <span id="usersCount"></span> Episódios de Séries</p>
                <p><i class="fas fa-video"></i> <span id="animesEpCount"></span> Episódios de Animes</p>
            </div>
            
        <div class="faq">
            
            <label class="accordion-wrapper">
              <input type="checkbox" class="accordion" hidden />
              <div class="title">
                <strong>Como Ativar ?</strong>
                <svg viewBox="0 0 256 512" width="12" title="angle-right" class="side-icon" fill="white">
                  <path d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z" />
                </svg>
                <svg viewBox="0 0 320 512" height="24" title="angle-down" class="down-icon" fill="white">
                  <path d="M143 352.3L7 216.3c-9.4-9.4-9.4-24.6 0-33.9l22.6-22.6c9.4-9.4 24.6-9.4 33.9 0l96.4 96.4 96.4-96.4c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9l-136 136c-9.2 9.4-24.4 9.4-33.8 0z" />
                </svg>
              </div>
              <div class="content">
                <p>Apenas crie uma conta no aplicativo usando seu email, então digite seu email no campo informado acima e depois faça o pagamento no Mercado Pago. Leia o aviso para pagamentos com a opção Pix no Mercado Pago.</p>
              </div>
            </label>
                <label class="accordion-wrapper">
              <input type="checkbox" class="accordion" hidden />
              <div class="title">
                <strong>Demora para ativar ?</strong>
                <svg viewBox="0 0 256 512" width="12" title="angle-right" class="side-icon" fill="white">
                  <path d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z" />
                </svg>
                <svg viewBox="0 0 320 512" height="24" title="angle-down" class="down-icon" fill="white">
                  <path d="M143 352.3L7 216.3c-9.4-9.4-9.4-24.6 0-33.9l22.6-22.6c9.4-9.4 24.6-9.4 33.9 0l96.4 96.4 96.4-96.4c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9l-136 136c-9.2 9.4-24.4 9.4-33.8 0z" />
                </svg>
              </div>
              <div class="content">
                <p>Não. Assim que o pagamento for realizado com sucesso sua assinatura será ativada instantaneamente.</p>
              </div>
            </label>
            <label class="accordion-wrapper">
              <input type="checkbox" class="accordion" hidden />
              <div class="title">
                <strong>Possui Fidelidade ?</strong>
                <svg viewBox="0 0 256 512" width="12" title="angle-right" class="side-icon" fill="white">
                  <path d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z" />
                </svg>
                <svg viewBox="0 0 320 512" height="24" title="angle-down" class="down-icon" fill="white">
                  <path d="M143 352.3L7 216.3c-9.4-9.4-9.4-24.6 0-33.9l22.6-22.6c9.4-9.4 24.6-9.4 33.9 0l96.4 96.4 96.4-96.4c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9l-136 136c-9.2 9.4-24.4 9.4-33.8 0z" />
                </svg>
              </div>
              <div class="content">
                <p>Não, o sistema não cobra automaticamente todos os meses, quando sua assinatura terminar você precisa vir aqui e ativar novamente.</p>
              </div>
            </label>
        </div>
        
            <div class="espaco">
                <p>Ultraflix 2023 - Todos os direitos reservados.</p>
            </div>
    </div>
    
    <script>
        // Carregue a animação Lottie
        var animation = bodymovin.loadAnimation({
            container: document.getElementById('lottie-container'),
            renderer: 'svg',
            loop: true,
            autoplay: true,
            path: 'https://assets1.lottiefiles.com/packages/lf20_rZQs81.json' // Substitua pelo caminho correto para o arquivo JSON da animação
        });
    </script>
    
    <script>
        // Carregue a animação Lottie
        var animation = bodymovin.loadAnimation({
            container: document.getElementById('lottie-containerd'),
            renderer: 'svg',
            loop: true,
            autoplay: true,
            path: 'https://assets4.lottiefiles.com/packages/lf20_IJ3W75JAEG.json' // Substitua pelo caminho correto para o arquivo JSON da animação
        });
    </script>
</body>
</html>
<?php /**PATH /home/ultraflix/public_html/site.ultraflix.net/resources/views/pagamento-p.blade.php ENDPATH**/ ?>