<?php

use App\Http\Controllers\MovieController;
use App\Http\Controllers\AtivarController;
use App\Http\Controllers\MercadoPagoController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\GenreController;
use App\Http\Controllers\SerieController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Auth\LoginController;
use App\Http\Controllers\Api\Auth\RegisterController;
use App\Http\Controllers\InicioController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;
use Symfony\Component\HttpFoundation\RedirectResponse;
use App\Http\Controllers\LivetvController;
use App\Http\Controllers\MovieVideoController;
use App\Http\Controllers\WebhookMercadoPagoController;
use App\Http\Controllers\FlussonicAuthController;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\ContinueWatchingController;
use Illuminate\Http\Request;
use App\Http\Controllers\FileController;
use App\Http\Controllers\SCloudController;
use App\Http\Controllers\VideoLinkController;
use App\Http\Controllers\CaktoWebhookController;
use App\Http\Controllers\SuitPayController;
use App\Http\Controllers\DeviceController;
use App\Http\Controllers\SqlDownloadController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\PaggueController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

Route::get('/ml', function () {
    return view('ml');
})->name('ml');

Route::get('/filmes/export-tmdb', [MovieController::class, 'exportTmdbIds']);

Route::any('/teste-create-user', [CaktoWebhookController::class, 'testeCreateUser']);
Route::post('/cakto-webhook', [CaktoWebhookController::class, 'handle']);

Route::get('/export-animes-video-links', [VideoLinkController::class, 'exportAnimesWithoutVideoLink'])->name('export-animes-video-links');
Route::get('/export-series-video-links', [VideoLinkController::class, 'exportSeriesWithoutVideoLink'])->name('export-series-video-links');
Route::get('/export-movies-video-links', [VideoLinkController::class, 'exportMoviesWithoutVideoLink'])->name('export-movies-video-links');

Route::get('/users/whatsapp', [UserController::class, 'usersWithWhatsapp']);
Route::get('/users/export', [UserController::class, 'exportUsersWithWhatsapp']);

Route::get('/files', [FileController::class, 'listFiles']);
Route::get('/pegar-emails', 'UserController@exportLatestEmails');

Route::get('/webhook-tribopay', 'WebhookController@tribopay');

Route::get('/dl', function (Request $request) {
    $url = 'https://f003.backblazeb2.com/file/utxgtx/teste-beta-ultraflix-app.apk';

    // Iniciar uma sessão cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    $response = curl_exec($ch);
    curl_close($ch);

    // Definir cabeçalhos para forçar o download
    return response($response, 200, [
        'Content-Type' => 'application/vnd.android.package-archive',
        'Content-Disposition' => 'attachment; filename="teste-beta-ultraflix-app.apk"',
    ]);
});

Route::get('/gerar-links-filmes-m3u', 'MovieController@generateMovieM3u');

Route::get('/gerar-links-series-m3u', 'SerieController@generateSeriesM3u');

Route::view('/baixar-sql', 'download_sql')->name('download.view');
Route::get('/download-sql', [ExportController::class, 'exportSql'])
     ->name('download.sql')
     ->middleware('limitdownloads');

Route::get('/auth', 'App\Http\Controllers\FlussonicAuthController@authenticate');

Route::get('/users_tv', 'UserController@index')->name('ativar_tv');
Route::put('/users_tv/{user}', 'UserController@update')->name('user_tv.update');

Route::get('/carregar-mais-canais', [LiveTvController::class, 'fetchMoreContent'])->name('livetv.more');

Route::get('/login/premium', function () {
    return view('auth.login_premium');
})->name('login.premium.view');

Route::post('/login/premium', 'Auth\LoginController@premiumLogin')->name('login.premium');

Route::get('/suporte-premium', function () {
    return view('suporte_premium');
})->middleware(['is_premium'])->name('suporte.premium');

Route::any('/testar-whatsapp', [WebhookMercadoPagoController::class, 'enviarMensagemWhatsAppTeste']);

Route::get('/', function () {
  return redirect('/br');
});

Route::get('/gerar-links-filmes', 'MovieController@generateMovieLinks');
Route::get('/gerar-links-series', 'SerieController@generateSeriesLinks');
Route::get('/gerar-links-animes', 'AnimeController@generateAnimesLinks');

Route::get('/dfe', 'MovieController@deleteExtraLinks')->name('movies.delete-extra-links');

Route::get('/mai', 'AnimeController@markInactiveAnimes');

Route::get('/msi', 'SerieController@markInactiveSeries');

Route::get('/mfi', [MovieController::class, 'markInactiveWithoutLink']);

Route::any('/webhook-braip', [WebhookController::class, 'handle']);

Route::any('/mailteste', [WebhookController::class, 'testeMail']);

Route::get('/br', 'LandingController@index');

Route::get('/subtitles/{id}', 'SubstitleController@showSubs');

Route::get('/direct-link', [MovieVideoController::class, 'getDirectLink']);

Route::get('/filemoon', [MovieVideoController::class, 'filemoon']);

Route::get('/list-link', [MovieVideoController::class, 'listLink']);

Route::get('/ativar', 'LandingController@planos')->name('ativar');
Route::get('/assinar', 'MercadoPagoController@assinar')->name('assinar');



// Rotas para controle de servidor, links, etc.
Route::post('/support/contact', function () { return redirect()->back(); });
Route::get('/direct-link', [App\Http\Controllers\MovieVideoController::class, 'getDirectLink'])->middleware('require.auth.playback');
Route::get('/list-link', [App\Http\Controllers\MovieVideoController::class, 'listLink'])->middleware('require.auth.playback');
Route::get('/tv/search', [App\Http\Controllers\LivetvController::class, 'search'])->name('livetv.search');

// Rotas que requerem autenticação para reprodução de vídeo
Route::middleware('require.auth.playback')->group(function () {
    Route::get('/tv/{id}', [App\Http\Controllers\LivetvController::class, 'show'])->name('livetv.show');
    Route::get('/movie/play/{id}', [App\Http\Controllers\MovieController::class, 'play'])->name('movie.play');
    Route::get('/serie/play/{id}', [App\Http\Controllers\SerieController::class, 'play'])->name('serie.play');
    Route::get('/anime/play/{id}', [App\Http\Controllers\AnimeController::class, 'play'])->name('anime.play');
    Route::post('/continue-watching', [App\Http\Controllers\ContinueWatchingController::class, 'store'])->name('continueWatching');
    Route::get('/continue-watching/get-position', [App\Http\Controllers\ContinueWatchingController::class, 'getPosition'])->name('continueWatching.getPosition');
});

// Middleware de verificação de limite de dispositivos
Route::middleware(['auth', 'check.device.limit'])->group(function () {
    // Rotas específicas que devem verificar limite de dispositivos
    Route::post('/check-device-limit', [App\Http\Controllers\DeviceController::class, 'checkDeviceLimitForContent'])->name('check.device.limit');
});

// Rotas para notificações
Route::get('/notificacoes', [App\Http\Controllers\NotificationsController::class, 'index'])
     ->middleware('auth', 'auth:sanctum')
     ->name('notifications');

Route::get('/api/notifications/count', [App\Http\Controllers\NotificationsController::class, 'getUnreadCountApi'])
     ->middleware('auth', 'auth:sanctum')
     ->name('api.notifications.count');

Route::group(['middleware' => 'guest'], function () {
    Route::any('/login-google', 'Api\Auth\LoginController@loginGoogle')->name('login.google');
    Route::get('/login', 'Auth\LoginController@showLoginForm')->name('login');
    Route::post('/login', 'Auth\LoginController@login');
    Route::get('register', 'Auth\RegisterController@showRegistrationForm')->name('register');
});

Route::get('/canais', [App\Http\Controllers\GenreController::class, 'latestlivetv'])->name('livetv.index');

Route::get('/inicio', [App\Http\Controllers\InicioController::class, 'index'])->name('inicio');

Route::middleware('auth', 'auth:sanctum', 'single.session')->group(function () {
    
    
    Route::get('/homeitens', [App\Http\Controllers\InicioController::class, 'homeitens'])->name('homeitens');
    Route::get('/filmes', [App\Http\Controllers\GenreController::class, 'latestmoviesweb'])->name('filmes.index');
    Route::get('/series', [App\Http\Controllers\GenreController::class, 'latestseriesweb'])->name('series.index');
    Route::get('/desenhos', [App\Http\Controllers\GenreController::class, 'latestanimesweb'])->name('animes.index');
    Route::get('/pesquisa', [App\Http\Controllers\SearchController::class, 'indexweb'])->name('search');
    Route::get('/pesquisa-em-tempo-real', [App\Http\Controllers\SearchController::class, 'realtimeSearch'])->name('realtime.search');
    Route::get('/filme/{id}', [App\Http\Controllers\MovieController::class, 'detail'])->name('filme.detail');
    Route::get('/serie/{id}', [App\Http\Controllers\SerieController::class, 'detail'])->name('serie.detail');
    Route::get('/anime/{id}', [App\Http\Controllers\AnimeController::class, 'detail'])->name('anime.detail');
    Route::get('/season/{seasonId}', [App\Http\Controllers\SerieController::class, 'getSeasonEpisodes'])->name('season.episodes');
    Route::get('/api/seasons/{seasonId}/episodes', [App\Http\Controllers\SerieController::class, 'episodesBySeason']);
    Route::get('/resultados/{type}/{id}', [App\Http\Controllers\SearchController::class, 'showResults'])->name('resultados');
    Route::get('/content/{type}', [App\Http\Controllers\ContentController::class, 'showMore'])->name('content.more');
    Route::get('/header', function () { return view('layouts._partials.header'); });
    Route::get('/random-movie', [App\Http\Controllers\InicioController::class, 'getRandomMovie'])->name('random_movie');
    Route::get('/random-series', [App\Http\Controllers\InicioController::class, 'getRandomSeries'])->name('random_series');
    Route::get('/random-animes', [App\Http\Controllers\InicioController::class, 'getRandomAnimes'])->name('random_animes');

    Route::post('/movies/sendResume/{code}', 'MoviesResumeController@sendResume')->name('sendResume');
    Route::get('/movies/resume/show/{movie}/{code}', 'MoviesResumeController@show');

    Route::get('/favoritos/{profileId?}', 'FavoritosController@index')->name('favoritos');

    Route::get('/api/avatars', 'AvatarController@getAvatars');
    Route::any('/movie/addtofav/{movieid}', 'MovieController@addtofav')->name('movie.addtofav');
    Route::get('/movie/isMovieFavorite/{movieid}', 'MovieController@isMovieFavorite')->name('movie.isFavorite');
    Route::any('/movie/removefromfav/{movieid}', 'MovieController@removefromfav')->name('movie.removefromfav');

    Route::any('/serie/addtofav/{movieid}', 'SerieController@addtofav');
    Route::get('/serie/isMovieFavorite/{movieid}', 'SerieController@isMovieFavorite');
    Route::any('/serie/removefromfav/{movieid}', 'SerieController@removefromfav');

    Route::get('/user/profile/edit/{profile_id}', 'UserController@editProfile')->name('edit-profile');
    Route::patch('/user/profile/update/{profile_id}', 'UserController@updateProfile')->name('update-profile');
    Route::get('/select-profile/{profile_id}', 'UserController@selectProfile')->name('select-profile');
    Route::get('/user/profiles', [UserController::class, 'showProfiles'])->name('choose-profile');
    Route::post('/user/profile/create', [UserController::class, 'createProfile']);
    Route::get('/user/profile/create', [UserController::class, 'showCreateProfileForm']);
    Route::delete('/user/profile/delete/{profile_id}', [UserController::class, 'deleteProfile']);

    Route::get('/choose-plan', 'MercadoPagoController@showChoosePlan')->name('choose.plan');

    Route::get('/avatars/{filename}', 'ProfileController@showDefaultAvatar')->name('avatar.show');
    Route::get('/profile', [ProfileController::class, 'showProfile'])->name('user.profile');
    Route::put('/profile', [ProfileController::class, 'updateProfile'])->name('user.profile.update');

    Route::get('/users/profile/{user}/{code}', 'UserController@showUser');
    Route::get('/site', 'MovieController@shows');
    Route::get('/moviesCount', 'AdminController@moviesCount');
    Route::get('/featured/data', 'FeaturedController@data');
    Route::get('/featureds', 'FeaturedController@datasite');
    Route::get('/media/featuredcontent/{code}', 'FeaturedController@featured');
    Route::get('/quantidade', function () {
        return view('quantidade_filmes');
    });

    Route::get('/header', function () {
        return view('layouts._partials.header');
    });

    // Rotas de favoritos para séries
    Route::post('/serie/addtofav/{movieid}', 'SerieController@addtofav')->name('serie.addtofav');
    Route::get('/serie/isMovieFavorite/{movieid}', 'SerieController@isMovieFavorite')->name('serie.isFavorite');
    Route::post('/serie/removefromfav/{movieid}', 'SerieController@removefromfav')->name('serie.removefromfav');

    Route::post('/anime/addtofav/{movieid}', 'AnimeController@addtofav')->name('anime.addtofav');
    Route::get('/anime/isMovieFavorite/{movieid}', 'AnimeController@isMovieFavorite')->name('anime.isFavorite');
    Route::post('/anime/removefromfav/{movieid}', 'AnimeController@removefromfav')->name('anime.removefromfav');

    // Rotas para continue watching
    Route::get('/continue-watching', [ContinueWatchingController::class, 'index'])->name('continueWatching.index');
    Route::delete('/continue-watching/{id}', [ContinueWatchingController::class, 'destroy'])->name('continueWatching.destroy');
});

// Grupo de rotas protegidas que verificam o limite de dispositivos
Route::middleware(['auth', 'check.device.limit'])->group(function () {
    // Rotas de conteúdo que requerem verificação de limite de dispositivos
    Route::get('/filme/{id}', 'MovieController@detail')->name('filme.detail');
    Route::get('/serie/{id}', 'SerieController@detail')->name('serie.detail');
    Route::get('/anime/{id}', 'AnimeController@detail')->name('anime.detail');
    // Adicione outras rotas de conteúdo que devem verificar o limite de dispositivos
});

// Rotas relacionadas ao gerenciamento de dispositivos (não devem verificar o limite)
Route::middleware(['auth'])->group(function () {
    Route::get('/devices', 'DeviceController@index')->name('devices.index');
    Route::delete('/devices/{id}', 'DeviceController@destroy')->name('devices.destroy');
    Route::post('/devices/destroy-all', 'DeviceController@destroyAll')->name('devices.destroy.all');
});

// Rotas para gerenciamento de dispositivos
Route::middleware(['auth'])->group(function () {
    // Lista de dispositivos
    Route::get('/dispositivos', [DeviceController::class, 'index'])->name('devices.index');

    // Remover dispositivo específico
    Route::delete('/dispositivos/{id}', [DeviceController::class, 'destroy'])->name('devices.destroy');

    // Remover todos os dispositivos (exceto o atual)
    Route::post('/dispositivos/remover-todos', [DeviceController::class, 'destroyAll'])->name('devices.destroy.all');

    // Verificação de limites para conteúdo
    Route::post('/check-device-limit', [DeviceController::class, 'checkDeviceLimitForContent'])
        ->name('check.device.limit');

});

// Rotas para o sistema de suporte
Route::middleware(['auth'])->group(function () {
    Route::get('/suporte', [App\Http\Controllers\SupportTicketController::class, 'index'])->name('support.index');
    Route::get('/suporte/novo', [App\Http\Controllers\SupportTicketController::class, 'create'])->name('support.create');
    Route::post('/suporte', [App\Http\Controllers\SupportTicketController::class, 'store'])->name('support.store');
    Route::get('/suporte/{id}', [App\Http\Controllers\SupportTicketController::class, 'show'])->name('support.show');

    // Rotas para administradores
    Route::middleware(['admin'])->prefix('admin')->group(function () {
        Route::get('/suporte', [App\Http\Controllers\SupportTicketController::class, 'adminIndex'])->name('admin.support.index');
        Route::get('/suporte/{id}', [App\Http\Controllers\SupportTicketController::class, 'adminShow'])->name('admin.support.show');
        Route::put('/suporte/{id}', [App\Http\Controllers\SupportTicketController::class, 'adminUpdate'])->name('admin.support.update');
        Route::get('/suporte/count', [App\Http\Controllers\SupportTicketController::class, 'getOpenTicketsCount'])->name('admin.support.count');
    });
});

// Rotas para manipulação de perfis
Route::middleware(['auth'])->group(function() {
    // Exibição de perfis
    Route::get('/choose-profile', 'UserController@showProfiles')->name('choose-profile');

    // Criação de perfis
    Route::get('/user/profile/create', 'UserController@showCreateProfileForm');
    Route::post('/user/profile/create', 'UserController@createProfile');

    // Edição de perfis
    Route::get('/user/profile/edit/{profile_id}', 'UserController@editProfile');
    Route::patch('/user/profile/update/{profile_id}', 'UserController@updateProfile');

    // Exclusão de perfis
    Route::delete('/user/profile/delete/{profile_id}', 'UserController@deleteProfile');

    // Seleção de perfil
    Route::get('/select-profile/{profile_id}', 'UserController@selectProfile');

    // Rota para página "Ver Mais"
    Route::get('/content/{type}', 'App\Http\Controllers\ContentController@showMore')->name('content.more');

});

Route::get('/demo', function () {
    return view('demo');
});

Route::post('/webhook-mp', [MercadoPagoController::class, 'handleMercadoPagoWebhook']);

Route::get('/mercadopago', [WebhookMercadoPagoController::class, 'searchPaymentByExternalReference']);

Route::any('/webhook/mercadopago', [WebhookMercadoPagoController::class, 'handleMercadoPagoWebhook'])->name('handleMercadoPagoWebhook');

Route::post('/pagamento', [MercadoPagoController::class, 'createPaymentPreference'])->name('createPaymentPreference');
Route::get('/pagamento', function () {
    return view('pagamento');
});

Route::post('/pagamento-p', [MercadoPagoController::class, 'createPaymentPreference'])->name('createPaymentPreference');
Route::get('/pagamento-p', function () {
    return view('pagamento-p');
});

Route::get('/pagamento/sucesso', [MercadoPagoController::class, 'pagamentoSucesso'])->name('pagamentoSucesso');
Route::get('/pagamento/sucesso', function () {
    return view('sucesso');
});

Route::get('/pagamento/falha', [MercadoPagoController::class, 'pagamentoFalha'])->name('pagamentoFalha');

Route::get('/pagamento/falha', function () {
    return view('falha');
});

Route::get('/pagamento/pendente', [MercadoPagoController::class, 'pagamentoPendente'])->name('pagamentoPendente');

Route::get('/pagamento/pendente', function () {
    return view('pendente');
});

Route::get('/noemail', function () {
    return view('noemail');
});

Route::get('/politica-de-privacidade', function () {
    return view('politica');
});

Route::post('/webhooks/mercado-pago', 'MercadoPagoController@webhook')->name('webhooks.mercado-pago');

Route::get('/pagamento/status/{paymentId}', 'MercadoPagoController@obterStatusPagamento')->name('obterStatusPagamento');

Route::get('/pagamentos/{id}', 'MercadoPagoController@obterPagamento')->name('obterPagamento');

// Rotas para SuitPay PIX
Route::post('/realizar-pagamento', [SuitPayController::class, 'processPayment'])->name('realizarPagamento');
Route::post('/suitpay/status', [SuitPayController::class, 'checkStatus'])->name('suitpay.status');
Route::post('/suitpay/callback', [SuitPayController::class, 'callback'])->name('suitpay.callback');
Route::any('/webhook/suitpay', [SuitPayController::class, 'callback'])
     ->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
Route::get('/admin/suitpay/webhook-status', [SuitPayController::class, 'webhookStatus'])->middleware('admin');
Route::post('/suitpay/test-webhook', [SuitPayController::class, 'testWebhook'])->middleware('admin');
Route::get('/suitpay/check-connectivity', [SuitPayController::class, 'checkApiConnection'])->middleware('admin');
Route::post('/paggue/callback', [App\Http\Controllers\PaggueController::class, 'callback'])->name('paggue.callback');
// NOVAS ROTAS: Páginas de sucesso e falha para o PIX
Route::get('/pagamento/sucesso', [SuitPayController::class, 'showSuccess'])->name('pagamento.sucesso');
Route::get('/pagamento/falha', [SuitPayController::class, 'showFailure'])->name('pagamento.falha');
// Rota de diagnóstico para ambiente de desenvolvimento
Route::get('/suitpay/debug/{reference?}', [SuitPayController::class, 'checkPaymentDebug']);

// Rotas para Paggue PIX
Route::post('/paggue/process', 'PaggueController@processPayment')->name('paggue.process');
Route::post('/paggue/callback', 'PaggueController@callback')->name('paggue.callback');
Route::post('/paggue/status', 'PaggueController@checkStatus')->name('paggue.status');
Route::get('/paggue/success', 'PaggueController@showSuccess')->name('paggue.success');

// Admin Login Routes - Não aplicar o middleware de sessão única
Route::get('/admin/login', 'AdminAuthController@showLoginForm')->name('admin.login')
    ->withoutMiddleware(['single.session', 'auth', 'checkSingleSession']);

Route::post('/admin/login', 'AdminAuthController@login')
    ->withoutMiddleware(['single.session', 'auth', 'checkSingleSession']);

Route::post('/admin/logout', 'AdminAuthController@logout')->name('admin.logout');

// Admin Routes - Ajustar middleware para verificar se é admin
Route::group(['prefix' => 'admin', 'middleware' => 'admin'], function () {
    Route::get('/cacheClear', function() {
        $exitCode2 = Artisan::call('optimize');
        $exitCode = Artisan::call('config:clear');
        return 'Routes cache cleared';
    });

    Route::get('/updateMailSettings', 'AdminController@updateMailSettings');

    Route::get('/', 'AdminController@index')->name('admin');
    Route::get('/movies', 'AdminController@movies')->name('admin.movies');
    Route::get('/series', 'AdminController@series')->name('admin.series');
    Route::get('/users', 'AdminController@users')->name('admin.users');
    Route::get('/streaming', 'AdminController@streaming')->name('admin.streaming');
    Route::get('/qualities', 'AdminController@servers')->name('admin.server');
    Route::get('/headers', 'AdminController@headers')->name('admin.headers');
    Route::get('/genres', 'AdminController@genres')->name('admin.genres');
    Route::get('/networks', 'AdminController@networks')->name('admin.networks');
    Route::get('/casters', 'AdminController@casters')->name('admin.casters');
    Route::get('/notifications', 'AdminController@notifications')->name('admin.notifications');
    Route::get('/settings', 'AdminController@settings')->name('admin.settings');
    Route::get('/account', 'AdminController@account')->name('admin.account');
    Route::get('/news', 'AdminController@articles')->name('admin.articles');
    Route::get('/substitles', 'AdminController@substitles')->name('admin.substitles');
    Route::get('/reports', 'AdminController@reports')->name('admin.reports');
    Route::get('/suggestions', 'AdminController@suggestions')->name('admin.suggestions');
    Route::get('/animes', 'AdminController@animes')->name('admin.animes');
    Route::get('/ads', 'AdminController@ads')->name('admin.ads');
    Route::get('/upcoming', 'AdminController@upcomings')->name('admin.upcomings');
    Route::get('/qualities', 'AdminController@servers')->name('admin.server');
    Route::get('/categories', 'AdminController@categories')->name('admin.categories');
    Route::get('/previews', 'AdminController@previews')->name('admin.previews');
    Route::get('/featured', 'AdminController@featured')->name('admin.featured');
    Route::get('/comments', 'AdminController@comments')->name('admin.comments');
    Route::get('/certifications', 'AdminController@certifications')->name('admin.certifications');
    Route::get('/settings', 'AdminController@settings')->name('admin.settings');
    Route::get('/moviesCount', 'AdminController@moviesCount');
    Route::get('/moviesInactiveCount', 'AdminController@moviesInactiveCount');
    Route::get('/substitles', 'AdminController@substitles')->name('admin.substitles');
    Route::get('/moviesCountViews', 'AdminController@moviesCountViews');
    Route::post('/create', 'Api\Auth\RegisterController@register');
    // Dashboard
    Route::get('/Allfeatured', 'AdminController@featured');
    Route::get('/topmovies', 'AdminController@topmovies');
    Route::get('/topanimes', 'AdminController@topanimes');
    Route::get('/topepisodes', 'AdminController@topepisodes');
    Route::get('/toplivetvs', 'AdminController@toplivetvs');
    Route::get('/topcontentmovies', 'AdminController@topcontentmovies');
    Route::get('/topcontentseries', 'AdminController@topcontentseries');
    Route::get('/topcontentanimes', 'AdminController@topcontentanimes');
    Route::get('/moviesInactiveCount', 'AdminController@moviesInactiveCount');
    // Settings
    Route::put('/settings/updatepanel', 'AdminController@updateWebPanel');

    Route::get('/settings/data', 'SettingController@data');
    Route::put('/settings/update/{setting}', 'SettingController@update');
    Route::post('/update/logo', 'SettingController@updateLogo');
    Route::post('/update/episode', 'SettingController@updateEpisode');
    Route::post('/update/mediahome', 'SettingController@mediahome');
    Route::post('/update/minilogo', 'SettingController@updateMiniLogo');
    Route::post('/update/notificationicon', 'SettingController@updateNotificationIcon');
    Route::post('/update/customBanner', 'SettingController@customBanner');
    Route::post('/update/splash', 'SettingController@updateSplash');

    // Account
    Route::get('/account/data', 'UserController@data');
    Route::put('/account/update', 'UserController@update');
    Route::put('/account/password/update', 'UserController@passwordUpdate');
    Route::put('/account/passwordApp/update', 'UserController@passwordUpdateApp');
    Route::put('/account/password/updateUser', 'UserController@updateUserPassword');
    Route::post('/update/avatar', 'UserController@updateAvatar');

    // Users
    Route::get('/users/data', 'UserController@data');
    Route::get('/users/allusers', 'UserController@allusers');
    Route::delete('/users/destroy/{user}', 'UserController@destroy');
    Route::put('/users/update/{user}', 'UserController@updateUser');
    Route::post('/users/store', 'UserController@store');

    // Comments
    Route::get('/comments/allcomments', 'CommentController@allcomments');
    Route::delete('/media/delete/comments/{movieid}', 'MovieController@deletecommentweb');

    // Featureds
    Route::post('/featureds/image/store', 'FeaturedController@storeImg');

    // Movies
    Route::get('/searchwebcasts', 'CastController@searchCast');
    Route::get('/search_featured', 'SearchController@searchFeatured');
    Route::get('/search_casts', 'SearchController@searchCasts');
    Route::get('/search_movies', 'SearchController@searchMovies');
    Route::get('/search_series', 'SearchController@searchSeries');
    Route::get('/search_animes', 'SearchController@searchAnimes');
    Route::get('/search_streaming', 'SearchController@searchStreaming');
    Route::get('/search_users', 'SearchController@searchUsers');
    Route::get('/movies/dataweb', 'MovieController@web');
    Route::post('/moviesmedia/storemovie', 'MovieController@store');
    Route::delete('/movies/destroy/{movie}', 'MovieController@destroy');
    Route::post('/movies/image/store', 'MovieController@storeImg');
    Route::put('/moviesmedia/updatemovie/{movie}', 'MovieController@update');
    Route::post('/movies/videodelete/destroy/{movie}', 'MovieController@deteleVideoFromServer');
    Route::delete('/movies/downloads/destroy/{moviedownload}', 'MovieController@downloadDestroy');
    Route::delete('/movies/videos/destroy/{movievideo}', 'MovieController@videoDestroy');
    Route::delete('/movies/substitles/destroy/{moviesubstitle}', 'MovieController@substitleDestroy');
    Route::delete('/movies/genres/destroy/{moviegenre}', 'MovieController@destroyGenre');
    Route::get('/movies/videos/{movie}', 'MovieController@videos');
    Route::get('/movies/productions/{movie}', 'MovieController@productions');
    Route::get('/movies/downloads/{movie}', 'MovieController@downloads');
    Route::get('/movies/substitles/{movie}', 'MovieController@substitles');
    Route::get('/movies/casters/{movie}', 'MovieController@casters');
    Route::delete('/movies/casts/destroy/{cast}', 'MovieController@destroyCast');
    Route::delete('/series/casts/destroy/{cast}', 'SerieController@destroyCast');
    Route::delete('/animes/casts/destroy/{cast}', 'AnimeController@destroyCast');
    Route::delete('/movies/networks/destroy/{cast}', 'MovieController@destroyNetworks');
    Route::delete('/series/networks/destroy/{cast}', 'SerieController@destroyNetworks');
    Route::delete('/animes/networks/destroy/{cast}', 'AnimeController@destroyNetworks');
    Route::delete('/movies/downloads/destroy/{moviedownload}', 'MovieController@downloadDestroy');
    //Series
    Route::get('/series/data', 'SerieController@data');
    Route::post('/series/store', 'SerieController@store');
    Route::delete('/series/destroy/{serie}', 'SerieController@destroy');
    Route::put('/series/update/{serie}', 'SerieController@update');
    Route::post('/series/image/store', 'SerieController@storeImg');
    Route::delete('/series/genres/destroy/{seriegenre}', 'SerieController@destroyGenre');

    // Seasons And Episodes
    Route::delete('/series/seasons/destroy/{season}', 'SeasonController@destroy');
    Route::delete('/series/episodes/destroy/{episode}', 'EpisodeController@destroy');
    Route::delete('/animes/episodes/destroy/{episode}', 'EpisodeController@destroyAnime');
    Route::delete('/series/videos/destroy/{serievideo}', 'EpisodeController@destroyVideo');
    Route::delete('/animes/videos/destroy/{serievideo}', 'EpisodeController@destroyVideoAnime');
    Route::delete('/animes/downloads/destroy/{serievideo}', 'EpisodeController@destroyDownloadAnime');
    Route::delete('/series/downloads/destroy/{serievideo}', 'EpisodeController@destroyDownloadSerie');
    Route::delete('/series/substitles/destroy/{seriesubstitle}', 'EpisodeController@destroySubstitles');
    Route::delete('/animes/substitles/destroy/{seriesubstitle}', 'EpisodeController@destroyAnimeSubstitles');
    Route::delete('/series/destroy/{serie}', 'SerieController@destroy');
    // Livetv
    Route::get('/livetv/data', 'LivetvController@data');
    Route::post('/livetv/store', 'LivetvController@store');
    Route::delete('/livetv/destroy/{livetv}', 'LivetvController@destroy');
    Route::put('/livetv/update/{livetv}', 'LivetvController@update');
    Route::post('/livetv/image/store', 'LivetvController@storeImg');
    Route::delete('/livetv/genres/destroy/{livetvgenre}', 'LivetvController@destroyGenre');
    Route::get('/livetvs/videos/{livetv}', 'LivetvController@videos');
    Route::delete('/livetvs/videos/destroy/{livetv}', 'LivetvController@videoDestroy');

    // Upcoming
    Route::get('/upcoming/data', 'UpcomingController@data');
    Route::post('/upcoming/store', 'UpcomingController@store');
    Route::delete('/upcoming/destroy/{upcoming}', 'UpcomingController@destroy');
    Route::put('/upcoming/update/{upcoming}', 'UpcomingController@update');
    Route::post('/upcoming/image/store', 'UpcomingController@storeImg');
    Route::get('/livetv/data', 'LivetvController@data');
    Route::get('/featured/data', 'FeaturedController@data');
    Route::post('/featured/store', 'FeaturedController@store');
    Route::delete('/featured/destroy/{upcoming}', 'FeaturedController@destroy');
    Route::put('/featured/update/{featured}', 'FeaturedController@update');
    Route::post('/featured/image/store', 'FeaturedController@storeImg');
    Route::get('/livetvs/videos/{livetv}', 'LivetvController@videos');

    // Previews
    Route::get('/preview/data', 'PreviewController@data');
    Route::post('/preview/store', 'PreviewController@store');
    Route::delete('/preview/destroy/{preview}', 'PreviewController@destroy');
    Route::put('/preview/update/{preview}', 'PreviewController@update');
    Route::post('/preview/image/store', 'PreviewController@storeImg');

    // Animes
    Route::get('/animes/data', 'AnimeController@data');
    Route::post('/animes/store', 'AnimeController@store');
    Route::delete('/animes/destroy/{anime}', 'AnimeController@destroy');
    Route::put('/animes/update/{anime}', 'AnimeController@update');
    Route::post('/animes/image/store', 'AnimeController@storeImg');
    Route::delete('/animes/genres/destroy/{animegenre}', 'AnimeController@destroyGenre');
    Route::delete('/animes/seasons/destroy/{season}', 'AnimeSeasonController@destroy');

    // Servers
    Route::get('/servers/dataservers', 'ServerController@serversdata');
    Route::get('/drmservers/drmdataservers', 'ServerController@drmdataservers');
    Route::get('/drmservers/drmdataserversweb', 'ServerController@drmdataserversweb');
    Route::post('/preview/image/store', 'PreviewController@storeImg');
    Route::post('/servers/store', 'ServerController@store');
    Route::put('/servers/update/{server}', 'ServerController@update');
    Route::delete('/servers/destroy/{server}', 'ServerController@destroy');
    Route::post('/animes/store', 'AnimeController@store');
    Route::post('/drmservers/store', 'ServerController@storedrm');
    Route::put('/drmservers/update/{server}', 'ServerController@updatedrm');
    Route::delete('/drmservers/destroy/{server}', 'ServerController@destroydrm');
    Route::delete('/animes/genres/destroy/{animegenre}', 'AnimeController@destroyGenre');

    // Headers
    Route::get('/headers/dataheaders', 'HeaderController@headersdata');
    Route::post('/headers/store', 'HeaderController@store');
    Route::put('/headers/update/{header}', 'HeaderController@update');
    Route::delete('/headers/destroy/{header}', 'HeaderController@destroy');
    Route::get('/drmservers/drmdataserversweb', 'ServerController@drmdataserversweb');

    // UserAgents
    Route::get('/useragents/datausersagent', 'HeaderController@userAgentweb');
    Route::get('/useragents/datausersagentoptions', 'HeaderController@datausersagentoptions');
    Route::post('/useragents/store', 'HeaderController@useragentsstore');
    Route::put('/useragents/update/{useragent}', 'HeaderController@useragentsupdate');
    Route::delete('/useragents/destroy/{header}', 'HeaderController@useragentsdestroy');
    Route::put('/drmservers/update/{server}', 'ServerController@updatedrm');

    // Production Companies
    Route::post('/productioncompanies/store', 'NetworkController@store');
    Route::delete('/productioncompanies/destroy/{network}', 'NetworkController@destroy');
    Route::put('/productioncompanies/update/{network}', 'NetworkController@update');
    Route::post('/headers/store', 'HeaderController@store');

    // Networks
    Route::get('/networks/datanetworks', 'NetworkController@datawebnetworks');
    Route::post('/networks/store', 'NetworkController@store');
    Route::delete('/networks/destroy/{network}', 'NetworkController@destroy');
    Route::put('/networks/update/{network}', 'NetworkController@update');
    Route::get('/useragents/datausersagentoptions', 'HeaderController@datausersagentoptions');

    // Genres
    Route::get('/genres/datagenres', 'GenreController@datagenres');
    Route::post('/genres/store', 'GenreController@store');
    Route::post('/genres/fetch', 'GenreController@fetch');
    Route::delete('/genres/destroy/{genre}', 'GenreController@destroy');
    Route::put('/genres/update/{genre}', 'GenreController@update');
    Route::delete('/productioncompanies/destroy/{network}', 'NetworkController@destroy');
    Route::get('/certifications/datagenres', 'CertificationController@datagenres');
    Route::post('/certifications/store', 'CertificationController@store');
    Route::post('/certifications/fetch', 'CertificationController@fetch');
    Route::delete('/certifications/destroy/{genre}', 'CertificationController@destroy');
    Route::put('/certifications/update/{genre}', 'CertificationController@update');
    Route::delete('/networks/destroy/{network}', 'NetworkController@destroy');
    Route::get('/networks/datawebnetworks', 'NetworkController@datawebnetworks');

    Route::put('/casters/updatecast/{cast}', 'CastController@update');
    Route::get('/casters/datawebcaster', 'CastController@datawebcaster');
    Route::get('/casters/datacasters', 'CastController@datacasters');
    Route::get('/casts/data', 'CastController@data');
    Route::post('/casts/store', 'CastController@store');
    Route::post('/casts/fetch', 'CastController@fetch');
    Route::delete('/casts/destroy/{genre}', 'CastController@destroy');
    Route::put('/casts/update/{cast}', 'CastController@update');
    Route::post('/casts/image/store', 'CastController@storeImg');
    Route::post('/certifications/fetch', 'CertificationController@fetch');
    Route::get('/categories/data', 'CategoryController@data');
    Route::post('/categories/store', 'CategoryController@store');
    Route::delete('/categories/destroy/{genre}', 'CategoryController@destroy');
    Route::put('/categories/update/{genre}', 'CategoryController@update');

    // Videos
    Route::post('/video/store', 'VideoController@store');
    Route::post('/video/anime/store', 'VideoController@store');
    Route::post('/streaming/store', 'VideoController@Streamingstore');
    Route::post('/casts/store', 'CastController@store');
    // Substitles
    Route::get('/substitles/data', 'SubstitleController@data');
    Route::post('/substitle/store', 'SubstitleController@store');
    Route::put('/substitles/update/{substitle}', 'SubstitleController@update');

    // Reports
    Route::post('/reports/send', 'ReportController@sendReport');
    Route::get('/reports/data', 'ReportController@data');
    Route::delete('/reports/destroy/{report}', 'ReportController@destroy');

    Route::post('/suggestions/send', 'SuggestionsController@sendReport');
    Route::get('/suggestions/data', 'SuggestionsController@data');
    Route::delete('/suggestions/destroy/{report}', 'SuggestionsController@destroy');
    Route::post('/streaming/store', 'VideoController@Streamingstore');
    // Ads
    Route::get('/ads/data', 'AdsController@data');
    Route::delete('/ads/destroy/{ads}', 'AdsController@destroy');
    Route::post('/ads/store', 'AdsController@store');
    Route::put('/ads/update/{ads}', 'AdsController@update');

    // Plans
    Route::get('/plans/data', 'PlanController@data');
    Route::get('/subscriptions/all', 'PlanController@all');
    Route::delete('/plans/destroy/{plan}', 'PlanController@destroy');
    Route::post('/plans/store', 'PlanController@store');
    Route::put('/plans/update/{plan}', 'PlanController@update');
    Route::get('/subscriptions/data', 'PlanController@all');
    Route::get('/subscriptions/paypal', 'PlanController@paypal');
    Route::get('/subscriptions/find', 'PlanController@find');
    // Ads
    Route::post('/settings/image/store', 'SettingController@storeImg');
    Route::delete('/ads/destroy/{ads}', 'AdsController@destroy');
    Route::get('/animes/show/{anime}', 'AnimeController@show');
    Route::get('/media/detail/{movie}', 'MovieController@show');
    Route::get('/series/show/{serie}', 'SerieController@show');
    Route::get('/stream/show/{livetv}', 'LivetvController@show');
    Route::get('/plans/data', 'PlanController@data');
    Route::get('/debug/serie/{id}', 'DebugController@checkSerieData');
    Route::delete('/plans/destroy/{plan}', 'PlanController@destroy');
    // Planos
    Route::get('/plans', 'PlanController@index')->name('admin.plans');
    Route::get('/plans/create', 'PlanController@create')->name('admin.plans.create');
    Route::post('/plans/store', 'PlanController@store')->name('admin.plans.store');
    Route::get('/plans/{id}/edit', 'PlanController@edit')->name('admin.plans.edit');
    Route::put('/plans/update/{id}', 'PlanController@update')->name('admin.plans.update');
    Route::delete('/plans/destroy/{id}', 'PlanController@destroy')->name('admin.plans.destroy');
    Route::get('/plans/stats', 'PlanController@getStats')->name('admin.plans.stats');
    Route::get('/animes/show/{anime}', 'AnimeController@show');
    // Gerenciamento de dispositivos
    Route::get('/devices', 'AdminController@devicesManagement')->name('admin.devices');
    Route::delete('/devices/{id}', 'AdminController@removeDevice')->name('admin.devices.destroy');
    Route::post('/devices/limit/{userId}', 'AdminController@setUserDeviceLimit')->name('admin.devices.limit');
    Route::get('/debug/serie/{id}', 'DebugController@checkSerieData');
    Route::get('/home', [App\Http\Controllers\AdminController::class, 'index'])->name('home');
    Route::get('/media/details/{id}', [MovieController::class, 'shows'])->name('filme');
    Route::get('/devices/user/{userId}', 'AdminController@getUserDevices')->name('admin.devices.user');
});

// Rota para a página de aviso sobre a descontinuação do aplicativo
Route::get('/aviso-importante', function () {
    return view('call-to-action');
})->name('call-to-action');

// Rota de redirecionamento para navegador externo
Route::get('/redirecionar-externo', 'App\Http\Controllers\ExternalBrowserController@redirect')
    ->name('external.redirect');

// Rota alternativa com abordagem específica para navegador externo
Route::get('/navegador-externo', function () {
    return view('external-browser');
})->name('external-browser');

Route::get('/home', [App\Http\Controllers\AdminController::class, 'index'])->name('home');
Route::get('/media/details/{id}', [MovieController::class, 'shows'])->name('filme');


// Rota principal para processamento de pagamento
Route::post('/realizar-pagamento', [PaymentController::class, 'realizarPagamento'])->name('realizarPagamento');


