<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ganhadores</title>
    <link rel="icon" href="https://ultraflix.net/wp-content/uploads/2023/02/cropped-favicon-32x32.png" type="image/x-icon">
    <!-- Lottie CSS e JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/lottie-web/5.7.8/lottie.min.js" crossorigin="anonymous"></script>
    
    <!-- Estilo CSS -->
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #000;
            margin: 0;
            padding: 0;
            color: #fff;
        }

        .container {
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        h2 {
            text-align: center;
            margin-bottom: 30px;
        }

        ul {
            list-style: none;
            padding-left: 0;
        }

        li {
            padding: 15px 10px;
            border-bottom: 1px solid #444;
            display: flex;
            align-items: center;
        }

        li:last-child {
            border-bottom: none;
        }

        .trophy-icon {
            margin-right: 10px;
        }

        .winner-name {
            font-weight: bold;
        }
        .email-winner {
            color: greenyellow;
        }

        .vencedores {
            align-items: center;
            display: flex;
            justify-content: center;
            gap: 20px;
            flex-direction: column;
        }

        .win-list {
            background-color: #444;
            border-radius: 15px;
            padding: 15px;
            gap: 7px;
            display: flex;
            flex-direction: column;
        }

        .vazio {
            background-color: #444;
            border-radius: 15px;
            padding: 11px;
        }

        a {
            text-decoration: none;
        }

        .voltar {
            background-color: #444;
            color: #fff;
            border-radius: 20px;
            padding: 15px;
            outline: none;
            list-style: none;
        }
        
    </style>
</head>

<body>
    <div class="container">
        <!-- Lottie Animation Container -->
        <div id="lottie-container" style="width: 100%; height: 300px; margin-bottom: 20px;"></div>
        <a href="{{ url()->previous() }}" class="voltar">Voltar</a>

            <h2>Ganhadores</h2>
            <ul class="vencedores">
            @php
                $exibiuAlgumVencedor = false;
                @endphp

                @forelse($sorteios as $sorteio)
                    @foreach($sorteio->vencedores as $vencedor)
                        @php
                        $exibiuAlgumVencedor = true;

                        $email = explode('@', $vencedor->email);
                        $email[0] = substr($email[0], 0, 3) . '***';
                        $obfuscatedEmail = implode('@', $email);
                        @endphp
                        <li class="win-list">
                            <!-- Trophy Icon -->
                            <span class="trophy-icon">🏆</span>
                            <span class="winner-name">{{ $vencedor->nome }}</span>
                            <span class="email-winner"> ({{ $obfuscatedEmail }}) </span>
                            Ganhou no sorteio {{ $sorteio->titulo }} {{ $sorteio->data_sorteio->format('d/m/Y H:i:s') }}
                        </li>
                    @endforeach
                @empty
                    <span class="vazio">Ainda não há vencedores, nenhum sorteio foi feito.</span>
                @endforelse

                @if(!$exibiuAlgumVencedor)
                    <span class="vazio">Ainda não há vencedores, nenhum sorteio foi feito.</span>
                @endif
            </ul>
    </div>

    <script>
        // Carregar animação Lottie
        let animation = lottie.loadAnimation({
            container: document.getElementById('lottie-container'),
            renderer: 'svg',
            loop: true,
            autoplay: true,
            path: 'https://lottie.host/2f4360ac-8ad5-4be4-a1ea-1bc1718350dc/XraBuZ3RUc.json'  // Substitua 'URL_DO_LOTTIE' pela URL que você fornecerá
        });
    </script>
</body>

</html>
