<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Atualizar Link</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500;600;700&family=Roboto:wght@400;500;900&family=Work+Sans:wght@900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <style>

        * {
            font-family: 'Poppins', sans-serif;
            font-family: 'Roboto', sans-serif;
            font-family: 'Work Sans', sans-serif;
        }

        body{
            color: white;
            font-size: 17px;
            font-family: 'Poppins', sans-serif;
            background-color: black;
        }

        input {
            border-radius: 15px;
            border: none;
            height: 30px;
            outline-color: #36ff03;
            font-family: 'Franklin Gothic Medium', 'Arial Narrow', Arial, sans-serif;
        }

        form {
            display: grid;
            gap: 5px;
            width: 75%;
        }

        section {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative;
            top: 100px;
            justify-content: center;
        }

        button {
            border-radius: 15px;
            border: none;
            background-color: #36ff03;
            cursor: pointer;
            width: 100%;
            font-family: 'Roboto', sans-serif;
            height: 32px;
            font-weight: 800;
            transition: .3s;
        }

        button:hover {
            background-color: #35ae16;
        }

        .alert {
            color: #36ff03;
            margin: 10px 0px 12px 0px;
            padding: 8px;
        }


    </style>
</head>
<body>
    <section>
        <h1>Atualizar Links</h1>

        @if(session('status') == 'success')
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            {{ session('message') }}
        </div>
        @endif

        <form method="post" action="{{ route('update-links') }}">
            @csrf
            <label for="old_domain">Antigo:</label>
            <input type="text" name="old_domain" required><br>

            <label for="new_domain">Novo:</label>
            <input type="text" name="new_domain" required><br>

            <button type="submit">Atualizar Links</button>
        </form>
    </section>
</body>
</html>